﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"   
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan"    >
    
    <!-- Library Logic
        This library will work in case where there are no external variable and configuration should be disabled for passing
        1) If IIS is not installed then Result is Pass with message saying IIS is not installed
        2) In any other pass case we return Pass wtih message as Configuration $$config$$ is disabled as expected.
        3) In case where result is False then we return Fail with message as Configuration $$config$$ is enabled but it should be disabled.
    -->    
    
    <!-- Entry Function for the library  -->
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        <xsl:variable name="result"  select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <xsl:variable name="Definitions"
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
        <xsl:variable name="title">
            <xsl:value-of select="$Definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>            
        </xsl:variable>
        
        <xsl:variable name="result1"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[1]/@result"/>
        
        <!-- Decide about the message id depending upon  the combination of results for various criterions ........................................................................................... -->

            <xsl:variable name="message_id">
                
                <!-- Check if result is true ........................................................................................... -->
                <xsl:if test="$result='true'">
                    <xsl:choose>
                        <xsl:when test="$result1 = 'true' ">
                            <xsl:text>com.mcafee.pa.msg.IISNotInstalled</xsl:text>                                    
                        </xsl:when>
                        <xsl:when test="$result = 'true' ">
                            <xsl:text>com.mcafee.pa.msg.winconfig_SCAP_IIS_2</xsl:text>                   
                        </xsl:when>
                    </xsl:choose>
                </xsl:if>
                
                <!-- Check if result is false ........................................................................................... -->
                <xsl:if test="$result='false'">
                            <xsl:text>com.mcafee.pa.msg.winconfig_SCAP_IIS_2</xsl:text>    
                </xsl:if>
  
            </xsl:variable>
            
        <!-- Decide about the isViolation value depending upon  the result of the check ........................................................................................... -->
            <xsl:variable name="isViolationValue">
                <xsl:choose>
                    <xsl:when test="$result = 'false' ">
                        <xsl:text>true</xsl:text>                                              
                    </xsl:when>
                    <xsl:when test="$result = 'true' ">
                        <xsl:text>false</xsl:text>                                              
                    </xsl:when>
                    </xsl:choose>               
            </xsl:variable>
        
        <!--Now Create Finding xml with all the values extracted ........................................................................................... -->
        <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
            <finding messageId="{$message_id}" isViolation="{$isViolationValue}">
                <instanceValue key="config">
                    <xsl:value-of select="$title"/>                                                    
                </instanceValue>
            </finding>
        </findings>
    </xsl:template>
</xsl:stylesheet>
