<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan"
    xmlns:fnd="http://results.pa.mcafee.com/findings/5.2">

    
    <!--  FILENAME: winLockoutPolicy_AcntLockout_Duration_ResetCounter_SCAP.xsl   DATE: 27th Oct, 2011     AUTHOR: Nandini NR   -->
    <!--  MAPPINGFILE: winLockoutPolicy_AcntLockout_Duration_ResetCounter_SCAP_xsl.txt    -->
    
    <!-- THIS LIBRARY IS DEVELOPED FOR WINDOWS COMPLIANCE CHECKS to Account Lockout Policy - Account Lockout Duration and Reset Account Lockout Counter settings -->
        
    <!-- FOLLOWING ARE SOME OF THE TEST CASES FOR THE LIBRARY 
        Configuration - Reset Account Lockout Counter/Account Lockout Duration
        Title - Account Lockout Policy: Reset Account Lockout Counter/Account Lockout Policy: Account Lockout Duration
    
    Pass:
    =====
    
    1. Account Lockout Duration is set to 0 (Account is locked out until Administrator unlocks it). So the policy setting (Title) is not applicable - Pass - Any Input/System value
    2. Configuration is set to %%actual value%% and is greater than the expected value ##expected value## as required. - Pass -  system value > Input
    3. Configuration is set to %%actual value%% and is equal to the expected value ##expected value## as required. - Pass -  Input = system value
    
    Fail:
    ===
    
    4. Account Lockout Threshold is currently set to 0. To achieve required setting for the configuration (Title) , Account Lockout Threshold should not be set to 0.
    Configuration value is currently set to %%actual value%%. It should be greater than or equal to the expected value ##expected value##. - Fail - system value < Input
    
    5. Account Lockout Threshold is currently set to 0. To achieve required setting for the configuration (Title), Account Lockout Threshold should not be set to 0.
        Configuration value is currently set to %%actual value%% and is greater than the expected value ##expected value## as required. - Fail - System value > Input
       
    6. Account Lockout Threshold is currently set to 0. To achieve required setting for the configuration (Title), Account Lockout Threshold should not be set to 0.
       Account Lockout Duration value is currently set to %%actual value%% and is equal to the expected value ##expected value## as required. - Fail - System value = Input
       
   7. Configuration value is currently set to %%actual value%%. It should be greater than or equal to the expected value ##expected value##. - Fail - System Value < Input & Account Lockout Threshold != 0
       
    -->
    
    <xsl:variable name="Definitions"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
    <xsl:variable name="Tests"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests"/>
    <xsl:variable name="TestedItems"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
    <xsl:variable name="CollectedObjects"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:collected_objects"/>
    <xsl:variable name="SystemData"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data"/>
    <xsl:variable name="States"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states"/>
    <xsl:variable name="Objects"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects"/>
    <xsl:variable name="Variables"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables"/>
    <xsl:variable name="OvalResult"
    select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>

        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>

        
     <xsl:call-template name="winConfigurationCheck">
            <xsl:with-param name="definitionId" select="$definitionId"/>
            <xsl:with-param name="def_result" select="$result"/>
          </xsl:call-template>
    </xsl:template>

    <xsl:template name="winConfigurationCheck">
        <xsl:param name="definitionId"/>
        <xsl:param name="def_result"/>

        <xsl:variable name="tests">
            <xsl:for-each select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion">

                <xsl:variable name="test" select="@test_ref"/>
                <xsl:if test="$Tests/win-def:lockoutpolicy_test[@id=$test]">
                    <xsl:variable name="object"
                        select="$Tests/win-def:user_test[@id=$test]/win-def:object/@object_ref"/>
                    <xsl:variable name="state"
                        select="$Tests/win-def:user_test[@id=$test]/win-def:state/@state_ref"/>

                    <xsl:element name="test">
                        <xsl:attribute name="id">
                            <xsl:value-of select="$test"/>
                        </xsl:attribute>
                        
                        <xsl:attribute name="type">
                            <xsl:text>lockoutpolicytest</xsl:text>
                        </xsl:attribute>                        
                    </xsl:element>
                </xsl:if>
           </xsl:for-each>

        </xsl:variable>
        
        <xsl:if test="$def_result = 'false' or $def_result = 'true' ">

            <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
                
                <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @type ='lockoutpolicytest' ]">
                    <xsl:variable name="test" select="@id"/>
                    <xsl:variable name="state" select="@state"/>
                    
                    <xsl:if test="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable != ''">
                        <xsl:for-each select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item">

                            <xsl:variable name="itemRef" select="@item_id"/>
                            <xsl:variable name="result" select="@result"/>
                            
                            <xsl:variable name="externalVarValue" select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable"/>
                            
                            <xsl:variable name="lockoutDurValue" select="$SystemData/win-sc:lockoutpolicy_item[@id=$itemRef]/win-sc:lockout_duration"/>
                            <xsl:variable name="lockoutThresValue" select="$SystemData/win-sc:lockoutpolicy_item[@id=$itemRef]/win-sc:lockout_threshold"/>
                            <xsl:variable name="lockoutObsWinValue" select="$SystemData/win-sc:lockoutpolicy_item[@id=$itemRef]/win-sc:lockout_observation_window"/>
                            
                            
                            <xsl:variable name="isViolationValue">
                                <xsl:if test="$def_result = 'false' ">
                                    <xsl:text>true</xsl:text>
                                </xsl:if>
                                <xsl:if test="$def_result = 'true' ">
                                    <xsl:text>false</xsl:text>
                                </xsl:if>
                            </xsl:variable>
                            
                            <xsl:variable name="title">
                                <xsl:value-of select="$Definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>            
                            </xsl:variable>
                            
                            <xsl:variable name="configName">
                                <xsl:value-of select="substring-after($Definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title,': ')"/>            
                            </xsl:variable>
                            
                            <xsl:variable name="sysValue">
                                  <xsl:choose>
                                      <xsl:when test="contains($configName,'Account Lockout Duration')">
                                          <xsl:value-of select="$lockoutDurValue"/>
                                      </xsl:when>
                                      <xsl:when test="contains($configName,'Reset Account Lockout Counter')">
                                          <xsl:value-of select="$lockoutObsWinValue"/>
                                      </xsl:when>
                                  </xsl:choose>
                                
                            </xsl:variable>
                            
                            <xsl:variable name="result2"
                                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[1]/@result"/>
                            <xsl:variable name="result3"
                                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[2]/@result"/>
                            <xsl:variable name="result4"
                            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[3]/@result"/>
                            
                       <xsl:variable name="message_Id">
                           <xsl:choose>
                               <!-- When final result is Pass -->
                               <xsl:when test="$def_result = 'true' and $result4 = 'true'">
                                   <xsl:text>com.mcafee.pa.msg.ActLockDur_Zero_AnyINP_SCAP</xsl:text>
                               </xsl:when>
                               <xsl:when test="$def_result = 'true' and $result3 = 'true' and $lockoutDurValue&gt;$externalVarValue">
                                   <xsl:text>com.mcafee.pa.msg.ActLock_INPGRT_SCAP</xsl:text>
                               </xsl:when>
                               <xsl:when test="$def_result = 'true' and $result3 = 'true' and $lockoutDurValue=$externalVarValue">
                                   <xsl:text>com.mcafee.pa.msg.ActLock_INPEQU_SCAP</xsl:text>
                               </xsl:when>
                               
                               <!-- When final result is Fail -->
                               <xsl:when test="$def_result = 'false' and $result2 = 'false' and $lockoutDurValue&lt;$externalVarValue">
                                   <xsl:text>com.mcafee.pa.msg.ActLockThresZero_ActLock_INPLESS_SCAP</xsl:text>
                               </xsl:when>
                               <xsl:when test="$def_result = 'false' and $result2 = 'false' and $lockoutDurValue&gt;$externalVarValue">
                                   <xsl:text>com.mcafee.pa.msg.ActLockThresZero_ActLock_INPGRT_SCAP</xsl:text>
                               </xsl:when>
                               <xsl:when test="$def_result = 'false' and $result2 = 'false' and $lockoutDurValue=$externalVarValue">
                                   <xsl:text>com.mcafee.pa.msg.ActLockThresZero_ActLock_INPEQU_SCAP</xsl:text>
                               </xsl:when>
                               <xsl:when test="$def_result = 'false' and $result2 = 'true' and $result3 = 'false'">
                                   <xsl:text>com.mcafee.pa.msg.ActLock_INPGRT_SCAP</xsl:text>
                               </xsl:when>
                           </xsl:choose>
                       </xsl:variable> 
                            
                        <inputValue key="expectedValue">
                            <xsl:value-of select="$externalVarValue"/>
                        </inputValue>
                            <finding messageId="{$message_Id}" isViolation="{$isViolationValue}">
                                <instanceValue key="configName">
                                    <xsl:value-of select="$configName"/>
                                </instanceValue>
                                <instanceValue key="title">
                                    <xsl:value-of select="$title"/>
                                </instanceValue>
                                <actualValue key="actualValue">
                                    <xsl:value-of select="$sysValue"/>
                                </actualValue>
                        </finding>
                        </xsl:for-each>
                    </xsl:if>
                </xsl:for-each>
            </findings>
         </xsl:if>     
    </xsl:template>
</xsl:stylesheet>