<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:aix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#aix"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    xmlns:aix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#aix"
    xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:xalan="http://xml.apache.org/xalan"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def ind-sc ind-def aix-def aix-sc">
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>
    
    <!--
        
        This XSL is specific to AIX Patch Checks of SCAP Content.
        
        Patch details will be piacked up based on the result of the applicability. 
        
        Usual title pattern would be Patch for AIX <cause of the vulnerability> vulnerability.
        
        Example:Patch for AIX nas advisory1
        
        This library is in specific for AIX NAS (Network Authentication Server) advisory1 check and any other related checks.
        
        Pre-requisite 
        Affected fileset is verified for a version >= fixed version. This is a modified version of aixPatchCheckLibrary_OpenSSL_With_3VersionRange.xsl
        
        <criteria>
            <criteria comment="Prerequisite tests" operator="OR">
                <criterion test_ref="oval:com.mcafee.oval:tst:525421" comment="krb5.client.rte fileset existence test"/>
                <criterion test_ref="oval:com.mcafee.oval:tst:525422" comment="krb5.server.rte fileset existence test"/>
            </criteria>
            <criteria operator="OR" negate="true" comment="Patch Criteria">
                <criteria operator="AND" comment="Check if krb5.client.rte fileset version is greater than or equal to 1.5.0 and less than 1.5.0.7">
                    <criterion test_ref="oval:com.mcafee.oval:tst:525423"/>
                    <criterion test_ref="oval:com.mcafee.oval:tst:525424"/>
                </criteria>
        
                <criteria operator="AND" comment="Check if krb5.server.rte fileset version is greater than or equal to 1.5.0 and less than 1.5.0.7">
                    <criterion test_ref="oval:com.mcafee.oval:tst:525425"/>
                    <criterion test_ref="oval:com.mcafee.oval:tst:525426"/>
                </criteria>
        
                <criteria operator="AND" comment="Check if krb5.client.rte fileset version is equal to 1.6.0.1">
                    <criterion test_ref="oval:com.mcafee.oval:tst:525427"/>
                    <criterion test_ref="oval:com.mcafee.oval:tst:525428"/>
                </criteria>
        
                <criteria operator="AND" comment="Check if krb5.server.rte fileset version is equal to 1.6.0.1">
                    <criterion test_ref="oval:com.mcafee.oval:tst:525429"/>
                    <criterion test_ref="oval:com.mcafee.oval:tst:525430"/>
                </criteria>
            </criteria>
        </criteria>
                            
Example: oval:com.mcafee.oval:def:525420
                  oval:com.mcafee.oval:def:1412177
	
    -->
    
    <xsl:param name="defid" />
    <xsl:template match="/">
        <xsl:call-template name="getFindings">
            <xsl:with-param name="definitionId" select="$defid"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        
        <xsl:variable name="result" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <xsl:variable name="testVar" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/oval-res:criteria"/>
        
        <xsl:variable name="fileset1ExistenceTestRes" select="$testVar/descendant::oval-res:criterion[1]/@result"/>
        <xsl:variable name="fileset2ExistenceTestRes" select="$testVar/descendant::oval-res:criterion[2]/@result"/>

        
             
        <xsl:variable name="filesetName1">
                <xsl:variable name="testID" select="$testVar/descendant::oval-res:criterion[4]/@test_ref"/>
                <xsl:variable name="objID"  select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/aix-def:fileset_test[@id=$testID]/aix-def:object/@object_ref"/>
                <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/aix-def:fileset_object[@id=$objID]/aix-def:flstinst/text()"/>    
        </xsl:variable>
        
        <xsl:variable name="filesetName2">
            <xsl:variable name="testID" select="$testVar/descendant::oval-res:criterion[10]/@test_ref"/>
            <xsl:variable name="objID"  select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/aix-def:fileset_test[@id=$testID]/aix-def:object/@object_ref"/>
            <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/aix-def:fileset_object[@id=$objID]/aix-def:flstinst/text()"/>
       </xsl:variable>
        
        <xsl:variable name="title">
            <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>            
        </xsl:variable>
        
        <xsl:variable name="isViolationValue">
            <xsl:choose>
                <xsl:when test="$result = 'false' ">
                    <xsl:text>false</xsl:text>
                </xsl:when>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>true</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="message_id">
            <xsl:if test="$result='true'">
                <xsl:text>com.mcafee.pa.msg.AIXLatestVersionNotInstalled</xsl:text>      
            </xsl:if>
            <xsl:if test="$result='false'">
                <xsl:choose>
                    <xsl:when test="($fileset2ExistenceTestRes='true' and $fileset1ExistenceTestRes='true') or ($fileset2ExistenceTestRes='true' and $fileset1ExistenceTestRes='false') or ($fileset2ExistenceTestRes='false' and $fileset1ExistenceTestRes='true')">
                        <xsl:text>com.mcafee.pa.msg.AIXPatchInstalled</xsl:text>
                    </xsl:when>
                    <xsl:when test="($fileset1ExistenceTestRes ='false' and $fileset2ExistenceTestRes='false')">
                        <xsl:text>com.mcafee.pa.msg.AIXPatchNotApplicable</xsl:text>
                    </xsl:when>
                </xsl:choose>
            </xsl:if>
        </xsl:variable>
        
        <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="id">
                <xsl:value-of select="$definitionId"/>
            </xsl:attribute>
            <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="messageId">
                    <xsl:value-of select="$message_id"/>
                </xsl:attribute>
                <xsl:attribute name="isViolation">
                    <xsl:value-of select="$isViolationValue"/>
                </xsl:attribute>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">title</xsl:attribute>
                    <xsl:value-of select="$title"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">fileset1</xsl:attribute>
                    <xsl:value-of select="$filesetName1"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">fileset2</xsl:attribute>
                    <xsl:value-of select="$filesetName2"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">filesets</xsl:attribute>
                    <xsl:value-of select="concat($filesetName1,' and ',$filesetName2)"/>
                </xsl:element>
            </xsl:element>
        </xsl:element>
    </xsl:template>
</xsl:stylesheet>