<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"   
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan"
    >
    
    <!--
        
        This XSL is apply to the definition which are made to check whether a installed 
        software meets  the minimum or maximum version requirement. 
        
        Software name will be get from the title. 
        title should start with software name as below. 
        
        <software name> Minimum/Maximum ...
        
         Criteria (and)
                  Criterion :  Reg test ( Check Software version)  
                      one or more...
                  Criterion :  File test  ( Check Software file  version)  (OPTIONAL)
                      one or more...
    -->
    <xsl:variable name="Definitions"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
    <xsl:variable name="Tests"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests"/>
    <xsl:variable name="TestedItems"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
    <xsl:variable name="CollectedObjects"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:collected_objects"/>
    <xsl:variable name="SystemData"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data"/>
    <xsl:variable name="States"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states"/>
    <xsl:variable name="Objects"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects"/>
    <xsl:variable name="Variables"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables"/>
    <xsl:variable name="OvalResult"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>
    
    <xsl:variable name="smallcase" select="'abcdefghijklmnopqrstuvwxyz'" />
    <xsl:variable name="uppercase" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'" />
    
    <xsl:template name="toggleBoolean">
        <xsl:param name="value"/>
        <xsl:choose>
            <xsl:when test="$value = 'true'">
                <xsl:value-of select="false()"/>
            </xsl:when>
            <xsl:when test="$value = 'false'">
                <xsl:value-of select="true()"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="true()"/>
            </xsl:otherwise>
        </xsl:choose>
        
        
    </xsl:template>
    
    <xsl:template name="getSoftwareNameFromTitle">
        <xsl:param name="title"/>
        
         <xsl:variable name="software">
             <xsl:if test="contains($title, 'Maximum' )">
                <xsl:value-of select="substring-before($title, 'Maximum' )"/>
             </xsl:if>
             <xsl:if test="contains($title, 'Minimum' )">
                <xsl:value-of select="substring-before($title, 'Minimum' )"/>
             </xsl:if>
             <xsl:if test="contains($title, 'Security Update' )">
                 <xsl:value-of select="substring-before($title, 'Security' )"/>
             </xsl:if>
             <xsl:if test="contains($title, 'version installed' )">
                 <xsl:value-of select="substring-before($title, 'version installed' )"/>
             </xsl:if>
         </xsl:variable>
        
        <xsl:choose>            
            <xsl:when test="$software != '' ">
                <xsl:value-of select="$software"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$title"/>
            </xsl:otherwise>
        </xsl:choose>
        
    </xsl:template>
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        
        <xsl:variable name="definitionIdWithoutCommon">
            <xsl:if test="contains($definitionId, '.common' )">
            <xsl:value-of select="concat(substring-before($definitionId, '.common'), substring-after($definitionId, '.common'))"/>
            </xsl:if>
            <xsl:if test="not(contains($definitionId, '.common' ))">
                <xsl:value-of select="$definitionId"/>
                </xsl:if>
        </xsl:variable>
        
        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionIdWithoutCommon]/@result"/>
        <xsl:call-template name="winSoftwareVersionCheck">
            <xsl:with-param name="definitionId" select="$definitionIdWithoutCommon"/>
            <xsl:with-param name="def_result" select="$result"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="winSoftwareVersionCheck">
        <xsl:param name="definitionId"/>       
        <xsl:param name="def_result"/>
        
         
         <xsl:variable name="title">
	<xsl:value-of select="$Definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>            
        </xsl:variable>
                
        <xsl:variable name="software">
            <xsl:call-template name="getSoftwareNameFromTitle">
                <xsl:with-param name="title" select="$title"/>            
            </xsl:call-template>
        </xsl:variable>
        
        <!-- calculate the number of tests in the definition, this will be helpful in generating only one finding message in case of  multiple tests -->
        <xsl:variable name="critCount">
            <xsl:value-of select="count($OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion)"/>
        </xsl:variable>
        
        <xsl:variable name="tests">        
            <xsl:for-each select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion">
                
                <xsl:variable name="test" select="@test_ref"/>
                <xsl:if test="$Tests/win-def:registry_test[@id=$test]">
                    <xsl:variable name="object" select="$Tests/win-def:registry_test[@id=$test]/win-def:object/@object_ref"/>
                    <xsl:variable name="state"  select="$Tests/win-def:registry_test[@id=$test]/win-def:state/@state_ref"/>
                    <xsl:variable name="key" select="$Objects/win-def:registry_object[@id=$object]/win-def:key"/>
                    <xsl:variable name="name" select="$Objects/win-def:registry_object[@id=$object]/win-def:name"/>                   
                    
                    <xsl:variable name="externalVar" select="$States/win-def:registry_state[@id=$state]/win-def:value/@var_ref"/>
                    <xsl:variable name="datatype" select="$States/win-def:registry_state[@id=$state]/win-def:value/@datatype"/>
                    <xsl:variable name="operation" select="$States/win-def:registry_state[@id=$state]/win-def:value/@operation"/>
                    
                    <xsl:element name="test">
                        <xsl:attribute name="id">
                            <xsl:value-of select="$test"/>
                        </xsl:attribute>
                        <xsl:attribute name="key">
                            <xsl:value-of select="$key"/>
                        </xsl:attribute>
                        <xsl:attribute name="name">
                            <xsl:value-of select="$name"/>
                        </xsl:attribute>
                        <xsl:attribute name="externalVar">
                            <xsl:value-of select="$externalVar"/>
                        </xsl:attribute>
                        <xsl:attribute name="operation">
                            <xsl:value-of select="$operation"/>
                        </xsl:attribute>
                        <xsl:attribute name="datatype">
                            <xsl:value-of select="$datatype"/>
                        </xsl:attribute>
                        <xsl:attribute name="testtype">
                            <xsl:text>registry</xsl:text>
                        </xsl:attribute>                       
                   
                    </xsl:element>
                </xsl:if>
                
                <!-- check if it is VARIABLE TEST -->
                <xsl:if test="$Tests/oval-ind:variable_test[@id=$test]">
                    <xsl:variable name="object" select="$Tests/oval-ind:variable_test[@id=$test]/oval-ind:object/@object_ref"/>
                    <xsl:variable name="state"  select="$Tests/oval-ind:variable_test[@id=$test]/oval-ind:state/@state_ref"/>
                    
                    <xsl:variable name="variableObjectRef" select="$Objects/oval-ind:variable_object[@id=$object]/oval-ind:var_ref"/>
                   
                    <xsl:variable name="externalVar" select="$States/oval-ind:variable_state[@id=$state]/oval-ind:value/@var_ref"/>
                    
                    <xsl:variable name="datatype" select="$States/oval-ind:variable_state[@id=$state]/oval-indvalue/@datatype"/>
                    <xsl:variable name="operation" select="$States/oval-ind:variable_state[@id=$state]/oval-ind:value/@operation"/>
                    
                    <xsl:element name="test">
                        <xsl:attribute name="id">
                            <xsl:value-of select="$test"/>
                        </xsl:attribute>
                        <xsl:attribute name="variableObjectRef">
                            <xsl:value-of select="$variableObjectRef"/>
                        </xsl:attribute>
                        <xsl:attribute name="externalVar">
                            <xsl:value-of select="$externalVar"/>
                        </xsl:attribute>
                        <xsl:attribute name="operation">
                            <xsl:value-of select="$operation"/>
                        </xsl:attribute>
                        <xsl:attribute name="datatype">
                            <xsl:value-of select="$datatype"/>
                        </xsl:attribute>
                        <xsl:attribute name="testtype">
                            <xsl:text>variable</xsl:text>
                        </xsl:attribute>                       
                        
                    </xsl:element>
                </xsl:if>
                
                <xsl:if test="$Tests/win-def:file_test[@id=$test]">
               
                    <xsl:variable name="state"  select="$Tests/win-def:file_test[@id=$test]/win-def:state/@state_ref"/>
                    
                    <xsl:if test="$States/win-def:file_state[@id=$state]/win-def:version">
                        <xsl:variable name="versionnode" select="name($States/win-def:file_state[@id=$state]/win-def:version)"/>
                        <xsl:variable name="externalVar" select="$States/win-def:file_state[@id=$state]/win-def:version/@var_ref"/>
                        <xsl:variable name="operation" select="$States/win-def:file_state[@id=$state]/win-def:version/@operation"/>
                        <xsl:variable name="datatype" select="$States/win-def:file_state[@id=$state]/win-def:version/@datatype"/>
                        
                     <xsl:element name="test">
                        <xsl:attribute name="id">
                            <xsl:value-of select="$test"/>
                        </xsl:attribute>
                         <xsl:attribute name="versionnodename">
                             <xsl:value-of select="$versionnode"/>
                        </xsl:attribute>
                        <xsl:attribute name="externalVar">
                            <xsl:value-of select="$externalVar"/>
                        </xsl:attribute>
                        <xsl:attribute name="operation">
                            <xsl:value-of select="$operation"/>
                        </xsl:attribute>
                        
                        <xsl:attribute name="testtype">
                            <xsl:text>file</xsl:text>
                        </xsl:attribute>
                      
                    </xsl:element>
                    </xsl:if>
                    
                    <xsl:if test="$States/win-def:file_state[@id=$state]/win-def:product_version">
                        <xsl:variable name="versionnode" select="name($States/win-def:file_state[@id=$state]/win-def:product_version)"/>
                        <xsl:variable name="externalVar" select="$States/win-def:file_state[@id=$state]/win-def:product_version/@var_ref"/>
                        <xsl:variable name="operation" select="$States/win-def:file_state[@id=$state]/win-def:product_version/@operation"/>
                        <xsl:variable name="datatype" select="$States/win-def:file_state[@id=$state]/win-def:version/@datatype"/>
                        
                        <xsl:element name="test">
                            <xsl:attribute name="id">
                                <xsl:value-of select="$test"/>
                            </xsl:attribute>
                            <xsl:attribute name="versionnodename">
                                <xsl:value-of select="$versionnode"/>
                            </xsl:attribute>
                            <xsl:attribute name="externalVar">
                                <xsl:value-of select="$externalVar"/>
                            </xsl:attribute>
                            <xsl:attribute name="operation">
                                <xsl:value-of select="$operation"/>
                            </xsl:attribute>
                            
                            <xsl:attribute name="testtype">
                                <xsl:text>file</xsl:text>
                            </xsl:attribute>
                            
                        </xsl:element>
                    </xsl:if>
                </xsl:if>
                
           
            </xsl:for-each>                        
        </xsl:variable>

                    
            
               <xsl:if test="$def_result = 'false' ">
                   <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
                       
                    <xsl:variable name="CheckSoftwareInstalled">
                           <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @testtype = 'registry'  ]">
                               <xsl:variable name="test" select="@id"/>          
                               <xsl:for-each  select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[@result = 'false'  or @result = 'error'  or  @result='not evaluated'] ">
                                   <xsl:text>1</xsl:text>
                               </xsl:for-each>
                      </xsl:for-each> 
                       <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @testtype = 'file' ]">
                               <xsl:variable name="test" select="@id"/>                 
                           <xsl:for-each  select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[@result = 'false'  or @result = 'error'  or  @result='not evaluated' ] ">
                                   <xsl:text>1</xsl:text>                                                                                             
                               </xsl:for-each>
                       </xsl:for-each>          
                        
                            <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @testtype = 'variable' ]">
                                <xsl:variable name="test" select="@id"/>          
                                <!-- following case has been added for the case when file test has varible for file path and that doesnot exist.
                                    in that case there is no tested item with test -->
                                <xsl:if test="not($TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item)">
                                    <xsl:text>2</xsl:text>
                                </xsl:if>
                                <xsl:for-each  select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[  @result = 'does not exist'  or  @result='not evaluated' or  @result='unknown' ] ">
                                    <xsl:text>2</xsl:text>                                                                                             
                                </xsl:for-each>
                            </xsl:for-each>
                        
                      </xsl:variable>
                       
                       <xsl:choose>
                           <xsl:when test="not(contains($CheckSoftwareInstalled,'1')) or contains($CheckSoftwareInstalled,'2')">
                       
                           <finding messageId="com.mcafee.pa.msg.winsoftwareversionnotexist" isViolation="true">
                               <instanceValue key="software">
                                   <xsl:value-of select="$software"/>                                                    
                               </instanceValue>
                           </finding>
                           </xsl:when>
                           <xsl:otherwise>
                       <!-- it is assumed that we need to generate findings message for last test criteria only for CRD coverage checks -->
                       <!-- therefore checking below that if it is last test then only create findings message -->
                       <xsl:for-each select="xalan:nodeset($tests)/descendant::test[position() = $critCount ]">
                  
                  <xsl:choose>
                                          
                      <xsl:when test="xalan:nodeset($tests)/descendant::test[ @testtype = 'variable']">
                          
                          <xsl:variable name="test" select="@id"/>
                          <xsl:variable name="variableObjectRef" select="@variableObjectRef"/>            
                          <xsl:variable name="datatype" select="@datatype"/>
                          <xsl:variable name="externalVarId" select="@externalVar"/>
                          <xsl:variable name="operation" select="@operation"/>
                          
                          <xsl:variable name="inputVersion" 
                              select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id = $externalVarId]"/>
                          
                          
                          <xsl:for-each  select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'false'  or @result = 'error'  or  @result='not evaluated' ] ">
                              
                              <xsl:variable name="itemRef" select="@item_id"/>
                              <xsl:variable name="result" select="@result"/>
                              
                          <!--    <xsl:variable name="actualVersion" select="$SystemData/oval-ind:variable_item[@id=$itemRef]/win-sc:value"/> -->
                              
                              <xsl:variable name="actualVersion" 
                              select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id = $variableObjectRef]"/>
                              
                              <xsl:variable name="actualVersionStatus" select="$SystemData/oval-ind:variable_item[@id=$itemRef]/oval-ind:name/@status"/>
                              
                              <xsl:variable name="message_id">
                                  <xsl:choose>
                                      <xsl:when test="$actualVersionStatus = 'does not exist' ">
                                          <xsl:text>com.mcafee.pa.msg.winsoftwareversionnotexist</xsl:text>                                    
                                      </xsl:when>
                                      <xsl:when test="$result = 'error' or  $result='not evaluated' ">
                                          <xsl:text>com.mcafee.pa.msg.winsoftwareversionreaderror</xsl:text>                                    
                                      </xsl:when>                                
                                      <xsl:otherwise>
                                          <xsl:choose>
                                              <xsl:when test="$operation = 'greater than or equal' ">
                                                  <xsl:text>com.mcafee.pa.msg.winsoftwareminimumversionmessage</xsl:text>
                                              </xsl:when>
                                              <xsl:when test="$operation = 'less than or equal' ">
                                                  <xsl:text>com.mcafee.pa.msg.winsoftwaremaximumversionmessage</xsl:text>
                                              </xsl:when>
                                              <xsl:otherwise>
                                                  <xsl:text>com.mcafee.pa.msg.winsoftwareversionmessage</xsl:text>          
                                              </xsl:otherwise>
                                          </xsl:choose>                                   
                                      </xsl:otherwise>
                                  </xsl:choose>
                              </xsl:variable>
                              
                              <finding messageId="{$message_id}" isViolation="true">
                                  <instanceValue key="software">
                                      <xsl:value-of select="$software"/>                                                    
                                  </instanceValue>    
                                  <instanceValue key="inputVersion">
                                      <xsl:value-of select="$inputVersion"/>                                                    
                                  </instanceValue>
                                  <instanceValue key="variable">
                                      <xsl:value-of select="$variableObjectRef"/>                                                    
                                  </instanceValue>                            
                                  <actualValue key="actualVersion">
                                      <xsl:value-of select="$actualVersion"/>                                                    
                                  </actualValue>
                              </finding>
                          </xsl:for-each>
                          
                          <xsl:for-each  select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'true'  ] ">
                              
                              <xsl:variable name="itemRef" select="@item_id"/>
                              <xsl:variable name="result" select="@result"/>
                              
                              <xsl:variable name="actualVersion" select="$SystemData/oval-ind:variable_item[@id=$itemRef]/oval-res:value"/>
                              
                              <xsl:variable name="actualVersionStatus" select="$SystemData/oval-ind:variable_item[@id=$itemRef]/oval-ind:name/@status"/>
                              
                              <xsl:variable name="message_id">
                                  <xsl:choose>           
                                      <xsl:when test="$operation = 'greater than or equal' ">
                                          <xsl:text>com.mcafee.pa.msg.winsoftwareminimumversionmessage</xsl:text>
                                      </xsl:when>
                                      <xsl:when test="$operation = 'less than or equal' ">
                                          <xsl:text>com.mcafee.pa.msg.winsoftwaremaximumversionmessage</xsl:text>
                                      </xsl:when>
                                      <xsl:otherwise>
                                          <xsl:text>com.mcafee.pa.msg.winsoftwareversionmessage</xsl:text>          
                                      </xsl:otherwise>
                                  </xsl:choose>                                  
                              </xsl:variable>
                              
                              <finding messageId="{$message_id}" isViolation="true">
                                  <instanceValue key="software">
                                      <xsl:value-of select="$software"/>                                                    
                                  </instanceValue> 
                                  <instanceValue key="inputVersion">
                                      <xsl:value-of select="$inputVersion"/>                                                    
                                  </instanceValue>
                                  <instanceValue key="variable">
                                      <xsl:value-of select="$variableObjectRef"/>                                                    
                                  </instanceValue>                                   
                                  <actualValue key="actualVersion">
                                      <xsl:value-of select="$actualVersion"/>                                                    
                                  </actualValue>
                              </finding>
                          </xsl:for-each>
                          
                      </xsl:when>
                  
                      <xsl:when test="xalan:nodeset($tests)/descendant::test[ @testtype = 'file']">
                          
                          <xsl:variable name="test" select="@id"/>
                          <xsl:variable name="versionnode" select="@versionnode"/>
                          <xsl:variable name="externalVarId" select="@externalVar"/>
                          <xsl:variable name="operation" select="@operation"/>
                          <xsl:variable name="datatype" select="@datatype"/>
                          
                          
                          <xsl:variable name="inputVersion" 
                              select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id = $externalVarId]"/>
                          
                          
                          <xsl:for-each select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'false'  or @result = 'error'  or  @result='not evaluated' ] ">
                              
                              <xsl:variable name="itemRef" select="@item_id"/>
                              <xsl:variable name="result" select="@result"/>
                              
                              <xsl:variable name="path" select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:path"/>
                              <xsl:variable name="file" select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:filename"/>
                              <xsl:variable name="fileStatus" select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:filename/@status"/>
                              
                              <xsl:variable name="version">
                                  <xsl:choose>
                                      <xsl:when test="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:product_version">
                                          <xsl:value-of select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:product_version"/>
                                      </xsl:when>
                                      <xsl:when test="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:version">
                                          <xsl:value-of select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:version"/>
                                      </xsl:when>
                                  </xsl:choose>
                              </xsl:variable>
                              
                              <xsl:variable name="versionStatus">
                                  <xsl:choose>
                                      <xsl:when test="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:product_version">
                                          <xsl:value-of select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:product_version/@status"/>
                                      </xsl:when>
                                      <xsl:when test="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:version">
                                          <xsl:value-of select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:version/@status"/>
                                      </xsl:when>
                                  </xsl:choose>                            
                              </xsl:variable>
                              
                              <xsl:variable name="message_id">
                                  <xsl:choose>
                                      <xsl:when test="$fileStatus = 'does not exist' ">
                                          <xsl:text>com.mcafee.pa.msg.winsoftwarefilenotexist</xsl:text>                                    
                                      </xsl:when>
                                      <xsl:when test="$versionStatus = 'does not exist' ">
                                          <xsl:text>com.mcafee.pa.msg.winsoftwarefileversionnotexist</xsl:text>                                    
                                      </xsl:when>
                                      <xsl:when test="$result = 'error' or  $result='not evaluated' ">
                                          <xsl:text>com.mcafee.pa.msg.winsoftwarefileversionreaderror</xsl:text>                                    
                                      </xsl:when>                                
                                      <xsl:otherwise>
                                          <xsl:choose>
                                              <xsl:when test="$operation = 'greater than or equal' ">
                                                  <xsl:text>com.mcafee.pa.msg.winfileminimumversionmessage</xsl:text>
                                              </xsl:when>
                                              <xsl:when test="$operation = 'less than or equal' ">
                                                  <xsl:text>com.mcafee.pa.msg.winfilemaximumversionmessage</xsl:text>
                                              </xsl:when>
                                              <xsl:otherwise>
                                                  <xsl:text>com.mcafee.pa.msg.winfileversionmessage</xsl:text>          
                                              </xsl:otherwise>
                                          </xsl:choose>                                   
                                      </xsl:otherwise>
                                  </xsl:choose>
                              </xsl:variable>
                              
                              <finding messageId="{$message_id}" isViolation="true">
                                  <instanceValue key="software">
                                      <xsl:value-of select="$software"/>                                                    
                                  </instanceValue>   
                                  <instanceValue key="inputVersion">
                                      <xsl:value-of select="$inputVersion"/>                                                    
                                  </instanceValue>
                                  <instanceValue key="filename">
                                      <xsl:value-of select="$file"/>                                                    
                                  </instanceValue> 
                                  <actualValue key="actualVersion">
                                      <xsl:value-of select="$version"/>                                                    
                                  </actualValue>
                              </finding>
                              
                          </xsl:for-each>
                          
                      </xsl:when>
                      <xsl:when test="xalan:nodeset($tests)/descendant::test[ @testtype = 'registry']">
                          
                          <xsl:variable name="test" select="@id"/>
                          <xsl:variable name="key" select="@key"/>
                          <xsl:variable name="name" select="@name"/>                   
                          <xsl:variable name="datatype" select="@datatype"/>
                          <xsl:variable name="externalVarId" select="@externalVar"/>
                          <xsl:variable name="operation" select="@operation"/>
                          
                          
                          <xsl:variable name="inputVersion" 
                              select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id = $externalVarId]"/>
                          
                          
                          <xsl:for-each  select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'false'  or @result = 'error'  or  @result='not evaluated' ] ">
                              
                              <xsl:variable name="itemRef" select="@item_id"/>
                              <xsl:variable name="result" select="@result"/>
                              
                              <xsl:variable name="actualVersion" select="$SystemData/win-sc:registry_item[@id=$itemRef]/win-sc:value"/>
                              <xsl:variable name="actualVersionStatus" select="$SystemData/win-sc:registry_item[@id=$itemRef]/win-sc:name/@status"/>
                              
                              <xsl:variable name="message_id">
                                  <xsl:choose>
                                      <xsl:when test="$actualVersionStatus = 'does not exist' ">
                                          <xsl:text>com.mcafee.pa.msg.winsoftwareversionnotexist</xsl:text>                                    
                                      </xsl:when>
                                      <xsl:when test="$result = 'error' or  $result='not evaluated' ">
                                          <xsl:text>com.mcafee.pa.msg.winsoftwareversionreaderror</xsl:text>                                    
                                      </xsl:when>                                
                                      <xsl:otherwise>
                                          <xsl:choose>
                                              <xsl:when test="$operation = 'greater than or equal' ">
                                                  <xsl:text>com.mcafee.pa.msg.winsoftwareminimumversionmessage</xsl:text>
                                              </xsl:when>
                                              <xsl:when test="$operation = 'less than or equal' ">
                                                  <xsl:text>com.mcafee.pa.msg.winsoftwaremaximumversionmessage</xsl:text>
                                              </xsl:when>
                                              <xsl:otherwise>
                                                  <xsl:text>com.mcafee.pa.msg.winsoftwareversionmessage</xsl:text>          
                                              </xsl:otherwise>
                                          </xsl:choose>                                   
                                      </xsl:otherwise>
                                  </xsl:choose>
                              </xsl:variable>
                              
                              <finding messageId="{$message_id}" isViolation="true">
                                  <instanceValue key="software">
                                      <xsl:value-of select="$software"/>                                                    
                                  </instanceValue>    
                                  <instanceValue key="inputVersion">
                                      <xsl:value-of select="$inputVersion"/>                                                    
                                  </instanceValue>
                                  <instanceValue key="registry">
                                      <xsl:value-of select="$key"/><xsl:text>\</xsl:text><xsl:value-of select="$name"/>                                                    
                                  </instanceValue>                            
                                  <actualValue key="actualVersion">
                                      <xsl:value-of select="$actualVersion"/>                                                    
                                  </actualValue>
                              </finding>
                          </xsl:for-each>
                      </xsl:when>   
                  </xsl:choose>
                       </xsl:for-each>
                           </xsl:otherwise>
                           </xsl:choose>
            
                                    
                </findings>
             </xsl:if>
        
        
            <xsl:if test="$def_result = 'true' ">
                <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">

                        <!-- it is assumed that we need to generate findings message for last test criteria only for CRD coverage checks -->
                        <!-- therefore checking below that if it is last test then only create findings message -->
                        <xsl:for-each select="xalan:nodeset($tests)/descendant::test[position() = $critCount ]">
                            
                            <xsl:choose>
                                                           
                                <xsl:when test="xalan:nodeset($tests)/descendant::test[ @testtype = 'variable'  ]">
                                    <xsl:variable name="test" select="@id"/>
                                    <xsl:variable name="variableObjectRef" select="@variableObjectRef"/>               
                                    <xsl:variable name="datatype" select="@datatype"/>
                                    <xsl:variable name="externalVarId" select="@externalVar"/>
                                    <xsl:variable name="operation" select="@operation"/>
                                    
                                    
                                    <xsl:variable name="inputVersion" 
                                        select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id = $externalVarId]"/>
                                    <!-- select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id = $externalVarId]"/>-->
                                    
                                    
                                    
                                    <xsl:for-each  select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'true'  ] ">
                                        
                                        <xsl:variable name="itemRef" select="@item_id"/>
                                        <xsl:variable name="result" select="@result"/>
                                        
                                       <!--  <xsl:variable name="actualVersion" select="$SystemData/oval-ind:tested_item[@id=$itemRef]/oval-ind:tested_variable[@id=$itemRef]/@value"/> -->
                                        <xsl:variable name="actualVersion" select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id = $variableObjectRef]"/>
                                        
                                        <xsl:variable name="actualVersionStatus" select="$SystemData/oval-ind:variable_item[@id=$itemRef]/oval-ind:name/@status"/>
                                        
                                        <xsl:variable name="message_id">
                                            <xsl:choose>           
                                                <xsl:when test="$operation = 'greater than or equal' ">
                                                    <xsl:text>com.mcafee.pa.msg.winsoftwareminimumversionmessage</xsl:text>
                                                </xsl:when>
                                                <xsl:when test="$operation = 'less than or equal' ">
                                                    <xsl:text>com.mcafee.pa.msg.winsoftwaremaximumversionmessage</xsl:text>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:text>com.mcafee.pa.msg.winsoftwareversionmessage</xsl:text>          
                                                </xsl:otherwise>
                                            </xsl:choose>                                  
                                        </xsl:variable>
                                        
                                        <finding messageId="{$message_id}" isViolation="false">
                                            <instanceValue key="software">
                                                <xsl:value-of select="$software"/>                                                    
                                            </instanceValue> 
                                            <instanceValue key="inputVersion">
                                                <xsl:value-of select="$inputVersion"/>                                                    
                                            </instanceValue>
                                            <instanceValue key="variable">
                                                <xsl:value-of select="$variableObjectRef"/>                                                    
                                            </instanceValue>                            
                                            <actualValue key="actualVersion">
                                                <xsl:value-of select="$actualVersion"/>                                                    
                                            </actualValue>
                                        </finding>
                                    </xsl:for-each>                                   
                                  
                                </xsl:when>
                      
                        <xsl:when test="xalan:nodeset($tests)/descendant::test[ @testtype = 'file' ]">
                        <xsl:variable name="test" select="@id"/>
                        <xsl:variable name="versionnode" select="@versionnode"/>
                        <xsl:variable name="externalVarId" select="@externalVar"/>
                        <xsl:variable name="operation" select="@operation"/>
                        <xsl:variable name="datatype" select="@datatype"/>
                        
                        
                        <xsl:variable name="inputVersion" 
                            select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id = $externalVarId]"/>
                        
                        
                        <xsl:for-each  select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'true' ] ">
                            
                            <xsl:variable name="itemRef" select="@item_id"/>
                            <xsl:variable name="result" select="@result"/>
                            
                            <xsl:variable name="path" select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:path"/>
                            <xsl:variable name="file" select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:filename"/>
                            <xsl:variable name="fileStatus" select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:filename/@status"/>
                            
                            <xsl:variable name="version">
                                <xsl:choose>
                                    <xsl:when test="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:product_version">
                                        <xsl:value-of select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:product_version"/>
                                    </xsl:when>
                                    <xsl:when test="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:version">
                                        <xsl:value-of select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:version"/>
                                    </xsl:when>
                                </xsl:choose>
                            </xsl:variable>
                            
                            <xsl:variable name="versionStatus">
                                <xsl:choose>
                                    <xsl:when test="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:product_version">
                                        <xsl:value-of select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:product_version/@status"/>
                                    </xsl:when>
                                    <xsl:when test="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:version">
                                        <xsl:value-of select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:version/@status"/>
                                    </xsl:when>
                                </xsl:choose>                            
                            </xsl:variable>
                            
                            <xsl:variable name="message_id">
                                        <xsl:choose>
                                            <xsl:when test="$operation = 'greater than or equal' ">
                                                <xsl:text>com.mcafee.pa.msg.winfileminimumversionmessage</xsl:text>
                                            </xsl:when>
                                            <xsl:when test="$operation = 'less than or equal' ">
                                                <xsl:text>com.mcafee.pa.msg.winfilemaximumversionmessage</xsl:text>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <xsl:text>com.mcafee.pa.msg.winfileversionmessage</xsl:text>          
                                            </xsl:otherwise>
                                        </xsl:choose>                                  
                            </xsl:variable>
                            
                            <finding messageId="{$message_id}" isViolation="false">
                                <instanceValue key="software">
                                    <xsl:value-of select="$software"/>                                                    
                                </instanceValue>   
                                <instanceValue key="inputVersion">
                                    <xsl:value-of select="$inputVersion"/>                                                    
                                </instanceValue>
                                <instanceValue key="filename">
                                    <xsl:value-of select="$path"/><xsl:text>\</xsl:text><xsl:value-of select="$file"/>                                                    
                                </instanceValue> 
                                <actualValue key="actualVersion">
                                    <xsl:value-of select="$version"/>                                                    
                                </actualValue>
                            </finding>
                            
                        </xsl:for-each>
                    </xsl:when>
                                <xsl:when test="xalan:nodeset($tests)/descendant::test[ @testtype = 'registry']">
                                    <xsl:variable name="test" select="@id"/>
                                    <xsl:variable name="key" select="@key"/>
                                    <xsl:variable name="name" select="@name"/>                   
                                    <xsl:variable name="datatype" select="@datatype"/>
                                    <xsl:variable name="externalVarId" select="@externalVar"/>
                                    <xsl:variable name="operation" select="@operation"/>
                                    
                                    
                                    <xsl:variable name="inputVersion" 
                                        select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id = $externalVarId]"/>
                                    
                                    
                                    <xsl:for-each  select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'true'  ] ">
                                        
                                        <xsl:variable name="itemRef" select="@item_id"/>
                                        <xsl:variable name="result" select="@result"/>
                                        
                                        <xsl:variable name="actualVersion" select="$SystemData/win-sc:registry_item[@id=$itemRef]/win-sc:value"/>
                                        <xsl:variable name="actualVersionStatus" select="$SystemData/win-sc:registry_item[@id=$itemRef]/win-sc:name/@status"/>
                                        
                                        <xsl:variable name="message_id">
                                            <xsl:choose>           
                                                <xsl:when test="$operation = 'greater than or equal' ">
                                                    <xsl:text>com.mcafee.pa.msg.winsoftwareminimumversionmessage</xsl:text>
                                                </xsl:when>
                                                <xsl:when test="$operation = 'less than or equal' ">
                                                    <xsl:text>com.mcafee.pa.msg.winsoftwaremaximumversionmessage</xsl:text>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:text>com.mcafee.pa.msg.winsoftwareversionmessage</xsl:text>          
                                                </xsl:otherwise>
                                            </xsl:choose>                                  
                                        </xsl:variable>
                                        
                                        <finding messageId="{$message_id}" isViolation="false">
                                            <instanceValue key="software">
                                                <xsl:value-of select="$software"/>                                                    
                                            </instanceValue> 
                                            <instanceValue key="inputVersion">
                                                <xsl:value-of select="$inputVersion"/>                                                    
                                            </instanceValue>
                                            <instanceValue key="registry">
                                                <xsl:value-of select="$key"/><xsl:text>\</xsl:text><xsl:value-of select="$name"/>                                                    
                                            </instanceValue>                            
                                            <actualValue key="actualVersion">
                                                <xsl:value-of select="$actualVersion"/>                                                    
                                            </actualValue>
                                        </finding>
                                    </xsl:for-each>
                                </xsl:when>
                            </xsl:choose>
                        </xsl:for-each>
                </findings>

            </xsl:if>
        
    </xsl:template>
</xsl:stylesheet>