/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.norad.ui;

import com.mcafee.epo.policy.model.PolicyObject;
import com.mcafee.epo.policy.model.PolicySettings;
import com.mcafee.epo.policy.services.PolicyObjectService;
import com.mcafee.orion.core.db.base.DatabaseUtil;
import com.mcafee.orion.core.db.base.IDatabase;
import com.mcafee.orion.core.servlet.ActionResponse;
import com.mcafee.orion.core.servlet.Response;
import com.mcafee.orion.core.servlet.mvc.BaseAction;
import java.sql.Connection;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class DATrepPolicySettings
extends BaseAction {
    private Logger logger = Logger.getLogger(DATrepPolicySettings.class);
    private IDatabase database;
    private PolicyObjectService policyObjectService;

    public Response displaypolicy(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        PolicyObject policyObject = (PolicyObject)httpServletRequest.getAttribute("epoPolicyObject");
        if (policyObject == null) {
            throw new Exception("Failed to get policy object from request");
        }
        Collection collection = policyObject.getPolicySettingsList();
        if (collection.size() > 0) {
            PolicySettings policySettings = (PolicySettings)collection.iterator().next();
            httpServletRequest.setAttribute("pso", (Object)policySettings);
            this.getUser().setAttribute("psoid", (Object)policySettings.getId());
            if ("1".equals(policySettings.getSetting("General", "optin"))) {
                httpServletRequest.setAttribute("optin", (Object)true);
            } else {
                httpServletRequest.setAttribute("optin", (Object)false);
            }
            if ("1".equals(policySettings.getSetting("General", "hcenable"))) {
                httpServletRequest.setAttribute("hcenable", (Object)true);
            } else {
                httpServletRequest.setAttribute("hcenable", (Object)false);
            }
            if (this.getUser().isAllowed("perm:MCDATREP1000.MCDATREP1000.admin")) {
                httpServletRequest.setAttribute("userAllowed", (Object)true);
            } else {
                httpServletRequest.setAttribute("userAllowed", (Object)false);
            }
            if (policyObject.getEditFlag() == 1) {
                httpServletRequest.setAttribute("readonly", (Object)true);
            } else {
                httpServletRequest.setAttribute("readonly", (Object)false);
            }
        }
        this.logger.debug((Object)"Forwarding the request to displayDATRepOptions.jsp");
        return ActionResponse.forward((String)"/MCDATREP1000", (String)"/WEB-INF/jsp/displayDATRepOptions.jsp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response savepolicy(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Integer n = (Integer)this.getUser().getAttribute("psoid");
        int n2 = 0;
        if (n != null) {
            n2 = n;
        }
        if (n2 > 0) {
            String string = httpServletRequest.getParameter("optin");
            String string2 = httpServletRequest.getParameter("hcenable");
            this.logger.debug((Object)("optinVal" + string));
            this.logger.debug((Object)("hcenableVal" + string2));
            if (string == null) {
                string = "0";
            }
            if (string2 == null) {
                string2 = "0";
            }
            if (!string.equalsIgnoreCase("0") && !string.equalsIgnoreCase("1")) {
                this.logger.debug((Object)"Invalid value for optin.Hence persisting values");
                return ActionResponse.none();
            }
            if (!string2.equalsIgnoreCase("0") && !string2.equalsIgnoreCase("1")) {
                this.logger.debug((Object)"Invalid value for hcenable.Hence persisting values");
                return ActionResponse.none();
            }
            if (string.equalsIgnoreCase("0")) {
                this.logger.debug((Object)"optin is disabled.Hence disabling hcenable");
                string2 = "0";
            }
            Connection connection = null;
            try {
                connection = this.database.getConnection();
                PolicySettings policySettings = this.policyObjectService.getPolicySettingsById(connection, this.getUser(), n2, false);
                policySettings.addSetting("General", "optin", string);
                policySettings.addSetting("General", "hcenable", string2);
                this.policyObjectService.savePolicySettings(connection, this.getUser(), policySettings, true, true);
                connection.commit();
            }
            catch (Exception exception) {
                this.logger.debug((Object)exception);
            }
            finally {
                DatabaseUtil.close((Connection)connection);
            }
        }
        return ActionResponse.none();
    }

    public void setPolicyObjectService(PolicyObjectService policyObjectService) {
        this.policyObjectService = policyObjectService;
    }

    public IDatabase getDatabase() {
        return this.database;
    }

    public void setDatabase(IDatabase iDatabase) {
        this.database = iDatabase;
    }
}

