/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.getsusp.common;

import com.mcafee.orion.core.auth.OrionUser;
import com.mcafee.orion.core.db.base.DatabaseMapper;
import com.mcafee.orion.core.query.QueryBuilder;
import com.mcafee.orion.core.query.QueryBuilderService;
import com.mcafee.orion.core.query.QueryExecutor;
import com.mcafee.orion.core.query.QueryResult;
import com.mcafee.orion.core.query.Row;
import com.mcafee.orion.core.query.sexp.Sexp;
import com.mcafee.orion.core.query.sexp.SexpException;
import com.mcafee.orion.core.query.sexp.SexpLong;
import com.mcafee.orion.core.query.sexp.SexpProp;
import com.mcafee.orion.core.query.sexp.ops.SexpEquals;
import com.mcafee.orion.core.query.sexp.ops.SexpSelect;
import com.mcafee.orion.core.query.sexp.ops.SexpWhere;
import java.sql.SQLException;

public class QueryExec {
    public static <T> QueryBuilder buildQuery(DatabaseMapper<T> databaseMapper, long l) {
        QueryBuilder queryBuilder = new QueryBuilder();
        queryBuilder.setTarget(databaseMapper.getTableName());
        DatabaseMapper.Column column = null;
        SexpSelect sexpSelect = new SexpSelect();
        for (DatabaseMapper.Column column2 : databaseMapper.getColumns()) {
            sexpSelect.addChild((Sexp)new SexpProp(databaseMapper.getTableName() + "." + column2.getColumnName()));
            if (!column2.isUniqueID()) continue;
            column = column2;
        }
        queryBuilder.setSelection(sexpSelect);
        SexpWhere sexpWhere = new SexpWhere();
        SexpEquals sexpEquals = new SexpEquals();
        sexpEquals.addChild((Sexp)new SexpProp(databaseMapper.getTableName() + "." + column.getColumnName()));
        sexpEquals.addChild((Sexp)new SexpLong(l));
        sexpWhere.addChild((Sexp)sexpEquals);
        queryBuilder.setCondition((Sexp)sexpWhere);
        return queryBuilder;
    }

    public static <T> T executeQuery(OrionUser orionUser, QueryBuilderService queryBuilderService, QueryBuilder queryBuilder, DatabaseMapper<T> databaseMapper) throws SexpException, SQLException, IllegalAccessException, InstantiationException {
        T t = null;
        QueryResult queryResult = queryBuilderService.executeQuery((QueryExecutor)queryBuilder, orionUser);
        if (queryResult.getCount() > 0) {
            t = databaseMapper.getBeanClass().newInstance();
            DatabaseMapper.Column[] columnArray = databaseMapper.getColumns();
            Row row = (Row)queryResult.getRows().get(0);
            for (int i = 0; i < columnArray.length; ++i) {
                columnArray[i].setValue(t, row.getDataObject(i));
            }
        }
        return t;
    }

    public static <T> T getEvent(OrionUser orionUser, QueryBuilderService queryBuilderService, DatabaseMapper<T> databaseMapper, long l) throws SexpException, SQLException, IllegalAccessException, InstantiationException {
        QueryBuilder queryBuilder = QueryExec.buildQuery(databaseMapper, l);
        return QueryExec.executeQuery(orionUser, queryBuilderService, queryBuilder, databaseMapper);
    }
}

