/*
 * Decompiled with CFR 0.152.
 */
package com.mcafee.getsusp.events.action;

import com.mcafee.getsusp.events.ExtendedEvent;
import com.mcafee.getsusp.events.ExtendedEventsDAO;
import com.mcafee.orion.core.auth.OrionUser;
import com.mcafee.orion.core.auth.UserAware;
import com.mcafee.orion.core.query.QueryBuilderService;
import com.mcafee.orion.core.servlet.ActionResponse;
import com.mcafee.orion.core.util.resource.LocaleAware;
import com.mcafee.orion.core.util.resource.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class ExtendedEventActions
implements UserAware,
LocaleAware {
    final Logger logger = Logger.getLogger(this.getClass());
    private String context = null;
    private static final String DESCRIPTION_URL = "/extendedevents/extendedevents.jsp";
    private OrionUser user;
    private Resource resource;
    private Locale locale;
    private QueryBuilderService queryService;

    public ActionResponse showExtendedEvents(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        long l = Long.parseLong(httpServletRequest.getParameter("uid"));
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        List<Object> list = new ArrayList();
        ExtendedEvent extendedEvent = null;
        try {
            ExtendedEventsDAO extendedEventsDAO = new ExtendedEventsDAO(this.user, this.queryService);
            extendedEvent = extendedEventsDAO.getEvent(l);
            if (extendedEvent != null) {
                list = this.splitString(extendedEvent.getSuspiciousFiles());
                this.addEventProperty(linkedHashMap, "GetSusp.da.suspiciousFiles", list);
                list = this.splitString(extendedEvent.getUnknownFiles());
                this.addEventProperty(linkedHashMap, "GetSusp.da.unknownFiles", list);
            }
        }
        catch (Exception exception) {
            this.logger.error((Object)("Error while fetching event with eventid " + l), (Throwable)exception);
            throw exception;
        }
        httpServletRequest.setAttribute("propertyMap", linkedHashMap);
        httpServletRequest.setAttribute("item", (Object)extendedEvent);
        return ActionResponse.forward((String)"/getsuspreports", (String)DESCRIPTION_URL);
    }

    public void addEventProperty(LinkedHashMap<String, Object> linkedHashMap, String string, Object object) {
        if (object != null) {
            if (object instanceof String && ((String)object).trim().equalsIgnoreCase("")) {
                return;
            }
            String string2 = this.resource.getString(string, this.locale);
            linkedHashMap.put(string2, object);
        }
    }

    public List<String> splitString(String string) {
        return Arrays.asList(string.split(","));
    }

    public void setUser(OrionUser orionUser) {
        this.user = orionUser;
    }

    public OrionUser getUser() {
        return this.user;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String string) {
        this.context = string;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public QueryBuilderService getQueryService() {
        return this.queryService;
    }

    public void setQueryService(QueryBuilderService queryBuilderService) {
        this.queryService = queryBuilderService;
    }
}

