--Copyright (C) 2023 Musarubra US LLC. All Rights Reserved.

-------------------------------------------Start GetSuspEventsMT Table and GetSuspEvents View---------------------------------------
--CUSTOM EVENT TABLE
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[GetSuspEventsMT]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
    CREATE TABLE [dbo].[GetSuspEventsMT] (
        [AutoID] [BIGINT] IDENTITY (1,1),
        [ParentID] [BIGINT] NOT NULL ,   -- Required for custom properties
        [ScanInitiated] datetime NOT NULL,
        [ScanFinished] datetime NOT NULL,
        [EmailId] [nvarchar](255) NOT NULL,
        [SuspiciousCount] [int] NOT NULL ,
        [UnknownCount] [int] NOT NULL,
        [SuspiciousFiles] [nvarchar](max),
        [UnknownFiles] [nvarchar](max),
        [SamplesFilename] [nvarchar](1024) NOT NULL,
        [SamplesDelivered] [bit] NOT NULL,
        [Comment] [nvarchar](250) NOT NULL,
        CONSTRAINT [PK_GetSuspEventsMT] PRIMARY KEY CLUSTERED
        (
          [AutoID] ASC
        ) ON [PRIMARY]
    ) ON [PRIMARY]
END
GO

-- Create foreign key
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_GetSuspEventsMT_EPOEvents_ParentID]') AND parent_object_id = OBJECT_ID(N'[dbo].[GetSuspEventsMT]'))
BEGIN
ALTER TABLE [dbo].[GetSuspEventsMT]  WITH CHECK ADD
    CONSTRAINT [FK_GetSuspEventsMT_EPOEvents_ParentID] FOREIGN KEY
    (
    [ParentID]
    )
    REFERENCES [dbo].[EPOEvents]
    (
    [AutoID]
    ) ON DELETE CASCADE ON UPDATE NO ACTION
END
GO

-- Create indexes
IF EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[GetSuspEventsMT]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
   AND NOT EXISTS (SELECT * FROM dbo.sysindexes WHERE id = OBJECT_ID(N'[dbo].[GetSuspEventsMT]') AND name = N'IX_GetSuspEvents_ScanFinished')
BEGIN
CREATE NONCLUSTERED INDEX [IX_GetSuspEvents_ScanFinished] ON [dbo].[GetSuspEventsMT]
(
       ScanFinished desc
)
INCLUDE (AutoID,ParentID,ScanInitiated,EmailId,SuspiciousCount,UnknownCount,SamplesFilename,SamplesDelivered,Comment)
END
GO


--NOW CREATE THE VIEW FOR THE GetSuspEventsMT Table
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[GetSuspEvents]') and OBJECTPROPERTY(id, N'IsView') = 1)
DROP VIEW [dbo].[GetSuspEvents]
GO

CREATE VIEW [dbo].[GetSuspEvents] AS
SELECT * FROM GetSuspEventsMT
GO

-------------------------------------------End GetSuspEventsMT Table and GetSuspEvents View---------------------------------------
