/*
 * Decompiled with CFR 0.152.
 */
package com.nai.Mead.RuleEngine;

import com.nai.Mead.RuleEngine.MessageAdaptorInterface;
import com.nai.Mead.RuleEngine.RuleEngineInterface;
import com.nai.Mead.RuleEngine.RuleInterface;
import com.nai.Mead.RuleEngine.RuleListenerInterface;
import com.nai.Mead.RuleEngine.Rules.RuleBase;
import com.nai.Mead.util.Resource;
import java.beans.ExceptionListener;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class RuleEngine
implements RuleEngineInterface,
ExceptionListener {
    private static final Logger m_log = Logger.getLogger((Class)(class$com$nai$Mead$RuleEngine$RuleEngine == null ? (class$com$nai$Mead$RuleEngine$RuleEngine = RuleEngine.class$("com.nai.Mead.RuleEngine.RuleEngine")) : class$com$nai$Mead$RuleEngine$RuleEngine));
    String engineName;
    boolean shuttingDown = false;
    Hashtable globalContext;
    Thread timerThread;
    final long SLEEP_MSEC = 1000L;
    RuleInterface rules;
    static /* synthetic */ Class class$com$nai$Mead$RuleEngine$RuleEngine;

    private void initEngine(String string) {
        this.engineName = string;
        this.rules = new RuleBase();
        this.globalContext = new Hashtable();
    }

    public RuleEngine() {
        this.initEngine("RuleEngine");
    }

    public RuleEngine(String string) {
        this.initEngine(string);
    }

    private void doTimer() {
        m_log.debug((Object)"Starting timer thread");
        this.timerThread = new Thread(){

            public void run() {
                try {
                    this.setName(RuleEngine.this.engineName + " timer");
                    m_log.debug((Object)"Timer thread has started");
                    while (!RuleEngine.this.shuttingDown) {
                        double d = System.currentTimeMillis();
                        RuleEngine.this.onTime(d, RuleEngine.this.globalContext);
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    m_log.debug((Object)"Timer thread has been stopped");
                }
            }
        };
        this.timerThread.start();
    }

    public static void main(String[] stringArray) {
        RuleEngine ruleEngine = new RuleEngine("Default");
        m_log.debug((Object)"RuleEngine is loading default rules...");
        ruleEngine.loadRules("rules.xml");
        m_log.debug((Object)"RuleEngine is starting");
        ruleEngine.start();
        m_log.debug((Object)"RuleEngine is stopping");
        ruleEngine.stop();
    }

    public int size() {
        return this.rules.size() - 1;
    }

    public void loadRules(InputStream inputStream) {
        RuleInterface ruleInterface = RuleBase.loadRules(inputStream, (ExceptionListener)this);
        if (ruleInterface != null) {
            this.rules = ruleInterface;
        }
    }

    public void loadRules(String string) {
        RuleInterface ruleInterface = RuleBase.loadRules(string, (ExceptionListener)this);
        if (ruleInterface != null) {
            this.rules = ruleInterface;
        }
    }

    public void saveRules(OutputStream outputStream) {
        RuleBase.saveRules(outputStream, this.rules);
    }

    public void saveRules(String string) {
        RuleBase.saveRules(string, this.rules);
    }

    public void addFalseRule(RuleListenerInterface ruleListenerInterface) {
        this.rules.addFalseRule(ruleListenerInterface);
    }

    public void addTrueRule(RuleListenerInterface ruleListenerInterface) {
        this.rules.addTrueRule(ruleListenerInterface);
    }

    public boolean isStarted() {
        return this.rules.isStarted();
    }

    public void removeFalseRule(RuleListenerInterface ruleListenerInterface) {
        this.rules.removeFalseRule(ruleListenerInterface);
    }

    public void removeTrueRule(RuleListenerInterface ruleListenerInterface) {
        this.rules.removeTrueRule(ruleListenerInterface);
    }

    public void start() {
        this.doTimer();
        this.rules.start();
    }

    public void stop() {
        if (this.isStarted() && this.timerThread != null) {
            this.timerThread.interrupt();
        }
        this.rules.stop();
    }

    public boolean onMessage(MessageAdaptorInterface messageAdaptorInterface, Hashtable hashtable) {
        m_log.debug((Object)"Starting onMessage for RuleEngine.");
        if (this.isStarted()) {
            m_log.debug((Object)"calling onMessage for the rules themselved.");
            return this.rules.onMessage(messageAdaptorInterface, hashtable);
        }
        m_log.debug((Object)"RuleEngine is not started, returning false.");
        return false;
    }

    public String getRuleID() {
        return this.rules.getRuleID();
    }

    public Object getRuleIDAsObject() {
        return this.rules.getRuleIDAsObject();
    }

    public void updateMessage(RuleInterface ruleInterface) {
        this.rules.updateMessage(ruleInterface);
    }

    public void doUpdate(RuleInterface ruleInterface) {
        m_log.debug((Object)"Updating rules in RuleEngine.");
        RuleEngine.updateRules(this.rules, ruleInterface);
        this.setRules(ruleInterface);
        m_log.debug((Object)"Done updating rule, calling setRules.");
    }

    public String getRuleText() {
        return null;
    }

    public void setRuleText(String string) {
    }

    public RuleInterface getRules() {
        return this.rules;
    }

    public void setRules(RuleInterface ruleInterface) {
        this.rules = ruleInterface;
    }

    public void onTime(double d, Hashtable hashtable) {
        if (this.isStarted()) {
            this.rules.onTime(d, hashtable);
        }
    }

    public List getFalseRules() {
        return this.getRules().getFalseRules();
    }

    public List getTrueRules() {
        return this.getRules().getTrueRules();
    }

    public void exceptionThrown(Exception exception) {
        m_log.error((Object)Resource.getString("ruleengine_load_failed"), (Throwable)exception);
    }

    public static HashMap collectAllRules(HashMap hashMap, RuleInterface ruleInterface) {
        String string = ruleInterface.getRuleID();
        Iterator iterator = null;
        m_log.debug((Object)("collect rule..." + string));
        hashMap.put(string, ruleInterface);
        try {
            RuleInterface ruleInterface2;
            iterator = ruleInterface.getTrueRules().iterator();
            while (iterator.hasNext()) {
                ruleInterface2 = (RuleInterface)iterator.next();
                RuleEngine.collectAllRules(hashMap, ruleInterface2);
            }
            iterator = ruleInterface.getFalseRules().iterator();
            while (iterator.hasNext()) {
                ruleInterface2 = (RuleInterface)iterator.next();
                RuleEngine.collectAllRules(hashMap, ruleInterface2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return hashMap;
    }

    public static HashMap collectAllRules(RuleInterface ruleInterface) {
        return RuleEngine.collectAllRules(new HashMap(), ruleInterface);
    }

    static void updateRules(RuleInterface ruleInterface, RuleInterface ruleInterface2) {
        m_log.debug((Object)("Get Source rules..." + ruleInterface));
        HashMap hashMap = RuleEngine.collectAllRules(ruleInterface);
        m_log.debug((Object)("Get Destination rules..." + ruleInterface2));
        HashMap hashMap2 = RuleEngine.collectAllRules(ruleInterface2);
        m_log.debug((Object)"Get key iterATOR...");
        try {
            Iterator iterator = hashMap.keySet().iterator();
            m_log.debug((Object)"Got the key iterator ");
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                RuleInterface ruleInterface3 = (RuleInterface)hashMap.get(string);
                RuleInterface ruleInterface4 = (RuleInterface)hashMap2.get(string);
                m_log.debug((Object)("Process rule " + string));
                if (ruleInterface3 == null || ruleInterface4 == null) continue;
                ruleInterface3.updateRule(ruleInterface4);
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    public void updateRule(RuleInterface ruleInterface) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

