/*
 * Decompiled with CFR 0.152.
 */
package com.nai.Mead.RuleEngine.tests;

import com.nai.Mead.RuleEngine.RuleEngine;
import com.nai.Mead.RuleEngine.RuleInterface;
import com.nai.Mead.RuleEngine.RuleListenerInterface;
import com.nai.Mead.RuleEngine.Rules.RuleBase;
import com.nai.Mead.RuleEngine.tests.RuleTest;
import java.beans.ExceptionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestRuleEngine
extends TestCase {
    static final int RULE_MAX = 1000;
    int trueMessages = 0;
    int falseMessages = 0;

    public TestRuleEngine(String string) {
        super(string);
    }

    public void testStartUpAndShutdown() {
        RuleEngine ruleEngine = new RuleEngine();
        Assert.assertFalse((String)"RuleEngine initally shows it is stopped.", (boolean)ruleEngine.isStarted());
        ruleEngine.start();
        Assert.assertTrue((String)"RuleEngine shows it is started after start().", (boolean)ruleEngine.isStarted());
        double d = System.currentTimeMillis() + 4000L;
        while ((double)System.currentTimeMillis() < d) {
        }
        ruleEngine.stop();
        Assert.assertFalse((String)"RuleEngine shows it is stopped after stop().", (boolean)ruleEngine.isStarted());
    }

    public void testRuleAddAndRemoveTrueRules() {
        RuleEngine ruleEngine = new RuleEngine();
        Assert.assertEquals((String)"Initial rule count is 0", (int)0, (int)ruleEngine.size());
        RuleBase ruleBase = new RuleBase();
        ruleEngine.addTrueRule(ruleBase);
        Assert.assertEquals((String)"After adding a true rule count is 1", (int)1, (int)ruleEngine.size());
        ruleEngine.addTrueRule(ruleBase);
        Assert.assertEquals((String)"After adding same true rule count is still 1", (int)1, (int)ruleEngine.size());
        ruleBase = new RuleBase();
        ruleEngine.addTrueRule(ruleBase);
        Assert.assertEquals((String)"After adding another true rule count is 2", (int)2, (int)ruleEngine.size());
        ruleEngine.removeTrueRule(ruleBase);
        Assert.assertEquals((String)"After removing original true rule count is 1", (int)1, (int)ruleEngine.size());
    }

    public void testRuleAddAndRemoveFalseRules() {
        RuleEngine ruleEngine = new RuleEngine();
        Assert.assertEquals((String)"Initial rule count is 0", (int)0, (int)ruleEngine.size());
        RuleBase ruleBase = new RuleBase();
        ruleEngine.addFalseRule(ruleBase);
        Assert.assertEquals((String)"After adding a false rule count is 1", (int)1, (int)ruleEngine.size());
        ruleEngine.addFalseRule(ruleBase);
        Assert.assertEquals((String)"After adding same false rule count is still 1", (int)1, (int)ruleEngine.size());
        ruleBase = new RuleBase();
        ruleEngine.addFalseRule(ruleBase);
        Assert.assertEquals((String)"After adding another false rule count is 2", (int)2, (int)ruleEngine.size());
        ruleEngine.removeFalseRule(ruleBase);
        Assert.assertEquals((String)"After removing original false rule count is 1", (int)1, (int)ruleEngine.size());
    }

    public void testSaveRules() {
        RuleEngine ruleEngine = new RuleEngine();
        RuleTest ruleTest = new RuleTest();
        ruleEngine.addTrueRule((RuleListenerInterface)ruleTest);
        ruleEngine.addFalseRule((RuleListenerInterface)new RuleTest());
        ruleTest.addTrueRule((RuleListenerInterface)new RuleTest());
        ruleTest.addTrueRule((RuleListenerInterface)new RuleTest());
        ruleEngine.addTrueRule((RuleListenerInterface)new RuleTest());
        Assert.assertEquals((String)"Preparing to save 5 rules", (int)5, (int)ruleEngine.size());
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream("Test.xml"));
            ruleEngine.saveRules(bufferedOutputStream);
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Assert.fail((String)"Can't open output file");
        }
        catch (IOException iOException) {
            Assert.fail((String)"Can't close output file");
        }
    }

    public void testLoadRules() {
        RuleEngine ruleEngine = new RuleEngine();
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream("Test.xml"));
            ruleEngine.loadRules(bufferedInputStream);
            ((InputStream)bufferedInputStream).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Assert.fail((String)"Can't open input file");
        }
        catch (IOException iOException) {
            Assert.fail((String)"Can't close input file");
        }
        Assert.assertEquals((String)"Load 5 rules", (int)5, (int)ruleEngine.size());
    }

    public void testUpdateRules() {
        RuleTest ruleTest = (RuleTest)RuleBase.loadRules("TestUpd1.xml", new ExceptionListener(){

            public void exceptionThrown(Exception exception) {
                exception.printStackTrace();
            }
        });
        ruleTest.setRuleText("public testing testing");
        ruleTest._setPrivatData("private testing testing");
        RuleBase.saveRules("TestUpd1.out", (RuleInterface)ruleTest);
        RuleTest ruleTest2 = (RuleTest)RuleBase.loadRules("TestUpd2.xml", new ExceptionListener(){

            public void exceptionThrown(Exception exception) {
                exception.printStackTrace();
            }
        });
        RuleBase.updateRules((RuleInterface)ruleTest2, (RuleInterface)ruleTest);
        RuleBase.saveRules("TestUpd2.out", (RuleInterface)ruleTest2);
        Assert.assertEquals((String)"Private text is preserved", (String)"private testing testing", (String)ruleTest2._getPrivatData());
        Assert.assertEquals((String)"Public text is replaced", (boolean)false, (boolean)"public testing testing".equals(ruleTest2.getRuleText()));
    }

    public static void main(String[] stringArray) {
        System.out.print("TestRuleEngine!\n");
    }
}

