/*
 * Decompiled with CFR 0.152.
 */
package com.nai.Mead.db;

import com.nai.Mead.RuleEngine.Rules.NotificationTarget.NotificationTargetBase;
import com.nai.Mead.RuleEngine.Rules.NotificationTarget.NotificationTargetFactory;
import com.nai.Mead.RuleEngine.Rules.NotificationTarget.NotificationTargetFactoryException;
import com.nai.Mead.db.AlertFamily;
import com.nai.Mead.db.EventCategory;
import com.nai.Mead.db.QueryUtil;
import com.nai.Mead.db.epo.EpoBranchNode;
import com.nai.Mead.db.epo.EpoDatabase;
import com.nai.Mead.util.Resource;
import com.nai.mcafee.common.db.DatabaseObject;
import com.nai.mcafee.common.db.DatabaseUtil;
import com.nai.mcafee.common.db.SimpleTable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import org.apache.log4j.Logger;

public class AlertUserRule
extends DatabaseObject {
    private static Logger m_log = Logger.getLogger((Class)(class$com$nai$Mead$db$AlertUserRule == null ? (class$com$nai$Mead$db$AlertUserRule = AlertUserRule.class$("com.nai.Mead.db.AlertUserRule")) : class$com$nai$Mead$db$AlertUserRule));
    public static final String TABLE_NAME = "AlertUserRule";
    public static final long FIVE_MINUTES_IN_MILLIS = 300000L;
    public static final int COL_ID = 1;
    public static final int COL_NAME = 2;
    public static final int COL_ENABLED = 3;
    public static final int COL_BRANCH_NODE_ID = 4;
    public static final int COL_BRANCH_NODE_PATH = 5;
    public static final int COL_SITE_ID = 6;
    public static final int COL_CREATE_DATE = 7;
    public static final int COL_MODIFY_DATE = 8;
    public static final int COL_DESCRIPTION = 9;
    public static final int COL_PRIORITY = 10;
    public static final int COL_ANY_ALERT_FAMILY = 11;
    public static final int COL_ANY_CATEGORY = 12;
    public static final int COL_THREAT_TEXT = 13;
    public static final int COL_THREAT_EXP = 14;
    public static final int COL_AGGREGATE = 15;
    public static final int COL_AGG_TIME = 16;
    public static final int COL_AGG_BY_COMPUTER = 17;
    public static final int COL_NUM_AGG_COMPUTERS = 18;
    public static final int COL_AGG_BY_EVENTS = 19;
    public static final int COL_NUM_AGG_EVENTS = 20;
    public static final int COL_THROTTLE = 21;
    public static final int COL_THROTTLE_TIME = 22;
    public static final int COL_WORKSTATION_OS = 23;
    public static final int COL_SERVER_OS = 24;
    public static final int COL_UNKNOWN_OS = 25;
    public static final int JOIN_ALERT_FAMILY_NAME = 26;
    public static final int JOIN_EVENT_CATEGORY_NAME = 27;
    public static final int JOIN_NOTIFICATION_TYPE = 28;
    public static final int PROP_SITE_NODE_NAME = 29;
    public static final int PROP_ALERT_FAMILIES = 30;
    public static final int PROP_EVENT_CATEGORIES = 31;
    public static final int PROP_NOTIFICATION_TARGETS = 32;
    public static final int PROP_CONFIG_FAMILIES = 33;
    public static final int PROP_CONFIG_CATEGORIES = 34;
    public static final int PROP_CONFIGURED_THREAT_NAME = 35;
    public static final int NUM_NATIVE_COLUMNS = 25;
    public static final int NUM_COLUMNS = 28;
    public static final int NUM_PROPERTIES = 35;
    public static final String[] PROPERTY_NAMES = new String[]{"", "AlertUserRuleId", "RuleName", "Enabled", "BranchNodeId", "BranchNodePath", "SiteId", "CreateDate", "ModifyDate", "Description", "Priority", "AnyAlertFamily", "AnyCategory", "ThreatText", "ThreatExp", "Aggregate", "AggregationTime", "AggByComputer", "NumAggComputers", "AggByEvents", "NumAggEvents", "Throttle", "ThrottleTime", "WorkstationOS", "ServerOS", "UnknownOS", "AlertFamilyName", "EventCategoryName", "NotificationType", "SiteNodeName", "AlertFamilies", "EventCategories", "NotificationTargets", "ConfiguredProductFamilies", "ConfiguredEventCategories", "ConfiguredThreatName"};
    public static final int MAX_LEN_RULE_NAME = 128;
    public static final int MAX_LEN_BRANCH_NODE_PATH = 512;
    public static final int MAX_LEN_DESCRIPTION = 2048;
    public static final int MAX_LEN_THREAT_TEXT = 50;
    public static final int MAX_LEN_THREAT_EXP = 50;
    protected static final String UNIQUE_SQL = "select * from AlertUserRule where AlertUserRuleId=?";
    protected static final String SQL_SELECT_BY_NAME = "select * from AlertUserRule where " + PROPERTY_NAMES[2] + "=?";
    private long m_id = -1L;
    private String m_name = null;
    private boolean m_enabled = true;
    private long m_branchNodeId = -1L;
    private String m_branchNodePath = null;
    private long m_siteId = -1L;
    private Timestamp m_createDate = new Timestamp(System.currentTimeMillis());
    private Timestamp m_modifyDate = null;
    private String m_description = "";
    private int m_priority = 2;
    protected Boolean m_anyAlertFamily = new Boolean(false);
    protected Boolean m_anyCategory = new Boolean(false);
    private String m_threatText = null;
    private String m_threatExp = null;
    private Boolean m_aggregate = new Boolean(false);
    private Long m_aggTime = new Long(300000L);
    private Boolean m_aggByComputer = new Boolean(false);
    private Integer m_numAggComputers = new Integer(100);
    private Boolean m_aggByEvents = new Boolean(true);
    private Integer m_numAggEvents = new Integer(100);
    private boolean m_throttle = false;
    private Long m_throttleTime = new Long(300000L);
    private Boolean m_workstationOS = new Boolean(true);
    private Boolean m_serverOS = new Boolean(true);
    private Boolean m_unknownOS = new Boolean(true);
    private Vector m_alertFamilies = null;
    private Vector m_categories = null;
    protected Vector m_targets = null;
    private String m_siteNodeName = null;
    private String m_afName = "";
    private String m_ecName = "";
    private String m_notType = "";
    static /* synthetic */ Class class$com$nai$Mead$db$AlertUserRule;
    static /* synthetic */ Class class$com$nai$Mead$db$AlertFamily;
    static /* synthetic */ Class class$com$nai$Mead$db$EventCategory;

    public static final Vector getByQuery(Connection connection, PreparedStatement preparedStatement, Class clazz, int n, int n2, NotificationTargetFactory notificationTargetFactory) throws SQLException, ClassNotFoundException, NotificationTargetFactoryException {
        Vector vector = DatabaseObject.getByQuery((Connection)connection, (PreparedStatement)preparedStatement, (Class)clazz, (int)n, (int)n2);
        if (vector != null) {
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                AlertUserRule alertUserRule = (AlertUserRule)((Object)iterator.next());
                alertUserRule.loadAFAndCat(connection);
                alertUserRule.loadNotTargets(connection, notificationTargetFactory);
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final AlertUserRule getUserRuleById(Connection connection, long l, Class clazz, NotificationTargetFactory notificationTargetFactory) throws SQLException, ClassNotFoundException, NotificationTargetFactoryException {
        PreparedStatement preparedStatement;
        Vector vector;
        block4: {
            AlertUserRule alertUserRule;
            vector = null;
            preparedStatement = null;
            try {
                preparedStatement = connection.prepareStatement(UNIQUE_SQL);
                preparedStatement.setLong(1, l);
                vector = AlertUserRule.getByQuery(connection, preparedStatement, clazz, 1, 1, notificationTargetFactory);
                if (vector.size() >= 1) break block4;
                alertUserRule = null;
                Object var9_7 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                DatabaseUtil.close((Statement)preparedStatement);
                throw throwable;
            }
            DatabaseUtil.close((Statement)preparedStatement);
            return alertUserRule;
        }
        if (vector.size() > 1) {
            throw new SQLException("getById() returned >1 row!");
        }
        Object var9_8 = null;
        DatabaseUtil.close((Statement)preparedStatement);
        return (AlertUserRule)((Object)vector.firstElement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Vector getAllUserRules(Connection connection, Class clazz, NotificationTargetFactory notificationTargetFactory) throws SQLException, ClassNotFoundException, NotificationTargetFactoryException {
        PreparedStatement preparedStatement = null;
        Vector vector = null;
        try {
            preparedStatement = connection.prepareStatement(QueryUtil.makeAlertUserRuleQuery(0, null, null));
            vector = AlertUserRule.getByQuery(connection, preparedStatement, clazz, 1, -1, notificationTargetFactory);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            DatabaseUtil.close((Statement)preparedStatement);
            throw throwable;
        }
        DatabaseUtil.close((Statement)preparedStatement);
        return vector;
    }

    public static final Vector getAllUserRulesAndCalc(Connection connection, Connection connection2, Class clazz, NotificationTargetFactory notificationTargetFactory) throws SQLException, ClassNotFoundException, NotificationTargetFactoryException {
        Vector vector = AlertUserRule.getAllUserRules(connection, clazz, notificationTargetFactory);
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            AlertUserRule alertUserRule = (AlertUserRule)((Object)iterator.next());
            alertUserRule.calculateProperties(connection, connection2, notificationTargetFactory);
        }
        return vector;
    }

    public static final Vector getAllEnabledUserRulesAndCalc(Connection connection, Connection connection2, Class clazz, NotificationTargetFactory notificationTargetFactory) throws SQLException, ClassNotFoundException, NotificationTargetFactoryException {
        Vector vector = DatabaseObject.getByQuery((Connection)connection, (String)"select * from AlertUserRule where Enabled=1", (Class)clazz, (int)1, (int)-1);
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            AlertUserRule alertUserRule = (AlertUserRule)((Object)iterator.next());
            alertUserRule.calculateProperties(connection, connection2, notificationTargetFactory);
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Vector getUserRuleByName(Connection connection, String string, Class clazz, NotificationTargetFactory notificationTargetFactory) throws SQLException, ClassNotFoundException, NotificationTargetFactoryException {
        PreparedStatement preparedStatement = null;
        Vector vector = null;
        try {
            preparedStatement = connection.prepareStatement(SQL_SELECT_BY_NAME);
            preparedStatement.setString(1, string);
            vector = AlertUserRule.getByQuery(connection, preparedStatement, clazz, 1, -1, notificationTargetFactory);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            DatabaseUtil.close((Statement)preparedStatement);
            throw throwable;
        }
        DatabaseUtil.close((Statement)preparedStatement);
        return vector;
    }

    public static void deleteUserRule(Connection connection, AlertUserRule alertUserRule) throws SQLException {
        long l = alertUserRule.getId();
        String string = "delete from RuleToAFMapping where " + PROPERTY_NAMES[1] + "=" + l;
        String string2 = "delete from RuleToCatMapping where " + PROPERTY_NAMES[1] + "=" + l;
        String string3 = "delete from AlertUserRule where " + PROPERTY_NAMES[1] + "=" + l;
        Vector vector = alertUserRule.getNotificationTargets();
        m_log.debug((Object)("Found: " + vector.size() + " notification targets."));
        Iterator iterator = alertUserRule.getNotificationTargets().iterator();
        while (iterator.hasNext()) {
            m_log.debug((Object)"Deleting another notification target...");
            NotificationTargetBase.deleteNotificationTarget(connection, (NotificationTargetBase)iterator.next());
            connection.commit();
        }
        m_log.debug((Object)("Executing SQL: " + string));
        DatabaseUtil.executeUpdate((Connection)connection, (String)string);
        m_log.debug((Object)("Executing SQL: " + string2));
        DatabaseUtil.executeUpdate((Connection)connection, (String)string2);
        m_log.debug((Object)("Executing SQL: " + string3));
        DatabaseUtil.executeUpdate((Connection)connection, (String)string3);
    }

    public int getNumColumns() {
        return 28;
    }

    public int getNumProperties() {
        return 35;
    }

    public String getPropertyName(int n) {
        return PROPERTY_NAMES[n];
    }

    public String getInsertSql() {
        return "insert into AlertUserRule values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    }

    public String getUpdateSql() {
        return "update AlertUserRule set RuleName=?, Enabled=?, BranchNodeId=?, BranchNodePath=?, SiteId=?, CreateDate=?, ModifyDate=?, Description=?, Priority=?, AnyAlertFamily=?, AnyCategory=?, ThreatText=?, ThreatExp=?, Aggregate=?, AggregationTime=?, AggByComputer=?, NumAggComputers=?, AggByEvents=?, NumAggEvents=?, Throttle=?, ThrottleTime=?, WorkstationOS=?, ServerOS=?, UnknownOS=? where AlertUserRuleId=?";
    }

    public String getUniqueQuerySql() {
        return UNIQUE_SQL;
    }

    public void add(Connection connection, Connection connection2, boolean bl) throws SQLException {
        this.loadEPOValues(connection2);
        this.add(connection, bl);
    }

    public void add(Connection connection, Connection connection2) throws SQLException {
        this.add(connection, connection2, true);
    }

    public void add(Connection connection, boolean bl) throws SQLException {
        super.add(connection, bl);
        this.saveAFAndCat(connection);
        this.saveNotTargets(connection);
    }

    public void add(Connection connection) throws SQLException {
        this.add(connection, true);
    }

    public void update(Connection connection) throws SQLException {
        super.update(connection);
        this.saveAFAndCat(connection);
        this.saveNotTargets(connection);
    }

    public void update(Connection connection, Connection connection2) throws SQLException {
        this.loadEPOValues(connection2);
        this.update(connection);
    }

    public void prepareInsert(PreparedStatement preparedStatement) throws SQLException {
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)1, (String)this.m_name, (int)128);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)2, (boolean)this.m_enabled);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)3, (long)this.m_branchNodeId);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)4, (String)this.m_branchNodePath);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)5, (long)this.m_siteId);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)6, (Timestamp)this.m_createDate);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)7, (Timestamp)this.m_modifyDate);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)8, (String)this.m_description, (int)2048);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)9, (int)this.m_priority);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)10, (Boolean)this.m_anyAlertFamily);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)11, (Boolean)this.m_anyCategory);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)12, (String)this.m_threatText, (int)50);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)13, (String)this.m_threatExp, (int)50);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)14, (Boolean)this.m_aggregate);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)15, (Long)this.m_aggTime);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)16, (Boolean)this.m_aggByComputer);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)17, (Integer)this.m_numAggComputers);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)18, (Boolean)this.m_aggByEvents);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)19, (Integer)this.m_numAggEvents);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)20, (boolean)this.m_throttle);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)21, (Long)this.m_throttleTime);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)22, (Boolean)this.m_workstationOS);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)23, (Boolean)this.m_serverOS);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)24, (Boolean)this.m_unknownOS);
    }

    public void prepareUpdate(PreparedStatement preparedStatement) throws SQLException {
        this.prepareInsert(preparedStatement);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)25, (long)this.m_id);
    }

    public void setUniqueID(int n) throws SQLException {
        this.setId(n);
    }

    public void setValues(ResultSet resultSet) throws SQLException {
        this.m_id = resultSet.getLong(1);
        this.m_name = resultSet.getString(2);
        this.m_enabled = resultSet.getBoolean(3);
        this.m_branchNodeId = resultSet.getLong(4);
        this.m_branchNodePath = resultSet.getString(5);
        this.m_siteId = resultSet.getLong(6);
        this.m_createDate = resultSet.getTimestamp(7);
        this.m_modifyDate = resultSet.getTimestamp(8);
        this.m_description = resultSet.getString(9);
        this.m_priority = resultSet.getInt(10);
        this.m_anyAlertFamily = this.getBoolean(resultSet, 11);
        this.m_anyCategory = this.getBoolean(resultSet, 12);
        this.m_threatText = resultSet.getString(13);
        this.m_threatExp = resultSet.getString(14);
        this.m_aggregate = this.getBoolean(resultSet, 15);
        this.m_aggTime = this.getLong(resultSet, 16);
        this.m_aggByComputer = this.getBoolean(resultSet, 17);
        this.m_numAggComputers = this.getInt(resultSet, 18);
        this.m_aggByEvents = this.getBoolean(resultSet, 19);
        this.m_numAggEvents = this.getInt(resultSet, 20);
        this.m_throttle = resultSet.getBoolean(21);
        this.m_throttleTime = this.getLong(resultSet, 22);
        this.m_workstationOS = this.getBoolean(resultSet, 23);
        this.m_serverOS = this.getBoolean(resultSet, 24);
        this.m_unknownOS = this.getBoolean(resultSet, 25);
        if (resultSet.getMetaData().getColumnCount() > 25) {
            this.m_afName = resultSet.getString(26);
            this.m_ecName = resultSet.getString(27);
            this.m_notType = resultSet.getString(28);
        }
    }

    public void calculateProperties(Connection connection, Connection connection2, NotificationTargetFactory notificationTargetFactory) throws SQLException, ClassNotFoundException, NotificationTargetFactoryException {
        m_log.debug((Object)("In calculate properties for rule: " + this.m_name));
        if (!this.loadEPOValues(connection2)) {
            m_log.debug((Object)"ePO values have changed.  Updating the rule...");
            this.update(connection);
            connection.commit();
        }
        if (this.m_alertFamilies == null || this.m_categories == null) {
            this.loadAFAndCat(connection);
            this.loadNotTargets(connection, notificationTargetFactory);
        }
    }

    public Vector getAlertFamilies() {
        return this.m_alertFamilies;
    }

    public String getConfiguredProductFamilies() {
        String string = "";
        if (this.m_alertFamilies != null) {
            string = this.mashTogether(this.m_alertFamilies.iterator());
        }
        return string;
    }

    public void addAlertFamily(Connection connection, String string) throws SQLException {
        if (this.m_alertFamilies == null) {
            this.m_alertFamilies = new Vector();
        }
        AlertFamily alertFamily = (AlertFamily)SimpleTable.getByName((Connection)connection, (String)"AlertFamily", (String)string, (Class)(class$com$nai$Mead$db$AlertFamily == null ? (class$com$nai$Mead$db$AlertFamily = AlertUserRule.class$("com.nai.Mead.db.AlertFamily")) : class$com$nai$Mead$db$AlertFamily));
        this.m_alertFamilies.add(alertFamily);
    }

    public void clearAlertFamilies() {
        if (this.m_alertFamilies != null) {
            this.m_alertFamilies.clear();
        }
    }

    private String mashTogether(Iterator iterator) {
        SimpleTable simpleTable;
        String string = "";
        if (iterator.hasNext()) {
            simpleTable = (SimpleTable)iterator.next();
            string = simpleTable.getName();
        }
        while (iterator.hasNext()) {
            simpleTable = (SimpleTable)iterator.next();
            string = string + "," + simpleTable.getName();
        }
        return string;
    }

    public Vector getEventCategoryNames() {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < this.getEventCategories().size()) {
            EventCategory eventCategory = (EventCategory)((Object)this.getEventCategories().elementAt(n));
            vector.add(eventCategory.getName());
            ++n;
        }
        return vector;
    }

    public Vector getEventCategoryNamesAsIds() {
        Vector<Long> vector = new Vector<Long>();
        int n = 0;
        while (n < this.getEventCategories().size()) {
            EventCategory eventCategory = (EventCategory)((Object)this.getEventCategories().elementAt(n));
            vector.add(new Long(eventCategory.getId()));
            ++n;
        }
        return vector;
    }

    public Vector getAlertFamilyNames() {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < this.getAlertFamilies().size()) {
            AlertFamily alertFamily = (AlertFamily)((Object)this.getAlertFamilies().elementAt(n));
            vector.add(alertFamily.getName());
            ++n;
        }
        return vector;
    }

    public Vector getAlertFamilyNamesAsIds() {
        Vector<Long> vector = new Vector<Long>();
        int n = 0;
        while (n < this.getAlertFamilies().size()) {
            AlertFamily alertFamily = (AlertFamily)((Object)this.getAlertFamilies().elementAt(n));
            vector.add(new Long(alertFamily.getId()));
            ++n;
        }
        return vector;
    }

    public Vector getEventCategories() {
        return this.m_categories;
    }

    public String getConfiguredEventCategories() {
        String string = "";
        if (this.m_categories != null) {
            string = this.mashTogether(this.m_categories.iterator());
        }
        return string;
    }

    public void addEventCategory(Connection connection, String string) throws SQLException {
        if (this.m_categories == null) {
            this.m_categories = new Vector();
        }
        EventCategory eventCategory = (EventCategory)SimpleTable.getByName((Connection)connection, (String)"EventCategory", (String)string, (Class)(class$com$nai$Mead$db$EventCategory == null ? (class$com$nai$Mead$db$EventCategory = AlertUserRule.class$("com.nai.Mead.db.EventCategory")) : class$com$nai$Mead$db$EventCategory));
        this.m_categories.add(eventCategory);
    }

    public void clearEventCategories() {
        if (this.m_categories != null) {
            this.m_categories.clear();
        }
    }

    public void addNotificationTarget(NotificationTargetBase notificationTargetBase) {
        if (this.m_targets == null) {
            this.m_targets = new Vector();
        }
        this.m_targets.add(notificationTargetBase);
    }

    public void updateNotificationTarget(NotificationTargetBase notificationTargetBase) {
        long l = notificationTargetBase.getNotificationTargetId();
        Iterator iterator = this.m_targets.iterator();
        while (iterator.hasNext()) {
            NotificationTargetBase notificationTargetBase2 = (NotificationTargetBase)iterator.next();
            if (notificationTargetBase2.getNotificationTargetId() != l) continue;
            iterator.remove();
            this.addNotificationTarget(notificationTargetBase);
            break;
        }
    }

    public Vector getNotificationTargets() {
        return this.m_targets;
    }

    public Long getAlertUserRuleId() {
        return new Long(this.m_id);
    }

    public long getId() {
        return this.m_id;
    }

    public void setId(int n) {
        this.m_id = n;
    }

    public String getNotificationRuleName() {
        return this.getRuleName();
    }

    public String getRuleName() {
        return this.m_name;
    }

    public void setRuleName(String string) {
        this.m_name = string;
    }

    public boolean getEnabled() {
        return this.m_enabled;
    }

    public void setEnabled(boolean bl) {
        this.m_enabled = bl;
    }

    public long getBranchNodeId() {
        return this.m_branchNodeId;
    }

    public void setBranchNodeId(long l) {
        this.m_branchNodeId = l;
    }

    public String getBranchNodePath() {
        return this.m_branchNodePath;
    }

    public void setBranchNodePath(String string) {
        this.m_branchNodePath = string;
    }

    public long getSiteId() {
        return this.m_siteId;
    }

    private void setSiteId(Connection connection) throws SQLException {
        if (this.m_branchNodeId != -1L) {
            LinkedList linkedList = EpoBranchNode.getAncestry(connection, this.m_branchNodeId);
            if (linkedList == null) {
                this.m_branchNodeId = -1L;
                this.m_siteId = -1L;
                this.m_branchNodePath = "";
                this.m_siteNodeName = "";
                this.m_enabled = false;
            } else if (linkedList.size() == 1) {
                this.m_siteId = ((EpoBranchNode)((Object)linkedList.getFirst())).getId();
            } else {
                Iterator iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    EpoBranchNode epoBranchNode = (EpoBranchNode)((Object)iterator.next());
                    if (epoBranchNode.getType() != 6) continue;
                    this.m_siteId = epoBranchNode.getId();
                    break;
                }
            }
        }
    }

    public void setSiteId(long l) {
        this.m_siteId = l;
    }

    public Timestamp getCreateDate() {
        return this.m_createDate;
    }

    public void setCreateDate(Timestamp timestamp) {
        this.m_createDate = timestamp;
    }

    public Timestamp getModifyDate() {
        return this.m_modifyDate;
    }

    public void setModifyDate(Timestamp timestamp) {
        this.m_modifyDate = timestamp;
    }

    public void setDescription(String string) {
        this.m_description = string;
    }

    public String getDescription() {
        return this.m_description;
    }

    public int getPriority() {
        return this.m_priority;
    }

    public void setPriority(int n) {
        this.m_priority = n;
    }

    public Boolean getAnyAlertFamily() {
        return this.m_anyAlertFamily;
    }

    public void setAnyAlertFamily(Boolean bl) {
        this.m_anyAlertFamily = bl;
        if (this.m_alertFamilies != null && bl.booleanValue()) {
            this.m_alertFamilies.clear();
        }
    }

    public Boolean getAnyCategory() {
        return this.m_anyCategory;
    }

    public void setAnyCategory(Boolean bl) {
        this.m_anyCategory = bl;
        if (this.m_categories != null && !bl.booleanValue()) {
            this.m_categories.clear();
        }
    }

    public String getThreatText() {
        return this.m_threatText;
    }

    public void setThreatText(String string) {
        this.m_threatText = string;
    }

    public String getThreatExp() {
        return this.m_threatExp;
    }

    public void setThreatExp(String string) {
        this.m_threatExp = string;
    }

    public Boolean getAggregate() {
        return this.m_aggregate;
    }

    public void setAggregate(Boolean bl) {
        this.m_aggregate = bl;
    }

    public Long getAggregationTime() {
        return this.m_aggTime;
    }

    public void setAggregationTime(Long l) {
        this.m_aggTime = l;
    }

    public Boolean getAggByComputer() {
        return this.m_aggByComputer;
    }

    public void setAggByComputer(Boolean bl) {
        this.m_aggByComputer = bl;
    }

    public Integer getNumAggComputers() {
        return this.m_numAggComputers;
    }

    public void setNumAggComputers(Integer n) {
        this.m_numAggComputers = n;
    }

    public Boolean getAggByEvents() {
        return this.m_aggByEvents;
    }

    public void setAggByEvents(Boolean bl) {
        this.m_aggByEvents = bl;
    }

    public Integer getNumAggEvents() {
        return this.m_numAggEvents;
    }

    public void setNumAggEvents(Integer n) {
        this.m_numAggEvents = n;
    }

    public boolean getThrottle() {
        return this.m_throttle;
    }

    public void setThrottle(boolean bl) {
        this.m_throttle = bl;
    }

    public Long getThrottleTime() {
        return this.m_throttleTime;
    }

    public void setThrottleTime(Long l) {
        this.m_throttleTime = l;
    }

    public void setSiteNodeName(String string) {
        this.m_siteNodeName = string;
    }

    public String getSiteNodeName() {
        return this.m_siteNodeName;
    }

    public String getConfiguredThreatName() {
        return this.getConfiguredThreatName(null);
    }

    public String getConfiguredThreatName(String string) {
        String string2 = null;
        if (this.m_threatExp != null) {
            string2 = Resource.getDataString(this.m_threatExp, string);
        }
        if (this.m_threatText != null) {
            string2 = string2 + " " + this.m_threatText;
        }
        return string2;
    }

    public void setWorkstationOS(Boolean bl) {
        this.m_workstationOS = bl;
    }

    public Boolean getWorkstationOS() {
        return this.m_workstationOS;
    }

    public void setServerOS(Boolean bl) {
        this.m_serverOS = bl;
    }

    public Boolean getServerOS() {
        return this.m_serverOS;
    }

    public void setUnknownOS(Boolean bl) {
        this.m_unknownOS = bl;
    }

    public Boolean getUnknownOS() {
        return this.m_unknownOS;
    }

    public void setAlertFamilyName(String string) {
        this.m_afName = string;
    }

    public String getAlertFamilyName() {
        return this.m_afName;
    }

    public void setEventCategoryName(String string) {
        this.m_ecName = string;
    }

    public String getEventCategoryName() {
        return this.m_ecName;
    }

    public void setNotificationType(String string) {
        this.m_notType = string;
    }

    public String getNotificationType() {
        return this.m_notType;
    }

    public boolean validateRule() {
        boolean bl = false;
        if (this.m_name != null && this.m_name.length() > 0 && this.m_branchNodeId != -1L && this.m_siteId != -1L && this.m_branchNodePath != null && this.m_branchNodePath.length() > 0 && this.m_targets.size() > 0) {
            bl = true;
        }
        return bl;
    }

    protected void loadNotTargets(Connection connection, NotificationTargetFactory notificationTargetFactory) throws SQLException, ClassNotFoundException, NotificationTargetFactoryException {
        if (this.m_targets == null) {
            this.m_targets = new Vector();
        }
        if (notificationTargetFactory == null) {
            notificationTargetFactory = new NotificationTargetFactory(connection);
        }
        NotificationTargetBase[] notificationTargetBaseArray = NotificationTargetBase.getByRuleId(connection, this.m_id, notificationTargetFactory);
        this.m_targets.addAll(Arrays.asList(notificationTargetBaseArray));
    }

    protected void saveNotTargets(Connection connection) throws SQLException {
        if (this.m_targets != null) {
            Iterator iterator = this.m_targets.iterator();
            while (iterator.hasNext()) {
                NotificationTargetBase notificationTargetBase = (NotificationTargetBase)iterator.next();
                notificationTargetBase.setAlertUserRuleId(this.m_id);
                m_log.debug((Object)("Associating a new notification target to rule ID: " + this.m_id));
                if (notificationTargetBase.getNotificationTargetId() <= -1L) {
                    notificationTargetBase.add(connection);
                    continue;
                }
                notificationTargetBase.update(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteTargets(Connection connection, String string) throws SQLException {
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.executeUpdate("delete from " + string + " where AlertUserRuleId=" + this.m_id);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            DatabaseUtil.close((Statement)statement);
            throw throwable;
        }
        DatabaseUtil.close((Statement)statement);
    }

    protected void loadAFAndCat(Connection connection) throws SQLException {
        Vector vector;
        if (this.m_id != -1L) {
            // empty if block
        }
        if (this.m_alertFamilies == null) {
            this.m_alertFamilies = new Vector();
        } else {
            this.m_alertFamilies.clear();
        }
        if (this.m_categories == null) {
            this.m_categories = new Vector();
        } else {
            this.m_categories.clear();
        }
        if (!this.getAnyAlertFamily().booleanValue() && (vector = AlertFamily.getAFByRuleId(connection, this.m_id)) != null) {
            this.m_alertFamilies.addAll(vector);
        }
        if (!this.getAnyCategory().booleanValue() && (vector = EventCategory.getCatByRuleId(connection, this.m_id)) != null) {
            this.m_categories.addAll(vector);
        }
    }

    protected void saveAFAndCat(Connection connection) throws SQLException {
        if (this.m_id != -1L) {
            if (this.m_alertFamilies != null) {
                this.deleteEntries(connection, "RuleToAFMapping");
                this.insertEntries(connection, "RuleToAFMapping", this.m_alertFamilies.iterator());
            }
            if (this.m_categories != null) {
                this.deleteEntries(connection, "RuleToCatMapping");
                this.insertEntries(connection, "RuleToCatMapping", this.m_categories.iterator());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertEntries(Connection connection, String string, Iterator iterator) throws SQLException {
        Statement statement = null;
        try {
            statement = connection.createStatement();
            while (iterator.hasNext()) {
                SimpleTable simpleTable = (SimpleTable)iterator.next();
                statement.executeUpdate("insert into " + string + " values(" + this.m_id + ", " + simpleTable.getId() + ")");
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            DatabaseUtil.close((Statement)statement);
            throw throwable;
        }
        DatabaseUtil.close((Statement)statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteEntries(Connection connection, String string) throws SQLException {
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.executeUpdate("delete from " + string + " where AlertUserRuleId=" + this.m_id);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            DatabaseUtil.close((Statement)statement);
            throw throwable;
        }
        DatabaseUtil.close((Statement)statement);
    }

    private boolean loadEPOValues(Connection connection) throws SQLException {
        boolean bl = true;
        m_log.debug((Object)"Loading ePO values...");
        m_log.debug((Object)("BranchNode ID is: " + this.m_branchNodeId));
        if (this.m_branchNodeId != -1L) {
            long l = this.m_siteId;
            this.setSiteId(connection);
            m_log.debug((Object)("Site ID is: " + this.m_siteId + " old site ID was: " + l));
            if (l != this.m_siteId) {
                bl = false;
            }
            if (this.m_branchNodeId != -1L) {
                String string = EpoBranchNode.getAncestryAsString(connection, this.m_branchNodeId);
                if (!string.equals(this.m_branchNodePath)) {
                    this.m_branchNodePath = string;
                    bl = false;
                }
                m_log.debug((Object)("Branch node path is: " + this.m_branchNodePath));
            }
        }
        if (this.m_siteId != -1L) {
            this.m_siteNodeName = EpoDatabase.getNameForBranchNode(connection, this.m_siteId);
            if (this.m_siteNodeName.equals("Directory")) {
                this.m_siteNodeName = "{Directory}";
            }
            m_log.debug((Object)("Site node name is: " + this.m_siteNodeName));
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

