/*
 * Decompiled with CFR 0.152.
 */
package com.nai.Mead.db;

import com.nai.Mead.db.AlertUserRule;
import com.nai.Mead.db.AlertingConfig;
import com.nai.Mead.db.NotificationLog;
import com.nai.Mead.db.SexpQueryUtil;
import com.nai.Mead.ui.util.PageState;
import com.nai.Mead.ui.util.PropDisplayFactory;
import com.nai.mcafee.common.condition.SexpException;
import com.nai.mcafee.common.db.DatabaseUtil;
import com.nai.mcafee.common.db.epo.EpoUser;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class QueryUtil {
    private static final Logger m_log = Logger.getLogger((Class)(class$com$nai$Mead$db$QueryUtil == null ? (class$com$nai$Mead$db$QueryUtil = QueryUtil.class$("com.nai.Mead.db.QueryUtil")) : class$com$nai$Mead$db$QueryUtil));
    public static final int ORDER_MIN = 1;
    public static final int ORDER_ASCENDING = 1;
    public static final int ORDER_DESCENDING = 2;
    public static final int ORDER_MAX = 2;
    static /* synthetic */ Class class$com$nai$Mead$db$QueryUtil;
    static /* synthetic */ Class class$com$nai$Mead$db$NotificationLog;

    public static final void clearAllTables(Connection connection) throws SQLException {
        DatabaseUtil.clearTable((Connection)connection, (String)"RuleToAFMapping");
        DatabaseUtil.clearTable((Connection)connection, (String)"RuleToCatMapping");
        DatabaseUtil.clearTable((Connection)connection, (String)"NotificationTargetSettings");
        DatabaseUtil.clearTable((Connection)connection, (String)"NotificationTarget");
        DatabaseUtil.clearTable((Connection)connection, (String)"AlertUserRule");
        DatabaseUtil.clearTable((Connection)connection, (String)"NotificationLog");
    }

    public static final String makeAlertUserRuleQuery(int n, EpoUser epoUser, AlertingConfig alertingConfig) {
        String string = "select a.AlertUserRuleId, max(a.[RuleName]) as RuleName, a.Enabled as Enabled, max(a.BranchNodeId) as BranchNodeId,  max(a.BranchNodePath) as BranchNodePath, max(a.SiteId) as SiteId, max(a.CreateDate) as CreateDate, max(a.ModifyDate) as ModifyDate, max(a.[Description]) as [Description], max(a.Priority) as Priority, a.AnyAlertFamily as AnyAlertFamily, a.AnyCategory as AnyCategory, max(a.ThreatText) as ThreatText, max(a.ThreatExp) as ThreatExp, a.Aggregate as Aggregate, max(a.AggregationTime) as AggregationTime, a.AggByComputer as AggByComputer, max(a.NumAggComputers) as NumAggComputers, a.AggByEvents as AggByEvents, max(a.NumAggEvents) as NumAggEvents, a.Throttle as Throttle, max(a.ThrottleTime) as ThrottleTime,\ta.WorkstationOS as WorkstationOS, a.ServerOS as SeverOS, a.UnknownOS as UnknownOS, min(af.[Name]) as AlertFamilyName, min(ec.[Name]) as EventCategoryName, max(nt.RuleClassName) as NotificationType from AlertUserRule as a left join RuleToAFMapping as afm on a.AlertUserRuleId=afm.AlertUserRuleId left join RuleToCatMapping as cm on a.AlertUserRuleId=cm.AlertUserRuleId left join AlertFamily as af on af.AlertFamilyId=afm.AlertFamilyId left join EventCategory as ec on ec.EventCategoryId=cm.EventCategoryId left join NotificationTarget as nt on nt.AlertUserRuleId=a.AlertUserRuleId ";
        string = n != 0 ? string + " where " + AlertUserRule.PROPERTY_NAMES[6] + "=" + n : QueryUtil.addSiteWhereClause(string, "a.", "SiteId", "SiteId", epoUser, alertingConfig);
        string = string + " group by a.AlertUserRuleId, a.Enabled, a.AnyAlertFamily, a.AnyCategory, a.Aggregate, a.AggByComputer, a.AggByEvents, a.Throttle, a.WorkstationOS, a.ServerOS, a.UnknownOS ";
        m_log.debug((Object)("Returing SQL: " + string));
        return string;
    }

    private static final String addSiteWhereClause(String string, String string2, String string3, String string4, EpoUser epoUser, AlertingConfig alertingConfig) {
        if (epoUser == null || alertingConfig == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (epoUser.isSiteAccount()) {
            m_log.debug((Object)"User account is a site account, checking config restrictions.");
            if (!alertingConfig.getAllowSiteToViewGlobal().booleanValue()) {
                m_log.debug((Object)"Site admins view is restricted.");
                if (string.indexOf("where") != -1) {
                    stringBuffer.append(" AND ");
                } else {
                    stringBuffer.append(" where ");
                }
                if (string2 != null) {
                    stringBuffer.append(string2);
                }
                stringBuffer.append(string3).append("=").append(epoUser.getRootNodeId());
            } else {
                m_log.debug((Object)"Site admins view is not restricted... getting site rules and global rules.");
                if (string.indexOf("where") != -1) {
                    stringBuffer.append(" AND (");
                } else {
                    stringBuffer.append(" where (");
                }
                if (string2 != null) {
                    stringBuffer.append(string2);
                }
                stringBuffer.append(string3).append("=").append(epoUser.getRootNodeId());
                stringBuffer.append(" OR ").append(string4).append("=").append("2 )");
            }
        } else {
            m_log.debug((Object)"User account is not a site account, skipping restriction.");
        }
        return stringBuffer.toString();
    }

    public static final String makeNotificationLogQuery(PageState pageState, EpoUser epoUser, AlertingConfig alertingConfig, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select ");
        if (n == 32) {
            stringBuffer.append(" * ");
        } else {
            int n2 = 1;
            while (n2 <= n) {
                stringBuffer.append(NotificationLog.PROPERTY_NAMES[n2]);
                if (n2 < 17) {
                    stringBuffer.append(",");
                }
                ++n2;
            }
        }
        stringBuffer.append(" from ").append("NotificationLog").append(" ");
        stringBuffer.append(QueryUtil.makeNoteLogWhereClause(pageState, epoUser, alertingConfig)).append(" ");
        try {
            stringBuffer.append(PropDisplayFactory.createPropDisplay(class$com$nai$Mead$db$NotificationLog == null ? (class$com$nai$Mead$db$NotificationLog = QueryUtil.class$("com.nai.Mead.db.NotificationLog")) : class$com$nai$Mead$db$NotificationLog, null, null).getOrderByClause(pageState));
        }
        catch (Exception exception) {
            m_log.debug((Object)"Failed to create propdisplay to find the sort order...", (Throwable)exception);
        }
        m_log.debug((Object)("Returing SQL: " + stringBuffer));
        return stringBuffer.toString();
    }

    public static final String makeNoteLogWhereClause(PageState pageState, EpoUser epoUser, AlertingConfig alertingConfig) {
        String string = "";
        int n = pageState.getSiteFilter();
        Timestamp timestamp = new Timestamp(System.currentTimeMillis() - (long)pageState.getTimeFilter());
        if (pageState.getSiteFilter() == -2) {
            String string2 = pageState.getSearchSexpStr();
            m_log.debug((Object)("customFilter=" + string2));
            String string3 = " where ";
            try {
                string3 = string3 + SexpQueryUtil.makeWhereSnippet(string2);
                m_log.debug((Object)("customFilterSQL=" + string3));
            }
            catch (SexpException sexpException) {
                m_log.error((Object)"Error creating notification log custom filter", (Throwable)sexpException);
                string3 = " where 1=1 ";
            }
            string = string + string3;
            string = QueryUtil.addSiteWhereClause(string, null, "SiteId", "SiteId", epoUser, alertingConfig);
            m_log.debug((Object)("Where clause after site restrictions: " + string));
        } else {
            string = n != 0 ? "where " + NotificationLog.PROPERTY_NAMES[10] + "=" + n : QueryUtil.addSiteWhereClause(string, null, "SiteId", "SiteId", epoUser, alertingConfig);
        }
        if (pageState.getTimeFilter() > 0) {
            string = string.indexOf("where") != -1 ? string + " AND " : string + " where ";
            string = string + "(TimeNotificationSent is null or TimeNotificationSent > '" + timestamp + "')";
        }
        m_log.debug((Object)("NotificationLog where clause=" + string));
        return string;
    }

    public static final String makeBranchNodeFilterQuery(EpoUser epoUser, AlertingConfig alertingConfig) {
        String string = "select * from BranchNode where (type=6 OR type=4) ";
        string = QueryUtil.addSiteWhereClause(string, null, "AutoId", "AutoId", epoUser, alertingConfig);
        m_log.debug((Object)("Filter query is: " + string));
        return string;
    }

    public static final String makeAllContactsQuery() {
        return "select * from Contact ";
    }

    public static final String makeAllSnmpServersQuery() {
        return "select * from SnmpServer ";
    }

    public static final String makeAllExtToolsQuery(int n) {
        return "select * from Tools where AppAssociation=" + n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

