/*
 * Decompiled with CFR 0.152.
 */
package com.nai.Mead.ui.util;

import com.nai.Mead.db.AlertFamily;
import com.nai.Mead.db.EventCategory;
import com.nai.Mead.server.Server;
import com.nai.Mead.util.Resource;
import com.nai.mcafee.common.db.DatabaseUtil;
import com.nai.mcafee.common.util.StringUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.Collator;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeMap;

public class EventFilterUtil {
    private boolean m_sInitialized = false;
    private StringBuffer m_flategories = new StringBuffer(1024);
    private StringBuffer m_catDisplayNames = new StringBuffer(1024);
    private StringBuffer m_showCategories = new StringBuffer(1024);
    private StringBuffer m_hasThreats = new StringBuffer(1024);
    private StringBuffer m_productSelect = new StringBuffer(1024);
    private String language = null;

    public String getFlategoriesArray() throws SQLException {
        if (!this.m_sInitialized) {
            this.init();
        }
        return this.m_flategories.toString();
    }

    public String getCategoryDisplayNamesArray() throws SQLException {
        if (!this.m_sInitialized) {
            this.init();
        }
        return this.m_catDisplayNames.toString();
    }

    public String getShowCategoryArray() throws SQLException {
        if (!this.m_sInitialized) {
            this.init();
        }
        return this.m_showCategories.toString();
    }

    public String getHasThreatsArray() throws SQLException {
        if (!this.m_sInitialized) {
            this.init();
        }
        return this.m_hasThreats.toString();
    }

    public String getProductSelectOptions() throws SQLException {
        if (!this.m_sInitialized) {
            this.init();
        }
        return this.m_productSelect.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws SQLException {
        if (this.m_sInitialized) {
            return;
        }
        Connection connection = null;
        try {
            connection = Server.getDb().getConnection();
            AlertFamily[] alertFamilyArray = AlertFamily.getAll(connection);
            EventCategory[] eventCategoryArray = EventCategory.getAll(connection);
            this.createProductControls(connection, alertFamilyArray);
            this.createCategoryControls(eventCategoryArray);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            DatabaseUtil.close((Connection)connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
        this.m_sInitialized = true;
    }

    private void createProductControls(Connection connection, AlertFamily[] alertFamilyArray) throws SQLException {
        TreeMap<Object, AlertFamily> treeMap = new TreeMap<Object, AlertFamily>(Collator.getInstance(new Locale(this.language)));
        int n = 0;
        while (n < alertFamilyArray.length) {
            treeMap.put(Resource.getDataString(alertFamilyArray[n].getName(), this.language), alertFamilyArray[n]);
            ++n;
        }
        Iterator<Object> iterator = treeMap.keySet().iterator();
        this.m_flategories.append("new Array();\n");
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            AlertFamily alertFamily = (AlertFamily)((Object)treeMap.get(string));
            this.m_flategories.append("flategories[\"").append(alertFamily.getName()).append("\"] = new Array(");
            String[] stringArray = EventCategory.getCategoriesForAlert(connection, alertFamily.getId());
            if (stringArray.length > 0) {
                this.m_flategories.append("\"").append(stringArray[0]).append("\"");
            }
            int n2 = 1;
            while (n2 < stringArray.length) {
                this.m_flategories.append(",\"").append(stringArray[n2]).append("\"");
                ++n2;
            }
            this.m_flategories.append(");\n");
            this.m_productSelect.append("<OPTION value=\"").append(alertFamily.getName()).append("\">").append(string).append("</OPTION>\n");
        }
    }

    private void createCategoryControls(EventCategory[] eventCategoryArray) {
        TreeMap<Object, EventCategory> treeMap = new TreeMap<Object, EventCategory>(Collator.getInstance(new Locale(this.language)));
        int n = 0;
        while (n < eventCategoryArray.length) {
            treeMap.put(Resource.getDataString(eventCategoryArray[n].getName(), this.language), eventCategoryArray[n]);
            ++n;
        }
        Iterator<Object> iterator = treeMap.keySet().iterator();
        this.m_catDisplayNames.append("new Array();\n");
        this.m_showCategories.append("new Array();\n");
        this.m_hasThreats.append("new Array();\n");
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            EventCategory eventCategory = (EventCategory)((Object)treeMap.get(string));
            this.m_catDisplayNames.append("names['").append(eventCategory.getName()).append("'] = '").append(StringUtil.safeHtml((String)string, (boolean)false)).append("';\n");
            this.m_showCategories.append("show['").append(eventCategory.getName()).append("'] = ").append("false").append(";\n");
            this.m_hasThreats.append("has_threats['").append(eventCategory.getName()).append("'] = ").append(eventCategory.getAssociateThreat()).append(";\n");
        }
    }

    public void setLanguage(String string) {
        this.language = string;
    }

    public String getLanguage() {
        return this.language;
    }
}

