/*
 * Decompiled with CFR 0.152.
 */
package com.nai.Utility;

import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BeanUtil {
    static boolean useXMLDecoder = true;

    public static Object readObject(InputStream inputStream, ExceptionListener exceptionListener) {
        if (useXMLDecoder) {
            XMLDecoder xMLDecoder = new XMLDecoder(inputStream, null, exceptionListener);
            Object object = xMLDecoder.readObject();
            xMLDecoder.close();
            return object;
        }
        return null;
    }

    public static Object readObject(String string, ExceptionListener exceptionListener) throws FileNotFoundException, IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        Object object = BeanUtil.readObject(bufferedInputStream, exceptionListener);
        ((InputStream)bufferedInputStream).close();
        return object;
    }

    public static void writeObject(OutputStream outputStream, Object object) {
        if (!useXMLDecoder) {
            return;
        }
        XMLEncoder xMLEncoder = new XMLEncoder(outputStream);
        xMLEncoder.writeObject(object);
        xMLEncoder.close();
    }

    public static void saveObject(String string, Object object) throws FileNotFoundException, IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
        BeanUtil.writeObject(bufferedOutputStream, object);
        ((OutputStream)bufferedOutputStream).close();
    }

    public static void setUseXMLDecoder(boolean bl) {
        useXMLDecoder = bl;
    }
}

