/*
 * Decompiled with CFR 0.152.
 */
package com.nai.Utility;

import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.joesnmp.protocols.snmp.SnmpHandler;
import org.joesnmp.protocols.snmp.SnmpIPAddress;
import org.joesnmp.protocols.snmp.SnmpOctetString;
import org.joesnmp.protocols.snmp.SnmpPduPacket;
import org.joesnmp.protocols.snmp.SnmpPduTrap;
import org.joesnmp.protocols.snmp.SnmpSession;
import org.joesnmp.protocols.snmp.SnmpSyntax;
import org.joesnmp.protocols.snmp.SnmpVarBind;

public class SNMPTrapClient
implements SnmpHandler {
    public static final int DEFAULT_TRAP_PORT = 162;
    private SnmpPduTrap m_trapPdu;
    private SnmpSession m_session;

    public SNMPTrapClient(String string, String string2, int n) throws UnknownHostException, SocketException {
        this.m_session = new SnmpSession(InetAddress.getByName(string));
        this.m_trapPdu = new SnmpPduTrap();
        this.m_trapPdu.setEnterprise(string2);
        this.m_trapPdu.setSpecific(n);
        this.m_trapPdu.setTimeStamp(System.currentTimeMillis());
        this.m_trapPdu.setAgentAddress(new SnmpIPAddress(InetAddress.getLocalHost()));
        this.m_trapPdu.setGeneric(6);
    }

    public void send() {
        this.m_session.getPeer().setPort(162);
        this.m_session.send(this.m_trapPdu, (SnmpHandler)this);
        this.m_session.close();
    }

    public void addVarBinding(String string, String string2) {
        SnmpOctetString snmpOctetString = new SnmpOctetString(string2.getBytes());
        SnmpVarBind snmpVarBind = new SnmpVarBind(string, (SnmpSyntax)snmpOctetString);
        this.m_trapPdu.addVarBind(snmpVarBind);
    }

    public void snmpReceivedPdu(SnmpSession snmpSession, int n, SnmpPduPacket snmpPduPacket) {
    }

    public void snmpInternalError(SnmpSession snmpSession, int n, SnmpSyntax snmpSyntax) {
    }

    public void snmpTimeoutError(SnmpSession snmpSession, SnmpSyntax snmpSyntax) {
    }

    public static void main(String[] stringArray) {
        String string = "shaleydev3";
        System.out.println("Sending an SNMP trap to " + string);
        try {
            SNMPTrapClient sNMPTrapClient = new SNMPTrapClient(string, "1.3.6.1.4.1.3401.12.2.1.4.1.1.27", 1);
            sNMPTrapClient.addVarBinding("1.3.6.1.4.1.3401.12.2.1.4.1.1.1.27", "TestRuleName");
            sNMPTrapClient.send();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

