/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.common.condition;

import com.nai.mcafee.common.condition.EvalContext;
import com.nai.mcafee.common.condition.EvaluationException;
import com.nai.mcafee.common.condition.Sexp;
import com.nai.mcafee.common.condition.SexpBool;
import com.nai.mcafee.common.condition.SexpList;
import com.nai.mcafee.common.condition.SexpString;
import com.nai.mcafee.common.util.IPFormatException;
import com.nai.mcafee.common.util.IPUtil;

public class SexpIpInRange
extends SexpList {
    public static final String TYPE = "ipInRange";

    public String type() {
        return TYPE;
    }

    public Sexp eval(EvalContext evalContext) throws EvaluationException {
        if (this.m_children.size() != 3) {
            throw new EvaluationException("'ipInRange' needs exactly three parameters!");
        }
        Sexp sexp = this.evalChild(0, evalContext);
        Sexp sexp2 = this.evalChild(1, evalContext);
        Sexp sexp3 = this.evalChild(2, evalContext);
        if (!(sexp instanceof SexpString && sexp2 instanceof SexpString && sexp3 instanceof SexpString)) {
            throw new EvaluationException("'ipInRange' needs three string parameters!");
        }
        try {
            int n = IPUtil.convert(((SexpString)sexp).getValue());
            int n2 = IPUtil.convert(((SexpString)sexp2).getValue());
            int n3 = IPUtil.convert(((SexpString)sexp3).getValue());
            if (n >= n2 && n <= n3) {
                return SexpBool.TRUE;
            }
            return SexpBool.FALSE;
        }
        catch (IPFormatException iPFormatException) {
            throw new EvaluationException("Invalid IP address supplied to ipInRangs", iPFormatException);
        }
    }
}

