/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.common.util;

import com.nai.mcafee.common.util.LocaleName;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class ResourceBase {
    private static final Logger m_log = Logger.getLogger((Class)(class$com$nai$mcafee$common$util$ResourceBase == null ? (class$com$nai$mcafee$common$util$ResourceBase = ResourceBase.class$("com.nai.mcafee.common.util.ResourceBase")) : class$com$nai$mcafee$common$util$ResourceBase));
    private static final HashMap m_allBundles = new HashMap();
    private Locale m_defaultLocale = Locale.getDefault();
    private HashMap m_bundles = new HashMap();
    private ClassLoader m_loader = this.getClass().getClassLoader();
    static /* synthetic */ Class class$com$nai$mcafee$common$util$ResourceBase;

    public void setDefaultLocale(String string) {
        this.m_defaultLocale = new Locale(string);
    }

    public void setDefaultLocale(Locale locale) {
        this.m_defaultLocale = locale;
    }

    public Locale getDefaultLocale() {
        return this.m_defaultLocale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ResourceBase initBundle(String string, Locale locale, ClassLoader classLoader) {
        ResourceBase resourceBase = new ResourceBase(string, locale, classLoader);
        HashMap hashMap = m_allBundles;
        synchronized (hashMap) {
            m_allBundles.put(string, resourceBase);
        }
        return resourceBase;
    }

    public static final String formatFromBundle(String string, String string2, String string3, String string4) {
        if (string2 == null) {
            throw new NullPointerException();
        }
        ResourceBase resourceBase = ResourceBase.getInstance(string);
        if (string4 != null) {
            return resourceBase.formatString(string2, string3, string4);
        }
        return resourceBase.formatString(string2, string3);
    }

    public static final String formatFromBundle(String string, String string2, Object[] objectArray, String string3) {
        if (string2 == null || objectArray == null) {
            throw new NullPointerException();
        }
        ResourceBase resourceBase = ResourceBase.getInstance(string);
        if (string3 == null) {
            return resourceBase.formatString(string2, objectArray);
        }
        return resourceBase.formatString(string2, objectArray, new Locale(string3));
    }

    public static void setDefaultLocale(String string, String string2) {
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        m_log.debug((Object)("Setting the default locale to " + string2 + " for bundle " + string));
        ResourceBase resourceBase = ResourceBase.getInstance(string);
        resourceBase.setDefaultLocale(string2);
    }

    public static final String getFromBundle(String string, String string2, String string3) {
        m_log.debug((Object)("Getting key: " + string2 + " from bundle: " + string + " in locale " + string3));
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        ResourceBase resourceBase = ResourceBase.getInstance(string);
        if (string3 != null) {
            return resourceBase.getString(string2, string3);
        }
        return resourceBase.getString(string2);
    }

    public static ResourceBundle getBundle(String string, String string2) {
        if (string == null) {
            throw new NullPointerException();
        }
        ResourceBundle resourceBundle = null;
        ResourceBase resourceBase = ResourceBase.getInstance(string);
        if (resourceBase != null) {
            resourceBundle = resourceBase.getBundle(string2);
        }
        return resourceBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void clearBundles() {
        HashMap hashMap = m_allBundles;
        synchronized (hashMap) {
            m_allBundles.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceBase getInstance(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        ResourceBase resourceBase = null;
        HashMap hashMap = m_allBundles;
        synchronized (hashMap) {
            resourceBase = (ResourceBase)m_allBundles.get(string);
            if (resourceBase == null) {
                resourceBase = ResourceBase.initBundle(string, null, null);
            }
        }
        return resourceBase;
    }

    public ResourceBase(String string) {
        this.init(string);
    }

    public ResourceBase(String string, ClassLoader classLoader) {
        if (classLoader != null) {
            this.m_loader = classLoader;
        }
        this.init(string);
    }

    public ResourceBase(String string, Locale locale, ClassLoader classLoader) {
        if (locale != null) {
            this.m_defaultLocale = locale;
        }
        if (classLoader != null) {
            this.m_loader = classLoader;
        }
        this.init(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        m_log.debug((Object)("Creating a new ResourceBase for " + string));
        this.loadBundles(string);
        HashMap hashMap = m_allBundles;
        synchronized (hashMap) {
            m_allBundles.put(string, this.m_bundles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBundles(String string) {
        Map map = LocaleName.getLanguages();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Locale locale = new Locale(string2);
            HashMap hashMap = this.m_bundles;
            synchronized (hashMap) {
                m_log.debug((Object)("Loading bundle for: " + string + " language: " + string2));
                this.m_bundles.put(string2, ResourceBundle.getBundle(string, locale, this.m_loader));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getString(String string, String string2) {
        try {
            HashMap hashMap = this.m_bundles;
            synchronized (hashMap) {
                ResourceBundle resourceBundle = (ResourceBundle)this.m_bundles.get(string2);
                if (resourceBundle != null) {
                    return resourceBundle.getString(string);
                }
                resourceBundle = (ResourceBundle)this.m_bundles.get("en");
                if (resourceBundle != null) {
                    return resourceBundle.getString(string);
                }
                return string;
            }
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    private String getString(String string) {
        return this.getString(string, this.m_defaultLocale.getLanguage());
    }

    private String formatString(String string, String string2) {
        Object[] objectArray = new Object[]{string2};
        return this.formatString(string, objectArray, this.m_defaultLocale);
    }

    private String formatString(String string, String string2, String string3) {
        Object[] objectArray = new Object[]{string2};
        return this.formatString(string, objectArray, new Locale(string3));
    }

    private String formatString(String string, Object[] objectArray) {
        return this.formatString(string, objectArray, this.m_defaultLocale);
    }

    private String formatString(String string, Object[] objectArray, Locale locale) {
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.setLocale(locale);
        String string2 = this.getString(string, locale.getLanguage());
        if (!string2.equals(string)) {
            string2 = string2.replaceAll("'", "''");
            messageFormat.applyPattern(string2);
            return messageFormat.format(objectArray);
        }
        int n = 0;
        while (n < objectArray.length) {
            string2 = string2 + " " + objectArray[n].toString();
            ++n;
        }
        return string2;
    }

    private ResourceBundle getBundle(String string) {
        String string2 = string != null ? string : this.m_defaultLocale.getLanguage();
        ResourceBundle resourceBundle = (ResourceBundle)this.m_bundles.get(string2);
        if (resourceBundle == null) {
            resourceBundle = (ResourceBundle)this.m_bundles.get("en");
        }
        return resourceBundle;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

