/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.action.concrete;

import com.nai.mcafee.common.db.Tool;
import com.nai.mcafee.common.db.ToolInstance;
import com.nai.mcafee.common.util.StringUtil;
import com.nai.mcafee.snowcap.action.ActionContext;
import com.nai.mcafee.snowcap.action.ActionEnvironment;
import com.nai.mcafee.snowcap.action.ActionImplBase;
import com.nai.mcafee.snowcap.action.ActionInvocationException;
import com.nai.mcafee.snowcap.action.concrete.ETA.ExternalToolRunner;
import com.nai.mcafee.snowcap.db.ActionStatus;
import org.apache.log4j.Logger;

public class ExternalToolAction
extends ActionImplBase {
    public static final String TYPE = "external tool";
    public static final String[] PARAM_NAMES = new String[]{"ToolId"};
    private static final Logger m_log = Logger.getLogger((Class)(class$com$nai$mcafee$snowcap$action$concrete$ExternalToolAction == null ? (class$com$nai$mcafee$snowcap$action$concrete$ExternalToolAction = ExternalToolAction.class$("com.nai.mcafee.snowcap.action.concrete.ExternalToolAction")) : class$com$nai$mcafee$snowcap$action$concrete$ExternalToolAction));
    private static int m_ttl = 0;
    boolean m_blocking = true;
    private boolean m_killit = true;
    private int m_toolId = 0;
    static /* synthetic */ Class class$com$nai$mcafee$snowcap$action$concrete$ExternalToolAction;

    public void killit() {
        this.m_killit = true;
    }

    public int invoke(ActionContext actionContext, ActionStatus actionStatus) throws ActionInvocationException {
        block6: {
            ExternalToolRunner externalToolRunner = null;
            Tool tool = null;
            tool = this.findTool(ActionEnvironment.instance().getTools());
            if (tool == null) {
                throw new NullPointerException("The tool id could not be found.");
            }
            String string = StringUtil.substitute((String)tool.getCmdLine(), (StringUtil.Map)actionContext.getMap());
            String string2 = ToolInstance.getExeCommand((String)tool.getExeName()) + " " + string;
            externalToolRunner = new ExternalToolRunner(string2, Thread.currentThread(), actionStatus, actionContext.getHost());
            externalToolRunner.addActionStatusListener(this);
            externalToolRunner.start();
            if (!this.m_blocking) break block6;
            try {
                int n;
                if (m_ttl == 0) {
                    this.m_killit = false;
                    n = 500;
                } else {
                    n = m_ttl;
                }
                while (externalToolRunner.isAlive()) {
                    Thread.sleep(n);
                    if (!externalToolRunner.isAlive() || !this.m_killit) continue;
                    m_log.debug((Object)"The runner is still alive after the timeout.  Attempting to kill it.");
                    externalToolRunner.interrupt();
                    Thread.sleep(n);
                }
            }
            catch (InterruptedException interruptedException) {
                m_log.debug((Object)"Received an interrupt from child thread... exiting.");
            }
        }
        return actionStatus.getStatus();
    }

    public String getActionStatusBaseKey() {
        return "actionstatus_tool_run";
    }

    public void setBlocking(boolean bl) {
        this.m_blocking = bl;
    }

    public boolean getBlocking() {
        return this.m_blocking;
    }

    private Tool findTool(Tool[] toolArray) {
        Tool tool = null;
        int n = 0;
        while (n < toolArray.length) {
            if (toolArray[n].getId() == this.m_toolId) {
                tool = toolArray[n];
                break;
            }
            ++n;
        }
        return tool;
    }

    public static void setTTL(int n) {
        m_ttl = n;
    }

    public static int getTTL() {
        return m_ttl;
    }

    public void setToolId(int n) {
        this.m_toolId = n;
    }

    public void setToolId(Integer n) {
        this.m_toolId = n;
    }

    public int getToolId() {
        return this.m_toolId;
    }

    public String getToolIdAsString() {
        return Integer.toString(this.m_toolId);
    }

    public String getType() {
        return TYPE;
    }

    public int getNumProperties() {
        return PARAM_NAMES.length;
    }

    public String getPropertyName(int n) {
        if (n >= 0 && n <= this.getNumProperties()) {
            return PARAM_NAMES[n];
        }
        return null;
    }

    public boolean isAsyncAction() {
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

