/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.action.concrete;

import com.nai.mcafee.common.db.DatabaseUtil;
import com.nai.mcafee.snowcap.action.ActionContext;
import com.nai.mcafee.snowcap.action.ActionEnvironment;
import com.nai.mcafee.snowcap.action.ActionImplBase;
import com.nai.mcafee.snowcap.action.ActionInvocationException;
import com.nai.mcafee.snowcap.db.ActionStatus;
import com.nai.mcafee.snowcap.db.Host;
import com.nai.mcafee.snowcap.util.Resource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;

public class QueryEPOAgentAction
extends ActionImplBase {
    private static final Logger m_log = Logger.getLogger((Class)(class$com$nai$mcafee$snowcap$action$concrete$QueryEPOAgentAction == null ? (class$com$nai$mcafee$snowcap$action$concrete$QueryEPOAgentAction = QueryEPOAgentAction.class$("com.nai.mcafee.snowcap.action.concrete.QueryEPOAgentAction")) : class$com$nai$mcafee$snowcap$action$concrete$QueryEPOAgentAction));
    public static final String TYPE = "epoagent_query";
    private static final Vector m_portsToCheck = new Vector();
    static /* synthetic */ Class class$com$nai$mcafee$snowcap$action$concrete$QueryEPOAgentAction;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPorts(Integer[] integerArray) {
        Vector vector = m_portsToCheck;
        synchronized (vector) {
            m_log.debug((Object)"Adding an array of ports to the list of ports to check.");
            m_portsToCheck.clear();
            m_portsToCheck.addAll(Arrays.asList(integerArray));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPorts(String string, String[] stringArray) {
        Vector vector = m_portsToCheck;
        synchronized (vector) {
            m_portsToCheck.clear();
            m_log.debug((Object)("Setting localAgentPort to: " + string));
            m_portsToCheck.add(new Integer(string));
            int n = 0;
            while (n < stringArray.length) {
                String string2 = stringArray[n];
                if (string2.length() > 0) {
                    m_log.debug((Object)("Adding port:" + string2));
                    m_portsToCheck.add(new Integer(string2));
                }
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String doConnection(URL uRL, boolean bl) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        Socket socket = null;
        try {
            m_log.debug((Object)("Opening connection to: " + uRL));
            socket = new Socket(uRL.getHost(), uRL.getPort());
            socket.setSoTimeout(10000);
            String string = "GET " + uRL.getPath() + " HTTP/1.1\n\n";
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(socket.getOutputStream());
            outputStreamWriter.write(string);
            outputStreamWriter.flush();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            String string2 = bufferedReader.readLine();
            String[] stringArray = string2.split(" ");
            if (stringArray.length != 3) {
                throw new IOException("Bad HTTP return");
            }
            int n = Integer.parseInt(stringArray[1]);
            if (n < 200 || n >= 300) throw new IOException(string2);
            if (bl) {
                while ((string2 = bufferedReader.readLine()) != null) {
                    String string3 = string2.toUpperCase();
                    if (string3.indexOf("<COMPUTERNAME>") != -1 || string3.indexOf("<VERSION>") != -1 || string3.indexOf("<AGENTGUID>") != -1 || string3.indexOf("<EPOSERVERNAME>") != -1) {
                        stringBuffer.append(string2).append("\n");
                    }
                    if (string2.indexOf("<Log component") != -1) break;
                }
            }
            Object var13_12 = null;
            if (socket == null) return stringBuffer.toString();
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            if (socket == null) throw throwable;
            socket.close();
            throw throwable;
        }
        socket.close();
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkForAgent(String string, StringBuffer stringBuffer) {
        Vector vector;
        boolean bl = false;
        Vector vector2 = m_portsToCheck;
        synchronized (vector2) {
            vector = new Vector(m_portsToCheck);
        }
        m_log.debug((Object)("Size of the localCopy: " + vector.size()));
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            m_log.debug((Object)("Trying port: " + n));
            try {
                Object[] objectArray = new String[]{n.toString(), string};
                stringBuffer.append(Resource.formatString("queryepoagentaction_tryingurl", objectArray));
                URL uRL = new URL("http", string, n, "/FrameworkLog.xsl");
                this.doConnection(uRL, false);
                uRL = new URL("http", string, n, "/");
                stringBuffer.append("...").append(Resource.getString("queryepoagentaction_query_success")).append("\n");
                stringBuffer.append(this.doConnection(uRL, true));
                stringBuffer.append("\n");
                bl = true;
            }
            catch (Exception exception) {
                stringBuffer.append("...").append(Resource.getString("queryepoagentaction_query_failed")).append("\n");
                m_log.debug((Object)("Failed to get ePO agent log from host: " + string), (Throwable)exception);
            }
        }
        return bl;
    }

    public int invoke(ActionContext actionContext, ActionStatus actionStatus) throws ActionInvocationException {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string = (String)actionContext.getParamProperty("IpAddress");
            if (string.length() == 0) {
                throw new ActionInvocationException(Resource.getString("queryepoagentaction_noipaddress"));
            }
            boolean bl = this.checkForAgent(string, stringBuffer);
            this.updateHostStatus(actionContext.getHost(), bl);
            String string2 = bl ? "queryepoagentaction_agentfound" : "queryepoagentaction_agentnotfound";
            this.setResults(0, stringBuffer.toString(), string2, actionStatus);
        }
        catch (Exception exception) {
            m_log.error((Object)"Error invoking Query EPO Agent Action", (Throwable)exception);
            throw new ActionInvocationException(exception);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateHostStatus(Host host, boolean bl) throws SQLException {
        if (host == null) {
            return;
        }
        boolean bl2 = false;
        if (host.getRogueType() == 1 && bl) {
            host.setRogueType(3);
            bl2 = true;
        }
        if (host.getRogueType() == 3 && !bl) {
            host.setRogueType(1);
            bl2 = true;
        }
        if (!bl2) {
            return;
        }
        Connection connection = null;
        try {
            ActionEnvironment actionEnvironment = ActionEnvironment.instance();
            connection = actionEnvironment.getDbConnection();
            host.update(connection);
            connection.commit();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            DatabaseUtil.close((Connection)connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
    }

    public String getType() {
        return TYPE;
    }

    public int getNumProperties() {
        return 0;
    }

    public String getPropertyName(int n) {
        return null;
    }

    public String getActionStatusBaseKey() {
        return "actionstatus_query_epoagent";
    }

    public boolean isAsyncAction() {
        return true;
    }

    public static void main(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        Integer[] integerArray = new Integer[]{new Integer(8081), new Integer(8080), new Integer(8585)};
        QueryEPOAgentAction.setPorts(integerArray);
        QueryEPOAgentAction queryEPOAgentAction = new QueryEPOAgentAction();
        if (!queryEPOAgentAction.checkForAgent("localhost", stringBuffer)) {
            System.out.println("Agent not found.");
        } else {
            System.out.println("Agent found.");
        }
        if (!queryEPOAgentAction.checkForAgent("172.16.39.131", stringBuffer)) {
            System.out.println("Agent not found.");
        } else {
            System.out.println("Agent found.");
        }
        System.out.println(stringBuffer.toString());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

