/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.db;

import com.nai.mcafee.common.db.DatabaseObject;
import com.nai.mcafee.common.db.DatabaseUtil;
import com.nai.mcafee.common.util.IPFormatException;
import com.nai.mcafee.common.util.IPUtil;
import com.nai.mcafee.common.util.StringUtil;
import com.nai.mcafee.snowcap.util.Resource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.BitSet;
import java.util.Vector;

public class Host
extends DatabaseObject {
    public static final int COL_ID = 1;
    public static final int COL_MAC = 2;
    public static final int COL_OUI = 3;
    public static final int COL_NET_ADDR = 4;
    public static final int COL_NET_PROTO = 5;
    public static final int COL_NB_NAME = 6;
    public static final int COL_DNS_NAME = 7;
    public static final int COL_LAST_DETECT = 8;
    public static final int COL_NETWORK_ID = 9;
    public static final int COL_EXCEPTION = 10;
    public static final int COL_EPO_ID = 11;
    public static final int COL_COMMENTS = 12;
    public static final int COL_OS_PLATFORM = 13;
    public static final int COL_OS_FAMILY = 14;
    public static final int COL_OS_VERSION = 15;
    public static final int COL_NB_COMMENTS = 16;
    public static final int COL_DELETED = 17;
    public static final int COL_FIRST_DETECT = 18;
    public static final int COL_USERS = 19;
    public static final int COL_DOMAIN = 20;
    public static final int COL_SID = 21;
    public static final int COL_FIRST_ROGUE = 22;
    public static final int COL_ROGUE_TYPE = 23;
    public static final int COL_LAST_AGENT_COM = 24;
    public static final int COL_IP_ADDRESS_NUM = 25;
    public static final int COL_FRIENDLY_NAME = 26;
    public static final int COL_MARK_FOR_ACTION = 27;
    public static final int NUM_COLUMNS = 27;
    public static final int PROP_ORG_NAME = 28;
    public static final int PROP_STATUS = 29;
    public static final int NUM_PROPERTIES = 29;
    public static final String[] PROPERTY_NAMES = new String[]{"", "HostId", "MAC", "OUI", "NetworkAddress", "NetworkProtocolID", "NetbiosName", "DnsName", "LastDetectTime", "NetworkID", "Exception", "EpoIndex", "Comments", "OSPlatform", "OSFamily", "OSVersion", "NetbiosComment", "Deleted", "FirstDetectTime", "Users", "Domain", "Sid", "FirstRogueTime", "RogueType", "LastAgentCom", "IpAddressNum", "FriendlyName", "MarkedForAction", "OrgName", "HostStatus"};
    public static final int MAX_LEN_MAC = 12;
    public static final int MAX_LEN_NET_ADDR = 50;
    public static final int MAX_LEN_NB_NAME = 16;
    public static final int MAX_LEN_DNS_NAME = 255;
    public static final int MAX_LEN_COMMENTS = 255;
    public static final int MAX_LEN_OS_PLATFORM = 25;
    public static final int MAX_LEN_OS_FAMILY = 128;
    public static final int MAX_LEN_OS_VERSION = 128;
    public static final int MAX_LEN_NB_COMMENT = 100;
    public static final int MAX_LEN_USERS = 128;
    public static final int MAX_LEN_DOMAIN = 16;
    public static final int MAX_LEN_SID = 48;
    public static final int MAX_LEN_FRIENDLYNAME = 255;
    public static final String DEFAULT_MAC = "000000000000";
    public static final String DEFAULT_OUI = "000000";
    public static final int INVALID_ID = -1;
    private int m_id = -1;
    private String m_MAC = "000000000000";
    private String m_OUI = "000000";
    private String m_networkAddr = "";
    private int m_protocolID = 1;
    private String m_netbiosName = "";
    private String m_dnsName = "";
    private Timestamp m_lastDetectTime = null;
    private Timestamp m_firstDetectTime = null;
    private Integer m_networkID = null;
    private boolean m_exception = false;
    private Integer m_epoIndex = null;
    private String m_comments = "";
    private String m_orgName = "";
    private String m_OSPlatform = "";
    private String m_OSFamily = "";
    private String m_OSVersion = "";
    private String m_netbiosComment = "";
    private String m_users = "";
    private boolean m_deleted = false;
    private String m_domain = "";
    private String m_sid = "";
    private Timestamp m_firstRogueTime = null;
    private int m_rogueType = 0;
    private Timestamp m_lastAgentCom = null;
    private int m_ipAddressNum = 0;
    private int m_markedForAction = 0;
    private int m_status = -1;
    private BitSet m_dirtyBits = new BitSet(27);
    static /* synthetic */ Class class$com$nai$mcafee$snowcap$db$Host;

    public Host() {
        this(DEFAULT_MAC, "", "", "");
    }

    public Host(String string, String string2, String string3, String string4) {
        this.setMAC(string);
        this.setNetworkAddress(string2);
        this.setNetbiosName(string3);
        this.setDnsName(string4);
        this.initDirtyBits();
    }

    public Host(Host host) {
        this.m_id = host.m_id;
        this.m_MAC = host.m_MAC;
        this.m_OUI = host.m_OUI;
        this.m_networkAddr = host.m_networkAddr;
        this.m_protocolID = host.m_protocolID;
        this.m_netbiosName = host.m_netbiosName;
        this.m_dnsName = host.m_dnsName;
        this.m_lastDetectTime = host.m_lastDetectTime;
        this.m_networkID = host.m_networkID;
        this.m_exception = host.m_exception;
        this.m_epoIndex = host.m_epoIndex;
        this.m_comments = host.m_comments;
        this.m_orgName = host.m_orgName;
        this.m_OSPlatform = host.m_OSPlatform;
        this.m_OSFamily = host.m_OSFamily;
        this.m_OSVersion = host.m_OSVersion;
        this.m_netbiosComment = host.m_netbiosComment;
        this.m_deleted = host.m_deleted;
        this.m_firstDetectTime = host.m_firstDetectTime;
        this.m_users = host.m_users;
        this.m_domain = host.m_domain;
        this.m_sid = host.m_sid;
        this.m_firstRogueTime = host.m_firstRogueTime;
        this.m_rogueType = host.m_rogueType;
        this.m_lastAgentCom = host.m_lastAgentCom;
        this.m_ipAddressNum = host.m_ipAddressNum;
        this.m_markedForAction = host.m_markedForAction;
        this.initDirtyBits();
    }

    public Host(ResultSet resultSet) throws SQLException {
        this.setValues(resultSet);
        this.initDirtyBits();
    }

    private void initDirtyBits() {
        this.m_dirtyBits.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void lookupOrgName(Connection connection) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("select OrgName from OUIs where OUI=?");
            preparedStatement.setString(1, this.m_OUI);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                this.m_orgName = resultSet.getString(1);
            }
            Object var5_4 = null;
            if (preparedStatement == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (preparedStatement == null) throw throwable;
            preparedStatement.close();
            throw throwable;
        }
        preparedStatement.close();
    }

    public static final Host getByID(Connection connection, int n) throws SQLException {
        Host[] hostArray = Host.getByQuery(connection, "select * from Hosts where HostID = '" + n + "'");
        if (hostArray.length == 0) {
            return null;
        }
        if (hostArray.length > 1) {
            throw new SQLException("Host.getHostByID() returned more than one host. More than one object in the database has the same ID.  Please contact McAfee Customer Support for assistance resolving this situation.");
        }
        Host host = hostArray[0];
        host.setId(n);
        return host;
    }

    public static final Host getByID(Connection connection, int n, boolean bl) throws SQLException {
        Host[] hostArray = Host.getByQuery(connection, "select * from Hosts as H left join OUIs as O on H.OUI = O.OUI where HostID = '" + n + "'");
        if (hostArray.length == 0) {
            return null;
        }
        if (hostArray.length > 1) {
            throw new SQLException("Host.getHostByID() returned more than one host. More than one object in the database has the same ID.  Please contact McAfee Customer Support for assistance resolving this situation.");
        }
        Host host = hostArray[0];
        host.setId(n);
        return host;
    }

    public static final Host[] getByMAC(Connection connection, String string, boolean bl) throws SQLException {
        String string2 = bl ? "select * from Hosts as H left join OUIs as O on H.OUI = O.OUI where MAC = '" + string + "'" : "select * from Hosts where MAC = '" + string + "'";
        return Host.getByQuery(connection, string2);
    }

    public static final Host[] getByMAC(Connection connection, String string) throws SQLException {
        return Host.getByMAC(connection, string, false);
    }

    public static final Host[] getByQuery(Connection connection, String string) throws SQLException {
        return Host.getByQuery(connection, string, 1, -1);
    }

    public static final Host[] getByQuery(Connection connection, String string, int n, int n2) throws SQLException {
        Vector vector = DatabaseObject.getByQuery((Connection)connection, (String)string, (Class)(class$com$nai$mcafee$snowcap$db$Host == null ? (class$com$nai$mcafee$snowcap$db$Host = Host.class$("com.nai.mcafee.snowcap.db.Host")) : class$com$nai$mcafee$snowcap$db$Host), (int)n, (int)n2);
        Host[] hostArray = new Host[]{};
        hostArray = vector.toArray(hostArray);
        return hostArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void setExceptionStatus(Connection connection, int n, boolean bl) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("update Hosts set Exception=? where HostID=?");
            preparedStatement.setBoolean(1, bl);
            preparedStatement.setInt(2, n);
            int n2 = preparedStatement.executeUpdate();
            if (n2 != 1) {
                throw new SQLException(Resource.formatString("host_template_setexceptionstatus_no_rows_changed", n2));
            }
            Object var6_5 = null;
            if (preparedStatement == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (preparedStatement == null) throw throwable;
            preparedStatement.close();
            throw throwable;
        }
        preparedStatement.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void setMarkedForActionStatus(Connection connection, int n, boolean bl) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("update Hosts set MarkedForAction=? where HostID=?");
            preparedStatement.setBoolean(1, bl);
            preparedStatement.setInt(2, n);
            int n2 = preparedStatement.executeUpdate();
            if (n2 != 1) {
                throw new SQLException(Resource.formatString("host_template_setexceptionstatus_no_rows_changed", n2));
            }
            Object var6_5 = null;
            if (preparedStatement == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (preparedStatement == null) throw throwable;
            preparedStatement.close();
            throw throwable;
        }
        preparedStatement.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void setDeletedStatus(Connection connection, int n, boolean bl) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("update Hosts set Deleted=? where HostID=?");
            preparedStatement.setBoolean(1, bl);
            preparedStatement.setInt(2, n);
            int n2 = preparedStatement.executeUpdate();
            if (n2 != 1) {
                throw new SQLException(Resource.formatString("host_template_setdeletedstatus_no_rows_changed", n2));
            }
            Object var6_5 = null;
            if (preparedStatement == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (preparedStatement == null) throw throwable;
            preparedStatement.close();
            throw throwable;
        }
        preparedStatement.close();
    }

    public static final void deleteFromDatabase(Connection connection, int n) throws SQLException {
        DatabaseUtil.executeUpdate((Connection)connection, (String)("delete from Hosts where HostID=" + n));
    }

    public String getInsertSql() {
        return "insert into Hosts values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    }

    public String getUpdateSql() {
        StringBuffer stringBuffer = null;
        if (this.m_dirtyBits.cardinality() > 0) {
            stringBuffer = new StringBuffer("update Hosts set ");
            boolean bl = true;
            int n = this.m_dirtyBits.nextSetBit(0);
            while (n >= 0) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(PROPERTY_NAMES[n + 1]).append("=?");
                n = this.m_dirtyBits.nextSetBit(n + 1);
            }
            stringBuffer.append(" where HostID=?");
        }
        if (stringBuffer != null) {
            return stringBuffer.toString();
        }
        return null;
    }

    public void prepareInsert(PreparedStatement preparedStatement) throws SQLException {
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)1, (String)this.m_MAC, (int)12);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)2, (String)this.m_OUI);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)3, (String)this.m_networkAddr, (int)50);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)4, (int)this.m_protocolID);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)5, (String)this.m_netbiosName, (int)16);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)6, (String)this.m_dnsName, (int)255);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)7, (Timestamp)this.m_lastDetectTime);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)8, (Integer)this.m_networkID);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)9, (boolean)this.m_exception);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)10, (Integer)this.m_epoIndex);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)11, (String)this.m_comments, (int)255);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)12, (String)this.m_OSPlatform, (int)25);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)13, (String)this.m_OSFamily, (int)128);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)14, (String)this.m_OSVersion, (int)128);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)15, (String)this.m_netbiosComment, (int)100);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)16, (boolean)this.m_deleted);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)17, (Timestamp)this.m_firstDetectTime);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)18, (String)this.m_users, (int)128);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)19, (String)this.m_domain, (int)16);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)20, (String)this.m_sid, (int)48);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)21, (Timestamp)this.m_firstRogueTime);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)22, (int)this.m_rogueType);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)23, (Timestamp)this.m_lastAgentCom);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)24, (int)this.m_ipAddressNum);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)25, (String)this.getFriendlyName(), (int)255);
        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)26, (int)this.m_markedForAction);
    }

    public void prepareUpdate(PreparedStatement preparedStatement) throws SQLException {
        if (this.m_dirtyBits.cardinality() > 0) {
            int n = 1;
            int n2 = this.m_dirtyBits.nextSetBit(0);
            while (n2 >= 0) {
                switch (n2 + 1) {
                    case 1: {
                        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)n, (int)this.getHostId());
                        break;
                    }
                    case 2: {
                        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)n, (String)this.getMAC(), (int)12);
                        break;
                    }
                    case 3: {
                        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)n, (String)this.getOUI());
                        break;
                    }
                    case 4: {
                        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)n, (String)this.getNetworkAddress(), (int)50);
                        break;
                    }
                    case 5: {
                        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)n, (int)this.getNetworkProtocolID());
                        break;
                    }
                    case 6: {
                        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)n, (String)this.getNetbiosName(), (int)16);
                        break;
                    }
                    case 7: {
                        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)n, (String)this.getDnsName(), (int)255);
                        break;
                    }
                    case 8: {
                        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)n, (Timestamp)this.getLastDetectTime());
                        break;
                    }
                    case 9: {
                        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)n, (Integer)this.getNetworkID());
                        break;
                    }
                    case 10: {
                        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)n, (boolean)this.getException());
                        break;
                    }
                    case 11: {
                        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)n, (Integer)this.getEpoIndex());
                        break;
                    }
                    case 12: {
                        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)n, (String)this.getComments(), (int)255);
                        break;
                    }
                    case 13: {
                        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)n, (String)this.getOSPlatform(), (int)25);
                        break;
                    }
                    case 14: {
                        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)n, (String)this.getOSFamily(), (int)128);
                        break;
                    }
                    case 15: {
                        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)n, (String)this.getOSVersion(), (int)128);
                        break;
                    }
                    case 16: {
                        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)n, (String)this.getNetbiosComment(), (int)100);
                        break;
                    }
                    case 17: {
                        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)n, (boolean)this.getDeleted());
                        break;
                    }
                    case 18: {
                        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)n, (Timestamp)this.getFirstDetectTime());
                        break;
                    }
                    case 19: {
                        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)n, (String)this.getUsers(), (int)128);
                        break;
                    }
                    case 20: {
                        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)n, (String)this.getDomain(), (int)16);
                        break;
                    }
                    case 21: {
                        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)n, (String)this.getSid(), (int)48);
                        break;
                    }
                    case 22: {
                        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)n, (Timestamp)this.getFirstRogueTime());
                        break;
                    }
                    case 23: {
                        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)n, (int)this.getRogueType());
                        break;
                    }
                    case 24: {
                        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)n, (Timestamp)this.getLastAgentCom());
                        break;
                    }
                    case 25: {
                        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)n, (int)this.getIpAddressNum());
                        break;
                    }
                    case 26: {
                        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)n, (String)this.getFriendlyName(), (int)255);
                        break;
                    }
                    case 27: {
                        DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)n, (int)this.getMarkedForAction());
                    }
                }
                ++n;
                n2 = this.m_dirtyBits.nextSetBit(n2 + 1);
            }
            DatabaseObject.setParam((PreparedStatement)preparedStatement, (int)n, (int)this.m_id);
        }
    }

    public void add(Connection connection, boolean bl) throws SQLException {
        super.add(connection, bl);
        this.initDirtyBits();
    }

    public void forceUpdateAllColumns(Connection connection) throws SQLException {
        this.m_dirtyBits.clear();
        this.m_dirtyBits.flip(1, 27);
        this.update(connection);
    }

    public void update(Connection connection) throws SQLException {
        if (this.m_dirtyBits.cardinality() > 0) {
            super.update(connection);
            this.initDirtyBits();
        }
    }

    public String getUniqueQuerySql() {
        return "select * from Hosts where MAC = ?";
    }

    public String getUniqueIdSql() {
        return "select HostID from Hosts where MAC = ?";
    }

    public void prepareUniqueQuery(PreparedStatement preparedStatement) throws SQLException {
        preparedStatement.setString(1, this.getMAC());
    }

    public void setUniqueID(int n) throws SQLException {
        this.setId(n);
    }

    public void setValues(ResultSet resultSet) throws SQLException {
        this.m_id = resultSet.getInt(1);
        this.m_MAC = resultSet.getString(2);
        this.m_OUI = resultSet.getString(3);
        this.m_networkAddr = resultSet.getString(4);
        this.m_protocolID = resultSet.getInt(5);
        this.m_netbiosName = resultSet.getString(6);
        this.m_dnsName = resultSet.getString(7);
        this.m_lastDetectTime = resultSet.getTimestamp(8);
        this.m_networkID = this.getInt(resultSet, 9);
        this.m_exception = resultSet.getBoolean(10);
        this.m_epoIndex = this.getInt(resultSet, 11);
        this.m_comments = resultSet.getString(12);
        this.m_OSPlatform = resultSet.getString(13);
        this.m_OSFamily = resultSet.getString(14);
        this.m_OSVersion = resultSet.getString(15);
        this.m_netbiosComment = resultSet.getString(16);
        this.m_deleted = resultSet.getBoolean(17);
        this.m_firstDetectTime = resultSet.getTimestamp(18);
        this.m_users = resultSet.getString(19);
        this.m_domain = resultSet.getString(20);
        this.m_sid = resultSet.getString(21);
        this.m_firstRogueTime = resultSet.getTimestamp(22);
        this.m_rogueType = resultSet.getInt(23);
        this.m_lastAgentCom = resultSet.getTimestamp(24);
        this.m_ipAddressNum = resultSet.getInt(25);
        this.m_markedForAction = resultSet.getInt(27);
        if (resultSet.getMetaData().getColumnCount() == 29) {
            this.m_orgName = resultSet.getString(28);
            if (this.m_orgName == null) {
                this.m_orgName = "";
            }
        } else {
            this.m_orgName = "";
        }
    }

    public int getNumColumns() {
        return 27;
    }

    public int getNumProperties() {
        return 29;
    }

    public String getPropertyName(int n) {
        return PROPERTY_NAMES[n];
    }

    public final void calculateProperties(long l, long l2) {
        this.m_status = this.isException() ? 0 : (this.m_lastDetectTime == null || this.m_lastDetectTime.getTime() + l2 < l ? 1 : (this.isRogue() ? 2 : 3));
    }

    public final boolean isRogue() {
        return this.m_rogueType != 0 && !this.isException();
    }

    public final boolean isException() {
        return this.m_exception;
    }

    public final boolean inRogueGracePeriod() {
        return this.m_rogueType == 4;
    }

    public boolean isMacDefault() {
        return this.getMAC() == DEFAULT_MAC;
    }

    private boolean isDifferent(int n, Object object, Object object2) {
        boolean bl = false;
        if (object2 == null && object != null || object2 != null && !object2.equals(object)) {
            bl = true;
            this.setDirtyProperty(n);
        }
        return bl;
    }

    private boolean isDifferent(int n, int n2, int n3) {
        boolean bl = false;
        if (n3 != n2) {
            bl = true;
            this.setDirtyProperty(n);
        }
        return bl;
    }

    private boolean isDifferent(int n, boolean bl, boolean bl2) {
        boolean bl3 = false;
        if (bl2 != bl) {
            bl3 = true;
            this.setDirtyProperty(n);
        }
        return bl3;
    }

    public int getId() {
        return this.m_id;
    }

    public void setId(int n) {
        this.m_id = n;
    }

    public int getHostId() {
        return this.m_id;
    }

    public void setHostId(int n) {
        this.m_id = n;
    }

    public String getMAC() {
        return this.m_MAC;
    }

    public void setMAC(String string) {
        if (this.isDifferent(2, this.m_MAC, string)) {
            if (string.length() != 12) {
                throw new IllegalArgumentException(Resource.formatString("host_template_wrong_mac_length", string));
            }
            this.m_MAC = string;
            String string2 = this.m_MAC.substring(0, 6);
            if (this.isDifferent(3, this.m_OUI, string2)) {
                this.m_OUI = string2;
            }
        }
    }

    public String getOUI() {
        return this.m_OUI;
    }

    public String getNetworkAddress() {
        return this.m_networkAddr;
    }

    public void setNetworkAddress(String string) {
        if (this.isDifferent(4, this.m_networkAddr, string)) {
            this.m_networkAddr = string;
            this.setIpAddressNum(string);
            this.setDirtyProperty(25);
        }
    }

    public String getIpAddress() {
        return this.m_networkAddr;
    }

    public void setIpAddress(String string) {
        this.setNetworkAddress(string);
    }

    public int getNetworkProtocolID() {
        return this.getProtocolID();
    }

    public int getProtocolID() {
        return this.m_protocolID;
    }

    public void setProtocolID(int n) {
        if (this.isDifferent(5, this.m_protocolID, n)) {
            this.m_protocolID = n;
        }
    }

    public String getNetbiosName() {
        return this.m_netbiosName;
    }

    public void setNetbiosName(String string) {
        if (this.isDifferent(6, this.m_netbiosName, string)) {
            this.m_netbiosName = string;
        }
    }

    public String getDnsName() {
        return this.m_dnsName;
    }

    public void setDnsName(String string) {
        if (this.isDifferent(7, this.m_dnsName, string)) {
            this.m_dnsName = string;
        }
    }

    public Timestamp getLastDetectTime() {
        return this.m_lastDetectTime;
    }

    public void setLastDetectTime(Timestamp timestamp) {
        if (this.isDifferent(8, this.m_lastDetectTime, timestamp)) {
            this.m_lastDetectTime = timestamp;
        }
        if (this.m_firstDetectTime == null) {
            this.setFirstDetectTime(timestamp);
        }
    }

    public Integer getNetworkID() {
        return this.m_networkID;
    }

    public void setNetworkID(Integer n) {
        if (this.isDifferent(9, this.m_networkID, n)) {
            this.m_networkID = n;
        }
    }

    public boolean getException() {
        return this.m_exception;
    }

    public void setException(boolean bl) {
        if (this.isDifferent(10, this.m_exception, bl)) {
            this.m_exception = bl;
        }
    }

    public Integer getEpoIndex() {
        return this.m_epoIndex;
    }

    public void setEpoIndex(Integer n) {
        if (this.isDifferent(11, this.m_epoIndex, n)) {
            this.m_epoIndex = n;
        }
    }

    public String getComments() {
        return this.m_comments;
    }

    public void setComments(String string) {
        if (this.isDifferent(12, this.m_comments, string)) {
            this.m_comments = string;
        }
    }

    public String getOrgName() {
        return this.m_orgName;
    }

    public void setOrgName(String string) {
        this.m_orgName = string;
    }

    public String getOSPlatform() {
        return this.m_OSPlatform;
    }

    public void setOSPlatform(String string) {
        if (this.isDifferent(13, this.m_OSPlatform, string)) {
            this.m_OSPlatform = string;
        }
    }

    public String getOSFamily() {
        return this.m_OSFamily;
    }

    public void setOSFamily(String string) {
        if (this.isDifferent(14, this.m_OSFamily, string)) {
            this.m_OSFamily = string;
        }
    }

    public String getOSVersion() {
        return this.m_OSVersion;
    }

    public void setOSVersion(String string) {
        if (this.isDifferent(15, this.m_OSVersion, string)) {
            this.m_OSVersion = string;
        }
    }

    public String getNetbiosComment() {
        return this.m_netbiosComment;
    }

    public void setNetbiosComment(String string) {
        if (this.isDifferent(16, this.m_netbiosComment, string)) {
            this.m_netbiosComment = string;
        }
    }

    public boolean getDeleted() {
        return this.m_deleted;
    }

    public boolean isDeleted() {
        return this.m_deleted;
    }

    public void setDeleted(boolean bl) {
        if (this.isDifferent(17, this.m_deleted, bl)) {
            this.m_deleted = bl;
        }
    }

    public Timestamp getFirstDetectTime() {
        return this.m_firstDetectTime;
    }

    public void setFirstDetectTime(Timestamp timestamp) {
        if (this.isDifferent(18, this.m_firstDetectTime, timestamp)) {
            this.m_firstDetectTime = timestamp;
        }
    }

    public String getUsers() {
        return this.m_users;
    }

    public void setUsers(String string) {
        if (this.isDifferent(19, this.m_users, string)) {
            this.m_users = string;
        }
    }

    public String getDomain() {
        return this.m_domain;
    }

    public void setDomain(String string) {
        if (this.isDifferent(20, this.m_domain, string)) {
            this.m_domain = string;
        }
    }

    public String getSid() {
        return this.m_sid;
    }

    public void setSid(String string) {
        if (this.isDifferent(21, this.m_sid, string)) {
            this.m_sid = string;
        }
    }

    public Timestamp getFirstRogueTime() {
        return this.m_firstRogueTime;
    }

    public void setFirstRogueTime(Timestamp timestamp) {
        if (this.isDifferent(22, this.m_firstRogueTime, timestamp)) {
            this.m_firstRogueTime = timestamp;
        }
    }

    public int getRogueType() {
        return this.m_rogueType;
    }

    public void setRogueType(int n) {
        if (this.isDifferent(23, this.m_rogueType, n)) {
            this.m_rogueType = n;
        }
    }

    public String getFriendlyName() {
        if (this.m_netbiosName.length() > 0) {
            return this.m_netbiosName;
        }
        if (this.m_dnsName.length() > 0) {
            return this.m_dnsName;
        }
        if (this.m_networkAddr.length() > 0) {
            return this.m_networkAddr;
        }
        return StringUtil.formatMAC((String)this.m_MAC);
    }

    public int getIpAddressNum() {
        return this.m_ipAddressNum;
    }

    private void setIpAddressNum(String string) {
        try {
            this.m_ipAddressNum = IPUtil.convert((String)string);
        }
        catch (IPFormatException iPFormatException) {
            this.m_ipAddressNum = 0;
        }
    }

    public void addUser(String string) {
        this.m_users = this.m_users.length() == 0 ? string : this.m_users + ", " + string;
    }

    public void setOSInfo(String string, String string2, String string3) {
        this.setOSPlatform(string);
        this.setOSFamily(string2);
        this.setOSVersion(string3);
    }

    public void setMacNoErrorChecking(String string) {
        this.m_MAC = string;
        this.m_OUI = DEFAULT_OUI;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = System.getProperty("line.separator");
        stringBuffer.append(Resource.getString("host_mac", string)).append(this.m_MAC).append(string2);
        stringBuffer.append(Resource.getString("host_ip", string)).append(this.m_networkAddr).append(string2);
        stringBuffer.append(Resource.getString("host_dns", string)).append(this.m_dnsName).append(string2);
        stringBuffer.append(Resource.getString("host_nbname", string)).append(this.m_netbiosName).append(string2);
        return stringBuffer.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        Host host = new Host(this);
        return host;
    }

    public Timestamp getLastAgentCom() {
        return this.m_lastAgentCom;
    }

    public void setLastAgentCom(Timestamp timestamp) {
        if (this.isDifferent(24, this.m_lastAgentCom, timestamp)) {
            this.m_lastAgentCom = timestamp;
        }
    }

    public int getStatus() {
        return this.m_status;
    }

    public void setStatus(int n) {
        this.m_status = n;
    }

    public int getHostStatus() {
        return this.m_status;
    }

    public void setHostStatus(int n) {
        this.m_status = n;
    }

    public int getMarkedForAction() {
        return this.m_markedForAction;
    }

    public boolean isMarkedForAction() {
        return this.m_markedForAction == 1;
    }

    public void setMarkedForAction(int n) {
        if (this.isDifferent(27, this.m_markedForAction, n)) {
            this.m_markedForAction = n;
        }
    }

    public void setDirtyProperty(int n) {
        this.m_dirtyBits.set(n - 1);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

