/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.db;

import com.nai.mcafee.common.db.Database;
import com.nai.mcafee.common.db.DatabaseTestSetup;
import com.nai.mcafee.common.db.Queries;
import com.nai.mcafee.snowcap.db.SchemaVersion;
import com.nai.mcafee.snowcap.db.SchemaVersionException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestResult;

public class SnowcapDbTestSetup
extends DatabaseTestSetup {
    private Database m_epoDb = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$nai$mcafee$snowcap$db$SnowcapDbTestSetup;

    public String getValidationQuery() {
        return Queries.VALIDATE_SNOWCAP_DB;
    }

    public String name() {
        return "snowcap";
    }

    public void ensureAllConnectionsClosed(Test test, TestResult testResult) {
        super.ensureAllConnectionsClosed(test, testResult);
        this.ensureAllConnectionsClosed("EPO", this.getEpoDatabase(), test, testResult);
    }

    public boolean testSchemaVersion(Test test, TestResult testResult) {
        boolean bl = true;
        try {
            SchemaVersion.verifyDbSchemaVersion(this.getDatabase());
        }
        catch (SchemaVersionException schemaVersionException) {
            testResult.addFailure(test, new AssertionFailedError(schemaVersionException.toString()));
            bl = false;
        }
        return bl;
    }

    public String getEpoValidationQuery() {
        return Queries.VALIDATE_EPO_DB;
    }

    public Connection getEpoConnection() throws SQLException {
        if (!$assertionsDisabled && !this.isSetup()) {
            throw new AssertionError();
        }
        return this.m_epoDb.getConnection();
    }

    public Database getEpoDatabase() {
        if (!$assertionsDisabled && !this.isSetup()) {
            throw new AssertionError();
        }
        return this.m_epoDb;
    }

    public void additionalSetup(Properties properties) throws Exception {
        this.m_epoDb = Database.createFromPropertiesFile((Properties)properties, (String)"epo", (String)Queries.VALIDATE_EPO_DB);
    }

    protected void additionalCleanup() {
        if (this.m_epoDb != null) {
            this.m_epoDb.close();
            this.m_epoDb = null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$nai$mcafee$snowcap$db$SnowcapDbTestSetup == null ? (class$com$nai$mcafee$snowcap$db$SnowcapDbTestSetup = SnowcapDbTestSetup.class$("com.nai.mcafee.snowcap.db.SnowcapDbTestSetup")) : class$com$nai$mcafee$snowcap$db$SnowcapDbTestSetup).desiredAssertionStatus();
    }
}

