/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.rmd;

import com.nai.mcafee.common.db.Database;
import com.nai.mcafee.common.db.DatabaseUtil;
import com.nai.mcafee.snowcap.db.ActionStatus;
import com.nai.mcafee.snowcap.db.EventLog;
import com.nai.mcafee.snowcap.db.Host;
import com.nai.mcafee.snowcap.db.Network;
import com.nai.mcafee.snowcap.db.Sensor;
import com.nai.mcafee.snowcap.db.epo.EpoDatabase;
import com.nai.mcafee.snowcap.message.HostDetectedMessage;
import com.nai.mcafee.snowcap.rmd.AgentDeployedStatusUpdater;
import com.nai.mcafee.snowcap.rmd.DefaultErrorHandler;
import com.nai.mcafee.snowcap.rmd.DefaultTimeSource;
import com.nai.mcafee.snowcap.rmd.ErrorHandler;
import com.nai.mcafee.snowcap.rmd.NewRogueAction;
import com.nai.mcafee.snowcap.rmd.TimeSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;

public class MessageProcessor {
    private static MessageProcessor m_instance;
    private NewRogueAction m_newRogueAction = null;
    private AgentDeployedStatusUpdater m_agentDeployStatusUpdater = null;
    private boolean m_useServerTime = true;
    private int m_epoDbLookupMethod = 1;
    private long m_deadAgentPeriod = 0L;
    private TimeSource m_timeSource = new DefaultTimeSource();
    private long m_rogueGracePeriod = 0L;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$nai$mcafee$snowcap$rmd$MessageProcessor;

    public static synchronized MessageProcessor instance() {
        if (m_instance == null) {
            m_instance = new MessageProcessor();
        }
        return m_instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processEvent(HostDetectedMessage hostDetectedMessage, Database database, Database database2, ErrorHandler errorHandler) {
        Connection connection = null;
        Connection connection2 = null;
        Timestamp timestamp = new Timestamp(this.m_timeSource.getTime());
        try {
            try {
                int n;
                MessageProcessor messageProcessor = this;
                synchronized (messageProcessor) {
                    connection = database.getConnection();
                    connection2 = database2.getConnection();
                }
                Sensor sensor = hostDetectedMessage.getSensor();
                Network network = hostDetectedMessage.getNetwork();
                try {
                    Network network2;
                    if (sensor.getAgentGUID().length() > 0 && hostDetectedMessage.getNumHosts() == 0) {
                        ActionStatus.updateSenorDeployedStatus(connection, sensor.getAgentGUID(), timestamp);
                        connection.commit();
                    }
                    if ((network2 = Network.getBySubnetInfo(connection, network.getNetworkAddress(), network.getSubnetMask())) == null) {
                        network.add(connection);
                    } else {
                        network = network2;
                        hostDetectedMessage.setNetwork(network);
                        network.setCovered(true);
                        Network.updateCoveredStatus(connection, network.getId(), true);
                    }
                    connection.commit();
                    if (!$assertionsDisabled && network.getId() == -1) {
                        throw new AssertionError();
                    }
                    sensor.setNetworkID(network.getId());
                    if (this.useServerTime()) {
                        sensor.setLastCommunicationTime(timestamp);
                    }
                    if ((n = sensor.getIdFromDatabase(connection)) == -1) {
                        sensor.add(connection);
                    } else {
                        sensor.setId(n);
                        sensor.update(connection);
                    }
                    connection.commit();
                }
                catch (Exception network2) {
                    if (errorHandler != null) {
                        errorHandler.onSensorInsertError(hostDetectedMessage, network2);
                    }
                    Object var20_16 = null;
                    DatabaseUtil.close((Connection)connection);
                    DatabaseUtil.close((Connection)connection2);
                    return;
                }
                int exception = hostDetectedMessage.getNumHosts();
                n = 0;
                while (n < exception) {
                    block28: {
                        Host host = hostDetectedMessage.getHost(n);
                        Host host2 = null;
                        boolean bl = false;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        host.setNetworkID(new Integer(network.getId()));
                        if (this.useServerTime()) {
                            host.setFirstDetectTime(timestamp);
                            host.setLastDetectTime(timestamp);
                        }
                        this.doRogueTest(connection2, host);
                        try {
                            Host host3 = (Host)host.getFromDatabase(connection);
                            if (host3 != null && host3.isDeleted()) {
                                MessageProcessor.deleteHost(connection, host3.getId());
                                Host.deleteFromDatabase(connection, host3.getId());
                                host3 = null;
                            }
                            if (host3 == null) {
                                host2 = (Host)((Object)host.clone());
                                this.doGracePeriodTest(host2);
                                host2.add(connection);
                                bl = true;
                            } else {
                                bl2 = !host3.isRogue();
                                bl3 = host3.inRogueGracePeriod();
                                host2 = host3;
                                MessageProcessor.copyHostInfo(host3, host);
                                this.doGracePeriodTest(host2);
                                host3.update(connection);
                                bl = false;
                            }
                            if (!$assertionsDisabled && host2 == null) {
                                throw new AssertionError();
                            }
                            if (!host2.isRogue() && !bl2 && this.m_agentDeployStatusUpdater != null) {
                                this.m_agentDeployStatusUpdater.update(connection, host2, timestamp);
                            }
                            connection.commit();
                            if (host2.isRogue() && !host2.inRogueGracePeriod() && (bl || bl2 || bl3) && this.m_newRogueAction != null) {
                                host2.lookupOrgName(connection);
                                this.m_newRogueAction.newRogueDetected(connection, network, sensor, host2);
                            }
                        }
                        catch (Exception host3) {
                            if (errorHandler == null) break block28;
                            errorHandler.onHostInsertError(host, host3);
                        }
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                if (errorHandler != null) {
                    errorHandler.onError(exception);
                }
                Object var20_18 = null;
                DatabaseUtil.close((Connection)connection);
                DatabaseUtil.close((Connection)connection2);
                return;
            }
            Object var20_17 = null;
        }
        catch (Throwable throwable) {
            Object var20_19 = null;
            DatabaseUtil.close(connection);
            DatabaseUtil.close(connection2);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
        DatabaseUtil.close((Connection)connection2);
    }

    private static final void deleteHost(Connection connection, int n) throws SQLException {
        ActionStatus.removeHostReference(connection, n);
        EventLog.removeHostReference(connection, n);
        Host.deleteFromDatabase(connection, n);
    }

    private final void doGracePeriodTest(Host host) {
        if (host.isRogue() && this.m_rogueGracePeriod > 0L) {
            long l = host.getFirstRogueTime().getTime();
            long l2 = host.getLastDetectTime().getTime();
            if (l2 < l + this.m_rogueGracePeriod) {
                host.setRogueType(4);
            }
        }
    }

    public void processEvent(HostDetectedMessage hostDetectedMessage, Database database, Database database2) throws Exception {
        DefaultErrorHandler defaultErrorHandler = new DefaultErrorHandler();
        this.processEvent(hostDetectedMessage, database, database2, defaultErrorHandler);
        defaultErrorHandler.throwIfErrors();
    }

    public void setNewRogueAction(NewRogueAction newRogueAction) {
        this.m_newRogueAction = newRogueAction;
    }

    public void setAgentDeployedStatusUpdater(AgentDeployedStatusUpdater agentDeployedStatusUpdater) {
        this.m_agentDeployStatusUpdater = agentDeployedStatusUpdater;
    }

    public void setUseServerTime(boolean bl) {
        this.m_useServerTime = bl;
    }

    public final boolean useServerTime() {
        return this.m_useServerTime;
    }

    public int getEpoDbLookupMethod() {
        return this.m_epoDbLookupMethod;
    }

    public void setEpoDbLookupMethod(int n) {
        if (n != 1 && n != 3 && n != 7) {
            throw new IllegalArgumentException("Illegal value passed to MessageProcessor.setEpoDbLookupMethod:" + n);
        }
        this.m_epoDbLookupMethod = n;
    }

    public void setDeadAgentPeriodInMs(long l) {
        this.m_deadAgentPeriod = l;
    }

    public long getDeadAgentPeriodInMs() {
        return this.m_deadAgentPeriod;
    }

    public void setTimeSource(TimeSource timeSource) {
        this.m_timeSource = timeSource;
    }

    public long getGracePeriodInMs() {
        return this.m_rogueGracePeriod;
    }

    public void setGracePeriodInMs(long l) {
        this.m_rogueGracePeriod = l;
    }

    private static final void copyHostInfo(Host host, Host host2) {
        if (host2.getNetworkAddress().length() == 0) {
            host.setLastDetectTime(host2.getLastDetectTime());
            MessageProcessor.copyRogueType(host2, host);
            host.setEpoIndex(host2.getEpoIndex());
            host.setLastAgentCom(host2.getLastAgentCom());
            return;
        }
        host.setNetworkAddress(host2.getNetworkAddress());
        if (!$assertionsDisabled && !host.getMAC().equals(host2.getMAC())) {
            throw new AssertionError();
        }
        if (host2.getNetbiosName().length() > 0 || host2.getDnsName().length() > 0) {
            host.setNetbiosName(host2.getNetbiosName());
            host.setDnsName(host2.getDnsName());
        }
        host.setLastDetectTime(host2.getLastDetectTime());
        host.setNetworkID(host2.getNetworkID());
        host.setEpoIndex(host2.getEpoIndex());
        if (host2.getOSPlatform().length() > 0) {
            host.setOSPlatform(host2.getOSPlatform());
        }
        if (host2.getOSFamily().length() > 0) {
            host.setOSFamily(host2.getOSFamily());
        }
        if (host2.getOSVersion().length() > 0) {
            host.setOSVersion(host2.getOSVersion());
        }
        if (host2.getNetbiosComment().length() > 0) {
            host.setNetbiosComment(host2.getNetbiosComment());
        }
        host.setDeleted(false);
        if (host.getFirstDetectTime() == null) {
            host.setFirstDetectTime(host2.getFirstDetectTime());
        }
        if (host2.getUsers().length() > 0) {
            host.setUsers(host2.getUsers());
        }
        if (host2.getDomain().length() > 0) {
            host.setDomain(host2.getDomain());
        }
        if (host2.getSid().length() > 0) {
            host.setSid(host2.getSid());
        }
        if (host2.getFirstRogueTime() == null || host.getFirstRogueTime() == null) {
            host.setFirstRogueTime(host2.getFirstRogueTime());
        }
        MessageProcessor.copyRogueType(host2, host);
        host.setLastAgentCom(host2.getLastAgentCom());
    }

    private static final void copyRogueType(Host host, Host host2) {
        if (host2.getRogueType() == 3 && host.getRogueType() == 1) {
            return;
        }
        host2.setRogueType(host.getRogueType());
    }

    private void doRogueTest(Connection connection, Host host) throws SQLException {
        EpoDatabase.AgentInfo agentInfo = EpoDatabase.getAgentInfo(connection, host, this.m_epoDbLookupMethod);
        if (agentInfo != null) {
            host.setEpoIndex(new Integer(agentInfo.getLeafNodeIndex()));
            long l = agentInfo.getLastCommInMillis();
            if (l != 0L) {
                host.setLastAgentCom(new Timestamp(l));
            } else {
                host.setLastAgentCom(null);
            }
        } else {
            host.setEpoIndex(null);
            host.setLastAgentCom(null);
        }
        boolean bl = host.getEpoIndex() == null;
        boolean bl2 = false;
        if (this.m_deadAgentPeriod > 0L) {
            Timestamp timestamp = host.getLastAgentCom();
            Timestamp timestamp2 = host.getLastDetectTime();
            if (!$assertionsDisabled && timestamp2 == null) {
                throw new AssertionError();
            }
            if (timestamp == null) {
                bl = true;
            } else if (timestamp.getTime() + this.m_deadAgentPeriod < timestamp2.getTime()) {
                bl2 = true;
            }
        }
        if (bl) {
            host.setFirstRogueTime(host.getLastDetectTime());
            host.setRogueType(1);
        } else if (bl2) {
            host.setFirstRogueTime(host.getLastDetectTime());
            host.setRogueType(2);
        } else {
            host.setFirstRogueTime(null);
            host.setRogueType(0);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$nai$mcafee$snowcap$rmd$MessageProcessor == null ? (class$com$nai$mcafee$snowcap$rmd$MessageProcessor = MessageProcessor.class$("com.nai.mcafee.snowcap.rmd.MessageProcessor")) : class$com$nai$mcafee$snowcap$rmd$MessageProcessor).desiredAssertionStatus();
        m_instance = null;
    }
}

