/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.ui;

import com.nai.mcafee.common.servlet.util.UserUtil;
import com.nai.mcafee.common.ui.ActionBeanBase;
import com.nai.mcafee.common.ui.util.SessionUtil;
import com.nai.mcafee.snowcap.db.SchemaVersionException;
import com.nai.mcafee.snowcap.db.io.Docks;
import com.nai.mcafee.snowcap.db.io.ExceptionsShip;
import com.nai.mcafee.snowcap.db.io.Shipping;
import com.nai.mcafee.snowcap.db.io.XMLDock;
import com.nai.mcafee.snowcap.util.Resource;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class DBIOActionBean
extends ActionBeanBase {
    private static final Logger m_log = Logger.getLogger((String)(class$com$nai$mcafee$snowcap$ui$DBIOActionBean == null ? (class$com$nai$mcafee$snowcap$ui$DBIOActionBean = DBIOActionBean.class$("com.nai.mcafee.snowcap.ui.DBIOActionBean")) : class$com$nai$mcafee$snowcap$ui$DBIOActionBean).getName());
    private Shipping m_ship;
    private Docks m_dock;
    private String m_nextPage = "displayuiconfig.do";
    private final String m_typeParam = "type";
    private final String m_formatParam = "format";
    private final String m_importFileParam = "importFile";
    private final String m_actionParam = "action";
    HashMap m_paramMap = new HashMap();
    private static final String CRLF = System.getProperty("line.separator");
    static /* synthetic */ Class class$com$nai$mcafee$snowcap$ui$DBIOActionBean;

    private Docks getDockFromRequest(String string) throws ClassNotFoundException {
        XMLDock xMLDock = null;
        String string2 = ((String[])this.m_paramMap.get("format"))[0];
        if (string2 == null) {
            throw new NullPointerException(Resource.getString("dbioactionbean_format_error", string));
        }
        if (!string2.equalsIgnoreCase("xml")) {
            throw new ClassNotFoundException(Resource.formatString("dbioactionbean_template_unknown_format", string2, string));
        }
        m_log.debug((Object)"XML format known, creating an XMLDock");
        xMLDock = new XMLDock();
        return xMLDock;
    }

    Shipping getShipFromRequest(String string) throws ParseException, ClassNotFoundException {
        ExceptionsShip exceptionsShip = null;
        String string2 = ((String[])this.m_paramMap.get("type"))[0];
        if (string2 == null) {
            throw new NullPointerException(Resource.getString("dbioactionbean_no_param_type", string));
        }
        if (!string2.equalsIgnoreCase("exceptions")) {
            throw new ClassNotFoundException(Resource.formatString("dbioactionbean_template_unsupported_type", string2, string));
        }
        m_log.debug((Object)"Exception type known, creating and ExceptionsShip");
        exceptionsShip = new ExceptionsShip();
        return exceptionsShip;
    }

    private void parseParameters(String string, String string2) throws ParseException, IOException {
        CharSequence charSequence;
        BufferedReader bufferedReader;
        String string3;
        String[] stringArray;
        CharSequence charSequence2 = null;
        String string4 = null;
        String string5 = "form-data;";
        int n = string.indexOf("-------------");
        if (n != -1) {
            string = string.substring(0, n);
        }
        if ((n = string.indexOf(string5)) == -1) {
            throw new ParseException(Resource.getString("dbioactionbean_parse_post_error", string2), 0);
        }
        String string6 = string.substring(n + string5.length() + 1).trim();
        String[] stringArray2 = string6.split("\n", 2);
        String[] stringArray3 = stringArray2[0].split(";");
        int n2 = 0;
        while (n2 < stringArray3.length) {
            stringArray = stringArray3[n2].split("=", 2);
            string3 = stringArray[0];
            bufferedReader = new BufferedReader(new StringReader(stringArray[1]));
            charSequence = bufferedReader.readLine();
            charSequence = ((String)charSequence).substring(1, ((String)charSequence).length() - 1);
            if (string3.equals("name")) {
                charSequence2 = charSequence;
            } else {
                m_log.debug((Object)("Found param: " + string3 + ", and val: " + (String)charSequence));
                String[] stringArray4 = new String[]{charSequence};
                this.m_paramMap.put(string3, stringArray4);
            }
            ++n2;
        }
        bufferedReader = new BufferedReader(new StringReader(stringArray2[1]));
        charSequence = new StringBuffer();
        while ((string3 = bufferedReader.readLine()) != null) {
            if (string3.length() == 0) break;
        }
        while ((string3 = bufferedReader.readLine()) != null) {
            ((StringBuffer)charSequence).append(string3 + "\n");
        }
        string4 = ((StringBuffer)charSequence).toString().trim();
        stringArray = new String[]{string4};
        this.m_paramMap.put(charSequence2, stringArray);
    }

    public String validate(HttpServletRequest httpServletRequest) throws Exception {
        Object object;
        Object object2;
        String string = UserUtil.getLanguageForUser((HttpServletRequest)httpServletRequest);
        m_log.debug((Object)"Validating request.");
        String string2 = httpServletRequest.getContentType();
        m_log.debug((Object)("Content-type is: " + string2));
        if (string2.indexOf("multipart/form-data") != -1) {
            String string3;
            m_log.debug((Object)"Request is encoded as multiplart/form-data");
            object2 = new StringBuffer();
            object = new BufferedReader(httpServletRequest.getReader());
            while ((string3 = ((BufferedReader)object).readLine()) != null) {
                ((StringBuffer)object2).append(string3);
                ((StringBuffer)object2).append(CRLF);
            }
            m_log.debug((Object)("Received data:" + object2));
            String string4 = this.scrollToNextSection(((StringBuffer)object2).toString());
            while (string4 != null) {
                String string5 = this.scrollToNextSection(string4);
                String string6 = string5 != null ? string4.substring(0, string4.indexOf("--------")) : string4;
                this.parseParameters(string6, string);
                string4 = string5;
            }
        } else {
            m_log.debug((Object)"Request is not encoded... gathering all parameters directly.");
            this.m_paramMap.putAll(httpServletRequest.getParameterMap());
        }
        if (m_log.isDebugEnabled()) {
            m_log.debug((Object)"Received data:");
            object2 = this.m_paramMap.entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                m_log.debug((Object)("KEY: " + object.getKey()));
                m_log.debug((Object)("VALUE: " + ((String[])object.getValue())[0]));
            }
        }
        this.m_ship = this.getShipFromRequest(UserUtil.getLanguageForUser((HttpServletRequest)httpServletRequest));
        this.m_dock = this.getDockFromRequest(string);
        return null;
    }

    public String scrollToNextSection(String string) throws IOException {
        String string2 = "Content-Disposition:";
        String string3 = null;
        int n = string.indexOf(string2);
        if (n != -1) {
            string3 = string.substring(n + string2.length() + 1, string.length());
        }
        return string3;
    }

    private void doImport(String string) throws IOException, SQLException, ParseException, SchemaVersionException {
        String string2 = ((String[])this.m_paramMap.get("importFile"))[0];
        if (string2 == null) {
            throw new IOException(Resource.getString("dbioactionbean_empty_import_data", string));
        }
        if (string2.length() == 0) {
            throw new IOException(Resource.getString("dbioactionbean_empty_import_data", string));
        }
        m_log.debug((Object)("Received the following document for import: " + CRLF + string2));
        m_log.debug((Object)"Importing data.");
        this.m_ship.Import(new ByteArrayInputStream(string2.getBytes()), this.m_dock);
    }

    private String doExport(HttpServletResponse httpServletResponse) throws IOException, SQLException {
        m_log.info((Object)"Responding to an export request.");
        m_log.debug((Object)"Exporting data.");
        httpServletResponse.reset();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4090);
        this.m_ship.Export(byteArrayOutputStream, this.m_dock);
        m_log.debug((Object)("Exporting the following data: " + CRLF + byteArrayOutputStream.toString()));
        httpServletResponse.setContentType("text/xml");
        String string = "attachment;filename=" + ((String[])this.m_paramMap.get("type"))[0] + "." + ((String[])this.m_paramMap.get("format"))[0];
        m_log.debug((Object)("Content-disposition: " + string));
        httpServletResponse.setHeader("Content-disposition", string);
        httpServletResponse.getOutputStream().write(byteArrayOutputStream.toByteArray());
        httpServletResponse.flushBuffer();
        return null;
    }

    public String execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = UserUtil.getLanguageForUser((HttpServletRequest)httpServletRequest);
        String string2 = "";
        String string3 = "";
        String string4 = "actiontaken.jsp";
        this.m_dock.SetExportType(this.m_ship.getExportType());
        String string5 = ((String[])this.m_paramMap.get("action"))[0];
        try {
            if (string5.equals("import")) {
                this.doImport(string);
                string2 = Resource.getString("dbioactionbean_successful_import", string);
                string3 = Resource.getJspString("jsputil_action_taken_confirmation", string);
            } else {
                this.doExport(httpServletResponse);
                string4 = "ui_config.jsp";
            }
        }
        catch (ParseException parseException) {
            string3 = Resource.getJspString("jsputil_action_failed", string);
            string2 = Resource.getString("dbioactionbean_parse_failed", string);
            m_log.log(Priority.ERROR, (Object)parseException, (Throwable)parseException);
        }
        catch (IOException iOException) {
            string3 = Resource.getJspString("jsputil_action_failed", string);
            string2 = Resource.formatString("dbioactionbean_io_failed", iOException.getMessage(), string);
            m_log.log(Priority.ERROR, (Object)iOException, (Throwable)iOException);
        }
        catch (SQLException sQLException) {
            string3 = Resource.getJspString("jsputil_action_failed", string);
            string2 = Resource.formatString("dbioactionbean_sql_failed", sQLException.getMessage(), string);
            m_log.log(Priority.ERROR, (Object)sQLException, (Throwable)sQLException);
        }
        SessionUtil.setActionTakenPageAttr((HttpServletRequest)httpServletRequest, (String)string3, (String)string2, (String)this.m_nextPage);
        return string4;
    }

    public static void main(String[] stringArray) {
        try {
            Object object;
            Object object2;
            String string;
            StringBuffer stringBuffer = new StringBuffer();
            FileReader fileReader = new FileReader("test.out");
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string);
                stringBuffer.append(CRLF);
            }
            DBIOActionBean dBIOActionBean = new DBIOActionBean();
            Object object3 = dBIOActionBean.scrollToNextSection(stringBuffer.toString());
            while (object3 != null) {
                object2 = dBIOActionBean.scrollToNextSection((String)object3);
                object = object2 != null ? ((String)object3).substring(0, ((String)object3).indexOf("--------")) : object3;
                dBIOActionBean.parseParameters((String)object, null);
                object3 = object2;
            }
            System.out.println("Received data:");
            object2 = dBIOActionBean.m_paramMap.entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                System.out.println("KEY: " + object.getKey());
                System.out.println("VALUE: " + object.getValue());
                System.out.println();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

