/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.ui;

import com.nai.mcafee.common.db.DatabaseObject;
import com.nai.mcafee.common.servlet.util.UserUtil;
import com.nai.mcafee.common.ui.ActionBeanBase;
import com.nai.mcafee.common.ui.InvalidParameterException;
import com.nai.mcafee.common.ui.util.SessionUtil;
import com.nai.mcafee.snowcap.db.ActionStatus;
import com.nai.mcafee.snowcap.db.Configuration;
import com.nai.mcafee.snowcap.db.EventLog;
import com.nai.mcafee.snowcap.db.Host;
import com.nai.mcafee.snowcap.db.Network;
import com.nai.mcafee.snowcap.server.Server;
import com.nai.mcafee.snowcap.ui.util.ActionStatusPropDisplay;
import com.nai.mcafee.snowcap.ui.util.EventLogPropDisplay;
import com.nai.mcafee.snowcap.ui.util.HostPropDisplay;
import com.nai.mcafee.snowcap.ui.util.NetworkPropDisplay;
import com.nai.mcafee.snowcap.ui.util.PropDisplay;
import com.nai.mcafee.snowcap.util.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DisplayConfigureTableBean
extends ActionBeanBase {
    public String validate(HttpServletRequest httpServletRequest) throws Exception {
        String string = httpServletRequest.getParameter("configureTableId");
        if (!SessionUtil.isIntegerLE((String)string, (int)4) || !SessionUtil.isIntegerGT((String)string, (int)0)) {
            throw new InvalidParameterException("Error: DisplayConfigureTableBean - illegal table id.");
        }
        return null;
    }

    public String execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        int n = Integer.parseInt(httpServletRequest.getParameter("configureTableId"));
        String string = UserUtil.getLanguageForUser((HttpServletRequest)httpServletRequest);
        String string2 = null;
        String string3 = null;
        DatabaseObject databaseObject = null;
        PropDisplay propDisplay = null;
        Configuration configuration = Server.getConfiguration();
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(Resource.getString("common_colon", string)).append(" ");
        switch (n) {
            case 1: {
                string3 = configuration.getMachineListCols();
                propDisplay = new HostPropDisplay(string);
                databaseObject = new Host();
                string2 = "displaymachines.do";
                stringBuffer.append(Resource.getString("page_view_machines", string));
                break;
            }
            case 2: {
                string3 = configuration.getSubnetListCols();
                propDisplay = new NetworkPropDisplay(string);
                databaseObject = new Network();
                string2 = "displaysubnets.do";
                stringBuffer.append(Resource.getString("page_view_list", string));
                break;
            }
            case 3: {
                string3 = configuration.getEventsListCols();
                propDisplay = new EventLogPropDisplay(string);
                databaseObject = new EventLog();
                string2 = "displayevents.do";
                stringBuffer.append(Resource.getString("page_view_events", string));
                break;
            }
            case 4: {
                string3 = configuration.getActionStatusListCols();
                propDisplay = new ActionStatusPropDisplay(string);
                databaseObject = new ActionStatus();
                string2 = "displayactionlist.do";
                stringBuffer.append(Resource.getString("page_view_actions", string));
                break;
            }
            default: {
                throw new InvalidParameterException("Error: DisplayConfigureTableBean - illegal table id.");
            }
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer(1024);
        boolean bl = true;
        stringBuffer3.append("switch( index )\n{\n");
        int n2 = 1;
        while (n2 <= databaseObject.getNumProperties()) {
            if (propDisplay.isPropertyDisplayable(n2)) {
                stringBuffer3.append("case '").append(n2).append("' :\n").append("optText = \"").append(propDisplay.getTruncatedHeader(n2)).append("\";\n").append("optValue = \"").append(n2).append("\";\n").append("break;\n");
                if (this.notSelected(string3, n2)) {
                    if (bl) {
                        bl = false;
                    } else {
                        stringBuffer2.append(":");
                    }
                    stringBuffer2.append(Integer.toString(n2));
                }
            }
            ++n2;
        }
        stringBuffer3.append("}");
        httpServletRequest.setAttribute("configTableReturnAction", (Object)string2);
        httpServletRequest.setAttribute("configTableSelectedCols", (Object)string3.toString());
        httpServletRequest.setAttribute("configTableAvailableCols", (Object)stringBuffer2.toString());
        httpServletRequest.setAttribute("configTableSwitchStatement", (Object)stringBuffer3.toString());
        httpServletRequest.setAttribute("configureTableId", (Object)Integer.toString(n));
        httpServletRequest.setAttribute("pageAdditionalTitle", (Object)stringBuffer.toString());
        return "configuretable.jsp";
    }

    private boolean notSelected(String string, int n) {
        boolean bl = true;
        String[] stringArray = string.split(":");
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].compareTo(Integer.toString(n)) == 0) {
                bl = false;
            }
            ++n2;
        }
        return bl;
    }
}

