/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.ui;

import com.nai.mcafee.common.condition.SerializationException;
import com.nai.mcafee.common.condition.SexpSerializer;
import com.nai.mcafee.common.db.DatabaseUtil;
import com.nai.mcafee.common.servlet.util.UserUtil;
import com.nai.mcafee.common.ui.ActionBeanBase;
import com.nai.mcafee.common.ui.util.SessionUtil;
import com.nai.mcafee.snowcap.action.Action;
import com.nai.mcafee.snowcap.action.ActionContext;
import com.nai.mcafee.snowcap.action.ActionInvoker;
import com.nai.mcafee.snowcap.db.Host;
import com.nai.mcafee.snowcap.db.ResponseDatabaseObject;
import com.nai.mcafee.snowcap.db.SexpQueryUtil;
import com.nai.mcafee.snowcap.db.action.ActionBase;
import com.nai.mcafee.snowcap.db.action.ActionFactoryException;
import com.nai.mcafee.snowcap.db.action.ActionPropertyException;
import com.nai.mcafee.snowcap.event.EventFactory;
import com.nai.mcafee.snowcap.event.Response;
import com.nai.mcafee.snowcap.event.concrete.UserRequestEvent;
import com.nai.mcafee.snowcap.server.Server;
import com.nai.mcafee.snowcap.util.Resource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class ResponseRunNowBean
extends ActionBeanBase {
    private static final Logger m_log = Logger.getLogger((String)(class$com$nai$mcafee$snowcap$ui$ResponseRunNowBean == null ? (class$com$nai$mcafee$snowcap$ui$ResponseRunNowBean = ResponseRunNowBean.class$("com.nai.mcafee.snowcap.ui.ResponseRunNowBean")) : class$com$nai$mcafee$snowcap$ui$ResponseRunNowBean).getName());
    static /* synthetic */ Class class$com$nai$mcafee$snowcap$ui$ResponseRunNowBean;

    public String validate(HttpServletRequest httpServletRequest) throws Exception {
        String string = UserUtil.getLanguageForUser((HttpServletRequest)httpServletRequest);
        if (!this.anyChecked(httpServletRequest)) {
            String string2 = Resource.getString("responserunnow_missing_selection", string);
            SessionUtil.setActionTakenPageAttr((HttpServletRequest)httpServletRequest, (String)Resource.getJspString("jsputil_user_input_required", string), (String)string2, (String)"displayresponselist.do");
            return "actiontaken.jsp";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        int n;
        String string = UserUtil.getLanguageForUser((HttpServletRequest)httpServletRequest);
        int[] nArray = this.getResponseIDs(httpServletRequest);
        Response[] responseArray = new Response[nArray.length];
        long l = System.currentTimeMillis();
        long l2 = Server.getConfiguration().getMachineWindow();
        try {
            n = 0;
            while (n < nArray.length) {
                responseArray[n] = this.createResponse(nArray[n]);
                if (responseArray[n].getCondition() != null) {
                    SexpQueryUtil.makeWhereSnippet(responseArray[n].getCondition(), l, l2);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            m_log.error((Object)Resource.getString("responserunnow_error_resp_load"));
            m_log.error((Object)exception);
            SessionUtil.setActionTakenPageAttr((HttpServletRequest)httpServletRequest, (String)Resource.getJspString("jsputil_user_input_required", string), (String)Resource.getString("responserunnow_error_resp_load", string), (String)"displayresponselist.do");
            return "actiontaken.jsp";
        }
        n = 0;
        int n2 = 0;
        while (n2 < responseArray.length) {
            ActionContext actionContext;
            Connection connection = null;
            Host[] hostArray = null;
            UserRequestEvent userRequestEvent = null;
            Response response = responseArray[n2];
            try {
                connection = Server.getDb().getConnection();
                String string2 = "select * from Hosts  left join OUIs on Hosts.OUI = OUIs.OUI  left join Networks on Hosts.NetworkID=Networks.NetworkID where  deleted=0 ";
                if (response.getCondition() != null) {
                    string2 = string2 + " and ( " + SexpQueryUtil.makeWhereSnippet(response.getCondition(), l, l2) + " )";
                }
                hostArray = Host.getByQuery(connection, string2);
                userRequestEvent = EventFactory.createUserRequestEvent(connection);
                actionContext = null;
            }
            catch (Throwable throwable) {
                actionContext = null;
                DatabaseUtil.close((Connection)connection);
                throw throwable;
            }
            DatabaseUtil.close((Connection)connection);
            int n3 = 0;
            while (n3 < hostArray.length) {
                int n4 = 0;
                while (n4 < response.numActions()) {
                    actionContext = userRequestEvent.createActionContext();
                    actionContext.setHost(hostArray[n3]);
                    try {
                        Action action = response.getAction(n4);
                        m_log.debug((Object)"Executing action async.");
                        ActionInvoker actionInvoker = Server.getActionInvoker();
                        actionInvoker.addToQueue(action, actionContext);
                    }
                    catch (Exception exception) {
                        m_log.error((Object)"", (Throwable)exception);
                        n = 1;
                    }
                    ++n4;
                }
                ++n3;
            }
            if (n != 0) {
                SessionUtil.setActionTakenPageAttr((HttpServletRequest)httpServletRequest, (String)Resource.getJspString("jsputil_user_input_required", string), (String)Resource.getString("responserunnow_error_failures", string), (String)"displayactionlist.do");
                return "actiontaken.jsp";
            }
            ++n2;
        }
        return "displayactionlist.do";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response createResponse(int n) throws SQLException, SerializationException, ActionFactoryException, ActionPropertyException {
        Response response;
        Connection connection = null;
        try {
            Response response2 = new Response();
            connection = Server.getDb().getConnection();
            ResponseDatabaseObject responseDatabaseObject = ResponseDatabaseObject.getById(connection, n);
            if (responseDatabaseObject == null) {
                throw new SQLException("Unable to load response with id:" + n);
            }
            String string = responseDatabaseObject.getCondition();
            if (string != null && string.length() > 0) {
                response2.setCondition(SexpSerializer.read((String)string));
            }
            ActionBase[] actionBaseArray = ActionBase.getByResponseId(connection, n, Server.getActionFactory());
            int n2 = 0;
            while (n2 < actionBaseArray.length) {
                response2.addAction((Action)((Object)actionBaseArray[n2]));
                ++n2;
            }
            response = response2;
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            DatabaseUtil.close((Connection)connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
        return response;
    }

    private int[] getResponseIDs(HttpServletRequest httpServletRequest) {
        Object object;
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!((String)object).startsWith("respid_")) continue;
            vector.add(((String)object).replaceFirst("respid_", ""));
        }
        object = new int[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            object[n] = Integer.parseInt((String)vector.get(n));
            ++n;
        }
        return object;
    }

    private boolean anyChecked(HttpServletRequest httpServletRequest) {
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith("respid_")) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

