/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.ui.util;

import com.nai.mcafee.common.condition.Sexp;
import com.nai.mcafee.common.condition.SexpAnd;
import com.nai.mcafee.common.condition.SexpBool;
import com.nai.mcafee.common.condition.SexpIpInRange;
import com.nai.mcafee.common.condition.SexpIpNotInRange;
import com.nai.mcafee.common.condition.SexpList;
import com.nai.mcafee.common.condition.SexpLong;
import com.nai.mcafee.common.condition.SexpProp;
import com.nai.mcafee.common.condition.SexpSerializer;
import com.nai.mcafee.common.condition.SexpString;
import com.nai.mcafee.common.db.DatabaseUtil;
import com.nai.mcafee.common.db.destination.Contact;
import com.nai.mcafee.common.servlet.util.UserUtil;
import com.nai.mcafee.common.ui.InvalidParameterException;
import com.nai.mcafee.common.ui.util.SessionUtil;
import com.nai.mcafee.common.util.StringUtil;
import com.nai.mcafee.snowcap.action.concrete.ExternalToolAction;
import com.nai.mcafee.snowcap.action.concrete.PushEPOAgentAction;
import com.nai.mcafee.snowcap.db.HNSParameterizer;
import com.nai.mcafee.snowcap.db.Host;
import com.nai.mcafee.snowcap.db.Network;
import com.nai.mcafee.snowcap.db.ResponseDatabaseObject;
import com.nai.mcafee.snowcap.db.Sensor;
import com.nai.mcafee.snowcap.db.action.ActionBase;
import com.nai.mcafee.snowcap.db.action.ActionFactory;
import com.nai.mcafee.snowcap.db.action.ActionFactoryException;
import com.nai.mcafee.snowcap.db.action.ActionPropertyException;
import com.nai.mcafee.snowcap.server.Server;
import com.nai.mcafee.snowcap.ui.util.ActionUtil;
import com.nai.mcafee.snowcap.util.Resource;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import javax.servlet.http.HttpServletRequest;

public class ResponseUtil {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$nai$mcafee$snowcap$ui$util$ResponseUtil;

    private static ResponseDatabaseObject getResponse(HttpServletRequest httpServletRequest) {
        ResponseDatabaseObject responseDatabaseObject = (ResponseDatabaseObject)httpServletRequest.getSession().getAttribute("responseDBO");
        if (responseDatabaseObject == null) {
            ResponseUtil.resetData(httpServletRequest);
        }
        return (ResponseDatabaseObject)httpServletRequest.getSession().getAttribute("responseDBO");
    }

    private static LinkedList getActionList(HttpServletRequest httpServletRequest) {
        return (LinkedList)httpServletRequest.getSession().getAttribute("responseActionList");
    }

    private static HNSParameterizer getEvent(HttpServletRequest httpServletRequest) {
        return (HNSParameterizer)httpServletRequest.getSession().getAttribute("responseEvent");
    }

    public static final void readAutoResponseFromRequest(HttpServletRequest httpServletRequest) throws Exception {
        String string;
        int n;
        ResponseUtil.resetData(httpServletRequest);
        ResponseDatabaseObject responseDatabaseObject = ResponseUtil.getResponse(httpServletRequest);
        HNSParameterizer hNSParameterizer = new HNSParameterizer(new Host(), new Network(), new Sensor());
        responseDatabaseObject.setName(httpServletRequest.getParameter("responseName"));
        String string2 = httpServletRequest.getParameter("responseId");
        if (SessionUtil.isIntegerGT((String)string2, (int)0)) {
            responseDatabaseObject.setId(Integer.parseInt(string2));
        }
        if ((n = Integer.parseInt((string = httpServletRequest.getParameter("responseEvent")).replaceFirst("evt_", ""))) == -1 || n == -2 || n >= 1 && n <= 5) {
            responseDatabaseObject.setEventType(n);
        } else {
            responseDatabaseObject.setEventType(-2);
        }
        String string3 = httpServletRequest.getParameter("responseEnabled");
        if (string3 == null) {
            responseDatabaseObject.setEnabled(false);
        } else {
            responseDatabaseObject.setEnabled(true);
        }
        String string4 = httpServletRequest.getParameter("conditionMasterLogicOp");
        if (string4 == null || string4.length() < 1) {
            throw new InvalidParameterException("ResponseUtil.readAutoResponseFromRequest - missing top condition logic operand.");
        }
        SexpList sexpList = (SexpList)SexpSerializer.read((String)("(" + string4 + ")"));
        String string5 = null;
        String string6 = "actionType";
        String string7 = "conditionType";
        int n2 = 0;
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            string5 = (String)enumeration.nextElement();
            if (string5.indexOf(string6) == 0) {
                ResponseUtil.readActionFromRequest(string5, httpServletRequest);
            }
            if (string5.indexOf(string7) != 0) continue;
            ++n2;
            sexpList.addFirstChild((Sexp)ResponseUtil.buildConditionSexp(string5, hNSParameterizer, httpServletRequest));
        }
        if (n2 == 1) {
            ResponseUtil.addSecondChild(sexpList);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 > 0) {
            sexpList.write(stringBuffer);
        }
        responseDatabaseObject.setCondition(stringBuffer.toString());
    }

    public static final void writeAutoResponseToRequest(HttpServletRequest httpServletRequest) throws Exception {
        Serializable serializable;
        ResponseDatabaseObject responseDatabaseObject = ResponseUtil.getResponse(httpServletRequest);
        LinkedList linkedList = ResponseUtil.getActionList(httpServletRequest);
        httpServletRequest.setAttribute("responseName", (Object)StringUtil.safeJavascriptLiteral((String)responseDatabaseObject.getName()));
        httpServletRequest.setAttribute("responseId", (Object)Integer.toString(responseDatabaseObject.getId()));
        httpServletRequest.setAttribute("responseEvent", (Object)("evt_" + responseDatabaseObject.getEventType()));
        httpServletRequest.setAttribute("responseEnabled", (Object)(responseDatabaseObject.isEnabled() ? "checked" : ""));
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("[");
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            serializable = (ActionBase)iterator.next();
            ResponseUtil.writeActionToStringBuffer((ActionBase)serializable, stringBuffer);
        }
        stringBuffer.replace(stringBuffer.lastIndexOf(","), stringBuffer.lastIndexOf(",") + 1, "");
        stringBuffer.append("]");
        serializable = new StringBuffer(1024);
        SexpList sexpList = null;
        if (responseDatabaseObject.getCondition().length() < 1) {
            ((StringBuffer)serializable).append("null");
        } else {
            sexpList = (SexpList)SexpSerializer.read((String)responseDatabaseObject.getCondition());
            httpServletRequest.setAttribute("conditionMasterLogicOp", (Object)sexpList.type());
            ResponseUtil.writeConditionParamStr(sexpList, (StringBuffer)serializable);
        }
        if (sexpList == null) {
            httpServletRequest.setAttribute("responseActionConditions", (Object)"null");
        } else {
            httpServletRequest.setAttribute("responseActionConditions", (Object)((StringBuffer)serializable).toString());
        }
        httpServletRequest.setAttribute("responseActionParams", (Object)stringBuffer.toString());
    }

    public static final void saveAutoResponseToDb(HttpServletRequest httpServletRequest, Connection connection, boolean bl) throws Exception {
        ResponseDatabaseObject responseDatabaseObject = ResponseUtil.getResponse(httpServletRequest);
        LinkedList linkedList = ResponseUtil.getActionList(httpServletRequest);
        if (bl) {
            int n = ResponseDatabaseObject.getById(connection, responseDatabaseObject.getId()).getResponseOrder();
            responseDatabaseObject.setResponseOrder(n);
            responseDatabaseObject.update(connection);
            ActionBase.deleteByResponseId(connection, responseDatabaseObject.getId(), Server.getActionFactory());
        } else {
            ResponseDatabaseObject.add(connection, true, responseDatabaseObject);
        }
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            ActionBase actionBase = (ActionBase)iterator.next();
            actionBase.setResponseId(responseDatabaseObject.getId());
            actionBase.add(connection);
        }
    }

    public static final void loadAutoResponseFromDb(HttpServletRequest httpServletRequest, Connection connection, int n) throws Exception {
        ResponseUtil.resetData(httpServletRequest);
        ResponseDatabaseObject responseDatabaseObject = ResponseDatabaseObject.getById(connection, n);
        httpServletRequest.getSession().setAttribute("responseDBO", (Object)responseDatabaseObject);
        LinkedList linkedList = ResponseUtil.getActionList(httpServletRequest);
        ActionBase[] actionBaseArray = ActionBase.getByResponseId(connection, responseDatabaseObject.getId(), Server.getActionFactory());
        int n2 = 0;
        while (n2 < actionBaseArray.length) {
            linkedList.add(actionBaseArray[n2]);
            ++n2;
        }
    }

    public static final String validateAutoResponse(HttpServletRequest httpServletRequest) throws Exception {
        String string = UserUtil.getLanguageForUser((HttpServletRequest)httpServletRequest);
        ResponseDatabaseObject responseDatabaseObject = ResponseUtil.getResponse(httpServletRequest);
        LinkedList linkedList = ResponseUtil.getActionList(httpServletRequest);
        String string2 = responseDatabaseObject.getName();
        if (!SessionUtil.isNonEmptyString((String)string2)) {
            return Resource.getString("responseutil_missing_name", string);
        }
        boolean bl = true;
        ExternalToolAction externalToolAction = new ExternalToolAction();
        String string3 = externalToolAction.getType();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            bl = false;
            ActionBase actionBase = (ActionBase)iterator.next();
            if (actionBase.getType().compareTo(string3) == 0) {
                String string4 = ((ExternalToolAction)actionBase).getToolIdAsString();
                if (ActionUtil.isValidExternalToolAction(string4)) continue;
                throw new InvalidParameterException("ResponseUtil.validateAutoResponse - invalid external tool id found.");
            }
            if (ActionUtil.isValidInternalAction(actionBase.getType())) continue;
            return Resource.getString("responseutil_unknown_action_type", string);
        }
        if (bl) {
            return Resource.getString("responseutil_missing_configured_action", string);
        }
        return null;
    }

    public static final String getConditionStringFromRequest(HttpServletRequest httpServletRequest) throws Exception {
        ResponseUtil.resetData(httpServletRequest);
        HNSParameterizer hNSParameterizer = new HNSParameterizer(new Host(), new Network(), new Sensor());
        String string = httpServletRequest.getParameter("conditionMasterLogicOp");
        if (string == null || string.length() < 1) {
            throw new InvalidParameterException("ResponseUtil.readConditionsFromRequest - missing top condition logic operand.");
        }
        SexpList sexpList = (SexpList)SexpSerializer.read((String)("(" + string + ")"));
        String string2 = null;
        String string3 = "conditionType";
        int n = 0;
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (string2.indexOf(string3) != 0) continue;
            ++n;
            sexpList.addFirstChild((Sexp)ResponseUtil.buildConditionSexp(string2, hNSParameterizer, httpServletRequest));
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (n > 0) {
            sexpList.write(stringBuffer);
        }
        return stringBuffer.toString();
    }

    public static final void setConditionStringInRequest(String string, HttpServletRequest httpServletRequest) throws Exception {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        SexpList sexpList = (SexpList)SexpSerializer.read((String)string);
        httpServletRequest.setAttribute("conditionMasterLogicOp", (Object)sexpList.type());
        StringBuffer stringBuffer = new StringBuffer(1024);
        ResponseUtil.writeConditionParamStr(sexpList, stringBuffer);
        httpServletRequest.setAttribute("searchFilterParams", (Object)stringBuffer.toString());
    }

    private static final String createTokenOption(String string, String string2) {
        String string3 = Resource.getString("hostpropdisplay_" + string, string2);
        if (string3.equals("hostpropdisplay_" + string)) {
            string3 = Resource.getString("networkpropdisplay_" + string, string2);
        }
        return "<option value='{" + string + "}'>" + string3 + "</option>";
    }

    public static final String getHtmlForTd(String string, String string2) throws Exception {
        StringBuffer stringBuffer = new StringBuffer(1024);
        String string3 = Resource.getString("common_colon", string2);
        if (string.compareTo("smtp") == 0) {
            stringBuffer.append("<table border=0 id='table1'>").append("\" +\n  \"");
            stringBuffer.append("<tr class='TaskTableText' id='tr1'>").append("<td>").append(Resource.getString("responseutil_to", string2)).append(Resource.getString("common_colon", string2)).append("</td>").append("<td><select class='Toolbar' id='").append("parameter_").append("' name='").append("parameter_").append("'>").append(ResponseUtil.getContactsAsOptions()).append("</select></td>").append("</tr>").append("\" +\n  \"");
            stringBuffer.append("<tr class='TaskTableText' id='tr2'>").append("<td>").append(Resource.getString("responseutil_subject", string2)).append(Resource.getString("common_colon", string2)).append("</td>").append("<td><input type='text' size=60 ").append("onchange='enableButtons()' onkeyup='enableButtons()' id='").append("parameter1_").append("' name='").append("parameter1_").append("'></input></td>").append("</tr>").append("\" +\n        \"");
            stringBuffer.append("<tr class='TaskTableText'>").append("<td>").append(Resource.getString("responseutil_body", string2)).append(Resource.getString("common_colon", string2)).append("</td>").append("<td><textarea cols=60 rows=4 ").append("onchange='enableButtons()' onkeyup='enableButtons()' id='").append("parameter2_").append("' name='").append("parameter2_").append("'></textarea>").append("</tr>").append("\" +\n        \"");
            stringBuffer.append("<tr class='TaskTableText'>").append("<td>&nbsp;</td>").append("<td>").append(Resource.getString("responseutil_insert_token", string2)).append(" \" +\n        \"").append("<select class='Toolbar' ").append("id='emailSel\" + actionCount + \"' ").append("name='emailSel\" + actionCount + \"'>").append(ResponseUtil.createTokenOption("MAC", string2)).append(ResponseUtil.createTokenOption("IpAddress", string2)).append(ResponseUtil.createTokenOption("NetbiosName", string2)).append(ResponseUtil.createTokenOption("DnsName", string2)).append(ResponseUtil.createTokenOption("LastDetectTime", string2)).append(ResponseUtil.createTokenOption("Comments", string2)).append(ResponseUtil.createTokenOption("OSPlatform", string2)).append(ResponseUtil.createTokenOption("OSFamily", string2)).append(ResponseUtil.createTokenOption("OSVersion", string2)).append(ResponseUtil.createTokenOption("NetbiosComment", string2)).append(ResponseUtil.createTokenOption("FirstDetectTime", string2)).append(ResponseUtil.createTokenOption("Users", string2)).append(ResponseUtil.createTokenOption("Domain", string2)).append(ResponseUtil.createTokenOption("FirstRogueTime", string2)).append(ResponseUtil.createTokenOption("RogueType", string2)).append(ResponseUtil.createTokenOption("FriendlyName", string2)).append(ResponseUtil.createTokenOption("OrgName", string2)).append(ResponseUtil.createTokenOption("HostStatus", string2)).append(ResponseUtil.createTokenOption("MarkedForAction", string2)).append(ResponseUtil.createTokenOption("NetworkName", string2)).append(ResponseUtil.createTokenOption("NetworkAddress", string2)).append(ResponseUtil.createTokenOption("AddressAndMask", string2)).append("</select>").append("\" +\n        \"").append("<img height=1 src='images/px_trans.gif' width=3 border=0>").append("<input type='button' class='clsBtn' onclick='insertString(").append("event, 1, ").append("emailSel\" + actionCount + \")' value='").append(Resource.getString("responseutil_subject", string2)).append("'></input>").append("<img height=1 src='images/px_trans.gif' width=3 border=0>").append("<input type='button' class='clsBtn' onclick='insertString(").append("event, 2, ").append("emailSel\" + actionCount + \")' value='").append(Resource.getString("responseutil_body", string2)).append("'></input>").append("</td></tr>").append("\" +\n        \"");
            stringBuffer.append("</table>");
        } else if (string.compareTo("pushAgent") == 0) {
            String string4;
            stringBuffer.append("<table border=0>\\\n");
            stringBuffer.append("<tr><td>").append("<span class='clsLabel'>");
            stringBuffer.append(Resource.getJspString("pushagent_agent_version", string2)).append(string3);
            stringBuffer.append("</span></td>\\\n");
            stringBuffer.append("<td>").append(ResponseUtil.makeFormTag("select class='Toolbar'", 0));
            Iterator iterator = PushEPOAgentAction.getAgentMap(string2).keySet().iterator();
            while (iterator.hasNext()) {
                string4 = (String)iterator.next();
                stringBuffer.append("<option value='").append(string4).append("' >").append(string4).append("\\\n");
            }
            stringBuffer.append("</select></td></tr>\\\n");
            stringBuffer.append("<tr><td>\\\n");
            stringBuffer.append("<span class='clsLabel'>").append(Resource.getJspString("pushagent_suppress_gui", string2));
            stringBuffer.append(string3).append("</span></td>\\\n");
            stringBuffer.append("<td><input type=checkbox id='suppressGUICheck\"+actionIndex+\"' onclick=setPushAgentHidden(\"+actionIndex+\") checked>");
            stringBuffer.append("</td></tr>\\\n");
            stringBuffer.append("<tr><td><span class='clsLabel'>");
            stringBuffer.append(Resource.getJspString("pushagent_installation_path", string2)).append(string3);
            stringBuffer.append("</span></td>\\\n");
            stringBuffer.append("<td>").append(ResponseUtil.makeFormTag("input type='hidden'", 2));
            stringBuffer.append("<span class='clsInputText' id='installPathLabel\"+actionIndex+\"'>--</span><br>\\\n");
            stringBuffer.append("<select class='Toolbar' id='selPrefix\"+actionIndex+\"'");
            stringBuffer.append(" onChange='saveAgentPathChange(\"+actionIndex+\")'>\\\n");
            stringBuffer.append("<option value='<SYSTEM_DRIVE>'>").append(Resource.getJspString("pushagent_system_drive", string2));
            stringBuffer.append("\\\n<option value='<PROGRAM_FILES_DIR>' selected>").append(Resource.getJspString("pushagent_program_files", string2));
            stringBuffer.append("\\\n<option value='<PROGRAM_FILES_COMMON_DIR>'>").append(Resource.getJspString("pushagent_program_files_common", string2));
            stringBuffer.append("\\\n<option value=''>").append(Resource.getJspString("pushagent_no_prefix", string2));
            stringBuffer.append("</select>&nbsp;");
            stringBuffer.append("<input type='text' value='Network Associates\\\\Common Framework' id='installDir\"+actionIndex+\"' size=24");
            stringBuffer.append(" onChange='saveAgentPathChange(\"+actionIndex+\")' ");
            stringBuffer.append(" onKeyUp='saveAgentPathChange(\"+actionIndex+\")'>\\\n");
            stringBuffer.append("</td></tr>\\\n");
            stringBuffer.append("<tr><td><span class='clsLabel'>").append(Resource.getJspString("pushagent_use_epo_credentials", string2));
            stringBuffer.append(string3).append("</span></td>\\\n<td>");
            stringBuffer.append("<input type=checkbox id='useEPOCreds\"+actionIndex+\"' onclick=updateCreds(\"+actionIndex+\") checked>");
            stringBuffer.append("</td></tr>\\\n");
            stringBuffer.append("<tr><td style='padding-left:10px'><span id='userAccountLabel\"+actionIndex+\"' class='clsLabel'>");
            string4 = Resource.getJspString("pushagent_user_account", string2);
            stringBuffer.append(string4.replaceAll("\\\\", "\\\\\\\\")).append(string3).append("</span></td>\\\n");
            stringBuffer.append("<td>");
            stringBuffer.append(ResponseUtil.makeFormTag("input type='text' size='24' onchange='pushAgentEnableControls(\"+actionIndex+\")' onkeyup='pushAgentEnableControls(\"+actionIndex+\")'", 4));
            stringBuffer.append("</td></tr>\\\n");
            stringBuffer.append("<tr><td style='padding-left:10px'><span id='passwordLabel\"+actionIndex+\"' class='clsLabel'>");
            stringBuffer.append(Resource.getJspString("common_password", string2)).append("</span></td>");
            stringBuffer.append("<td>");
            stringBuffer.append(ResponseUtil.makeFormTag("input type='password' size='24' onchange='updatePAPassword(\"+actionIndex+\")' onkeyup='updatePAPassword(\"+actionIndex+\")'", 5));
            stringBuffer.append("</td>\\\n");
            stringBuffer.append("</tr></table>\\\n");
            stringBuffer.append(ResponseUtil.makeFormTag("input type='hidden'", 6));
            stringBuffer.append(ResponseUtil.makeFormTag("input type='hidden' value='true'", 3));
            stringBuffer.append(ResponseUtil.makeFormTag("input type='hidden' value='true'", 1));
        } else {
            stringBuffer.append(Resource.getString("responseutil_none", string2));
        }
        return stringBuffer.toString();
    }

    private static final String makeFormTag(String string, int n) {
        String string2 = ResponseUtil.makeActionParam(n);
        return "<" + string + " name=" + string2 + " id=" + string2 + ">";
    }

    private static final String makeActionParam(int n) {
        return "'actionParam\"+ actionIndex +\":" + n + "'";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String getContactsAsOptions() throws Exception {
        StringBuffer stringBuffer = new StringBuffer(1024);
        Connection connection = null;
        try {
            connection = Server.getDb().getConnection();
            Contact[] contactArray = Contact.getAll((Connection)connection);
            int n = 0;
            while (n < contactArray.length) {
                stringBuffer.append("<option value='").append(contactArray[n].getId()).append("'>");
                stringBuffer.append(StringUtil.safeJavascriptLiteral((String)StringUtil.safeHtml((String)contactArray[n].getName()))).append("</option>");
                ++n;
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            DatabaseUtil.close((Connection)connection);
            throw throwable;
        }
        DatabaseUtil.close((Connection)connection);
        return stringBuffer.toString();
    }

    private static final void readActionFromRequest(String string, HttpServletRequest httpServletRequest) throws ActionFactoryException, ActionPropertyException, InvalidParameterException {
        LinkedList linkedList = ResponseUtil.getActionList(httpServletRequest);
        String string2 = ResponseUtil.getNum(string);
        String string3 = httpServletRequest.getParameter(string);
        if (ActionUtil.isValidInternalAction(string3)) {
            ActionFactory actionFactory = Server.getActionFactory();
            ActionBase actionBase = actionFactory.create(string3);
            int n = 0;
            while (n < actionBase.getNumProperties()) {
                String string4 = httpServletRequest.getParameter("actionParam" + string2 + ":" + n);
                if (string4 != null) {
                    actionBase.setPropertyAsString(n, string4);
                }
                ++n;
            }
            linkedList.addFirst(actionBase);
        } else if (ActionUtil.isValidExternalToolAction(string3)) {
            ExternalToolAction externalToolAction = new ExternalToolAction();
            externalToolAction.setToolId(Integer.parseInt(string3));
            linkedList.addFirst(externalToolAction);
        } else {
            throw new InvalidParameterException("ResponseUtil.readAutoResponseFromRequest - Unknown action type encountered.");
        }
    }

    private static final void writeActionToStringBuffer(ActionBase actionBase, StringBuffer stringBuffer) throws ActionPropertyException {
        if (actionBase.getType().compareTo("external tool") == 0) {
            ResponseUtil.appendRequestParam(stringBuffer, ((ExternalToolAction)actionBase).getToolIdAsString());
            ResponseUtil.appendRequestParam(stringBuffer, "0");
        } else if (actionBase.getType().compareTo("pushAgent") == 0) {
            ResponseUtil.appendRequestParam(stringBuffer, actionBase.getType());
            ResponseUtil.appendRequestParam(stringBuffer, Integer.toString(actionBase.getNumProperties()));
            int n = 0;
            while (n < actionBase.getNumProperties()) {
                if (actionBase.getPropertyName(n).compareTo("Password") != 0) {
                    ResponseUtil.appendRequestParam(stringBuffer, actionBase.getPropertyAsString(n));
                } else if (actionBase.getPropertyAsString(n).length() > 0) {
                    ResponseUtil.appendRequestParam(stringBuffer, "********");
                } else {
                    ResponseUtil.appendRequestParam(stringBuffer, "");
                }
                ++n;
            }
        } else {
            ResponseUtil.appendRequestParam(stringBuffer, actionBase.getType());
            ResponseUtil.appendRequestParam(stringBuffer, Integer.toString(actionBase.getNumProperties()));
            int n = 0;
            while (n < actionBase.getNumProperties()) {
                ResponseUtil.appendRequestParam(stringBuffer, actionBase.getPropertyAsString(n));
                ++n;
            }
        }
    }

    private static final SexpList buildConditionSexp(String string, HNSParameterizer hNSParameterizer, HttpServletRequest httpServletRequest) throws Exception, InvalidParameterException {
        HNSParameterizer hNSParameterizer2 = ResponseUtil.getEvent(httpServletRequest);
        String string2 = ResponseUtil.getNum(string);
        String string3 = httpServletRequest.getParameter(string);
        String string4 = httpServletRequest.getParameter("conditionProp:" + string2);
        SexpList sexpList = (SexpList)SexpSerializer.read((String)("(" + string3 + ")"));
        sexpList.addChild((Sexp)new SexpProp(string4));
        String string5 = null;
        int n = ResponseUtil.getAddlChildNodes(sexpList);
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = hNSParameterizer.getParamPropertyType(hNSParameterizer.getParamPropertyIndex(string4));
            string5 = ResponseUtil.combineParamStrings(httpServletRequest, n4, string2, n2);
            n2 += ResponseUtil.getParamCountFromEventPropType(n4);
            if (string5 == null) {
                throw new InvalidParameterException("ResponseUtil.readAutoResponseFromRequest - missing condition:" + string2 + " parameter:" + n3);
            }
            SexpLong sexpLong = null;
            if (hNSParameterizer2.getParamPropertyType(hNSParameterizer2.getParamPropertyIndex(string4)) == 2 || hNSParameterizer2.getParamPropertyType(hNSParameterizer2.getParamPropertyIndex(string4)) == 1) {
                sexpLong = new SexpLong(Long.parseLong(string5));
            } else {
                string5 = string5.replaceAll("\\\\", "\\\\\\\\");
                string5 = string5.replaceAll("\\\"", "\\\\\\\"");
                string5 = string5.replaceAll("\\(", "\\\\\\(");
                string5 = string5.replaceAll("\\)", "\\\\\\)");
                sexpLong = new SexpString(string5);
            }
            sexpList.addChild((Sexp)sexpLong);
            ++n3;
        }
        return sexpList;
    }

    private static final String combineParamStrings(HttpServletRequest httpServletRequest, int n, String string, int n2) throws InvalidParameterException {
        StringBuffer stringBuffer = new StringBuffer();
        if (!($assertionsDisabled || n > 0 && n < 4)) {
            throw new AssertionError();
        }
        switch (n) {
            case 0: 
            case 2: {
                stringBuffer.append(httpServletRequest.getParameter(ResponseUtil.condParamID(string, n2)));
                break;
            }
            case 4: {
                int n3 = 0;
                while (n3 < 6) {
                    stringBuffer.append(httpServletRequest.getParameter(ResponseUtil.condParamID(string, n2 + n3)));
                    ++n3;
                }
                break;
            }
            case 3: {
                int n4 = 0;
                while (n4 < 4) {
                    stringBuffer.append(httpServletRequest.getParameter(ResponseUtil.condParamID(string, n2 + n4)));
                    if (n4 < 3) {
                        stringBuffer.append(".");
                    }
                    ++n4;
                }
                break;
            }
            case 1: {
                long l = Long.parseLong(httpServletRequest.getParameter(ResponseUtil.condParamID(string, n2)));
                int n5 = Integer.parseInt(httpServletRequest.getParameter(ResponseUtil.condParamID(string, n2 + 1)));
                switch (n5) {
                    case 3: {
                        l = (long)((double)l * 24.0);
                    }
                    case 2: {
                        l = (long)((double)l * 60.0);
                    }
                    case 1: {
                        l = (long)((double)l * 60.0);
                    }
                    case 0: {
                        l = (long)((double)l * 1000.0);
                        break;
                    }
                    default: {
                        throw new InvalidParameterException("ResponseUtil.combineParamStrings - bad time unit found.");
                    }
                }
                stringBuffer.append(Long.toString(l));
            }
        }
        return stringBuffer.toString();
    }

    private static final void writeConditionParamStr(SexpList sexpList, StringBuffer stringBuffer) throws Exception {
        int n;
        Sexp sexp = null;
        stringBuffer.append("[");
        int n2 = 0;
        while (n2 < sexpList.numChildren()) {
            sexp = sexpList.childAt(n2);
            if (!(sexp instanceof SexpBool)) {
                ResponseUtil.appendRequestParam(stringBuffer, sexp.type());
                ResponseUtil.appendRequestParam(stringBuffer, ((SexpProp)sexp.childAt(0)).getPropName());
                ResponseUtil.appendRequestParam(stringBuffer, Integer.toString(ResponseUtil.getAddlChildNodes((SexpList)sexp)));
                n = 1;
                while (n < sexp.numChildren()) {
                    ResponseUtil.appendRequestParam(stringBuffer, ResponseUtil.getSexpValueAsString(sexp.childAt(n)));
                    ++n;
                }
            }
            ++n2;
        }
        n = stringBuffer.lastIndexOf(",");
        if (n > -1) {
            stringBuffer.replace(stringBuffer.lastIndexOf(","), stringBuffer.lastIndexOf(",") + 1, "");
        }
        stringBuffer.append("]");
    }

    private static final String condParamID(String string, int n) {
        return "conditionParam" + string + ":" + n;
    }

    private static final int getParamCountFromEventPropType(int n) throws Exception {
        if (!($assertionsDisabled || n > 0 && n < 4)) {
            throw new AssertionError();
        }
        switch (n) {
            case 0: 
            case 2: {
                return 1;
            }
            case 4: {
                return 6;
            }
            case 3: {
                return 4;
            }
            case 1: {
                return 1;
            }
        }
        throw new Exception("ResponseUtil.getPropTypeStringCount - unknown ParamPropertyTypes range encountered.");
    }

    private static final void resetData(HttpServletRequest httpServletRequest) {
        ResponseDatabaseObject responseDatabaseObject = new ResponseDatabaseObject();
        LinkedList linkedList = new LinkedList();
        HNSParameterizer hNSParameterizer = new HNSParameterizer(new Host(), new Network(), new Sensor());
        httpServletRequest.getSession().setAttribute("responseDBO", (Object)responseDatabaseObject);
        httpServletRequest.getSession().setAttribute("responseActionList", linkedList);
        httpServletRequest.getSession().setAttribute("responseEvent", (Object)hNSParameterizer);
    }

    private static final String getNum(String string) {
        return string.substring(string.indexOf(":") + 1);
    }

    private static final String getSexpValueAsString(Sexp sexp) throws Exception {
        if (sexp.type().compareTo("long") == 0) {
            return Long.toString(((SexpLong)sexp).getValue());
        }
        if (sexp.type().compareTo("string") == 0) {
            return ((SexpString)sexp).getValue();
        }
        throw new Exception("ResponseUtil.getSexpValueAsString - encountered non-String or non-Long Sexp.");
    }

    private static final int getAddlChildNodes(SexpList sexpList) {
        if (sexpList instanceof SexpIpInRange || sexpList instanceof SexpIpNotInRange) {
            return 2;
        }
        return 1;
    }

    private static final void appendRequestParam(StringBuffer stringBuffer, String string) {
        stringBuffer.append("\"").append(StringUtil.safeJavascriptLiteral((String)string, (boolean)false)).append("\",");
    }

    private static final void addSecondChild(SexpList sexpList) {
        SexpBool sexpBool = new SexpBool();
        boolean bl = sexpList instanceof SexpAnd;
        sexpBool.setValue(bl);
        sexpList.addChild((Sexp)sexpBool);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$nai$mcafee$snowcap$ui$util$ResponseUtil == null ? (class$com$nai$mcafee$snowcap$ui$util$ResponseUtil = ResponseUtil.class$("com.nai.mcafee.snowcap.ui.util.ResponseUtil")) : class$com$nai$mcafee$snowcap$ui$util$ResponseUtil).desiredAssertionStatus();
    }
}

