/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.snowcap.ui.util;

import com.nai.mcafee.common.ui.InvalidParameterException;
import com.nai.mcafee.snowcap.ui.util.HostInfo;
import java.util.ArrayList;
import java.util.Iterator;

public class SubnetInfo {
    public String m_networkAddress;
    public String m_subnetMask;
    private ArrayList m_hosts = new ArrayList();

    private SubnetInfo() {
    }

    public SubnetInfo(String string, String string2) {
        this.m_networkAddress = string;
        this.m_subnetMask = string2;
    }

    public int size() {
        return this.m_hosts.size();
    }

    public String getHostnames() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.m_hosts.iterator();
        while (iterator.hasNext()) {
            HostInfo hostInfo = (HostInfo)iterator.next();
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(hostInfo.m_hostName);
        }
        return stringBuffer.toString();
    }

    public String getLeafNodeIdAt(int n) throws InvalidParameterException {
        this.checkIndex(n);
        return ((HostInfo)this.m_hosts.get((int)n)).m_leafNodeId;
    }

    public String getHostnameAt(int n) throws InvalidParameterException {
        this.checkIndex(n);
        return ((HostInfo)this.m_hosts.get((int)n)).m_hostName;
    }

    public void clear() {
        this.m_hosts.clear();
    }

    public boolean isEqual(String string, String string2) {
        return this.m_networkAddress.compareTo(string) == 0 && this.m_subnetMask.compareTo(string2) == 0;
    }

    public void addHost(String string, String string2) {
        boolean bl = false;
        int n = 0;
        HostInfo hostInfo = new HostInfo(string, string2);
        if (this.m_hosts.size() < 1) {
            this.m_hosts.add(hostInfo);
            bl = true;
        }
        Iterator iterator = this.m_hosts.iterator();
        while (!bl && iterator.hasNext()) {
            HostInfo hostInfo2 = (HostInfo)iterator.next();
            int n2 = hostInfo.m_hostName.compareTo(hostInfo2.m_hostName);
            if (n2 < 0) {
                this.m_hosts.add(n, hostInfo);
                bl = true;
            }
            if (n2 == 0) {
                n2 = hostInfo.m_leafNodeId.compareTo(hostInfo2.m_leafNodeId);
                if (n2 < 0) {
                    this.m_hosts.add(n, hostInfo);
                    bl = true;
                }
                if (n2 == 0) {
                    bl = true;
                }
            }
            ++n;
        }
        if (!bl) {
            this.m_hosts.add(n, hostInfo);
        }
    }

    public void removeHost(String string, String string2) {
        boolean bl = false;
        int n = 0;
        if (this.m_hosts.size() < 1) {
            bl = true;
        }
        Iterator iterator = this.m_hosts.iterator();
        while (!bl && iterator.hasNext()) {
            HostInfo hostInfo = (HostInfo)iterator.next();
            int n2 = string2.compareTo(hostInfo.m_hostName);
            if (n2 == 0 && string.compareTo(hostInfo.m_leafNodeId) == 0) {
                this.m_hosts.remove(n);
                bl = true;
            }
            ++n;
        }
    }

    public boolean containsHost(int n) {
        boolean bl = false;
        Iterator iterator = this.m_hosts.iterator();
        while (!bl && iterator.hasNext()) {
            HostInfo hostInfo = (HostInfo)iterator.next();
            if (hostInfo.m_leafNodeId.compareTo(Integer.toString(n)) != 0) continue;
            bl = true;
        }
        return bl;
    }

    public String getNetworkAddress() {
        return this.m_networkAddress;
    }

    public String getSubnetMask() {
        return this.m_subnetMask;
    }

    public void checkIndex(int n) throws InvalidParameterException {
        if (n < 0 || n > this.m_hosts.size()) {
            throw new InvalidParameterException("SubnetInfo.getLeafNodeIdAt - invalid index");
        }
    }
}

