/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.common.action.eta;

import com.nai.mcafee.common.action.ActionStatusDispatcher;
import com.nai.mcafee.common.action.ActionStatusListener;
import com.nai.mcafee.common.db.DatabaseObject;
import com.nai.mcafee.common.util.Resource;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class Runner
extends Thread
implements ActionStatusDispatcher {
    private Thread m_parent;
    private String m_cmd;
    private StringBuffer m_output = new StringBuffer();
    private Set m_statusListeners = new HashSet();
    private DatabaseObject m_logger;
    private Logger m_log = Logger.getLogger((Class)(class$com$nai$mcafee$common$action$eta$Runner == null ? (class$com$nai$mcafee$common$action$eta$Runner = Runner.class$("com.nai.mcafee.common.action.eta.Runner")) : class$com$nai$mcafee$common$action$eta$Runner));
    private static final String CRLF = System.getProperty("line.separator");
    static /* synthetic */ Class class$com$nai$mcafee$common$action$eta$Runner;

    public void addActionStatusListener(ActionStatusListener actionStatusListener) {
        this.m_statusListeners.add(actionStatusListener);
    }

    public void removeActionStatusListener(ActionStatusListener actionStatusListener) {
        this.m_statusListeners.remove(actionStatusListener);
    }

    private void dispatchStatus(int n) {
        Iterator iterator = this.m_statusListeners.iterator();
        while (iterator.hasNext()) {
            ActionStatusListener actionStatusListener = (ActionStatusListener)iterator.next();
            actionStatusListener.setResults(n, this.m_output.toString(), this.m_cmd, this.m_logger);
        }
    }

    public Runner(String string, Thread thread, DatabaseObject databaseObject) {
        this.m_logger = databaseObject;
        this.m_cmd = string;
        this.m_parent = thread;
    }

    public void run() {
        int n = -1;
        this.m_output.delete(0, this.m_output.length());
        StreamReader[] streamReaderArray = new StreamReader[2];
        Process process = null;
        Runtime runtime = Runtime.getRuntime();
        try {
            File file = new File(System.getProperty("java.io.tmpdir"));
            if (this.m_log.isInfoEnabled()) {
                this.m_log.info((Object)Resource.formatString("runner_running", new String[]{this.m_cmd, file.getPath()}));
            }
            process = runtime.exec(this.m_cmd.split(" "), null, file);
            streamReaderArray[0] = new StreamReader(new BufferedReader(new InputStreamReader(process.getInputStream())));
            streamReaderArray[1] = new StreamReader(new BufferedReader(new InputStreamReader(process.getErrorStream())));
            try {
                streamReaderArray[0].start();
                streamReaderArray[1].start();
                n = process.waitFor();
                this.m_log.debug((Object)("The command has completed normally: " + n));
            }
            catch (InterruptedException interruptedException) {
                String string = Resource.getString("externaltoolaction_stoppingrun");
                this.m_log.warn((Object)string);
                if (process != null) {
                    process.destroy();
                }
                n = 1;
                this.m_output.append(string).append("\n");
            }
            this.m_log.debug((Object)"Gathering the output results.");
            String string = streamReaderArray[0].getOutput();
            this.m_output.append("STDOUT: ").append(string != null ? string : "");
            string = streamReaderArray[1].getOutput();
            this.m_output.append("STDERR: ").append(string != null ? string : "");
            this.m_log.debug((Object)"Setting the results.");
            this.dispatchStatus(n);
        }
        catch (IOException iOException) {
            StringWriter stringWriter = new StringWriter();
            iOException.printStackTrace(new PrintWriter(stringWriter));
            this.m_output.append(stringWriter.toString());
            this.m_log.error((Object)Resource.getString("externaltoolaction_ioerror"), (Throwable)iOException);
            if (process != null) {
                process.destroy();
            }
            n = 1;
            int n2 = this.m_output.indexOf("error=");
            if (n2 != -1) {
                try {
                    String string = this.m_output.substring(n2 + 6, this.m_output.indexOf(System.getProperty("line.separator"), n2));
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.dispatchStatus(n);
        }
        if (this.m_parent != null) {
            this.m_log.debug((Object)"Interrupting the parent thread.");
            this.m_parent.interrupt();
        }
    }

    public static void main(String[] stringArray) {
        String string = "C:\\WIN2KS\\system32\\nbtstat.exe -n";
        Runner runner = new Runner(string, Thread.currentThread(), null);
        runner.start();
        try {
            Thread.sleep(60000L);
            System.out.println("Received no interrupt... killing the child thread.");
            runner.interrupt();
            Thread.sleep(60000L);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Received an interrupt from the child thread... it must be done.");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class StreamReader
    extends Thread {
        private BufferedReader m_reader;
        private String m_output = null;

        public StreamReader(BufferedReader bufferedReader) {
            this.m_reader = bufferedReader;
        }

        public void run() {
            if (this.m_reader != null) {
                StringBuffer stringBuffer = new StringBuffer();
                try {
                    String string = this.m_reader.readLine();
                    while (string != null) {
                        stringBuffer.append(string).append(CRLF);
                        string = this.m_reader.readLine();
                    }
                }
                catch (IOException iOException) {
                    Runner.this.m_log.debug((Object)"", (Throwable)iOException);
                }
                this.m_output = stringBuffer.toString();
            }
        }

        public String getOutput() {
            return this.m_output;
        }
    }
}

