/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.common.log;

import com.nai.mcafee.common.log.RollingCalendar;
import com.nai.mcafee.common.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class DailyRollingFileAppender
extends FileAppender {
    static final int TOP_OF_TROUBLE = -1;
    static final int TOP_OF_MINUTE = 0;
    static final int TOP_OF_HOUR = 1;
    static final int HALF_DAY = 2;
    static final int TOP_OF_DAY = 3;
    static final int TOP_OF_WEEK = 4;
    static final int TOP_OF_MONTH = 5;
    private String datePattern = "'.'yyyy-MM-dd";
    private String scheduledFilename;
    private long nextCheck = System.currentTimeMillis() - 1L;
    Date now = new Date();
    SimpleDateFormat sdf;
    RollingCalendar rc = new RollingCalendar();
    int checkPeriod = -1;
    static final TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");

    public DailyRollingFileAppender() {
    }

    public DailyRollingFileAppender(Layout layout, String string, String string2) throws IOException {
        super(layout, string, true);
        this.datePattern = string2;
        this.activateOptions();
    }

    public void setDatePattern(String string) {
        this.datePattern = string;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void activateOptions() {
        super.activateOptions();
        if (this.datePattern != null && this.fileName != null) {
            this.now.setTime(System.currentTimeMillis());
            this.sdf = new SimpleDateFormat(this.datePattern);
            int n = this.computeCheckPeriod();
            this.printPeriodicity(n);
            this.rc.setType(n);
            File file = new File(this.fileName);
            this.scheduledFilename = this.fileName + this.sdf.format(new Date(file.lastModified()));
        } else {
            LogLog.error((String)("Either File or DatePattern options are not set for appender [" + this.name + "]."));
        }
    }

    void printPeriodicity(int n) {
        switch (n) {
            case 0: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled every minute."));
                break;
            }
            case 1: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled on top of every hour."));
                break;
            }
            case 2: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at midday and midnight."));
                break;
            }
            case 3: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at midnight."));
                break;
            }
            case 4: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at start of week."));
                break;
            }
            case 5: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at start of every month."));
                break;
            }
            default: {
                LogLog.warn((String)("Unknown periodicity for appender [" + this.name + "]."));
            }
        }
    }

    int computeCheckPeriod() {
        RollingCalendar rollingCalendar = new RollingCalendar(gmtTimeZone, Locale.ENGLISH);
        Date date = new Date(0L);
        if (this.datePattern != null) {
            int n = 0;
            while (n <= 5) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.datePattern);
                simpleDateFormat.setTimeZone(gmtTimeZone);
                String string = simpleDateFormat.format(date);
                rollingCalendar.setType(n);
                Date date2 = new Date(rollingCalendar.getNextCheckMillis(date));
                String string2 = simpleDateFormat.format(date2);
                if (string != null && string2 != null && !string.equals(string2)) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    void rollOver() throws IOException {
        File file;
        boolean bl;
        if (this.datePattern == null) {
            this.errorHandler.error("Missing DatePattern option in rollOver().");
            return;
        }
        String string = this.fileName + this.sdf.format(this.now);
        if (this.scheduledFilename.equals(string)) {
            return;
        }
        this.closeFile();
        File file2 = new File(this.scheduledFilename);
        if (file2.exists()) {
            file2.delete();
        }
        if (bl = FileUtil.renameFile(file = new File(this.fileName), file2)) {
            LogLog.debug((String)(this.fileName + " -> " + this.scheduledFilename));
        } else {
            LogLog.error((String)("Failed to rename [" + this.fileName + "] to [" + this.scheduledFilename + "]."));
        }
        try {
            this.setFile(this.fileName, false, this.bufferedIO, this.bufferSize);
        }
        catch (IOException iOException) {
            this.errorHandler.error("setFile(" + this.fileName + ", false) call failed.");
        }
        this.scheduledFilename = string;
    }

    protected void subAppend(LoggingEvent loggingEvent) {
        long l = System.currentTimeMillis();
        if (l >= this.nextCheck) {
            this.now.setTime(l);
            this.nextCheck = this.rc.getNextCheckMillis(this.now);
            try {
                this.rollOver();
            }
            catch (IOException iOException) {
                LogLog.error((String)"rollOver() failed.", (Throwable)iOException);
            }
        }
        super.subAppend(loggingEvent);
    }
}

