/*
 * Decompiled with CFR 0.152.
 */
package com.nai.mcafee.common.servlet.util;

import com.nai.mcafee.common.db.epo.EpoUser;
import com.nai.mcafee.common.util.LocaleName;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class UserUtil {
    private static final Logger m_log = Logger.getLogger((Class)(class$com$nai$mcafee$common$servlet$util$UserUtil == null ? (class$com$nai$mcafee$common$servlet$util$UserUtil = UserUtil.class$("com.nai.mcafee.common.servlet.util.UserUtil")) : class$com$nai$mcafee$common$servlet$util$UserUtil));
    public static final String SESSION_ID_PARAM = "SESSIONID";
    public static final String USER_CREDENTIALS = "userCredentials";
    public static final String PARAM_LOCALE = "LanguageId";
    public static final String EMBEDDED_FLAG_NAME = "All_for_one";
    public static final String EMBEDDED_FLAG_VALUE = "One_for_all";
    public static final long USER_TIMEOUT_PERIOD_IN_MILLIS = 86400000L;
    static /* synthetic */ Class class$com$nai$mcafee$common$servlet$util$UserUtil;

    public static boolean isEmbedded(HttpServletRequest httpServletRequest) {
        EpoUser epoUser = UserUtil.getEpoUser(httpServletRequest);
        if (epoUser != null) {
            return epoUser.getEmbedded();
        }
        return false;
    }

    public static boolean isUserAuthenticated(HttpServletRequest httpServletRequest) {
        EpoUser epoUser = UserUtil.getEpoUser(httpServletRequest);
        if (epoUser != null) {
            long l = System.currentTimeMillis();
            if (epoUser.getEmbedded() || l < epoUser.getLastComm() + 86400000L) {
                epoUser.setLastComm(l);
                return true;
            }
        }
        return false;
    }

    public static void saveEpoUser(EpoUser epoUser, HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter(PARAM_LOCALE);
        String string2 = LocaleName.getLanguageForId(string);
        m_log.debug((Object)("Setting user locale to: " + string + ", " + string2));
        epoUser.setLanguageId(string2);
        String string3 = httpServletRequest.getParameter(EMBEDDED_FLAG_NAME);
        boolean bl = false;
        if (string3 != null && string3.length() > 0 && string3.compareTo(EMBEDDED_FLAG_VALUE) == 0) {
            bl = true;
        }
        epoUser.setEmbedded(bl);
        epoUser.setLastComm(System.currentTimeMillis());
        UserUtil.clearEpoUser(httpServletRequest);
        httpServletRequest.getSession().setAttribute(USER_CREDENTIALS, (Object)epoUser);
    }

    public static void clearEpoUser(HttpServletRequest httpServletRequest) {
        httpServletRequest.getSession().removeAttribute(USER_CREDENTIALS);
    }

    public static Long getLastComm(HttpServletRequest httpServletRequest) {
        EpoUser epoUser = UserUtil.getEpoUser(httpServletRequest);
        if (epoUser != null) {
            return new Long(epoUser.getLastComm());
        }
        return null;
    }

    public static EpoUser getEpoUser(HttpServletRequest httpServletRequest) {
        m_log.debug((Object)"Getting EPO user...");
        EpoUser epoUser = null;
        m_log.debug((Object)"Looking in the session first.");
        epoUser = (EpoUser)httpServletRequest.getSession().getAttribute(USER_CREDENTIALS);
        if (epoUser == null) {
            m_log.debug((Object)"User was not found in the session, looking in the request for a session ID");
            String string = httpServletRequest.getParameter(SESSION_ID_PARAM);
            if (string != null) {
                m_log.debug((Object)("Found SESSIONID: " + string + " in the request, checking internal mappings."));
                epoUser = EpoUser.getFromInternalSessionMap(string);
                if (epoUser == null) {
                    m_log.debug((Object)"No login information could be found in internal session mappings.");
                }
            } else {
                m_log.debug((Object)"No session ID was found in the request...");
            }
        } else {
            m_log.debug((Object)"Found user in session, returning.");
        }
        return epoUser;
    }

    public static String getLanguageForUser(HttpServletRequest httpServletRequest) {
        String string = null;
        EpoUser epoUser = UserUtil.getEpoUser(httpServletRequest);
        if (epoUser != null) {
            m_log.debug((Object)("Getting the Locale for " + epoUser.getUserName()));
            if (epoUser != null) {
                string = epoUser.getLanguageId();
            }
        }
        m_log.debug((Object)("Returning locale: " + string));
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

