----------------------------------------------------
-- This file only work on epo3.6 and above
-- to convert this so it will run on epo3.5 and below:
-- search for the string "epo3.5" and comment out the 3.6 version and uncomment the 3.5 version
--	of the statement listed. 
-- The rogue EventLog table rebaned a field from Type to EventType

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVITEST_truncate_tables]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVITEST_truncate_tables]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVITEST_truncate_tables
(
@Type int
)
AS
BEGIN

	Create table #tmpnodes(
		endautoid int )


	execute AVIDALSP_Generate_BranchNode_Enum


	IF @type =2     /* truncate all tables */
	begin
		insert into #tmpnodes
		select endautoid 
		from branchnodeenum
		where startautoid = (select autoid from branchnode where nodename = 'Directory')
	end
	else	-- truncate only from avitest directory
	begin
		insert into #tmpnodes
		select endautoid 
		from branchnodeenum
		where startautoid = (select autoid from branchnode where nodename = 'AVITest')
	end

	IF @type =1  or  @type =2  /* truncate all tables */
	BEGIN
		-- delete events
		delete from events where nodeid in (select autoid from leafnode where parentid in 
							(select endautoid from #tmpnodes))
		delete from events where nodeid is null

		delete from productevents where nodeid in (select autoid from leafnode where parentid in 
							(select endautoid from #tmpnodes))
		delete from productevents where nodeid is null

		-- cascade delete leafnode and linked tables via leafnode triggers
		delete from leafnode where parentid in (select endautoid from #tmpnodes)
		delete from leafnode where parentid in (select autoid from branchnode where nodename = 'AVITest')
	
		-- cascade delete branchnode and linked tables via leafnode triggers
		delete from branchnode where autoid in (select endautoid from #tmpnodes) and Type in (6, 3)
		delete from branchnode where autoid in (select autoid from branchnode where nodename = 'AVITest')


	END
	ELSE		/* truncate all except */
			/* BranchNode */
	BEGIN
		-- cascade delete leafnode and linked tables via leafnode triggers
		delete from leafnode where parentid in (select endautoid from #tmpnodes)
		delete from leafnode where parentid in (select autoid from branchnode where nodename = 'AVITest')

	END

	
--	IF @type =1     /* truncate all tables */
--	 BEGIN
--		TRUNCATE TABLE ProductSettings
--		TRUNCATE TABLE ProductProperties
--		TRUNCATE TABLE ComputerProperties
--		TRUNCATE TABLE LeafNode
--		TRUNCATE TABLE Events
--		TRUNCATE TABLE BranchNode
--		TRUNCATE TABLE BranchNodeEnum
--	 END
--	ELSE			/* truncate all except */
--			/* BranchNode & Software & user*/
--	 BEGIN	
--		TRUNCATE TABLE ProductSettings
--		TRUNCATE TABLE ProductProperties
--		TRUNCATE TABLE ComputerProperties
--		TRUNCATE TABLE LeafNode
--		TRUNCATE TABLE Events
--	 END
END  

GO
SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVITEST_Truncate_ProdProp_4leaf]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVITEST_Truncate_ProdProp_4leaf]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVITEST_Truncate_ProdProp_4leaf
(
@NodeName nvarchar (255),
@ProdCode nvarchar(50)
)
AS
BEGIN

      DECLARE @ParentID int

      SELECT @ParentID = AutoID 
                           FROM LeafNode 
                           WHERE NodeName = @NodeName

	IF @ProdCode IS NOT NULL
		DELETE ProductProperties 
			WHERE ParentID = @ParentID
				AND ProductCode = @ProdCode
	ELSE
		DELETE ProductProperties 
			WHERE ParentID = @ParentID
END  

GO
SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVITEST_Truncate_Events_4leaf]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVITEST_Truncate_Events_4leaf]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVITEST_Truncate_Events_4leaf
(
@NodeName nvarchar (255),
@ProdID int
)
AS
BEGIN

	DECLARE @AgentGUID uniqueidentifier
	
	/* delete current entries if exists */
      SELECT @AgentGUID = AgentGUID 
                           FROM LeafNode 
                           WHERE NodeName = @NodeName	

	IF @ProdID > 0
		DELETE Events
			WHERE AgentGUID = @AgentGUID
				AND ProductID = @ProdID
	ELSE
		DELETE Events 
			WHERE AgentGuid = @AgentGUID
END  

GO
SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVITEST_insert_branchnode]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVITEST_insert_branchnode]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVITEST_insert_branchnode
(
@NodeName nvarchar (255),
@ParentNodeName nvarchar (255),
@Type int,
@WriteAccessMask int
)
AS  
	/* Copyright  1995-2000 Networks Associates Technology, Inc. All Rights Reserved.*/

/* type=4 root, 6 site, 3 group */

BEGIN

      DECLARE @ParentID int

      DELETE BranchNode where NodeName = @NodeName

	SET @ParentID = 0
      IF @type =7
          SET @ParentID = 0
      ELSE
       BEGIN
            SELECT @ParentID = AutoID 
                           FROM BranchNode 
                           WHERE NodeName = @ParentNodeName 
       END
 
	INSERT INTO BranchNode
      (
		NodeName,
		Type,
		ParentID,
		PolicyTimestamp,
		TheTimestamp,
		TheHiddenTimestamp,
		TaskTimestamp
      )
      Values
      (
		@NodeName,
		@Type,
		@ParentID,
		NULL,
		NULL, NULL, NULL
      )

	RETURN
END

GO
SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVITEST_addProdProp]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVITEST_addProdProp]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVITEST_addProdProp
(
@NodeName nvarchar(255),
@ProdCode nvarchar(50),
@ProdVer nvarchar(50),
@EngVer int,
@EngineVer nvarchar(100),
@DATVer nvarchar(50),
@Language nvarchar(50),
@ExtraDat nvarchar(100) ='',
@ServicePack nvarchar(50) = '',
@Hotfix nvarchar(50) = '',
@LicenceType nvarchar(50) = '',
@ExpirationDate nvarchar(20) = '',
@AddPolicy nvarchar(50) = '',      -- AddCompPolicy | AddBranchPolicy
@BFDat nvarchar(20) = ''	  -- add buffer overflow dat version
)
AS
BEGIN

      DECLARE @ParentID int
--	DECLARE @ProdVer varchar(50)

--	Set @ProdVer = '1.0'

	IF @ProdCode IS NULL
		return
	IF @NodeName IS NULL
		return

      SELECT @ParentID = AutoID 
                           FROM LeafNode 
                           WHERE NodeName = @NodeName 


      IF @ProdCode IS NULL
		return
      
		INSERT INTO ProductProperties
		(
			ParentID,
			ProductCode,
			ProductSerialNum, 
		      InstalledPath,
		      EngineVer,
		      DATver,
			DATDate,
			Language,
			ProductVersion,
			ExtraDatNames,
			ServicePack,
			Hotfix,
			LicenseStatus,
			ExpirationDate

		)
		values
		(
			@ParentID ,
			@ProdCode ,
			NULL, 	
        		'C:\Program Files\' + @ProdCode,
        		@EngineVer,
        		@DATVer,
			NULL,
			@Language, 
			@ProdVer,
			@ExtraDat,
			@ServicePack,
			@Hotfix,
			@LicenceType,
			@ExpirationDate

		)

	Declare @PPAutoID int
       SELECT @PPAutoID = max(AutoID) 
                           FROM ProductProperties 

	-- get computerproperty values
	declare @agentguid nvarchar(50)
	declare @hostname nvarchar(50)
	declare @ipaddr nvarchar(50)
	declare @username nvarchar(50)

	select
		@agentguid = agentguid
		,@hostname = computername
		,@ipaddr= ipaddress
		,@username= username
	from computerproperties, leafnode
	where
		leafnode.autoid = computerproperties.parentid
		and leafnode.nodename=@nodename

--Task
--OnDemand
--Automatic

	-- Enter ProductEvent records to build an update history
      IF @EngineVer > '4.1.10' 
      BEGIN
		insert into ProductEvents
		(eventdatetime, eventlocaldatetime, agentguid, Productcode, agentversion,
		hostname, hostipaddress, username,
		type, version, error, sitename, initiatorid, initiatortype,NodeID)
		values ('7/1/2002','7/1/2002',@agentguid,@prodcode,'3.0.111',@hostname,@ipaddr,@username,
		'Engine','4.1.10',0,'UpdateServer1',@prodcode,'Task',@ParentID )
	END
      IF @EngineVer > '4.1.20' 
      BEGIN
		insert into ProductEvents
		(eventdatetime, eventlocaldatetime, agentguid, Productcode, agentversion,
		hostname, hostipaddress, username,
		type, version, error, sitename, initiatorid, initiatortype,NodeID)
		values ('8/1/2002','8/1/2002',@agentguid,@prodcode,'3.0.111',@hostname,@ipaddr,@username,
		'Engine','4.1.20',0,'UpdateServer2',@prodcode,'OnDemand',@ParentID)
	END
      IF @EngineVer > '4.1.30' 
      BEGIN
		insert into ProductEvents
		(eventdatetime, eventlocaldatetime, agentguid, Productcode, agentversion,
		hostname, hostipaddress, username,
		type, version, error, sitename, initiatorid, initiatortype,NodeID)
		values ('9/1/2002','9/1/2002',@agentguid,@prodcode,'3.0.111',@hostname,@ipaddr,@username,
		'Engine','4.1.30',0,'UpdateServer3',@prodcode,'Automatic',@ParentID)
	END
      IF @DatVer > '4.1.4130' 
      BEGIN
		insert into ProductEvents
		(eventdatetime, eventlocaldatetime, agentguid, Productcode, agentversion,
		hostname, hostipaddress, username,
		type, version, error, sitename, initiatorid, initiatortype,NodeID)
		values ('5/1/2002','5/1/2002',@agentguid,@prodcode,'3.0.111',@hostname,@ipaddr,@username,
		'DAT','4.1.4130',0,'UpdateServer1',@prodcode,'Automatic',@ParentID)
	END
      IF @DatVer > '4.1.4131' 
      BEGIN
		insert into ProductEvents
		(eventdatetime, eventlocaldatetime, agentguid, Productcode, agentversion,
		hostname, hostipaddress, username,
		type, version, error, sitename, initiatorid, initiatortype,NodeID)
		values ('6/1/2002','6/1/2002',@agentguid,@prodcode,'3.0.111',@hostname,@ipaddr,@username,
		'DAT','4.1.4131',0,'UpdateServer2',@prodcode,'Task',@ParentID)
	END
      IF @DatVer > '4.1.4132' 
      BEGIN
		insert into ProductEvents
		(eventdatetime, eventlocaldatetime, agentguid, Productcode, agentversion,
		hostname, hostipaddress, username,
		type, version, error, sitename, initiatorid, initiatortype,NodeID)
		values ('7/1/2002','7/1/2002',@agentguid,@prodcode,'3.0.111',@hostname,@ipaddr,@username,
		'DAT','4.1.4132',0,'UpdateServer3',@prodcode,'OnDemand',@ParentID)
	END
      IF @DatVer > '4.1.4133' 
      BEGIN
		insert into ProductEvents
		(eventdatetime, eventlocaldatetime, agentguid, Productcode, agentversion,
		hostname, hostipaddress, username,
		type, version, error, sitename, initiatorid, initiatortype,NodeID)
		values ('8/1/2002','8/1/2002',@agentguid,@prodcode,'3.0.111',@hostname,@ipaddr,@username,
		'DAT','4.1.4133',0,'UpdateServer1',@prodcode,'Task',@ParentID)
	END
      IF @DatVer > '4.1.4134' 
      BEGIN
		insert into ProductEvents
		(eventdatetime, eventlocaldatetime, agentguid, Productcode, agentversion,
		hostname, hostipaddress, username,
		type, version, error, sitename, initiatorid, initiatortype,NodeID)
		values ('9/1/2002','9/1/2002',@agentguid,@prodcode,'3.0.111',@hostname,@ipaddr,@username,
		'DAT','4.1.4134',0,'UpdateServer2',@prodcode,'Automatic',@ParentID)
	END
      IF @ProdVer > '4.5.0' 
      BEGIN
		insert into ProductEvents
		(eventdatetime, eventlocaldatetime, agentguid, Productcode, agentversion,
		hostname, hostipaddress, username,
		type, version, error, sitename, initiatorid, initiatortype,NodeID)
		values ('9/1/2002','9/1/2002',@agentguid,@prodcode,'3.0.111',@hostname,@ipaddr,@username,
		'Install','4.5.1',0,'UpdateServer2',@prodcode,'Automatic',@ParentID)
	END
      IF @Servicepack > '' 
      BEGIN
		insert into ProductEvents
		(eventdatetime, eventlocaldatetime, agentguid, Productcode, agentversion,
		hostname, hostipaddress, username,
		type, version, error, sitename, initiatorid, initiatortype,NodeID)
		values ('9/1/2002','9/1/2002',@agentguid,@prodcode,'3.0.111',@hostname,@ipaddr,@username,
		'Servicepack','SP1',0,'UpdateServer2',@prodcode,'Automatic',@ParentID)
	END
      IF @Hotfix > '' 
      BEGIN
		insert into ProductEvents
		(eventdatetime, eventlocaldatetime, agentguid, Productcode, agentversion,
		hostname, hostipaddress, username,
		type, version, error, sitename, initiatorid, initiatortype,NodeID)
		values ('9/1/2002','9/1/2002',@agentguid,@prodcode,'3.0.111',@hostname,@ipaddr,@username,
		'Hotfix','HF1',0,'UpdateServer1',@prodcode,'Automatic',@ParentID)
	END
      IF @Extradat > '' 
      BEGIN
		insert into ProductEvents
		(eventdatetime, eventlocaldatetime, agentguid, Productcode, agentversion,
		hostname, hostipaddress, username,
		type, version, error, sitename, initiatorid, initiatortype,NodeID)
		values ('9/1/2002','9/1/2002',@agentguid,@prodcode,'3.0.111',@hostname,@ipaddr,@username,
		'Extradat','Extrastuff',0,'UpdateServer2',@prodcode,'Task',@ParentID)
	END

	-- load some fake product settings
	insert into ProductSettings
		(ParentID, SectionName, SettingName, Value)
		values (@PPAutoID,'General','Product Version', @ProdVer)
	insert into ProductSettings
		(ParentID, SectionName, SettingName, Value)
		values (@PPAutoID,'General','Product Code', @ProdCode)
	insert into ProductSettings
		(ParentID, SectionName, SettingName, Value)
		values (@PPAutoID,'General','Engine Version', @EngineVer)
	insert into ProductSettings
		(ParentID, SectionName, SettingName, Value)
		values (@PPAutoID,'General','DAT Version', @DATVer)
	insert into ProductSettings
		(ParentID, SectionName, SettingName, Value)
		values (@PPAutoID,'General','Language', @Language)
	insert into ProductSettings
		(ParentID, SectionName, SettingName, Value)
		values (@PPAutoID,'General','Installed Path', @ProdCode + '/0409')
	insert into ProductSettings
		(ParentID, SectionName, SettingName, Value)
		values (@PPAutoID,'General','ExtraDAT', @ExtraDat)
	insert into ProductSettings
		(ParentID, SectionName, SettingName, Value)
		values (@PPAutoID,'General','Service Pack', @ServicePack)
	insert into ProductSettings
		(ParentID, SectionName, SettingName, Value)
		values (@PPAutoID,'General','HotFix', @Hotfix)
	-- add buffer overflow dat
	if @BFDat > ''
	insert into ProductSettings
		(ParentID, SectionName, SettingName, Value)
		values (@PPAutoID,'General','szBufferOverflowDAT', @BFDat)


	-- If add policy input is set add some fake policy entries
	if @AddPolicy > ''
	begin
		declare @lid int
		declare @bid int
		declare @BranchName varchar(50)
		declare @type int
		declare @pid int
		select @lid=leafnode.autoid, @bid=Branchnode.autoid, @BranchName=BranchNode.Nodename, @type=Branchnode.type
			from leafnode, branchnode  where leafnode.parentid=branchnode.autoid and leafnode.nodename=@NodeName
		if @AddPolicy > 'AddBranchPolicy'
		begin
			-- add branchnode fake policy if one doesnt already exist
			if not exists (select * from policy where parentid=@bid and parenttype != 1 and productcode=@ProdCode)
			begin
				insert policy (ParentID, ParentType, ProductCode) values (@bid, @type, @ProdCode)
				select @pid=autoid from policy where parentid=@bid and ParentType != 1 and Productcode = @ProdCode
				insert policysettings (ParentID, SectionName, SettingName, Value)
					values(@pid, 'FakeBranchSection', 'FakeSetting', 'Yes')
				insert policysettings (ParentID, SectionName, SettingName, Value)
					values(@pid, 'FakeBranchSection', 'FakeSetting2', 'No')
				-- scp policy needed for reports
				insert policysettings (ParentID, SectionName, SettingName, Value)
					values(@pid, 'FakeBranchSection', 'LastModified', getdate())
			end
		end
		else if @AddPolicy > '' -- add computer policy
		begin
			if not exists (select * from policy where parentid=@lid and parenttype = 1 and productcode=@ProdCode)
			begin
				insert policy (ParentID, ParentType, ProductCode) values (@lid, 1, @ProdCode)
				select @pid=autoid from policy where parentid=@lid and ParentType = 1 and productcode=@ProdCode
				insert policysettings (ParentID, SectionName, SettingName, Value)
					values(@pid, 'FakeCompSection', 'FakeSetting', 'Yes')
				insert policysettings (ParentID, SectionName, SettingName, Value)
					values(@pid, 'FakeCompSection', 'FakeSetting2', 'No')
				-- scp policy needed for reports
				insert policysettings (ParentID, SectionName, SettingName, Value)
					values(@pid, 'FakeCompSection', 'LastModified', getdate())
			end
		end		
	end
	--		-- AddCompPolicy | AddBranchPolicy

END


GO
SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVITEST_delProdProp]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVITEST_delProdProp]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVITEST_delProdProp
(
@NodeName nvarchar(255),
@ProdCode nvarchar(50)
)
AS
BEGIN

      Delete ProductProperties
	from leafnode
	where productcode = @ProdCode 
		and leafnode.autoid = productproperties.parentid
		and nodename = @NodeName

END
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVITEST_addEvent]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVITEST_addEvent]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVITEST_addEvent
(
@NodeName nvarchar(255),
@ProdName nvarchar(50),
@EngVer int,
@EngineVer nvarchar(16),
@DATVer nvarchar(16),
@VirusDef int,
@VirusName nvarchar(128),
@TVDEventID int,
@FileName nvarchar (512),
@ActionTaken int,
@TVDSeverity int,
@VirusType nvarchar(128),
@MinusDays int,
@Date datetime = '',
@ProdVer nvarchar(50) = '',
@User nvarchar(50) = '',
@Computer nvarchar(50) = '',
@lVirusType	int =0,
@Source	nvarchar(255) = '',
@DetectionName	nvarchar(128) = '',
@ProcessName	nvarchar(128) = '',
@ModuleName	nvarchar(128) = '',
@APIName	nvarchar(128) = ''
)
AS
BEGIN

      DECLARE @ParentID int
	DECLARE @AgentGUID uniqueidentifier
	DECLARE @EventDate	DateTime

	
	/* delete current entries if exists */

      SELECT @ParentID = AutoID 
                           FROM LeafNode 
                           WHERE NodeName = @NodeName	
      SELECT @AgentGUID = AgentGUID 
                           FROM LeafNode 
                           WHERE NodeName = @NodeName	

	IF @NodeName IS NULL
		return

	-- Used fixed or relative date
	IF @date > '' 
		set @EventDate = @Date
	else
		Set @EventDate = GETDATE() - @MinusDays

	IF @ProdVer = '' or @ProdVer is null
		set @ProdVer = '4.5.1'

	IF @ProdName = '' or @ProdName is null
		set @ProdName = 'Viruscan'

	IF @User = '' or @User is null
		Set @User = 'Comp_' + @NodeName

	IF @Computer = '' or @Computer is null
		Set @Computer = 'User' + @NodeName


      
		INSERT INTO Events
		(
			Counter,
			EventDateTime,
			ProductName,
			ProductVersion,
			HostName,
			HostIPAddress,
			UserName,
			VirusName,
			TVDEventID,
			FileName,
			EngineVersion,
			DATVersion,
			ScanTime,
			ActionTaken,
			TVDSeverity,
			VirusType,
			TVDTaskName,
			ProductID,
			AgentGUID,
			NodeID,
			EventLocalDateTime,
			TheTimestamp,
			TheHiddenTimestamp,
			-- new vs fields
			lVirusType,	
			Source,	
			DetectionName,
			ProcessName,	
			ModuleName,	
			APIName
		)
		values
		(
			NULL ,
			@EventDate ,
			@ProdName,
			@ProdVer,
			@Computer,
			'172.16.39.221',
			@User,
			@VirusName,
			@TVDEventID,
			@FileName,
			@EngineVer,
			@DATVer,
			NULL ,
			@ActionTaken,
			@TVDSeverity,
			@VirusType,
			NULL,
			0,
			@AgentGUID,
			@ParentID,
			dateadd(hour, 3, @EventDate) ,
			NULL , NULL,
			@lVirusType,
			@Source,
			@DetectionName,
			@ProcessName,
			@ModuleName,
			@APIName
		)

END
GO



if exists (select * from sysobjects where id = object_id(N'[dbo].[AVITEST_addBufferOverflow]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVITEST_addBufferOverflow]
GO

CREATE PROCEDURE dbo.AVITEST_addBufferOverflow
(
@NodeName nvarchar(255),
@VirusName nvarchar(128),
@VirusType nvarchar(128),
@ProcessName nvarchar(128),
@ModuleName nvarchar(128),
@APIName nvarchar(128),
@TVDEventID int,
@TVDSeverity int,
@ProdName nvarchar(50),
@EngineVer nvarchar(16),
@DATVer nvarchar(16),
@MinusDays int,
@Date datetime = '',
@ProdVer nvarchar(50) = '',
@User nvarchar(50) = '',
@Computer nvarchar(50) = ''
)
AS
BEGIN

      DECLARE @ParentID int
	DECLARE @AgentGUID uniqueidentifier
	DECLARE @EventDate	DateTime

	
	-- set some defaults
	Declare @ActionTaken int
	Set @ActionTaken = @TVDEventID

	Declare @FileName nvarchar (512)
	Set @FileName = ''
	Declare @Source nvarchar (255)
	Set @Source = ''

	/* delete current entries if exists */

      SELECT @ParentID = AutoID 
                           FROM LeafNode 
                           WHERE NodeName = @NodeName	
      SELECT @AgentGUID = AgentGUID 
                           FROM LeafNode 
                           WHERE NodeName = @NodeName	

	IF @NodeName IS NULL
		return

	-- Used fixed or relative date
	IF @date > '' 
		set @EventDate = @Date
	else
		Set @EventDate = GETDATE() - @MinusDays

	IF @ProdVer = '' or @ProdVer is null
		set @ProdVer = '4.5.1'

	IF @ProdName = '' or @ProdName is null
		set @ProdName = 'Viruscan'

	IF @User = '' or @User is null
		Set @User = 'Comp_' + @NodeName

	IF @Computer = '' or @Computer is null
		Set @Computer = 'User' + @NodeName

      
		INSERT INTO Events
		(
			Counter,
			EventDateTime,
			ProductName,
			ProductVersion,
			HostName,
			HostIPAddress,
			UserName,
			DetectionName,
			TVDEventID,
			FileName,
			EngineVersion,
			DATVersion,
			ScanTime,
			ActionTaken,
			TVDSeverity,
			VirusType,
			TVDTaskName,
			ProductID,
			AgentGUID,
			NodeID,
			EventLocalDateTime,
			TheTimestamp,
			TheHiddenTimestamp,
			ProcessName ,
			ModuleName ,
			APIName 
		)
		values
		(
			NULL ,
			@EventDate ,
			@ProdName,
			@ProdVer,
			@Computer,
			'172.16.39.221',
			@User,
			@VirusName,
			@TVDEventID,
			@FileName,
			@EngineVer,
			@DATVer,
			NULL ,
			@ActionTaken,
			@TVDSeverity,
			@VirusType,
			NULL,
			0,
			@AgentGUID,
			@ParentID,
			@EventDate ,
			NULL , NULL,
			@ProcessName ,
			@ModuleName ,
			@APIName 
		)

END
GO


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVITEST_addVirusSource]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVITEST_addVirusSource]
GO

CREATE PROCEDURE dbo.AVITEST_addVirusSource
(
@NodeName nvarchar(255),
@VirusName nvarchar(128),
@VirusType nvarchar(128),
@FileName nvarchar (512),
@ActionTaken int,
@Source nvarchar (255),
@TVDEventID int,
@TVDSeverity int,
@ProdName nvarchar(50),
@EngineVer nvarchar(16),
@DATVer nvarchar(16),
@MinusDays int,
@Date datetime = '',
@ProdVer nvarchar(50) = '',
@User nvarchar(50) = '',
@Computer nvarchar(50) = ''
)
AS
BEGIN

      DECLARE @ParentID int
	DECLARE @AgentGUID uniqueidentifier
	DECLARE @EventDate	DateTime

	
	/* delete current entries if exists */

      SELECT @ParentID = AutoID 
                           FROM LeafNode 
                           WHERE NodeName = @NodeName	
      SELECT @AgentGUID = AgentGUID 
                           FROM LeafNode 
                           WHERE NodeName = @NodeName	

	IF @NodeName IS NULL
		return

	-- Used fixed or relative date
	IF @date > '' 
		set @EventDate = @Date
	else
		Set @EventDate = GETDATE() - @MinusDays

	IF @ProdVer = '' or @ProdVer is null
		set @ProdVer = '4.5.1'

	IF @ProdName = '' or @ProdName is null
		set @ProdName = 'Viruscan'

	IF @User = '' or @User is null
		Set @User = 'Comp_' + @NodeName

	IF @Computer = '' or @Computer is null
		Set @Computer = 'User' + @NodeName

      
		INSERT INTO Events
		(
			Counter,
			EventDateTime,
			ProductName,
			ProductVersion,
			HostName,
			HostIPAddress,
			UserName,
			VirusName,
			TVDEventID,
			FileName,
			EngineVersion,
			DATVersion,
			ScanTime,
			ActionTaken,
			TVDSeverity,
			VirusType,
			TVDTaskName,
			ProductID,
			AgentGUID,
			NodeID,
			EventLocalDateTime,
			TheTimestamp,
			TheHiddenTimestamp,
			Source
		)
		values
		(
			NULL ,
			@EventDate ,
			@ProdName,
			@ProdVer,
			@Computer,
			'172.16.39.221',
			@User,
			@VirusName,
			@TVDEventID,
			@FileName,
			@EngineVer,
			@DATVer,
			NULL ,
			@ActionTaken,
			@TVDSeverity,
			@VirusType,
			NULL,
			0,
			@AgentGUID,
			@ParentID,
			@EventDate ,
			NULL , NULL
			,@Source
		)

END
GO


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVITEST_addEvents_VSEBehaviourBlock]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVITEST_addEvents_VSEBehaviourBlock]
GO

CREATE PROCEDURE dbo.AVITEST_addEvents_VSEBehaviourBlock
(
@NodeName nvarchar(255),
@RuleName nvarchar(128) = '',
@ProcessName nvarchar(128) = '',
@ActionsBlocked int,
@Source nvarchar(128) = '',
@FileName nvarchar(128) = '',
@Count int,
@User nvarchar(128) = '',
@Computer nvarchar(128) = '',
@ProdName nvarchar(128) = '',
@ProdVer nvarchar(128) = '',
@TVDEventID nvarchar(128) = '',
@MinusDays int,
@Date nvarchar(128) = ''
)
AS
BEGIN

      DECLARE @ParentID int
	DECLARE @AgentGUID uniqueidentifier
	DECLARE @EventDate	DateTime

	
	/* delete current entries if exists */

      SELECT @ParentID = AutoID 
                           FROM LeafNode 
                           WHERE NodeName = @NodeName	
      SELECT @AgentGUID = AgentGUID 
                           FROM LeafNode 
                           WHERE NodeName = @NodeName	

	IF @NodeName IS NULL
		return

	-- Used fixed or relative date
	IF @date > '' 
		set @EventDate = @Date
	else
		Set @EventDate = GETDATE() - @MinusDays

	IF @ProdVer = '' or @ProdVer is null
		set @ProdVer = '8.0'

	IF @ProdName = '' or @ProdName is null
		set @ProdName = 'Viruscan'

	IF @User = '' or @User is null
		Set @User = 'Comp_' + @NodeName

	IF @Computer = '' or @Computer is null
		Set @Computer = 'User' + @NodeName

      
		INSERT INTO dbo.Events_VSEBehaviourBlock
		(
			AgentGUID,
			UserName,
			HostName,
			HostIPAddress,
			ProductName,	
			ProductVersion,
			TVDTaskName,
			TVDEventID,
			EventLocalDateTime,
			EventDateTime,
			Count,
			RuleName,
			ProcessName,
			ActionsBlocked,
			Source,
			FileName
		)
		values
		(
			@AgentGUID ,
			@User,
			@Computer,
			'172.16.39.221',
			@ProdName,
			@ProdVer,
			'Task1',
			@TVDEventID,
			@EventDate,
			@EventDate,
			@Count,
			@RuleName,
			@ProcessName,
			@ActionsBlocked,
			@Source,
			@FileName


		)

END
GO


-- add this only if table exists
--begin

if not exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Events_ContentFilter]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
begin
CREATE TABLE [dbo].[Events_ContentFilter] (
	[AutoID] [int] IDENTITY (1, 1) NOT NULL ,
	[Counter] [int] NULL ,
	[EventDateTime] [datetime] NULL ,
	[ProductName] [nvarchar] (64) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[ProductVersion] [nvarchar] (16) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[HostName] [nvarchar] (512) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[HostIPAddress] [nvarchar] (16) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[UserName] [nvarchar] (32) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[VirusName] [nvarchar] (128) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[TVDEventID] [int] NULL ,
	[FileName] [nvarchar] (512) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[EngineVersion] [nvarchar] (16) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[DATVersion] [nvarchar] (16) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[ScanTime] [datetime] NULL ,
	[ActionTaken] [smallint] NULL ,
	[TVDSeverity] [int] NULL ,
	[VirusType] [nvarchar] (128) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[TVDTaskName] [nvarchar] (128) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[ProductID] [int] NULL ,
	[AgentGUID] [uniqueidentifier] NULL ,
	[NodeID] [int] NULL ,
	[EventLocalDateTime] [datetime] NULL ,
	[TheTimestamp] [binary] (8) NULL ,
	[TheHiddenTimestamp] [timestamp] NULL ,
	[lVirusType] [int] NULL ,
	[Source] [nvarchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[DetectionName] [nvarchar] (128) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[ProcessName] [nvarchar] (128) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[ModuleName] [nvarchar] (128) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[APIName] [nvarchar] (128) COLLATE SQL_Latin1_General_CP1_CI_AS NULL 
) ON [PRIMARY]
end
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVITEST_addEventContentFilter]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVITEST_addEventContentFilter]
GO

CREATE PROCEDURE dbo.AVITEST_addEventContentFilter
(
@NodeName nvarchar(255),
@ProdName nvarchar(50),
@EngVer int,
@EngineVer nvarchar(16),
@DATVer nvarchar(16),
@VirusDef int,
@VirusName nvarchar(128),
@TVDEventID int,
@FileName nvarchar (512),
@ActionTaken int,
@TVDSeverity int,
@VirusType nvarchar(128),
@MinusDays int,
@Date datetime = '',
@ProdVer nvarchar(50) = '',
@User nvarchar(50) = '',
@Computer nvarchar(50) = ''
)
AS
BEGIN

      DECLARE @ParentID int
	DECLARE @AgentGUID uniqueidentifier
	DECLARE @EventDate	DateTime

	
	/* delete current entries if exists */

      SELECT @ParentID = AutoID 
                           FROM LeafNode 
                           WHERE NodeName = @NodeName	
      SELECT @AgentGUID = AgentGUID 
                           FROM LeafNode 
                           WHERE NodeName = @NodeName	

	IF @NodeName IS NULL
		return

	-- Used fixed or relative date
	IF @date > '' 
		set @EventDate = @Date
	else
		Set @EventDate = GETDATE() - @MinusDays

	IF @ProdVer = '' or @ProdVer is null
		set @ProdVer = '4.5.1'

	IF @ProdName = '' or @ProdName is null
		set @ProdName = 'Viruscan'

	IF @User = '' or @User is null
		Set @User = 'Comp_' + @NodeName

	IF @Computer = '' or @Computer is null
		Set @Computer = 'User' + @NodeName

      
		INSERT INTO Events_ContentFilter
		(
			Counter,
			EventDateTime,
			ProductName,
			ProductVersion,
			HostName,
			HostIPAddress,
			UserName,
			VirusName,
			TVDEventID,
			FileName,
			EngineVersion,
			DATVersion,
			ScanTime,
			ActionTaken,
			TVDSeverity,
			VirusType,
			TVDTaskName,
			ProductID,
			AgentGUID,
			NodeID,
			EventLocalDateTime,
			TheTimestamp,
			TheHiddenTimestamp
		)
		values
		(
			NULL ,
			@EventDate ,
			@ProdName,
			@ProdVer,
			@Computer,
			'172.16.39.221',
			@User,
			@VirusName,
			@TVDEventID,
			@FileName,
			@EngineVer,
			@DATVer,
			NULL ,
			@ActionTaken,
			@TVDSeverity,
			@VirusType,
			NULL,
			0,
			@AgentGUID,
			@ParentID,
			dateadd(hour, 3, @EventDate) ,
			NULL , NULL
		)

END
GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Events_Spam]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[Events_Spam]
GO

CREATE TABLE [dbo].[Events_Spam] (
	[AutoID] [int] IDENTITY (1, 1) NOT NULL ,
	[HostName] [nvarchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[AgentGUID] [uniqueidentifier] NULL ,
	[HostIPAddress] [nvarchar] (16) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[OSName] [nvarchar] (32) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[OSType] [nvarchar] (32) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[OSVersion] [nvarchar] (32) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[DomainName] [nvarchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[UserName] [nvarchar] (32) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[ProductName] [nvarchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[ProductVersion] [int] NULL ,
	[ProductFamily] [nvarchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[ProductID] [int] NULL ,
	[SpamEngineVersion] [nvarchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[SpamRuleSetVersion] [nvarchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[TVDEventID] [int] NULL ,
	[EventDateTime] [datetime] NULL ,
	[TVDSeverity] [int] NULL ,
	[SpamRulesBroken] [nvarchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[SpamScore] [nvarchar] (64) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[SpamRecipients] [nvarchar] (255) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[MessageSize] [nvarchar] (64) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[SourceIPAddress] [nvarchar] (128) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[NodeID] [int] NULL ,
	[EventLocalDateTime] [datetime] NULL 
) ON [PRIMARY]
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVITEST_addEventSpam]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVITEST_addEventSpam]
GO

CREATE PROCEDURE dbo.AVITEST_addEventSpam
(
@NodeName nvarchar(255),
@ProdName nvarchar(50),
@EngineVer nvarchar(16),
@DATVer nvarchar(16),
@TVDEventID int,
@TVDSeverity int,
@MinusDays int,
@Date datetime = '',
@User nvarchar(50) = '',
@Computer nvarchar(50) = ''
,@SpamRulesBroken nvarchar(50) = ''
,@SpamScore nvarchar(50) = ''
,@SpamRecipients nvarchar(50) = ''
,@MessageSize nvarchar(50) = ''
,@SourceIPAddress nvarchar(50) = ''
)
AS
BEGIN



      DECLARE @ParentID int
	DECLARE @AgentGUID uniqueidentifier
	DECLARE @EventDate	DateTime

	
	/* delete current entries if exists */

      SELECT @ParentID = AutoID 
                           FROM LeafNode 
                           WHERE NodeName = @NodeName	
      SELECT @AgentGUID = AgentGUID 
                           FROM LeafNode 
                           WHERE NodeName = @NodeName	

	IF @NodeName IS NULL
		return

	-- Used fixed or relative date
	IF @date > '' 
		set @EventDate = @Date
	else
		Set @EventDate = GETDATE() - @MinusDays

	IF @ProdName = '' or @ProdName is null
		set @ProdName = 'Webshield'

	IF @User = '' or @User is null
		Set @User = 'Comp_' + @NodeName

	IF @Computer = '' or @Computer is null
		Set @Computer = 'User' + @NodeName

      
	INSERT INTO Events_Spam
	(
	[HostName] ,
	[AgentGUID] ,
	[HostIPAddress] ,
	[OSName] ,
	[OSType] ,
	[OSVersion] ,
	[DomainName] ,
	[UserName] ,
	[ProductName] ,
	[ProductFamily] ,
	[SpamEngineVersion] ,
	[SpamRuleSetVersion] ,
	[TVDEventID] ,
	[EventDateTime] ,
	[TVDSeverity] ,
	[SpamRulesBroken] ,
	[SpamScore] ,
	[SpamRecipients] ,
	[MessageSize] ,
	[SourceIPAddress] ,
	[NodeID] ,
	[EventLocalDateTime] 
	)
	values
	(
	@NodeName ,
	@AgentGUID ,
	'172.16.39.221' ,
	'windows' ,
	'server' ,
	'2000' ,
	'MyDomain' ,
	'MyUser' ,
	@ProdName ,
	'TVD' ,
	@EngineVer ,
	@DATVer ,
	@TVDEventID ,
	@EventDate ,
	@TVDSeverity ,
	@SpamRulesBroken ,
	@SpamScore ,
	@SpamRecipients ,
	@MessageSize ,
	@SourceIPAddress ,
	@ParentID ,
	dateadd(hour, 3, @EventDate)
	)

END
GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Events_Statistics]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[Events_Statistics]
GO

CREATE TABLE [dbo].[Events_Statistics] (
	[AutoID] [int] IDENTITY (1, 1) NOT NULL ,
	[HostName] [nvarchar] (512) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[AgentGUID] [uniqueidentifier] NULL ,
	[HostIPAddress] [nvarchar] (16) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[OSName] [nvarchar] (32) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[OSType] [nvarchar] (32) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[OSVersion] [nvarchar] (32) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[DomainName] [nvarchar] (512) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[UserName] [nvarchar] (32) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[ProductName] [nvarchar] (512) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[ProductVersion] [int] NULL ,
	[ProductFamily] [nvarchar] (512) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[ProductID] [int] NULL ,
	[TVDEventID] [int] NULL ,
	[EventDateTime] [datetime] NULL ,
	[TVDSeverity] [int] NULL ,
	[StatisticsCounter] [nvarchar] (512) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[StatisticsValue] [int] NULL ,
	[NodeID] [int] NULL ,
	[EventLocalDateTime] [datetime] NULL 
) ON [PRIMARY]
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVITEST_addEventWebShieldStatistics]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVITEST_addEventWebShieldStatistics]
GO

CREATE PROCEDURE dbo.AVITEST_addEventWebShieldStatistics
(
@NodeName nvarchar(255),
@ProdName nvarchar(50),
@TVDEventID int,
@TVDSeverity int,
@MinusDays int,
@Date datetime = '',
@User nvarchar(50) = '',
@Computer nvarchar(50) = ''
,@StatisticsCounter nvarchar(50) = ''
,@StatisticsValue int = 0
)
AS
BEGIN

      DECLARE @ParentID int
	DECLARE @AgentGUID uniqueidentifier
	DECLARE @EventDate	DateTime
	
      /* delete current entries if exists */
      SELECT @ParentID = AutoID 
                           FROM LeafNode 
                           WHERE NodeName = @NodeName	
      SELECT @AgentGUID = AgentGUID 
                           FROM LeafNode 
                           WHERE NodeName = @NodeName	

	IF @NodeName IS NULL
		return

	-- Used fixed or relative date
	IF @date > '' 
		set @EventDate = @Date
	else
		Set @EventDate = GETDATE() - @MinusDays

	IF @ProdName = '' or @ProdName is null
		set @ProdName = 'Webshield'

	IF @User = '' or @User is null
		Set @User = 'Comp_' + @NodeName

	IF @Computer = '' or @Computer is null
		Set @Computer = 'User' + @NodeName

      
	INSERT INTO Events_Statistics
	(
	HostName,
	AgentGUID,
	HostIPAddress,
	OSName,
	OSType,
	OSVersion,
	DomainName,
	UserName,
	ProductName,
	ProductFamily,
	TVDEventID,
	EventDateTime,
	TVDSeverity,
	StatisticsCounter,
	StatisticsValue,
	NodeID,
	EventLocalDateTime
	)
	values
	(
	@NodeName,
	@AgentGUID,
	'172.16.39.221',
	'windows',
	'server',
	'2000',
	'MyDomain',
	'MyUser',
	@ProdName,
	'TVD',
	@TVDEventID,
	@EventDate,
	@TVDSeverity,
	@StatisticsCounter,
	@StatisticsValue,
	@ParentID,
	dateadd(hour, 3, @EventDate)
	)

END
GO



SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO



if exists (select * from sysobjects where id = object_id(N'[dbo].[AVITEST_addInfections]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVITEST_addInfections]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVITEST_addInfections
(
@VirusName nvarchar(128)
,@VirusType nvarchar(128)
,@NodeName1 nvarchar(255)
,@FileName1 nvarchar(512)
,@ActionTaken1 int
,@Date1 datetime
,@NodeName2 nvarchar(255) = ''
,@FileName2 nvarchar(512) = ''
,@ActionTaken2 int = 0	
,@Date2 datetime = ''
,@NodeName3 nvarchar(255) = ''
,@FileName3 nvarchar(512) = ''
,@ActionTaken3 int = 0	
,@Date3 datetime = ''
,@NodeName4 nvarchar(255) = ''
,@FileName4 nvarchar(512) = ''
,@ActionTaken4 int = 0	
,@Date4 datetime = ''
,@NodeName5 nvarchar(255) = ''
,@FileName5 nvarchar(512) = ''
,@ActionTaken5 int = 0		
,@Date5 datetime = ''
,@EventActionIDMatch int = 0	
)
AS
BEGIN

	DECLARE @TVDEventID int
--	DECLARE @ActionTaken int
	DECLARE @TVDSeverity int


	/* Set defaults */
	--SET @VirusName = 'W32/Ska.exe'
	SET @TVDEventID = 1027
	--SET @FileName = 'c:\downloads\happy99.exe'
	--SET @ActionTaken = 50
	SET @TVDSeverity = 1

	-- get computerproperty values
	declare @agentguid nvarchar(50)
	declare @hostname nvarchar(50)
	declare @ipaddr nvarchar(50)
	declare @username nvarchar(50)
	declare @DatVer nvarchar(50)
	declare @EngineVer nvarchar(50)
	declare @Softwarename nvarchar(50)
	declare @prodver nvarchar(50)
	declare @prodcode nvarchar(50)

	-- check first value
	IF @NodeName1 > ''
	select
		@agentguid = agentguid
		,@hostname = computername
		,@ipaddr= ipaddress
		,@username= username
		,@DatVer= max(EngineVer)
		,@EngineVer= max(DATver)
		,@Softwarename= max(SoftwareName)
		,@prodver= max(ProductVersion)
		,@prodcode= max(productproperties.Productcode)
	from computerproperties, leafnode, productproperties, aviview_software
	where
		leafnode.autoid = computerproperties.parentid
		and leafnode.nodename=@nodename1
		and leafnode.autoid = productproperties.parentid
		and aviview_software.productcode = productproperties.productcode
	group by
		agentguid
		,computername
		,ipaddress
		,username

	Set @Softwarename = 'VirusScan'
	-- If webshield
	IF @prodcode = 'WEBSHLD_1000'
	SET @TVDEventID = 1503
	else
	SET @TVDEventID = 1027

	if @EventActionIDMatch > 0
		set @TVDEventID = @ActionTaken1

	/* Create Events */
	IF @NodeName1 > ''
		EXECUTE AVITEST_addEvent @NodeName1, 
						@Softwarename, 0, @EngineVer, @DATVer, 0, 
						@VirusName, @TVDEventID, 
						@FileName1, @ActionTaken1, @TVDSeverity, @VirusType, 0, @Date1




	IF @NodeName2 > ''
	select
		@agentguid = agentguid
		,@hostname = computername
		,@ipaddr= ipaddress
		,@username= username
		,@DatVer= max(EngineVer)
		,@EngineVer= max(DATver)
--		,@Softwarename= max(SoftwareName)
		,@prodver= max(ProductVersion)
		,@prodcode= max(productproperties.Productcode)
	from computerproperties, leafnode, productproperties, aviview_software
	where
		leafnode.autoid = computerproperties.parentid
		and leafnode.nodename=@nodename2
		and leafnode.autoid = productproperties.parentid
		and aviview_software.productcode = productproperties.productcode
	group by
		agentguid
		,computername
		,ipaddress
		,username

	-- If webshield
	IF @prodcode = 'WEBSHLD_1000'
	SET @TVDEventID = 1503
	else
	SET @TVDEventID = 1027


	if @EventActionIDMatch > 0
		set @TVDEventID = @ActionTaken2

	/* Create Events */
	IF @NodeName2 > ''
		EXECUTE AVITEST_addEvent @NodeName2, 
						@Softwarename, 0, @EngineVer, @DATVer, 0, 
						@VirusName, @TVDEventID, 
						@FileName2, @ActionTaken2, @TVDSeverity, @VirusType, 0, @Date2



	IF @NodeName3 > ''
	select
		@agentguid = agentguid
		,@hostname = computername
		,@ipaddr= ipaddress
		,@username= username
		,@DatVer= max(EngineVer)
		,@EngineVer= max(DATver)
--		,@Softwarename= max(SoftwareName)
		,@prodver= max(ProductVersion)
		,@prodcode= max(productproperties.Productcode)
	from computerproperties, leafnode, productproperties, aviview_software
	where
		leafnode.autoid = computerproperties.parentid
		and leafnode.nodename=@nodename3
		and leafnode.autoid = productproperties.parentid
		and aviview_software.productcode = productproperties.productcode
	group by
		agentguid
		,computername
		,ipaddress
		,username

	-- If webshield
	IF @prodcode = 'WEBSHLD_1000'
	SET @TVDEventID = 1503
	else
	SET @TVDEventID = 1027


	if @EventActionIDMatch > 0
		set @TVDEventID = @ActionTaken3

	/* Create Events */
	IF @NodeName3 > ''
		EXECUTE AVITEST_addEvent @NodeName3, 
						@Softwarename, 0, @EngineVer, @DATVer, 0, 
						@VirusName, @TVDEventID, 
						@FileName3, @ActionTaken3, @TVDSeverity, @VirusType, 0, @Date3



	IF @NodeName4 > ''
	select
		@agentguid = agentguid
		,@hostname = computername
		,@ipaddr= ipaddress
		,@username= username
		,@DatVer= max(EngineVer)
		,@EngineVer= max(DATver)
--		,@Softwarename= max(SoftwareName)
		,@prodver= max(ProductVersion)
		,@prodcode= max(productproperties.Productcode)
	from computerproperties, leafnode, productproperties, aviview_software
	where
		leafnode.autoid = computerproperties.parentid
		and leafnode.nodename=@nodename4
		and leafnode.autoid = productproperties.parentid
		and aviview_software.productcode = productproperties.productcode
	group by
		agentguid
		,computername
		,ipaddress
		,username

	-- If webshield
	IF @prodcode = 'WEBSHLD_1000'
	SET @TVDEventID = 1503
	else
	SET @TVDEventID = 1027


	if @EventActionIDMatch > 0
		set @TVDEventID = @ActionTaken4

	/* Create Events */
	IF @NodeName4 > ''
		EXECUTE AVITEST_addEvent @NodeName4, 
						@Softwarename, 0, @EngineVer, @DATVer, 0, 
						@VirusName, @TVDEventID, 
						@FileName4, @ActionTaken4, @TVDSeverity, @VirusType, 0, @Date4




	IF @NodeName5 > ''
	select
		@agentguid = agentguid
		,@hostname = computername
		,@ipaddr= ipaddress
		,@username= username
		,@DatVer= max(EngineVer)
		,@EngineVer= max(DATver)
--		,@Softwarename= max(SoftwareName)
		,@prodver= max(ProductVersion)
		,@prodcode= max(productproperties.Productcode)
	from computerproperties, leafnode, productproperties, aviview_software
	where
		leafnode.autoid = computerproperties.parentid
		and leafnode.nodename=@nodename5
		and leafnode.autoid = productproperties.parentid
		and aviview_software.productcode = productproperties.productcode
	group by
		agentguid
		,computername
		,ipaddress
		,username

	-- If webshield
	IF @prodcode = 'WEBSHLD_1000'
	SET @TVDEventID = 1503
	else
	SET @TVDEventID = 1027


	if @EventActionIDMatch > 0
		set @TVDEventID = @ActionTaken5

	/* Create Events */
	IF @NodeName5 > ''
		EXECUTE AVITEST_addEvent @NodeName5, 
						@Softwarename, 0, @EngineVer, @DATVer, 0, 
						@VirusName, @TVDEventID, 
						@FileName5, @ActionTaken5, @TVDSeverity, @VirusType, 0, @Date5

END
GO




SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVITEST_addUpdateEvent]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVITEST_addUpdateEvent]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO


--EXECUTE dbo.AVITEST_addUpdateEvent
--@HostName, @autoid
--,@Type5,@Version5,@ErrorID5,@Date5,@AgentVer5,@ProductCode5,@SiteName5,@InitiatorID5,@InitiatorType5


CREATE PROCEDURE dbo.AVITEST_addUpdateEvent
(
@HostName nvarchar(128)
,@autoid int
,@Type nvarchar(64)
,@Version nvarchar(64)
,@ErrorID int
,@Date datetime
,@AgentVer nvarchar(64)
,@ProductCode nvarchar(64)
,@SiteName nvarchar(64)
,@InitiatorID nvarchar(64)
,@InitiatorType nvarchar(64)
)
AS
BEGIN

      DECLARE @ParentID int
	DECLARE @AgentGUID uniqueidentifier
	DECLARE @EventDate	DateTime

	

      SELECT @ParentID = AutoID 
                           FROM LeafNode 
                           WHERE NodeName = @HostName	
      SELECT @AgentGUID = AgentGUID 
                           FROM LeafNode 
                           WHERE NodeName = @HostName	

	IF @HostName IS NULL
		return

	-- Used fixed or relative date
	DECLARE @MinusDays	DateTime
	IF @Date > ''
		set @EventDate = @Date
	else
		Set @EventDate = GETDATE() - @MinusDays

--	IF @ProdVer = ''
--		set @ProdVer = '4.5.1'

INSERT INTO ProductEvents
                      (EventDateTime, EventLocalDateTime, HostName, Nodeid, ProductName, ProductVersion, AgentVersion, ProductCode
			, Type, Version, Error, Locale 
                      	, SiteName, InitiatorID, InitiatorType)
VALUES     (@date, @date, @HostName, @autoid, '', '', @AgentVer, @ProductCode
			, @Type, @Version, @ErrorID, '0409 '
			, @Sitename, @InitiatorID, @INitiatorType)


END
GO



if exists (select * from sysobjects where id = object_id(N'[dbo].[AVITEST_addUpdateEvents]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVITEST_addUpdateEvents]
GO

-- EXECUTE dbo.AVITEST_addUpdateEvents HostName, 
--	Type, Version, ErrorID, EventDateTime, AgentVersion, ProductCode, SiteName, InitiatorID, InitiatorType
--	Above fields can repeat up to 5 times

CREATE PROCEDURE dbo.AVITEST_addUpdateEvents
(
@HostName nvarchar(128)
,@Type1 nvarchar(64)
,@Version1 nvarchar(64)
,@ErrorID1 int
,@Date1 datetime
,@AgentVer1 nvarchar(64)
,@ProductCode1 nvarchar(64)
,@SiteName1 nvarchar(64)
,@InitiatorID1 nvarchar(64)
,@InitiatorType1 nvarchar(64)
,@Type2 nvarchar(64)
,@Version2 nvarchar(64)
,@ErrorID2 nvarchar(64)
,@Date2 nvarchar(64)
,@AgentVer2 nvarchar(64)
,@ProductCode2 nvarchar(64)
,@SiteName2 nvarchar(64)
,@InitiatorID2 nvarchar(64)
,@InitiatorType2 nvarchar(64)
,@Type3 nvarchar(64)
,@Version3 nvarchar(64)
,@ErrorID3 int
,@Date3 datetime
,@AgentVer3 nvarchar(64)
,@ProductCode3 nvarchar(64)
,@SiteName3 nvarchar(64)
,@InitiatorID3 nvarchar(64)
,@InitiatorType3 nvarchar(64)
,@Type4 nvarchar(64)
,@Version4 nvarchar(64)
,@ErrorID4 int
,@Date4 datetime
,@AgentVer4 nvarchar(64)
,@ProductCode4 nvarchar(64)
,@SiteName4 nvarchar(64)
,@InitiatorID4 nvarchar(64)
,@InitiatorType4 nvarchar(64)
,@Type5 nvarchar(64)
,@Version5 nvarchar(64)
,@ErrorID5 int
,@Date5 datetime
,@AgentVer5 nvarchar(64)
,@ProductCode5 nvarchar(64)
,@SiteName5 nvarchar(64)
,@InitiatorID5 nvarchar(64)
,@InitiatorType5 nvarchar(64)
)
AS
BEGIN

	DECLARE @autoid int

	-- get computerproperty values
	declare @agentguid nvarchar(50)
--	declare @hostname nvarchar(50)
	declare @ipaddr nvarchar(50)
	declare @username nvarchar(50)
	declare @DatVer nvarchar(50)
	declare @EngineVer nvarchar(50)
	declare @Softwarename nvarchar(50)
	declare @prodver nvarchar(50)
	declare @prodcode nvarchar(50)

	-- check first value
--	IF @HostName > ''

	select
		@agentguid = agentguid
		,@autoid = leafnode.autoid
		,@hostname = computername
		,@ipaddr= ipaddress
		,@username= username
		,@DatVer= max(EngineVer)
		,@EngineVer= max(DATver)
		,@Softwarename= max(SoftwareName)
		,@prodver= max(ProductVersion)
		,@prodcode= max(productproperties.Productcode)
	from computerproperties, leafnode, productproperties, aviview_software
	where
		leafnode.autoid = computerproperties.parentid
		and leafnode.nodename=@HostName
		and leafnode.autoid = productproperties.parentid
		and aviview_software.productcode = productproperties.productcode
	group by
		agentguid
		,computername
		,ipaddress
		,username
		,leafnode.autoid


	/* Create Events */
	IF @Type1 > ''
		EXECUTE dbo.AVITEST_addUpdateEvent
			@HostName, @autoid
			,@Type1,@Version1,@ErrorID1,@Date1,@AgentVer1,@ProductCode1,@SiteName1,@InitiatorID1,@InitiatorType1

	IF @Type2 > ''
		EXECUTE dbo.AVITEST_addUpdateEvent
			@HostName, @autoid
			,@Type2,@Version2,@ErrorID2,@Date2,@AgentVer2,@ProductCode2,@SiteName2,@InitiatorID2,@InitiatorType2

	IF @Type3 > ''
		EXECUTE dbo.AVITEST_addUpdateEvent
			@HostName, @autoid
			,@Type3,@Version3,@ErrorID3,@Date3,@AgentVer3,@ProductCode3,@SiteName3,@InitiatorID3,@InitiatorType3

	IF @Type4 > ''
		EXECUTE dbo.AVITEST_addUpdateEvent
			@HostName, @autoid
			,@Type4,@Version4,@ErrorID4,@Date4,@AgentVer4,@ProductCode4,@SiteName4,@InitiatorID4,@InitiatorType4

	IF @Type5 > ''
		EXECUTE dbo.AVITEST_addUpdateEvent
			@HostName, @autoid
			,@Type5,@Version5,@ErrorID5,@Date5,@AgentVer5,@ProductCode5,@SiteName5,@InitiatorID5,@InitiatorType5

END

GO



if exists (select * from sysobjects where id = object_id(N'[dbo].[AVITEST_addEvents_4LeafProd]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVITEST_addEvents_4LeafProd]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVITEST_addEvents_4LeafProd
(
@NodeName nvarchar(255),
@ProdCode nvarchar(50),
@EngVer int,
@EngineVer nvarchar(100),
@DATVer nvarchar(50),
@EventDef int
)
AS
BEGIN

	DECLARE @VirusName nvarchar(128)
	DECLARE @TVDEventID int
	DECLARE @FileName nvarchar(512)
	DECLARE @ActionTaken int
	DECLARE @TVDSeverity int
	DECLARE @VirusType nvarchar(128)


	/* Set defaults */
	SET @VirusName = 'W32/Ska.exe'
	SET @TVDEventID = 1027
	SET @FileName = 'c:\downloads\happy99.exe'
	SET @ActionTaken = 50
	SET @TVDSeverity = 1
	SET @VirusType = 'File'


	/* Create Events */

      IF @EventDef = 0
           return

	/* Prodcode1 */
      IF @EventDef = 1
      BEGIN
		EXECUTE AVITEST_addEvent @NodeName, @ProdCode, 
						@EngVer, @EngineVer, @DATVer, 
						1, @VirusName, @TVDEventID, @FileName,
							@ActionTaken, @TVDSeverity, @VirusType, 10
		EXECUTE AVITEST_addEvent @NodeName, @ProdCode, 
						@EngVer, @EngineVer, @DATVer, 
						2, @VirusName, @TVDEventID, @FileName,
							@ActionTaken, @TVDSeverity, @VirusType, 20
		EXECUTE AVITEST_addEvent @NodeName, @ProdCode, 
						@EngVer, @EngineVer, @DATVer, 
						3, @VirusName, @TVDEventID, @FileName,
							@ActionTaken, @TVDSeverity, @VirusType, 30
		EXECUTE AVITEST_addEvent @NodeName, @ProdCode, 
						@EngVer, @EngineVer, @DATVer, 
						4, @VirusName, @TVDEventID, @FileName,
							@ActionTaken, @TVDSeverity, @VirusType, 40
		EXECUTE AVITEST_addEvent @NodeName, @ProdCode, 
						@EngVer, @EngineVer, @DATVer, 
						5, @VirusName, @TVDEventID, @FileName,
							@ActionTaken, @TVDSeverity, @VirusType, 50
	END
      IF @EventDef = 2
      BEGIN
		EXECUTE AVITEST_addEvent @NodeName, @ProdCode, 
						@EngVer, @EngineVer, @DATVer, 
						1, @VirusName, @TVDEventID, @FileName,
							@ActionTaken, @TVDSeverity, @VirusType, 5
		EXECUTE AVITEST_addEvent @NodeName, @ProdCode, 
						@EngVer, @EngineVer, @DATVer, 
						2, @VirusName, @TVDEventID, @FileName,
							@ActionTaken, @TVDSeverity, @VirusType, 15
		EXECUTE AVITEST_addEvent @NodeName, @ProdCode, 
						@EngVer, @EngineVer, @DATVer, 
						3, @VirusName, @TVDEventID, @FileName,
							@ActionTaken, @TVDSeverity, @VirusType, 25
		EXECUTE AVITEST_addEvent @NodeName, @ProdCode, 
						@EngVer, @EngineVer, @DATVer, 
						4, @VirusName, @TVDEventID, @FileName,
							@ActionTaken, @TVDSeverity, @VirusType, 35
	END
      IF @EventDef = 3

      BEGIN
		EXECUTE AVITEST_addEvent @NodeName, @ProdCode, 
						@EngVer, @EngineVer, @DATVer, 
						1, @VirusName, @TVDEventID, @FileName,
							@ActionTaken, @TVDSeverity, @VirusType, 0
		EXECUTE AVITEST_addEvent @NodeName, @ProdCode, 
						@EngVer, @EngineVer, @DATVer, 
						2, @VirusName, @TVDEventID, @FileName,
							@ActionTaken, @TVDSeverity, @VirusType, 1
		EXECUTE AVITEST_addEvent @NodeName, @ProdCode, 
						@EngVer, @EngineVer, @DATVer, 
						3, @VirusName, @TVDEventID, @FileName,
							@ActionTaken, @TVDSeverity, @VirusType, 2
	END
      IF @EventDef = 4
      BEGIN
		EXECUTE AVITEST_addEvent @NodeName, @ProdCode, 
						@EngVer, @EngineVer, @DATVer, 
						1, @VirusName, @TVDEventID, @FileName,
							@ActionTaken, @TVDSeverity, @VirusType, 11
		EXECUTE AVITEST_addEvent @NodeName, @ProdCode, 
						@EngVer, @EngineVer, @DATVer, 
						2, @VirusName, @TVDEventID, @FileName,
							@ActionTaken, @TVDSeverity, @VirusType, 12
	END
      IF @EventDef = 5
      BEGIN
		EXECUTE AVITEST_addEvent @NodeName, @ProdCode, 
						@EngVer, @EngineVer, @DATVer, 
						1, @VirusName, @TVDEventID, @FileName,
							@ActionTaken, @TVDSeverity, @VirusType, 3
	END

END

GO
SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO



if exists (select * from sysobjects where id = object_id(N'[dbo].[AVITEST_addleaf_plus]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVITEST_addleaf_plus]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVITEST_addleaf_plus
(
@NodeName nvarchar(255),
@ParentNodeName nvarchar(255),
@LastUpdate nvarchar(16),
@AddProdEvents int,
@OSType	nvarchar(128),
@OSPlatform nvarchar(128),
@DomainName nvarchar(128)='',
@SnowcapNetworkDate DateTime ='', 	-- Add to snowcap tables using this date as the first rogue detection
@ProdCode1 nvarchar(50) ='',
@EngVer1 int =0,
@Events1 int =0,
@ProdCode2 nvarchar(50) ='',
@EngVer2 int =0,
@Events2 int =0,
@ProdCode3 nvarchar(50) ='',
@EngVer3 int =0,
@Events3 int =0,
@ProdCode4 nvarchar(50) ='',
@EngVer4 int =0,
@Events4 int =0,
@ProdCode5 nvarchar(50) ='',
@EngVer5 int =0,
@Events5 int =0
)
AS
BEGIN
      DECLARE @ParentID int
      DECLARE @BranchID int
      DECLARE @LeafID int
      DECLARE @BranchName nvarchar(50)
	DECLARE @AgentGUID uniqueidentifier
	DECLARE @EngineVer nvarchar(100)
	DECLARE @DATVer nvarchar(50)

	
	/* delete current entries if exists */
      SELECT @ParentID = AutoID
                           FROM LeafNode 
                           WHERE NodeName = @NodeName	
      SELECT @AgentGUID = AgentGUID 
                           FROM LeafNode 
                           WHERE NodeName = @NodeName	
      
      DELETE Events where NodeID = @ParentID
	DELETE ComputerProperties where ParentID = @ParentID
	DELETE ProductProperties where ParentID = @ParentID
	DELETE LeafNode where NodeName = @NodeName


      SELECT @BranchID = AutoID, @BranchName = NodeName  
                           FROM BranchNode 
                           WHERE NodeName = @ParentNodeName 

	INSERT INTO LeafNode
      (
		NodeName,
		Type,
		ParentID,
		TheTimestamp,
		AgentGUID,
		ModifiedPropsDate,
		LastUpdate,
		AgentState,
		AgentPubKey,
		AgentPubKeyLen,
		UninstallFlag,
		AgentPolicyVersion,
		PolicyTimestamp,
		LastMaxPolicyVersion,
		TheHiddenTimestamp,
		TaskTimestamp,
		AgentTaskVersion,
		LastMaxTaskVersion,
		AgentSiteInfoVersion,
		AVInstalls
      )
      Values
      (
 		@NodeName,
		1,
		@BranchID,
		NULL ,
		NEWID(),
		NULL , @LastUpdate , 0 , NULL , NULL ,
		1,
		NULL,  NULL,  NULL,  NULL,  NULL,  NULL,  NULL,  NULL, 0
     )

      SELECT @LeafID = AutoID 
                           FROM LeafNode 
                           WHERE NodeName = @NodeName 

	-- If domain not explicitly set, set domainname based on branchnode name
	If @DomainName = ''
		Set @DomainName = 'Domain'+@BranchName
	-- Setup fake IP and Network ids based on branch and leafnode ids
	Declare @IPAddress varchar(50)
	Set @IPAddress = '123.45.'+rtrim(convert(varchar(10),@BranchID))
			+rtrim(convert(varchar(10),@LeafID))
	Declare @NetworkID varchar(50)
	Set @NetworkID = '123.45.'+rtrim(convert(varchar(10),@BranchID))+'.0'



      /* Create Computer Properties */
	INSERT INTO ComputerProperties
	(
		ParentID,
		ComputerName,
		UserName,
		DomainName,
		IPAddress,
		OSType,
		OSPlatform,
		OSVersion,
		OSServicePackVer,
		OSBuildNum,
		OSOEMID,
		CPUType,
		CPUSpeed,
		NumOfCPU,
		TotalPhysicalMemory,
		FreeDiskSpace,
		TotalDiskSpace,
		TimeZone,
		DefaultLangID,
		NetAddress
	)
	values
	(
		@LeafID,
		@NodeName,
		@NodeName,
		@DomainName ,
		@IPAddress,
		@OSType, @OSPlatform, '5.0', 'Service Pack 3', 
		2190 ,
		NULL , 'Intel Pentium 4' , 2400 , 1 , 133726208 , 2917 , 13778 , 'Pacific Standard Time' ,
		'0409',
		'00105A25E703' 
	)


	-- Add snowcap host table entry if the table exists
	IF EXISTS (SELECT * FROM sysobjects WHERE name = 'Hosts')
	Begin
		Declare @id int
		Declare @nid int
		Declare @hid int
		Declare @sid int
		Declare @RogueType int
		Set @RogueType=1
		Declare @NetName nvarchar(50)
		select @NetName='Network'+branchnode.nodename from leafnode,branchnode 
			where branchnode.autoid=leafnode.parentid and leafnode.nodename=@NodeName 
		select @nid=Networks.NetworkID, @sid=SensorID from Networks, Sensors 
				where NetworkName = @NetName and Networks.NetworkID=Sensors.NetworkID
		if @SnowcapNetworkDate > '' -- Will add computer to existing or new snowcap network
		begin

		if not exists (select epoindex from Hosts, leafnode 
			where Hosts.epoindex=leafnode.autoid and nodename=@NodeName)
		begin
			-- create a network and sensor for every branchnode entry if one doesnt already exist
			if @nid=0 or @nid is null or @sid=0 or @sid is null
			begin
				insert Networks (NetworkName, SubnetMask, NetworkAddress, NetworkAddressNum) 
					values (@NetName, '255.255.0.0',@NetworkID, 1)
				select @nid=NetworkID from Networks where NetworkName = @NetName
				insert Sensors (NetworkID, MAC, SensorName, IPAddress, OSPlatform, OSFamily, OSVersion,
						LastCommunicationTime,Domain,SID,AgentGUID) 
					values (@nid, @nid, 'Sensor'+@BranchName, @IPAddress, @OSType, @OSType, @OSPlatform,
						getdate(), 'MyDomain', '1',NEWID())
				select @sid=SensorID from Sensors where NetworkID = @nid
			end
			-- insert host
			insert Hosts 
			( MAC, OUI, NetworkAddress, NetworkProtocolID, NetbiosName, DnsName, LastDetectTime, NetworkID, Exception,
				EpoIndex, Comments, OSPlatform, OSFamily, OSVersion, NetBiosComment, Deleted, FirstDetectTime,
				Users, Domain, SID, FirstRogueTime, RogueType,
				LastAgentCom, IpAddressNum, FriendlyName, MarkedForAction) 
			values(@Leafid, 'OUI', @IPAddress, 1, 'NetBios', 'DNSName', getdate(), @nid, 0,
				@Leafid, 'Comment', @OSType, @OSType, @OSPlatform, 'NetBiosComment', 0, @SnowcapNetworkDate,
				'Users', 'MyDomain', '1', @SnowcapNetworkDate, @RogueType,
				getdate(), 1, @NodeName, 1)
			select @hid=HostID from Hosts where FriendlyName = @NodeName and epoindex = @Leafid
				
			-- insert EventLog
			-- epo3.6 version: eventlog.type renamed to eventlog.eventtype
--			insert EventLog
--			(CreateTime, EventType, SourceHostId, SourceNetworkId, SourceSensorId, Archive, ActionCount)
--			values(@SnowcapNetworkDate, @RogueType, @hid, @nid, @sid, 1, 1)

			-- epo3.5 version EventLog.Event
			insert EventLog
			(CreateTime, Type, SourceHostId, SourceNetworkId, SourceSensorId, Archive, ActionCount)
			values(@SnowcapNetworkDate, @RogueType, @hid, @nid, @sid, 1, 1)


		end
		end
	End


	/* check if adding products and events */
	IF @AddProdEvents = 0
		return

	/* Create 5 default Product Installations */

	/* Set defaults */
	SET @EngineVer = '4.0.70'
	SET @DATVer = '4.0.4064'
      
	EXECUTE AVITEST_addProdProp @NodeName, @ProdCode1, '', @EngVer1, @EngineVer, @DatVer, '0409'
	EXECUTE AVITEST_addProdProp @NodeName, @ProdCode2, '', @EngVer2, @EngineVer, @DatVer, '040a'
	EXECUTE AVITEST_addProdProp @NodeName, @ProdCode3, '', @EngVer3, @EngineVer, @DatVer, '0407'
	EXECUTE AVITEST_addProdProp @NodeName, @ProdCode4, '', @EngVer4, @EngineVer, @DatVer, '0409'
	EXECUTE AVITEST_addProdProp @NodeName, @ProdCode5, '', @EngVer5, @EngineVer, @DatVer, '040c'


      /* Add events */
      EXECUTE AVITEST_addEvents_4LeafProd @NodeName, 
				@ProdCode1, @EngVer1, @EngineVer, @DatVer, @Events1
      EXECUTE AVITEST_addEvents_4LeafProd @NodeName, 
				@ProdCode2, @EngVer2, @EngineVer, @DatVer, @Events2
      EXECUTE AVITEST_addEvents_4LeafProd @NodeName, 
				@ProdCode3, @EngVer3, @EngineVer, @DatVer, @Events3
      EXECUTE AVITEST_addEvents_4LeafProd @NodeName, 
				@ProdCode4, @EngVer4, @EngineVer, @DatVer, @Events4
      EXECUTE AVITEST_addEvents_4LeafProd @NodeName, 
				@ProdCode5, @EngVer5, @EngineVer, @DatVer, @Events5




END
GO


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVITEST_RemoveSnowcapEntries]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVITEST_RemoveSnowcapEntries]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVITEST_RemoveSnowcapEntries
(
@NodeName nvarchar(255)
)
AS
BEGIN

Declare @nid int
Declare @hid int
Declare @id int

IF EXISTS (SELECT * FROM sysobjects WHERE name = 'Hosts')
begin
	select @id=epoindex,@nid=NetworkID, @hid=HostID from Hosts, leafnode 
		where Hosts.epoindex=leafnode.autoid and nodename=@NodeName
	if @id > 0 and @hid > 0
	begin
		delete EventLog where SourceHostID = @hid
		delete Hosts where HostID = @hid
		-- delete sensors and networks if nothing else point to them
		delete Sensors where NetworkID = @nid and networkid not in (select networkid from hosts)
		delete Networks where NetworkID = @nid and networkid not in (select networkid from hosts)
	end
end

End
GO

SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO




SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVITEST_insertnew_user]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVITEST_insertnew_user]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVITEST_insertnew_user
(
@szUserName nvarchar(255),
@szTopNodeName nvarchar(255),
@iAccessMask int
)
AS
BEGIN

	Declare @iTopNodeID int

      DELETE UserTable where UserName = @szUserName

	SELECT @iTopNodeID = AutoID
			FROM BranchNode
			WHERE NodeName = @szTopNodeName
 
	IF EXISTS 
		(SELECT AutoID
			FROM BranchNode
			WHERE NodeName = @szTopNodeName) 
      BEGIN
		INSERT INTO UserTable
     		(
			UserName,
			Password,
			TheTimestamp,
			TheHiddenTimestamp,
			RootNodeID,
			WriteAccess
  	    	)
  	    	Values
  	    	(
			@szUserName,
			'fake',
			NULL,
			NULL,
			@iTopNodeID, @iAccessMask
  	    	)
  	END
END
GO


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVITEST_CopyComputer]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVITEST_CopyComputer]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVITEST_CopyComputer
(
@szNodeName nvarchar(255),
@szSuffix nvarchar(255)
)
AS
BEGIN


insert leafnode
(
	[NodeName] 
	,[Type] 
	,[ParentID] 
--	,[TheTimestamp]
	,[AgentGUID] 
	,[ModifiedPropsDate] 
	,[LastUpdate]
	,[AgentState] 
	,[AgentPubKey] 
	,[AgentPubKeyLen] 
	,[UninstallFlag] 
	,[AgentPolicyVersion] 
	,[PolicyTimestamp] 
	,[LastMaxPolicyVersion] 
--	,[TheHiddenTimestamp] 
	,[TaskTimestamp] 
	,[AgentTaskVersion] 
	,[LastMaxTaskVersion] 
	,[AgentSiteInfoVersion] 
	,[AgentEventFilterVersion] 
	,[NodePath]
	,[AgentPlatform] 
	,[URL] 
	,[AVinstalls]  
	,[SuperAgent]  
	,[SuperAgentRepo] 
	,[AgentVersion] 
)
select 
	[NodeName] + @szSuffix
	,[Type] 
	,[ParentID] 
--	,[TheTimestamp]
	,[AgentGUID] 
	,[ModifiedPropsDate] 
	,[LastUpdate]
	,[AgentState] 
	,[AgentPubKey] 
	,[AgentPubKeyLen] 
	,[UninstallFlag] 
	,[AgentPolicyVersion] 
	,[PolicyTimestamp] 
	,[LastMaxPolicyVersion] 
--	,[TheHiddenTimestamp] 
	,[TaskTimestamp] 
	,[AgentTaskVersion] 
	,[LastMaxTaskVersion] 
	,[AgentSiteInfoVersion] 
	,[AgentEventFilterVersion] 
	,[NodePath]
	,[AgentPlatform] 
	,[URL] 
	,[AVinstalls]  
	,[SuperAgent]  
	,[SuperAgentRepo] 
	,[AgentVersion] 
from leafnode
where Nodename = @szNodeName

-- fetch new nodes autoid

-- insert tasks, policies, products, and all settings
-- insert all events and productevents


END
GO


/****************************/
/*** AVIDBTest Procedures ***/
/****************************/
/* Stored in aviprocedures as well */
/* Remove from here if a separate test script files is not needed */

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_RemoveLeadAndTrailSeperator]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_RemoveLeadAndTrailSeperator]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVISP_RemoveLeadAndTrailSeperator
	@szString	 VARCHAR(1000),
	@szSeperator VARCHAR(100),
	@szRemaining VARCHAR(1000) OUTPUT
AS
BEGIN
	/* Copyright  1995-2000 Networks Associates Technology, Inc. All Rights Reserved.*/

	DECLARE @Pos INTEGER

	/* strip leading seperator*/
	SET @Pos=CHARINDEX(@szSeperator, @szString)

	IF(@Pos=1)
		SET @szString =	 SUBSTRING(@szString, LEN(@szSeperator)+1,LEN(@szString))

	/* strip trailing seperator*/
	SET @szString = REVERSE(@szString)
	SET @Pos=CHARINDEX(REVERSE(@szSeperator), @szString)
	IF(@Pos=1)
		SET @szString =	 SUBSTRING(@szString, LEN(REVERSE(@szSeperator))+1,LEN(@szString))
	
	SET @szString = REVERSE(@szString)
	SET @szRemaining = 	@szString
	RETURN 1
END
GO


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_SplitString]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_SplitString]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO


SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVISP_SplitString
	@szString	 VARCHAR(1000),
	@szSeperator VARCHAR(100),
	@szRemaining VARCHAR(1000) OUTPUT ,
	@szSubString VARCHAR(1000) OUTPUT
	
AS
BEGIN
	/* Copyright  1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

	DECLARE @Pos INTEGER
	DECLARE @RetVal INTEGER

	EXECUTE AVISP_RemoveLeadAndTrailSeperator @szString, @szSeperator, @szString OUTPUT

	/* reverse them - we want the last substring */

	SET @szString = REVERSE(@szString)
	SET @szSeperator = REVERSE(@szSeperator)

	/* look for next seperator */
	SET @Pos=CHARINDEX(@szSeperator, @szString)
	IF (@Pos!=0)
	BEGIN
		/* found */
		SET @RetVal=1
		SET @szSubString=SUBSTRING(@szString,1,@Pos-1)
		SET @szRemaining=SUBSTRING(@szString,@Pos+LEN(@szSeperator),LEN(@szString))
	
	END
	ELSE
	BEGIN
		/* not found */
		SET @RetVal=0
		SET @szSubString=@szString
		SET @szRemaining=''
	
	END

	/* un reverse the return params */

	SET @szSubString=REVERSE(@szSubString)
	SET @szRemaining=REVERSE(@szRemaining)


	RETURN @RetVal
END
GO


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVITEST_insertnew_software]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVITEST_insertnew_software]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVITEST_insertnew_software
(
@ProductCode nvarchar(50),
@SoftwareName nvarchar(50),
@PackageName nvarchar(50),
@PackageDir nvarchar(255),
@VersionNum nvarchar(50),
@ProductFamily nvarchar(50),
@Language nvarchar(500)
)
AS
BEGIN

      DELETE Software where ProductCode = @ProductCode

	INSERT INTO Software
      (
		ProductCode,
		SoftwareName,
		PackageName,
		PackDir,
		ProductCfgPath,
		InstallGUID,
		ProductVersion,
		ProductFamily,
		Language,
		PlatformsSupported,
		PluginVer,
		TheTimestamp,
		TheHiddenTimestamp,
		RepositoryType,
		OSType,
		RepoFlag,
		SoftwareType
      )
      Values
      (
		@ProductCode,
		@SoftwareName,
		@PackageName,
		@PackageDir,
		NULL,
		NULL,
		@VersionNum,
		@ProductFamily,
		@Language,
		NULL,
		NULL,
		NULL,
		NULL, NULL, NULL, 0, 0
      )

END


GO
SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO


if exists (select * from sysobjects where id = object_id(N'[dbo].[AVITEST_insertall_software]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVITEST_insertall_software]
GO

SET QUOTED_IDENTIFIER  ON    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE dbo.AVITEST_insertall_software
AS
BEGIN

      TRUNCATE TABLE Software

EXECUTE AVITEST_insertnew_software
		'ePOAgent2000',
		'ePO Agent for Windows',
		'10',
		'ePOAgent\1.0\English',
		'2.0.0', 'EPO',
		'0409'

EXECUTE AVITEST_insertnew_software
		'ePOAgent1000',
		'ePO Agent',
		'1.1.0.171',
		'ePOAgent\1.0.0.0\English',
		'1.1.0', 'EPO',
		'0409'

EXECUTE AVITEST_insertnew_software
		'VIRUSCAN4500',
		'VirusScan 4.5',
		'4.5.0',
		'VirusScan\4.5..0\English',
		'4.5.0', 'TVD',
		'0409'

EXECUTE AVITEST_insertnew_software
		'VIRUSCAN4000WNTW',
		'VirusScan 4.0.3',
		'4.0.3',
		'VirusScan\4.0.3\English',
		'4.0.3', 'TVD',
		'0409'

EXECUTE AVITEST_insertnew_software
		'VIRUSCAN6000',
		'VirusScan TC',
		'6.0.0',
		'VirusScan\6.0.0\English',
		'6.0.0', 'TVD',
		'0409'

EXECUTE AVITEST_insertnew_software
		'WEBSHLD_1000',
		'WebShield 1.0',
		'1.0',
		'WebShield\1.0\English',
		'1.0', 'TVD',
		'0409'

EXECUTE AVITEST_insertnew_software
		'NETSHLD_4500',
		'INstaller for Virusscan TC',
		'4.5.0',
		'NetShield\4.5.0\English',
		'4.5.0', 'TVD',
		'0409'

EXECUTE AVITEST_insertnew_software
		'NETSHLD_4000',
		'NetShield v4.0.3',
		'4.0.3',
		'NetShield\4.0.3\English',
		'4.0.3', 'TVD',
		'0409'

EXECUTE AVITEST_insertnew_software
		'GSDOMINO5000',
		'GroupShield 5.0',
		'5.0.0',
		'GroupShield\4.0.2\English',
		'5.0.0', 'TVD',
		'0409'

EXECUTE AVITEST_insertnew_software
		'ALERTMNG4500',
		'Alert Manager',
		'4.5.0',
		'GroupShield\4.5.0\English',
		'4.5.0', 'TVD_NS',
		'0409'

EXECUTE AVITEST_insertnew_software
		'LWI_____6000',
		'GroupShield',
		'1.0.0',
		'GroupShield\4.5.0\English',
		'1.0.0', 'TVD_NS',
		'0409'

EXECUTE AVITEST_insertnew_software
		'PCR_____6000',
		'Product Coverage Report',
		'1.0.0',
		'GroupShield\4.5.0\English',
		'1.0.0', 'TVD_NS',
		'0409'

EXECUTE AVITEST_insertnew_software
		'NORTONAV',
		'Norton anti-virus',
		'1.0.0',
		'Norton\4.5.0\English',
		'1.0.0', 'TVD_NC',
		'0409'


END  
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[AVISP_GetConsistentProductCode]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[AVISP_GetConsistentProductCode]
GO


CREATE PROCEDURE dbo.AVISP_GetConsistentProductCode
 @szProductName  VARCHAR(100),
 @szProductVersion  VARCHAR(100),
 @szProductCode VARCHAR(50) OUTPUT
AS
BEGIN
 /* Copyright   1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/

 /* Default to the provided one*/
 SET @szProductCode = @szProductName + @szProductVersion

 IF @szProductName LIKE 'NetShield%'  AND @szProductVersion = '4.0.3'
	  SET @szProductCode = 'NETSHLD_4000'

 IF @szProductName LIKE 'NetShield%'  AND @szProductVersion = '4.5.0'
	  SET @szProductCode = 'NETSHLD_4500'

 IF @szProductName LIKE 'VirusScan%' 
  	SET @szProductCode = 'VIRUSCAN4500'

 IF @szProductName LIKE 'VirusScan%'  AND @szProductVersion = '4.0.3'
  	SET @szProductCode = 'VIRUSCAN4000WNTW'

 IF @szProductName LIKE 'VirusScan%'  AND @szProductVersion = '6.0.0'
  	SET @szProductCode = 'VIRUSCAN6000'

 IF @szProductName LIKE 'VirusScan%'  AND @szProductVersion = '4.5.1'
  	SET @szProductCode = 'VIRUSCAN6500'

 IF @szProductName LIKE 'GroupShield%'  
  	SET @szProductCode = 'GSDOMINO5000'

 IF @szProductName LIKE '%Agent%' 
  	SET @szProductCode = 'ePOAgent1000'

 IF @szProductName LIKE '%Agent%'  AND @szProductVersion = '2.0.0'
  	SET @szProductCode = 'ePOAgent2000'

 IF @szProductName LIKE '%TC Installer'  AND @szProductVersion = '1.0.0'
  	SET @szProductCode = 'LWI____6000'

 IF @szProductName LIKE 'Alert Manager%'  AND @szProductVersion = '4.5.0'
  	SET @szProductCode = 'ALERTMNG4500'

 RETURN
END
GO


-------


