--------------------------------------------------------------
--------------------------------------------------------------
--  Triggers.sql - All epo triggers should be placed here
--	This file was introduces with epo3.5 patch4
--	Remember to create each object under dbo ownership
--------------------------------------------------------------
--------------------------------------------------------------


----------------------------------------------
--  Branchnode table
----------------------------------------------

-- If trigger was created outside dbo ownership, make sure it gets dropped
if exists (select * from sysobjects where id = object_id(N'[TR_EPO_DeleteFrom_BranchNode]'))
drop trigger [TR_EPO_DeleteFrom_BranchNode]
GO
-- delete trigger
if exists (select * from sysobjects where id = object_id(N'[dbo].[TR_EPO_DeleteFrom_BranchNode]'))
drop trigger [dbo].[TR_EPO_DeleteFrom_BranchNode]
GO

CREATE trigger dbo.TR_EPO_DeleteFrom_BranchNode on BranchNode
for delete
as
BEGIN

	--Delete the Policies, Tasks, IPSubnetMasks
	DELETE Policy WHERE (ParentType>2) AND (ParentID IN (Select AutoID from deleted))
	DELETE Task WHERE (ParentType>2)  AND (ParentID IN (Select AutoID from deleted))
	DELETE IPSubnetMask WHERE ParentID IN (Select AutoID from deleted)
	DELETE Mapping_Points WHERE EPONodeID IN (Select AutoID from deleted)

END
GO

-- update trigger
-- If trigger was created outside dbo ownership, make sure it gets dropped
if exists (select * from sysobjects where id = object_id(N'[TR_EPO_Move_BranchNode]'))
drop trigger [TR_EPO_Move_BranchNode]
GO
-- changed to maintain fullpath table when nodename changes
if exists (select * from sysobjects where id = object_id(N'[dbo].[TR_EPO_Move_BranchNode]'))
drop trigger [dbo].[TR_EPO_Move_BranchNode]
GO

CREATE TRIGGER dbo.TR_EPO_Move_BranchNode on BranchNode
for UPDATE
as
Begin

	declare @NewNodeID int
	select @NewNodeID=AutoID from inserted
	declare @DeletedNodeID int
	select @DeletedNodeID=AutoID from deleted

	-- Call routine to keep full path id table up-to-date
	IF UPDATE(ParentID)
	BEGIN
		 -- epo3.5 patch4 bz236142 Pass in new and old node to regenerate pathid entries
		 EXECUTE AVIDALSP_MOVEWITHIN_BranchNode_Enum @NewNodeID, @DeletedNodeID
	END
	
	IF UPDATE(NodeName)
	BEGIN
		-- epo3.5 patch4 bz236142 Delete only the node affected rather than recreate whole table
		execute AVIDALSP_CalculateANodeIDPathRemove @DeletedNodeID, 'NoResultSet'
		execute AVIDALSP_CalculateANodeIDPath @NewNodeID, 'NoResultSet'		
		--EXECUTE AVIDALSP_CalculateAllNodeIDPaths '','','','NoResultSet'
	END

End
Go

-- insert trigger
-- If trigger was created outside dbo ownership, make sure it gets dropped
if exists (select * from sysobjects where id = object_id(N'[TR_EPO_AddTo_BranchNode]'))
drop trigger [TR_EPO_AddTo_BranchNode]
GO
-- changed to maintain fullpath table when nodename changes
if exists (select * from sysobjects where id = object_id(N'[dbo].[TR_EPO_AddTo_BranchNode]'))
drop trigger [dbo].[TR_EPO_AddTo_BranchNode]
GO

CREATE trigger dbo.TR_EPO_AddTo_BranchNode on BranchNode
for insert
as
BEGIN

	declare @TheID int
	select @TheID=AutoID from inserted
	EXECUTE AVIDALSP_AddTo_BranchNode_Enum @TheID

END
GO

----------------------------------------------
-- LeafNode table
----------------------------------------------

-- delete trigger
-- If trigger was created outside dbo ownership, make sure it gets dropped
if exists (select * from sysobjects where id = object_id(N'[TR_EPO_DELLEAFNODE]'))
drop trigger [TR_EPO_DELLEAFNODE]
GO
if exists (select * from sysobjects where id = object_id(N'[dbo].[TR_EPO_DELLEAFNODE]'))
drop trigger [dbo].[TR_EPO_DELLEAFNODE]
GO

CREATE TRIGGER dbo.TR_EPO_DELLEAFNODE ON [LeafNode] 
FOR DELETE 
AS
BEGIN

	--Delete the Policies, Tasks, ComputerProperties
	DELETE Policy WHERE (ParentType<3) AND (ParentID IN (Select AutoID from deleted))
	DELETE Task WHERE (ParentType<3)  AND (ParentID IN (Select AutoID from deleted))
	DELETE ComputerProperties WHERE ParentID IN (Select AutoID from deleted)
	DELETE ProductProperties WHERE ParentID IN (Select AutoID from deleted)

END
GO

----------------------------------------------
-- software table
----------------------------------------------

-- insert trigger
-- epo3.5 patch2 213085 : Remove any ghost product entries when a new product nap is installed.
--	This prevents the policy compiler from getting confused between the ghost entries (added from
--	installed products before the nap is installed) and the real entries from the nap install.

/* sometimes productproperty data added before software table (no nap) */
/* productproperty insert trigger will fail */
/* This trigger assures that avinsert is set correctly in that case */ 
-- changed to maintain fullpath table when nodename changes

-- If trigger was created outside dbo ownership, make sure it gets dropped
if exists (select * from sysobjects where id = object_id(N'[TR_EPO_INSSOFTWARE]'))
drop trigger [TR_EPO_INSSOFTWARE]
GO
if exists (select * from sysobjects where id = object_id(N'[dbo].[TR_EPO_INSSOFTWARE]'))
drop trigger [dbo].[TR_EPO_INSSOFTWARE]
GO

CREATE TRIGGER dbo.TR_EPO_INSSOFTWARE ON [Software] 
for insert
as
begin

	UPDATE LeafNode Set AgentVersion = inserted.productversion
	  from inserted, ProductProperties
		where
		leafnode.autoid = ProductProperties.parentid
		and inserted.productcode = ProductProperties.productcode
		and inserted.productfamily = 'EPO'
		and inserted.productcode like 'epoagent%'
	
	
	declare @cnt int
	select @cnt=count(*) from software, inserted where software.productcode = inserted.productcode

	if @cnt <= 1
	UPDATE LeafNode Set AVInstalls = AVInstalls + 1
	   WHERE 
		LeafNode.AVinstalls <= 1
		AND LeafNode.AutoID in  
	                      (
	                           Select ParentID 
	                              from inserted, ProductProperties 
	                              where inserted.ProductCode = ProductProperties.ProductCode
	                              AND ( inserted.ProductFamily in ( 'TVD','TVD_NC' )
										or inserted.ProductFamily like 'TVD_NC%' ) 
	                      )     

	-- epo3.5 assure than any blank language entries get update to 0000
	-- the epo server needs this for some reason
	update software set language = '0000' where language = '' or language is null
	
	-- epo3.5 patch2 213085 : Remove any ghost product entries when a new product nap is installed.
	-- remove orphaned entry
	delete software 
	where
	( InstallGuid is null )
	-- must remove this clause because the fix below for 218543 will now put an entry into productfamily
	--and ( productfamily = '' or productfamily is null )
	and ( PlatformsSupported = '' or PlatformsSupported is null )
	and productcode in (
		select productcode from inserted
		where 
			( InstallGuid is not null )
			and ( productfamily > '' )
			and ( PlatformsSupported > '' )
		)

	-- epo3.5 patch3 218543 : If ghost entry is legit (nap removed but product still installed)
	--  make sure the productfamily field is updated properly if it is blank (reports fail otherwise)

 
	if exists (select * from inserted where inserted.productfamily='' or inserted.productfamily is null)
	begin 
		Set @cnt=0 
		-- do we need to set ProductFamily = TVD (dat and engine versions exist)
		select @cnt=count(*) from inserted, ProductProperties
			where inserted.productcode = ProductProperties.productcode
				and (inserted.productfamily='' or inserted.productfamily is null)
				and ProductProperties.DATver > '' and ProductProperties.Enginever > ''
	
		-- search for a newer version of the product and use its product family (TVD, TVD_NC, TVD_NC*)
		Declare @ProdFamily varchar(20)    set @ProdFamily = ''
		select @ProdFamily=software.ProductFamily from software, inserted	
			where left(software.productcode,8) = left(inserted.productcode,8)
				and software.ProductFamily > ''
				and software.ProductFamily != 'epo_reports'
	
		-- no newer version, default to tvd
		if @ProdFamily = ''
			set @ProdFamily = 'TVD'
		
		if @cnt > 0
			update software
				set ProductFamily = @ProdFamily
				from inserted
				where 
					inserted.productcode = software.productcode
					and (software.productfamily='' or software.productfamily is null)
	end

end
Go



-- delete trigger
-- epo3.5 patch2 211454 : If a product entry (multilanguage) is removed from the software
--	table, make sure that any policies or tasks associated with it are also removed

-- If trigger was created outside dbo ownership, make sure it gets dropped
if exists (select * from sysobjects where id = object_id(N'[TR_EPO_DELSOFTWARE]'))
drop trigger [TR_EPO_DELSOFTWARE]
GO
if exists (select * from sysobjects where id = object_id(N'[dbo].[TR_EPO_DELSOFTWARE]'))
drop trigger [dbo].[TR_EPO_DELSOFTWARE]
GO

CREATE TRIGGER dbo.TR_EPO_DELSOFTWARE ON [Software] 
for delete
as
begin

	delete policy
	where autoid in (
		select Policy.autoid
		from policy, software, deleted
		where policy.productcode *= software.productcode
			and deleted.productcode = policy.productcode
			group by policy.productcode, software.softwarename, Policy.autoid
			having software.softwarename is null
	)

	delete	Task
	where autoid in (
		select Task.autoid
		from Task, software, deleted
		where Task.productcode *= software.productcode
			and deleted.productcode = Task.productcode
			group by Task.productcode, software.softwarename, Task.autoid
			having software.softwarename is null
		)

end
Go


----------------------------------------------
-- ProductProperties table
----------------------------------------------

-- delete trigger
-- If trigger was created outside dbo ownership, make sure it gets dropped
if exists (select * from sysobjects where id = object_id(N'[TR_EPO_DELPRODSETTINGS]'))
drop trigger [TR_EPO_DELPRODSETTINGS]
GO
if exists (select * from sysobjects where id = object_id(N'[dbo].[TR_EPO_DELPRODSETTINGS]'))
drop trigger [dbo].[TR_EPO_DELPRODSETTINGS]
GO


CREATE TRIGGER dbo.TR_EPO_DELPRODSETTINGS ON dbo.ProductProperties 
for delete
as
BEGIN

	delete ProductSettings where ParentID IN (select AutoID from deleted)
	
	UPDATE LeafNode Set AVInstalls = AVInstalls - 1
	   WHERE LeafNode.AutoID in  
	    (Select ParentID 
	     from deleted, aviview_software 
	     where deleted.ProductCode = aviview_Software.ProductCode
	      AND ( aviview_Software.ProductFamily in ( 'TVD','TVD_NC' ) 
				or aviview_Software.ProductFamily like 'TVD_NC%' ) 
		)     
	   AND LeafNode.AVInstalls > 0 
	
	
	UPDATE LeafNode Set AgentVersion = ''
	   WHERE LeafNode.AutoID in  
	    (Select ParentID 
	     from deleted, aviview_software 
	     where deleted.ProductCode = aviview_Software.ProductCode
	      AND aviview_Software.ProductFamily in ( 'EPO' )
	      and deleted.ProductCode like 'ePOAgent%'  )     

   
END
GO

-- insert trigger
-- If trigger was created outside dbo ownership, make sure it gets dropped
if exists (select * from sysobjects where id = object_id(N'[TR_EPO_INSPRODPROP]'))
drop trigger [TR_EPO_INSPRODPROP]
GO
if exists (select * from sysobjects where id = object_id(N'[dbo].[TR_EPO_INSPRODPROP]'))
drop trigger [dbo].[TR_EPO_INSPRODPROP]
GO


CREATE TRIGGER dbo.TR_EPO_INSPRODPROP ON dbo.ProductProperties 
for insert
as
begin

	UPDATE LeafNode Set AgentVersion = inserted.productversion
	  from inserted, aviview_software
		where
		leafnode.autoid = inserted.parentid
		and inserted.productcode = aviview_software.productcode
		and aviview_software.productfamily = 'EPO'
		and aviview_software.productcode like 'epoagent%'
	
	
	UPDATE LeafNode Set AVInstalls = AVInstalls + 1
	   WHERE LeafNode.AutoID in  
	    (Select ParentID 
	     from inserted, aviview_software 
	     where inserted.ProductCode = aviview_Software.ProductCode
	      AND ( aviview_Software.ProductFamily in ( 'TVD','TVD_NC' )
				or aviview_Software.ProductFamily like 'TVD_NC%' )
	   )

end
go


-- update trigger
-- If trigger was created outside dbo ownership, make sure it gets dropped
if exists (select * from sysobjects where id = object_id(N'[TR_EPO_UPDPRODPROP]'))
drop trigger [TR_EPO_UPDPRODPROP]
GO
if exists (select * from sysobjects where id = object_id(N'[dbo].[TR_EPO_UPDPRODPROP]'))
drop trigger [dbo].[TR_EPO_UPDPRODPROP]
GO


CREATE TRIGGER dbo.TR_EPO_UPDPRODPROP ON dbo.ProductProperties 
for update
as
begin

	declare @inspv nvarchar(50)
	declare @delpv nvarchar(50)
	
	select @inspv = productversion from inserted
	select @delpv = productversion from deleted
	 
	if (@inspv <> @delpv) or (@inspv is not null and @delpv is null)
	UPDATE LeafNode Set AgentVersion = inserted.productversion
	  from inserted, aviview_software
		where
		leafnode.autoid = inserted.parentid
		and inserted.productcode = aviview_software.productcode
		and aviview_software.productfamily = 'EPO'
		and aviview_software.productcode like 'epoagent%'
	

end
go


----------------------------------------------
-- Policy table
----------------------------------------------

-- delete trigger
-- If trigger was created outside dbo ownership, make sure it gets dropped
if exists (select * from sysobjects where id = object_id(N'[TR_EPO_DELPOLICYSETTINGS]'))
drop trigger [TR_EPO_DELPOLICYSETTINGS]
GO
if exists (select * from sysobjects where id = object_id(N'[dbo].[TR_EPO_DELPOLICYSETTINGS]'))
drop trigger [dbo].[TR_EPO_DELPOLICYSETTINGS]
GO

CREATE TRIGGER dbo.TR_EPO_DELPOLICYSETTINGS ON [Policy] 
for delete
as
BEGIN
	delete PolicySettings where ParentID IN (select AutoID FROM deleted)
END
GO


-- delete trigger
-- If trigger was created outside dbo ownership, make sure it gets dropped
if exists (select * from sysobjects where id = object_id(N'[TR_DEL_UPDATEPOLICYTIMESTAMP]'))
drop trigger [TR_DEL_UPDATEPOLICYTIMESTAMP]
GO
if exists (select * from sysobjects where id = object_id(N'[dbo].[TR_DEL_UPDATEPOLICYTIMESTAMP]'))
drop trigger [dbo].[TR_DEL_UPDATEPOLICYTIMESTAMP]
GO

CREATE TRIGGER dbo.TR_DEL_UPDATEPOLICYTIMESTAMP ON [Policy] 
FOR DELETE 
AS
BEGIN

	update thecount set thedata=1
	UPDATE BranchNode SET PolicyTimestamp=@@DBTS WHERE AutoID IN (SELECT ParentID FROM deleted WHERE ParentType>=3)
	UPDATE LeafNode SET PolicyTimestamp=@@DBTS WHERE AutoID IN (SELECT ParentID FROM deleted WHERE ParentType<=2)

END
GO


-- insert, update trigger
-- If trigger was created outside dbo ownership, make sure it gets dropped
if exists (select * from sysobjects where id = object_id(N'[TR_ADD_UPDATEPOLICYTIMESTAMP]'))
drop trigger [TR_ADD_UPDATEPOLICYTIMESTAMP]
GO
if exists (select * from sysobjects where id = object_id(N'[dbo].[TR_ADD_UPDATEPOLICYTIMESTAMP]'))
drop trigger [dbo].[TR_ADD_UPDATEPOLICYTIMESTAMP]
GO

CREATE TRIGGER dbo.TR_ADD_UPDATEPOLICYTIMESTAMP ON [Policy] 
FOR INSERT,UPDATE 
AS
BEGIN

	DECLARE @ParentType TINYINT
	DECLARE @ParentID INT
	SELECT @ParentType=ParentType,@ParentID=ParentID FROM inserted
	update thecount set thedata=1
	IF (@ParentType>2)  -- BranchNode
	BEGIN
	 UPDATE BranchNode SET PolicyTimestamp=@@DBTS WHERE AutoID=@ParentID
	END
	ELSE  -- LeafNode
	BEGIN
	 UPDATE LeafNode SET PolicyTimestamp=@@DBTS WHERE AutoID=@ParentID
	END

END
GO


----------------------------------------------
-- Task table
----------------------------------------------

-- delete trigger
-- If trigger was created outside dbo ownership, make sure it gets dropped
if exists (select * from sysobjects where id = object_id(N'[TR_EPO_DELTASKSETTINGS]'))
drop trigger [TR_EPO_DELTASKSETTINGS]
GO
if exists (select * from sysobjects where id = object_id(N'[dbo].[TR_EPO_DELTASKSETTINGS]'))
drop trigger [dbo].[TR_EPO_DELTASKSETTINGS]
GO

CREATE TRIGGER dbo.TR_EPO_DELTASKSETTINGS ON [Task] 
for delete
as
BEGIN

	delete TaskSettings where ParentID IN (select AutoID FROM deleted)

END
GO


-- delete trigger
-- If trigger was created outside dbo ownership, make sure it gets dropped
if exists (select * from sysobjects where id = object_id(N'[TR_DEL_UPDATETASKTIMESTAMP]'))
drop trigger [TR_DEL_UPDATETASKTIMESTAMP]
GO
if exists (select * from sysobjects where id = object_id(N'[dbo].[TR_DEL_UPDATETASKTIMESTAMP]'))
drop trigger [dbo].[TR_DEL_UPDATETASKTIMESTAMP]
GO

CREATE TRIGGER dbo.TR_DEL_UPDATETASKTIMESTAMP ON [Task] 
FOR DELETE 
AS
BEGIN

	DECLARE @ParentType TINYINT
	DECLARE @ParentID INT
	SELECT @ParentType=ParentType,@ParentID=ParentID FROM deleted
	update thecount set thedata=1
	IF (@ParentType>2)  -- BranchNode
	BEGIN
	 UPDATE BranchNode SET TaskTimestamp=@@DBTS WHERE AutoID=@ParentID
	END
	ELSE  -- LeafNode
	BEGIN
	 UPDATE LeafNode SET TaskTimestamp=@@DBTS WHERE AutoID=@ParentID
	END

END
GO


-- insert, update trigger
-- If trigger was created outside dbo ownership, make sure it gets dropped
if exists (select * from sysobjects where id = object_id(N'[TR_ADD_UPDATETASKTIMESTAMP]'))
drop trigger [TR_ADD_UPDATETASKTIMESTAMP]
GO
if exists (select * from sysobjects where id = object_id(N'[dbo].[TR_ADD_UPDATETASKTIMESTAMP]'))
drop trigger [dbo].[TR_ADD_UPDATETASKTIMESTAMP]
GO

CREATE TRIGGER dbo.TR_ADD_UPDATETASKTIMESTAMP ON [Task] 
FOR INSERT,UPDATE 
AS
BEGIN

	DECLARE @ParentType TINYINT
	DECLARE @ParentID INT
	SELECT @ParentType=ParentType,@ParentID=ParentID FROM inserted
	update thecount set thedata=1
	IF (@ParentType>2)  -- BranchNode
	BEGIN
	 UPDATE BranchNode SET TaskTimestamp=@@DBTS WHERE AutoID=@ParentID
	END
	ELSE  -- LeafNode
	BEGIN
	 UPDATE LeafNode SET TaskTimestamp=@@DBTS WHERE AutoID=@ParentID
	END

END
GO


----------------------------------------------
-- events table
----------------------------------------------

-- epo3.5 Insert trigger for events table
--	Change actiontaken, virustype and counter to actual tranalation codes
--	Get rid of table joins, major performance improvement without adding new data rows

-- If trigger was created outside dbo ownership, make sure it gets dropped
if exists (select * from sysobjects where id = object_id(N'[TR_EPO_INSEVENTS]'))
drop trigger [TR_EPO_INSEVENTS]
GO
if exists (select * from sysobjects where id = object_id(N'[dbo].[TR_EPO_INSEVENTS]'))
drop trigger [dbo].[TR_EPO_INSEVENTS]
GO

CREATE TRIGGER dbo.TR_EPO_INSEVENTS ON [Events] 
for insert
as
begin

	insert EventDayResolution 
		(autoid, nodeid, actionTaken, tvdeventid, yearmonthday, 
		YearWeek,  -- YearQuarter, 
		YearMonth, -- Year,
		virusname, productname, productversion, HostName, Username)
	select autoid, nodeid, actiontaken, tvdeventid 
		,convert(char,EventDateTime,102)  
		,DateName(Year, EventDateTime) + '-' + substring(convert(char(3), datepart( wk, EventDateTime) + 100), 2, 2)
		,Substring(convert(char,EventDateTime,120),1,7)
		,virusname, productname, productversion, HostName, Username
	from inserted
	where virusname > '' and ActionTaken > 0
		and TVDEventid != 1506 and TVDEventid != 4600

end
Go

-- epo3.5 patch4:  must remove events table delete trigger (EventDayResolution data deleted separately)

-- If trigger was created outside dbo ownership, make sure it gets dropped
if exists (select * from sysobjects where id = object_id(N'[TR_EPO_DELEVENTS]'))
drop trigger [TR_EPO_DELEVENTS]
GO
if exists (select * from sysobjects where id = object_id(N'[dbo].[TR_EPO_DELEVENTS]'))
drop trigger [dbo].[TR_EPO_DELEVENTS]
GO




----------------------------------------------
--  ServerTask table
----------------------------------------------

-- If trigger was created outside dbo ownership, make sure it gets dropped
if exists (select * from sysobjects where id = object_id(N'[TR_EPO_DELSERVERTASKSETTINGS]'))
drop trigger [TR_EPO_DELSERVERTASKSETTINGS]
GO
IF EXISTS (SELECT * FROM sysobjects WHERE name = 'TR_EPO_DELSERVERTASKSETTINGS')
DROP TRIGGER dbo.TR_EPO_DELSERVERTASKSETTINGS
GO 

CREATE TRIGGER dbo.TR_EPO_DELSERVERTASKSETTINGS ON [ServerTask] 
FOR DELETE
as
BEGIN

	DELETE ServerTaskSetting WHERE ParentID IN (SELECT AutoID FROM DELETED)
	DELETE ComplianceRule WHERE ServerTaskID IN (SELECT AutoID FROM DELETED)

END
GO

----------------------------------------------
--  ServerTaskType table
----------------------------------------------

-- If trigger was created outside dbo ownership, make sure it gets dropped
if exists (select * from sysobjects where id = object_id(N'[TR_EPO_DELSERVERTASKS]'))
drop trigger [TR_EPO_DELSERVERTASKS]
GO
IF EXISTS (SELECT * FROM sysobjects WHERE name = 'TR_EPO_DELSERVERTASKS')
DROP TRIGGER dbo.TR_EPO_DELSERVERTASKS
GO 

CREATE TRIGGER dbo.TR_EPO_DELSERVERTASKS ON [ServerTaskType] 
for delete
as
BEGIN
	delete ServerTask where TaskTypeCode IN (select TaskTypeCode FROM deleted)
END
GO



----------------------------------------------
--  PolicyTemplate table
----------------------------------------------

-- If trigger was created outside dbo ownership, make sure it gets dropped
if exists (select * from sysobjects where id = object_id(N'[TR_EPO_DELPOLICYTEMPLATE]'))
drop trigger [TR_EPO_DELPOLICYTEMPLATE]
GO
if exists (select * from sysobjects where id = object_id(N'[dbo].[TR_EPO_DELPOLICYTEMPLATE]'))
drop trigger [dbo].[TR_EPO_DELPOLICYTEMPLATE]
GO

CREATE TRIGGER dbo.TR_EPO_DELPOLICYTEMPLATE ON [PolicyTemplate] 
FOR DELETE 
AS
BEGIN
	--Delete the PolicyTemplateSettings
	DELETE PolicyTemplateSetting WHERE ParentID IN (Select AutoID from deleted)
END
GO

----------------------------------------------
--  PolicyTemplateFolder table
----------------------------------------------

-- If trigger was created outside dbo ownership, make sure it gets dropped
if exists (select * from sysobjects where id = object_id(N'[TR_EPO_DELPOLICYTEMPLATEFOLDER]'))
drop trigger [TR_EPO_DELPOLICYTEMPLATEFOLDER]
GO
if exists (select * from sysobjects where id = object_id(N'[dbo].[TR_EPO_DELPOLICYTEMPLATEFOLDER]'))
drop trigger [dbo].[TR_EPO_DELPOLICYTEMPLATEFOLDER]
GO

CREATE TRIGGER dbo.TR_EPO_DELPOLICYTEMPLATEFOLDER ON [PolicyTemplateFolder] 
FOR DELETE 
AS
BEGIN
	--Delete the PolicyTemplates
	DELETE PolicyTemplate WHERE ParentID IN (Select AutoID from deleted)
END
GO

----------------------------------------------
--  Mapping_Points table
----------------------------------------------

-- If trigger was created outside dbo ownership, make sure it gets dropped
if exists (select * from sysobjects where id = object_id(N'[TR_EPO_DeleteFrom_Mapping_Points]'))
drop trigger [TR_EPO_DeleteFrom_Mapping_Points]
GO
if exists (select * from sysobjects where id = object_id(N'[dbo].[TR_EPO_DeleteFrom_Mapping_Points]'))
drop trigger [dbo].[TR_EPO_DeleteFrom_Mapping_Points]
GO

CREATE trigger dbo.TR_EPO_DeleteFrom_Mapping_Points on Mapping_Points
for delete
as
BEGIN
	--Delete the Exclusions
	DELETE Mapping_Exclusions WHERE ParentID IN (Select AutoID from deleted)
END
GO




----------------------------------------------------
-- end with comment to make sure last GO has a CR
----------------------------------------------------

