﻿var APPLY_BUTTON = 0;

var g_szGlobalTaskID = "";
var g_szOldTaskName = "";
var g_bSaved = false;

function fnOnLoad()
{
}

// Load the task name
function fnLoadTaskName(szTaskID)
{
	var bReturn = false;
	var objClientTasks = new Object();
	var dwError = parent.salID_EPO.fnGetClientTasks(objClientTasks);
	var bOK = (dwError == 0);
	
	if(bOK)
	{
		var xmldomClientTasks = new ActiveXObject("MSXML.DOMDOCUMENT");
		var szClienttasks = objClientTasks.xmlClientTasks;
		var regExp = /&amp;/g
		
		bOK = xmldomClientTasks.loadXML(szClienttasks.replace(regExp, "&amp;amp;"));
	}
	
	if(bOK)
	{
		var nodeTaskList = xmldomClientTasks.selectNodes("//tasklist/record");
		bOK = (nodeTaskList != null);
	}
	
	if(bOK)
	{
		for(var i = 0; i < nodeTaskList.length; i++)
		{
			var nodeTask = nodeTaskList.nextNode();
			
			var szTestID = nodeTask.selectSingleNode("gid").nodeTypedValue;

			if (szTestID == szTaskID)
			{
				g_szOldTaskName = nodeTask.selectSingleNode("name").nodeTypedValue;
				inputtextID_Name.value = g_szOldTaskName;
				
				bReturn = true;
			}
		}		
	}
	
	return bReturn;
}


// Load the task-type name and description.
function fnLoadTaskStrings(szProductID)
{
	var objClientTaskTypes = new Object();
	var dwError = parent.salID_EPO.fnGetClientTaskTypes(objClientTaskTypes);
	var bOK = (dwError == 0);
	var bReturn = false;
	
	if(bOK)
	{
		var xmldomClientTaskTypes = new ActiveXObject("MSXML.DOMDOCUMENT");
		bOK = xmldomClientTaskTypes.loadXML(objClientTaskTypes.xmlClientTaskTypes);
	}
	
	if(bOK)
	{
		var nodelistTaskType = xmldomClientTaskTypes.selectNodes("//tasktype");
		bOK = (nodelistTaskType.length > 0);
	}
	
	if(bOK)
	{
		for(var i=0; i<nodelistTaskType.length; i++)
		{
			nodeTaskType = nodelistTaskType.nextNode();
			
			if (nodeTaskType.parentNode.getAttribute("id") == szProductID)
			{
				labelID_Software.innerText = nodeTaskType.parentNode.getAttribute("name");
				labelID_Tasktype.innerText = parent.d_szTaskDisplayType;

				bReturn = true;
				break;
			}
		}
	}
	
	return bReturn;
}


function fnLoadTask()
{
	var oParams = parent.salID_EPO.fnParseURL(window.location.href);
	var objTaskSchedule = new Object();
	var bOK = true;
	
	if(oParams.szGID != "")
	{
		if(bOK)
		{
			bOK = fnLoadTaskName(oParams.szGID);
		}
	
		if (bOK)
		{
			g_szGlobalTaskID = oParams.szGID;
			parent.salID_EPO.fnStartModifyTask(g_szGlobalTaskID, false);
			var dwError = parent.salID_EPO.fnGetTaskScheduleXML(oParams.szGID, objTaskSchedule);
			bOK = (dwError == 0);
		}
		
		if(bOK)
		{
	
			if(parseInt(objTaskSchedule.szStopAfterMinutes, 10) > 0)
			{
				var dwHour = parseInt(objTaskSchedule.szStopAfterMinutes, 10) / 60;
				var szHour = dwHour.toString()
				var dwIndex = szHour.indexOf('.');
				
				if(dwIndex != -1)
					textboxID_Hours.value = szHour.substring(0, dwIndex);
				else
					textboxID_Hours.value = szHour;
				
				textboxID_Minutes.value = parseInt(objTaskSchedule.szStopAfterMinutes, 10) % 60;
				checkboxID_StopDuration.bChecked = true;
				
			}

			htcID_ScheduleSettings.fnLoadScheduleSettings(objTaskSchedule);
			checkboxID_Inherit.bChecked = objTaskSchedule.bInheritted;
			checkboxID_Enabled.bChecked = objTaskSchedule.bEnabled;
			fnOnInheritClick(checkboxID_Inherit);
		}
	}
	else
	{
		var objTask = new Object();
		var dwError = parent.salID_EPO.fnCreateNewTask(oParams.szPrdID, oParams.szTType, objTask);
		var bOK = (dwError == 0);
		
		if(bOK)
		{
			g_szGlobalTaskID = objTask.lGlobalTaskID.toString();
			parent.salID_EPO.fnStartModifyTask(g_szGlobalTaskID, true);
			checkboxID_Enabled.bChecked = true;
			fnOnStopDuration(true);
		}
	}
	
	if(bOK)
	{
		parent.fnShowContentTitle("CLIENT_SCHED_TASKS");
		parent.fnSetTab("SCHEDULED_TASKS");
		htcID_ToolBar.fnCreateToolbar("../XML/Toolbar/EPO100_ToolBarEditClientTask.xml");
		htcID_ToolBar.fnSetDisabled(APPLY_BUTTON, true);
	}

	if(bOK)
	{
		bOK = fnLoadTaskStrings(oParams.szPrdID);
		
		if(!bOK)
		{
		}
	}
}	

function fnToolbarClick()
{
	szAction = event.szValue;

	switch(szAction)
	{
		case "CANCEL":
			g_bSaved = true;
			window.location.href = "../XML/EPO100_ClientTasks.xml";
			break;
		case "SAVE":
			fnSaveSettings(false);
			break;
	}
}

function fnSaveSettings(bSilent)
{
	if(fnTrimEnd(inputtextID_Name.value) != "")
	{
		var objScheduleSettings = new Object();
		
		var bOK = htcID_ScheduleSettings.fnReadScheduleSettings(objScheduleSettings);
		
		if (bOK)
		{
			objScheduleSettings.szDisplayName = inputtextID_Name.value;
			objScheduleSettings.bInheritted = checkboxID_Inherit.bChecked;
			objScheduleSettings.bEnabled = checkboxID_Enabled.bChecked;
			
			if(textboxID_Hours.value == "")
				textboxID_Hours.value = "0";
				
			if(textboxID_Minutes.value == "")
				textboxID_Minutes.value = "0";
			
			if (checkboxID_StopDuration.bChecked)
				objScheduleSettings.dwStopAfterMinutes = parseInt(textboxID_Hours.value) * 60 + parseInt(textboxID_Minutes.value);
			else
				objScheduleSettings.dwStopAfterMinutes = 0;

			var dwError = parent.salID_EPO.fnEndModifyTask(parseInt(g_szGlobalTaskID, 10), true, objScheduleSettings);
			bOK = (dwError == 0);
		}
		
		if(bOK)
		{
			g_bSaved = true;
			htcID_ToolBar.fnSetDisabled(APPLY_BUTTON, false);
			
			if (!bSilent)
				window.location.href = "../XML/EPO100_ClientTasks.xml";
		}
	}
	else
	{
		if (!bSilent)
		{
			alert(g_szNoTaskName);
			inputtextID_Name.focus();
		}
	}
}

function fnOnModifySettings()
{
	htcID_ToolBar.fnSetDisabled(APPLY_BUTTON, false);
}

function fnShowTaskHTML()
{
	var oParams = parent.salID_EPO.fnParseURL(window.location.href);

	dwRet = parent.salID_EPO.fnShowTaskHTML(oParams.szPrdID, oParams.szTType);
	
	if (dwRet == 1)
		fnOnModifySettings();
}

function fnOnInheritClick(objID)
{
	var bState = objID.bChecked;
	document.getElementById("checkboxID_Enabled").disabled			= bState;
	document.getElementById("checkboxID_StopDuration").disabled		= bState;
	document.getElementById("htcID_ScheduleSettings").disabled		= bState;
	
	fnOnStopDuration(bState);
}

function fnOnUnload()
{
	if(!g_bSaved)
	{
		if(confirm(g_szModifyValues))
			fnSaveSettings(true);
		else
			parent.salID_EPO.fnEndModifyTask(parseInt(g_szGlobalTaskID, 10), false);
	}
	else
		parent.salID_EPO.fnEndModifyTask(parseInt(g_szGlobalTaskID, 10), false);
}

function fnOnStopDuration(bState)
{
	
	var bLocalState = (!document.getElementById("checkboxID_StopDuration").bChecked) || bState;
	
	document.getElementById("labelID_Hours").disabled			= bLocalState;
	document.getElementById("labelID_Minutes").disabled			= bLocalState;
	
	document.getElementById("textboxID_Hours").bDisabled		= bLocalState;
	document.getElementById("textboxID_Minutes").bDisabled		= bLocalState;
}

function fnShowHelp()
{
	parent.salID_EPO.fnDisplayHelp("Scheduled_Tasks_Add_Edit_page.html");
}

function fnTrimEnd(szStr)
{
	var bOK = false;
	var dwError = 0;
	
	bOK = (szStr != null);
	
	if(bOK)
	{
		var dwLength = szStr.length;
		bOK = (dwLength > 0);
	}
	
	if(bOK)
	{
		for(var dwIndex=dwLength; dwIndex>0; dwIndex--)
		{
			if(szStr.substring(dwIndex-1, dwIndex) != " ")
				break;
		}
	}
	
	return szStr.substring(0, dwIndex);
}
