﻿var d_szTaskDisplayType = "";

function fnOnLoad()
{
}

function fnClearTabs()
{
	tabstripID_Main.fnClearTabs();
}

function fnLoadTabs(dwNodeType)
{
	fnClearTabs();

	switch(dwNodeType)
	{
		case NODETYPE_LOG_ON:
			tdID_MasterHeader.innerText = rc_szWelcomeMessage;
			break;
	
		case NODETYPE_HOME:
			tdID_Home.style.background = "#CC0033";
			tdID_MasterHeader.innerText = rc_szHome;
			break;
			
		case NODETYPE_SERVER:
			tdID_Server.style.background = "#CC0033";
			tabstripID_Main.fnCreateTabs("EPO100_TabStripServer.xml");
			tdID_MasterHeader.innerText = rc_szServer;
			break;
			
		case NODETYPE_ALL_COMPUTERS:
			tdID_AllComputers.style.background = "#CC0033";
			tabstripID_Main.fnCreateTabs("EPO100_TabStripAllComputers.xml");
			tdID_MasterHeader.innerText = rc_szAllComputers;
			break;

		case NODETYPE_SITE:
		case NODETYPE_GROUP:
			tdID_AllComputers.style.background = "#CC0033";
			tabstripID_Main.fnCreateTabs("EPO100_TabStripGroup.xml");
			tdID_MasterHeader.innerText = rc_szAllComputers + " > " + parent.salID_EPO.currentNodeName;
			break;
			
		case NODETYPE_COMPUTER:
			tdID_AllComputers.style.background = "#CC0033";
			tabstripID_Main.fnCreateTabs("EPO100_TabStripComputer.xml");
			tdID_MasterHeader.innerText = rc_szAllComputers + " > " + parent.salID_EPO.currentNodeParent + " > " + parent.salID_EPO.currentNodeName;
			break;
			
		case NODETYPE_LAF:
			tdID_AllComputers.style.background = "#CC0033";
			tabstripID_Main.fnCreateTabs("EPO100_TabStripLAF.xml");
			tdID_MasterHeader.innerText = rc_szLostAndFound;
			break;
	}
}

function fnOnSelectedIndexChange()
{
	szTabValue = event.szValue;

	fnLoadTabContent(szTabValue);
}

function fnSetTab(szTabName)
{
	tabstripID_Main.fnShowTab(szTabName);
}

function fnLoadTabContent(szURL)
{
	parent.frames.frameName_Main.location = szURL;
}


////////// Utility bar functions ///////////////


function fnShowUtilityBar()
{
	//tableID.style.display = "inline";
	
	tdID_Home.style.display = "inline";
	tdID_Server.style.display = "inline";
	tdID_AllComputers.style.display = "inline";
	tdID_LogOff.style.display = "inline";
}

function fnHideUtilityBar()
{
	tableID.style.display = "none";
}

function fnOnClickUtilityBar(szType)
{
	switch(szType)
	{
		case "LOG_OFF":
				parent.salID_EPO.fnConsoleTaskNotify(TASK_ROOT_LOGOFF, "");
			break;
			
		case "HOME":
				parent.salID_EPO.fnGotoNode(NODETYPE_HOME, "");
			break;
			
		case "SERVER":
				parent.salID_EPO.fnGotoNode(NODETYPE_SERVER, "");
			break;
			
		case "ALL_COMPUTERS":
				parent.salID_EPO.fnGotoNode(NODETYPE_ALL_COMPUTERS, "");
			break;
			
		default:
				alert("Not implemented yet: " + szType);
			break;
	}
}



/////////////// Page Title and sub-tab functions ///////////////


function fnShowContentTitle(szTitle)
{
	tableID_PageTitle.style.display = "inline";

	var bShowPrintButton = true;

	switch(szTitle)
	{
		case "LOG_ON":
			szTitle = rc_szTitleLogOn;
			break;				
	
		case "HOME":
			szTitle = rc_szTitleHome;
			break;
				
		case "AVERT_ALERTS":
			szTitle = rc_szTitleAvertAlerts;
			break;

// SERVER NODE

		case "SERVER_GENERAL":
			szTitle = rc_szTitleServerGeneral;
			break;
			
		case "SERVER_LOG":
			szTitle = rc_szTitleServerLog;
			break;
		
		case "SERVER_SETTINGS":
			szTitle = rc_szTitleServerSettings;
			break;
			
		case "SERVER_PROXY":
			szTitle = rc_szTitleServerProxy;
			break;
			
		case "SERVER_REPOSITORY":
			szTitle = rc_szTitleServerRepositories;
			break;

		case "ALL_COMPUTERS_GENERAL":
			szTitle = rc_szTitleAllComputersGeneral;
			break;
			
		case "GROUP_GENERAL":
			szTitle = fnInsertNodeName(rc_szTitleGroupGeneral);
			break;
			
		case "COMPUTER_GENERAL":
			szTitle = fnInsertNodeName(rc_szTitleComputerGeneral);
			break;
			
		case "CLIENT_SCHED_TASKS":
				switch(parent.salID_EPO.currentNodeType)
				{
					case NODETYPE_COMPUTER:
						szTitle = fnInsertNodeName(rc_szTitleComputerScheduledTasks);
						break;
						
					case NODETYPE_ALL_COMPUTERS:
						szTitle = rc_szTitleAllComputersScheduledTasks;
						break;
					
					case NODETYPE_SITE:
					case NODETYPE_GROUP:
					case NODETYPE_LAF:
						szTitle = fnInsertNodeName(rc_szTitleGroupScheduledTasks);
						break;
				}
			break;
					
		case "COMPUTER_LOG":
			szTitle = fnInsertNodeName(rc_szTitleComputerLog);
			break;
						
		case "GROUP_IP_MANAGEMENT":
			szTitle = fnInsertNodeName(rc_szTitleGroupIPSorting);
			break;
			
		case "POLICIES":
				switch(parent.salID_EPO.currentNodeType)
				{
					case NODETYPE_COMPUTER:
						szTitle = fnInsertNodeName(rc_szTitleComputerPolicies);
						break;
					case NODETYPE_ALL_COMPUTERS:
						szTitle = rc_szTitleAllComputersPolicies;
						break;
					case NODETYPE_SITE:
					case NODETYPE_GROUP:
					case NODETYPE_LAF:
						szTitle = fnInsertNodeName(rc_szTitleGroupPolicies);
						break;
				}
			break;
			
		case "PRODUCT_PROPERTIES":
			szTitle = fnInsertNodeName(rc_szTitleComputerProductProperties);
			break;
			
		case "COMPUTER_PROPERTIES":
			szTitle = fnInsertNodeName(rc_szTitleComputerProperties);
			break;
			
		case "UPDATE_HISTORY":
			szTitle = fnInsertNodeName(rc_szTitleComputerUpdateHistory);
			break;
			
		case "COMPLIANCE_LIST":
			if ( (parent.salID_EPO.currentNodeType == NODETYPE_ALL_COMPUTERS) || (parent.salID_EPO.currentNodeType == NODETYPE_HOME) )
				var szName = rc_szAllComputers;
			else
				var szName = parent.salID_EPO.currentNodeName;
			
			szTitle = rc_szTitleCommonComplianceDetails + ' "' + szName + '"';
			break;
			
		case "DETECTION_LIST":
			if ( (parent.salID_EPO.currentNodeType == NODETYPE_ALL_COMPUTERS) || (parent.salID_EPO.currentNodeType == NODETYPE_HOME) )
				var szName = rc_szAllComputers;
			else
				var szName = parent.salID_EPO.currentNodeName;
				
			szTitle = rc_szTitleCommonDetectionDetails + ' "' + szName + '"';
			break;

		default:
			szTitle = '';
	}
	
	tdID_Title.innerText = szTitle;
}

function fnInsertNodeName(szText)
{
	szReturn = szText.replace("$nodename", parent.salID_EPO.currentNodeName);
	return szReturn;
}

function fnHideContentTitle()
{
	tableID_PageTitle.style.display = "none";
}

function fnCommonTaskClick(szAction)
{
	switch(szAction)
	{
		case "BACK":
			parent.fnBack();
			break;
		case "PRINT":
			if(typeof(parent.frames.frameName_Main.fnPrinterFriendly) == "function")
				parent.frames.frameName_Main.fnPrinterFriendly();
			//else
			//	alert("Print functionality is not implemented yet.");
			break;
		case "HELP":
			if(typeof(parent.frames.frameName_Main.fnShowHelp) == "function")
				parent.frames.frameName_Main.fnShowHelp();
			//else
			//	alert("Help content is not available yet.");
			break;
			
		default:
			alert("Action not implemented : " + szAction);
	}
}


function fnShowSubTabs(szXMLPath)
{
	tdID_SubTabStrip.style.display = "inline";
	htcID_SubTabs.fnCreateTabs(szXMLPath);
}

function fnHideSubTabs()
{
	tdID_SubTabStrip.style.display = "none";
}

function fnSetSubTab(szTabName)
{
	htcID_SubTabs.fnShowTab(szTabName);
}

function fnOnSubTabChange()
{
	szTabValue = event.szValue;

	fnSubTabCallback(szTabValue);
}

function fnSubTabCallback()
{
	// empty by default..
}