-- PRP 1.1 to 1.1.1 SQL updates

--------------------------------------------------------
-- Fetch Compliance Definition
-- SMBSP_FetchComplianceDefinition

if exists (select * from sysobjects where id = object_id(N'[dbo].[SMBSP_FetchComplianceDefinition]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[SMBSP_FetchComplianceDefinition]
GO

CREATE PROCEDURE dbo.SMBSP_FetchComplianceDefinition
(
 @szOptionalReportParms  VARCHAR(500)
)
AS
BEGIN

/*AVISP_ReportParmLoadProductSettingMonitor*/
 /* Copyright c 1995-2001 Networks Associates Technology, Inc. All Rights Reserved.*/


   Declare @szLang VARCHAR(3)
   Declare @szFullLang VARCHAR(5)
   Declare @szDefaultLang VARCHAR(5)
   Declare @szLanguageID VARCHAR(5)
   Declare @szTime VARCHAR(10)
   Declare @szFilter VARCHAR(50)
   Declare @szReportID VARCHAR(50)
   Declare @szRptGroup VARCHAR(50)
   Set @szLanguageID = '0409'   
   Set @szLang = '09'
   Set @szFullLang = '0'
   Set @szTime = 'GMT'
   Set @szReportID = 'ASCI'


   if @szOptionalReportParms > ''
   	Execute AVISP_GetReportParms2 @szOptionalReportParms, 
		@szLang OUTPUT, @szFullLang OUTPUT, @szTime OUTPUT, 
		@szFilter OUTPUT, @szReportID OUTPUT,
		@szRptGroup OUTPUT


   SELECT 	@szDefaultLang = DefaultLanguageID 
      FROM	ReportLanguageID
      WHERE	ActualLanguageID = @szFullLang


   /* determine language to use */
        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szDefaultLang

        select @szLanguageID=LanguageID from ReportTextStrings where LanguageID = @szFullLang


----------------------
-- eposmb: check which part of compliance defn changed

	-- Has compliance def'n possibly changed
	Declare @ComplianceDefnMayChange int
	Declare @ProdVerComplianceDefnMayChange int
	Declare @DATComplianceDefnMayChange int
	Declare @ENGComplianceDefnMayChange int
	Declare @ComplianceRedoRollup int
	Select 	@ComplianceDefnMayChange=ComplianceDefnMayChange, 
		@ProdVerComplianceDefnMayChange=ProdVerComplianceDefnMayChange, 
		@DATComplianceDefnMayChange=DATComplianceDefnMayChange, 
		@ENGComplianceDefnMayChange=ENGComplianceDefnMayChange,
		@ComplianceRedoRollup=ComplianceRedoRollup
		from smbCheckpoint


	Declare @ComplianceDefnMayChange1 int
	Declare	@ProdVerChange1 int
	Declare	@AgentChange1 int
	Declare	@DATChange1 int
	Declare	@ENGChange1 int
	Select
	 	@ComplianceDefnMayChange1=count(*)
		,@ProdVerChange1=sum(ProdVerChange)
		,@AgentChange1=sum(AgentChange)
		,@DATChange1=sum(DATChange)
		,@ENGChange1=sum(ENGChange)
		from smbTmpComplianceDefn

	if @ComplianceDefnMayChange > 0 or @ComplianceDefnMayChange1 > 0
		Set @ComplianceDefnMayChange = 1
	-- if scanner or agent version changes, check both
	if @ProdVerComplianceDefnMayChange > 0 or @ProdVerChange1 > 0 or @AgentChange1 > 0
		Set @ProdVerComplianceDefnMayChange = 1
	-- if either dat or engine changes, check both
	if @ENGComplianceDefnMayChange > 0 or @ENGChange1  > 0 or @DATComplianceDefnMayChange > 0 or @DATChange1 > 0
	Begin
		Set @ENGComplianceDefnMayChange = 1 
		Set @DATComplianceDefnMayChange = 1
	End

-----------------------------------------
-- Dynamically check DB for any new products that needs to be added to the compliance list

 
IF @szReportID = 'COMPLIANCEISSUES'
BEGIN

-- Check for any new products that need to have their settings loaded in the report metadata tables

------------------------------
-- ReportInputParameters table
-- Create any new inputs dynamically for now

--truncate table ReportPropertySettings 
--GO


Declare @cnt int
Declare @ret int
set @ret=0

------------------------------------------------------------------------------------------
-- get product version list, assume everything is new

if @ProdVerComplianceDefnMayChange > 0
Begin

	IF EXISTS (select * from sysobjects where name = 'tmpProdVerList' 
	   and xtype = 'U')
	  DROP TABLE dbo.tmpProdVerList

	-- find the max version for each product type
--	if @ComplianceRedoRollup = 0   -- do fast check using smbTmpComplianceDefn
--	Begin	
		select distinct SoftwareName, 
			max(ProductVersion) as ProductVersion, 
			1 as new, 
			ProductFamily,
			case
			when charindex('.',substring(max(ProductVersion),6,4)) = 0
				then max(ProductVersion)
			when charindex('.',substring(max(ProductVersion),6,4)) > 0
				then substring(max(ProductVersion),1,4+charindex('.',substring(max(ProductVersion),6,4)))
			end as ProductVersionNoBuildnum
		into dbo.tmpProdVerList
		from smbTmpComplianceDefn
		where 
			( ProductFamily in ('TVD', 'TVD_NC', 'SECURE')
				or (ProductFamily = 'EPO' and ProductCode Like 'EPOAGENT%') 
				or ProductFamily like ('TVD_NC_%') )
			and ProductVersion != '5000'
		Group By
		SoftwareName, ProductFamily



	-- check if any products are not in the compliance report product list
	-- set all matches back to zero (not new)
	
	update dbo.tmpProdVerList
	set new = 0
	from ReportInputParameters
	where 
	ReportInputParameters.ReportID = 'COMPLIANCEISSUES'
	and ReportInputParameters.CustPageName  = 'ProductVersions'
	and ReportInputParameters.ParmName = dbo.tmpProdVerList.SoftwareName
	
	-- eposp2 
	-- Update existing products whose versions have changed
	update ReportInputParameters
	set ReportInputParameters.ParmValue = dbo.tmpProdVerList.ProductVersion,
	ReportInputParameters.ParmValuePrompt = dbo.tmpProdVerList.ProductVersion,
	ReportInputParameters.DBFldName = dbo.tmpProdVerList.ProductFamily,
	ReportInputParameters.ParmValueAlternative = dbo.tmpProdVerList.ProductVersionNoBuildnum
	from dbo.tmpProdVerList
	where 
	ReportInputParameters.ParmName = dbo.tmpProdVerList.SoftwareName
	and dbo.tmpProdVerList.ProductVersion > ReportInputParameters.ParmValue
	and ReportInputParameters.ReportID = 'COMPLIANCEISSUES'



	-- add any new products
	
	INSERT ReportInputParameters 
	( 	ReportID, RptGroupID
		, ParmName, DBFldName, ParmValue, ParmValuePrompt, ParmValueAlternative
		, Prompt, PDesc 
		, CustPageName 
		, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
		, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
	)
	select 'COMPLIANCEISSUES', '' 
	, dbo.tmpProdVerList.SoftwareName as ParmName
	, dbo.tmpProdVerList.ProductFamily as DBFldName
	, dbo.tmpProdVerList.ProductVersion as ParmValue
	, dbo.tmpProdVerList.ProductVersion as ParmValuePrompt
	, dbo.tmpProdVerList.ProductVersionNoBuildnum as ParmValueAlternative
	, dbo.tmpProdVerList.SoftwareName as Prompt, 'Enter Minimum Compliant Version' as PDesc
	, 'ProductVersions'
	, 0, 1, 0, 0
	, 0, 0, 0, 0
	from dbo.tmpProdVerList
	where 
		new = 1
	
	set @ret = @ret + @@rowcount


	-- eposmb
	-- hardcoded cleanup: Product can change names but still be tied to just one compliant version
	-- If virusscan enterprise version as compliance defn for virusscan enterprise & virusscan
	-- Set secondary name to the product version of the primary name
	
	Update smbComplianceNameEquivalents
		Set PrimaryProductVersion = ParmValue
		from ReportInputParameters
		Where PrimaryName = ParmName
			and ReportInputParameters.ReportID = 'COMPLIANCEISSUES'

	--		and ParmValue > PrimaryProductVersion
	
	Update ReportInputParameters
		Set ParmValue = PrimaryProductVersion, 
			ParmValuePrompt = PrimaryProductVersion,
			ParmValueAlternative = ProductVersionNoBuildno
		from smbComplianceNameEquivalents
		Where ParmName = SecondaryName
		and ReportInputParameters.ReportID = 'COMPLIANCEISSUES'

	
	
	-- special code: remove virusscan7 .wrk & .srv suffix
	-- This needs to be the last step in checking for product version compliance
	Update ReportInputParameters
		Set ParmValue = Replace(Replace(ParmValue,'.wrk',''),'.srv',''),
			ParmValuePrompt = Replace(Replace(ParmValuePrompt,'.wrk',''),'.srv','')
		Where
			ReportInputParameters.ReportID = 'COMPLIANCEISSUES'

	Update ReportInputParameters
		Set ParmValue = Replace(Replace(ParmValue,'wrk',''),'srv',''),
			ParmValuePrompt = Replace(Replace(ParmValuePrompt,'wrk',''),'srv','')
		Where
			ReportInputParameters.ReportID = 'COMPLIANCEISSUES'

	-- artificially set Norton compliance version high so its always uncompliant
	-- stinger also uses tvd_nc??????? It shouldnt, NC means norton
	Update ReportInputParameters
		Set ParmValue = '9.9.9999'
			,ParmValuePrompt = '9.9.9999'
			,ParmValueAlternative = '9.9.9999'
		from aviview_software
		Where
			ReportInputParameters.DBFldName = aviview_software.ProductFamily
			and ReportInputParameters.ReportID = 'COMPLIANCEISSUES'
			and DBFldName = 'TVD_NC'
			and aviview_software.productcode like 'NORTONAV%'
			and ParmName like 'Norton%'


	-- cleanup
	
	drop table dbo.tmpProdVerList

End



---------------------------------------------------------------------------------------------------
-- get DAT version list, assume everything is new
-- Gets version for each productfamily, not each product
-- load any future dat/engines with productfamily = 'TVD_NC%' naming convention

if @DATComplianceDefnMayChange > 0
Begin

	IF EXISTS (select * from sysobjects where name = 'tmpDATVerList' 
	   and xtype = 'U')
	  DROP TABLE dbo.tmpDATVerList
	
	-- find the max version for each product type
--	if @ComplianceRedoRollup = 0   -- do fast check using smbTmpComplianceDefn
--	Begin	
		select distinct ProductFamily as ProductFamily
			, min(SoftwareName) as SoftwareName
			, max(DATVer) as DATVer, 1 as new
		into dbo.tmpDATVerList
		from smbTmpComplianceDefn
		where 
			DATVer not in ('5000', 'N/A')
			and 
			(ProductFamily in ('TVD', 'TVD_NC')
				or ProductFamily like 'TVD_NC%')
		Group By
			ProductFamily
--	End
--	Else	-- delete done, redo whole calculation
--	Begin
--		select distinct AVIView_Software.ProductFamily as ProductFamily
--			, min(AVIView_Software.SoftwareName) as SoftwareName
--			, max(ProductProperties.DATVer) as DATVer, 1 as new
--		into dbo.tmpDATVerList
--		from ProductProperties, AVIView_Software
--		where 
--			ProductProperties.ProductCode =  AVIView_Software.ProductCode
--			and ProductProperties.DATVer not in ('5000', 'N/A')
--			and 
--			(ProductFamily in ('TVD', 'TVD_NC')
--				or ProductFamily like 'TVD_NC%')
--		Group By
--			AVIView_Software.ProductFamily
--	End



	-- check if any products are not in the compliance report product list
	-- set all matches back to zero (not new)
	
	update dbo.tmpDATVerList
	set new = 0
	from ReportInputParameters
	where 
	ReportInputParameters.ReportID = 'COMPLIANCEISSUES'
	and ReportInputParameters.CustPageName  = 'EngineDATs'
	and
	ReportInputParameters.ParmName = dbo.tmpDATVerList.ProductFamily + '_DATs'
	
	-- eposp2 
	-- Update existing products whose versions have changed
	update ReportInputParameters
	set ReportInputParameters.ParmValue = dbo.tmpDATVerList.DATVer,
	ReportInputParameters.ParmValuePrompt = dbo.tmpDATVerList.DATVer
	from dbo.tmpDATVerList
	where 
	ReportInputParameters.ParmName = dbo.tmpDATVerList.ProductFamily + '_DATs'
	and dbo.tmpDATVerList.DATVer > ReportInputParameters.ParmValue
	and ReportInputParameters.ReportID = 'COMPLIANCEISSUES'




	-- add any new products
	
	INSERT ReportInputParameters 
	( 	ReportID, RptGroupID
		, ParmName, DBFldName, ParmValue, ParmValuePrompt
		, Prompt, PDesc 
		, CustPageName 
		, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
		, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField
	)
	select 'COMPLIANCEISSUES', '' 
	, dbo.tmpDATVerList.ProductFamily + '_DATs' as ParmName, ''
	, dbo.tmpDATVerList.DATVer as ParmValue
	, dbo.tmpDATVerList.DATVer as ParmValuePrompt
	, dbo.tmpDATVerList.SoftwareName + '_DATs'  as Prompt, 'Enter Minimum Compliant Version' as PDesc
	, 'EngineDATs'
	, 0, 1, 0, 0
	, 0, 0, 0, 0
	from dbo.tmpDATVerList
	where 
		new = 1
	
	set @ret = @ret + @@rowcount


	-- eposmb 
	-- Override any existing dat version with repository stored values
	-- Must use software table because repository type is not in aviview_software
	update ReportInputParameters
	set ReportInputParameters.ParmValue = software.ProductVersion,
	ReportInputParameters.ParmValuePrompt = software.ProductVersion
	from software
	where 
	'upd_' + ReportInputParameters.ParmName = software.ProductFamily + '_DATs'
	and ReportInputParameters.ReportID = 'ComplianceIssues'
	and software.RepositoryType = 'Updates'
	-- bugfix2005-11 make sure that repository pupdat chnages particpate in compliance def'n  
	and software.SoftwareName in ('DAT','PUP DAT')



	-- cleanup
	
	drop table dbo.tmpDATVerList

End





---------------------------------------------------------------------------------------------------
-- get Engine version list, assume everything is new
-- Gets version for each productfamily, not each product


if @ENGComplianceDefnMayChange > 0
Begin


	IF EXISTS (select * from sysobjects where name = 'tmpEngineVerList' 
	   and xtype = 'U')
	  DROP TABLE dbo.tmpEngineVerList
	
	-- find the max version for each product type
--	if @ComplianceRedoRollup = 0   -- do fast check using smbTmpComplianceDefn
--	Begin	
		select distinct ProductFamily as ProductFamily
			, min(SoftwareName) as SoftwareName
			, max(EngineVer) as EngineVer, 1 as new
		into dbo.tmpEngineVerList
		from smbTmpComplianceDefn
		where 
			EngineVer not in ('5000', 'N/A')
			and (ProductFamily in ('TVD', 'TVD_NC')
			or ProductFamily like 'TVD_NC%')
		Group By
			ProductFamily
--	End
--	Else	-- delete done, redo whole calculation
--	Begin
--		select distinct AVIView_Software.ProductFamily as ProductFamily
--			, min(AVIView_Software.SoftwareName) as SoftwareName
--			, max(ProductProperties.EngineVer) as EngineVer, 1 as new
--		into dbo.tmpEngineVerList
--		from ProductProperties, AVIView_Software
--		where 
--			ProductProperties.ProductCode =  AVIView_Software.ProductCode
--			and ProductProperties.EngineVer not in ('5000', 'N/A')
--			and (ProductFamily in ('TVD', 'TVD_NC')
--			or ProductFamily like 'TVD_NC%')
--		Group By
--			AVIView_Software.ProductFamily
--	End


	-- check if any products are not in the compliance report product list
	-- set all matches back to zero (not new)
	
	update dbo.tmpEngineVerList
	set new = 0
	from ReportInputParameters
	where 
	ReportInputParameters.ReportID = 'COMPLIANCEISSUES'
	and ReportInputParameters.CustPageName  = 'EngineDATs'
	and ReportInputParameters.ParmName = dbo.tmpEngineVerList.ProductFamily + '_Engines'

	-- eposp2 
	-- Update existing products whose versions have changed
	update ReportInputParameters
	set ReportInputParameters.ParmValue = dbo.tmpEngineVerList.EngineVer,
	ReportInputParameters.ParmValuePrompt = dbo.tmpEngineVerList.EngineVer 
	from dbo.tmpEngineVerList
	where 
	ReportInputParameters.ParmName = dbo.tmpEngineVerList.ProductFamily + '_Engines'
	and dbo.tmpEngineVerList.EngineVer > ReportInputParameters.ParmValue
	and ReportInputParameters.ReportID = 'COMPLIANCEISSUES'




	-- add any new products
	
	INSERT ReportInputParameters 
	( 	ReportID, RptGroupID
		, ParmName, DBFldName, ParmValue, ParmValuePrompt
		, Prompt, PDesc 
		, CustPageName 
		, iType, iSaveUserEntry, iDefaultFlag ,iUseDefault
		, iCrystalParm, iCrystalFieldCust, iLocalizedField, iDBField 
	)
	select 'COMPLIANCEISSUES', '' 
	, dbo.tmpEngineVerList.ProductFamily  + '_Engines' as ParmName, ''
	, dbo.tmpEngineVerList.EngineVer as ParmValue
	, dbo.tmpEngineVerList.EngineVer as ParmValuePrompt
	, dbo.tmpEngineVerList.SoftwareName  + '_Engines'  as Prompt, 'Enter Minimum Compliant Version' as PDesc
	, 'EngineDATs'
	, 0, 1, 0, 0
	, 0, 0, 0, 0
	from dbo.tmpEngineVerList
	where 
		new = 1

	set @ret = @ret + @@rowcount
	
	-- eposmb 
	-- Override any existing engine version with repository stored values
	-- Must use software table because repository type is not in aviview_software
	update ReportInputParameters
	set ReportInputParameters.ParmValue = software.ProductVersion,
	ReportInputParameters.ParmValuePrompt = software.ProductVersion
	from software
	where 
	'upd_' + ReportInputParameters.ParmName = software.ProductFamily + '_Engines'
	and ReportInputParameters.ReportID = 'ComplianceIssues'
	and software.RepositoryType = 'Updates'
	and software.SoftwareName = 'Engine'


	-- cleanup
	
	drop table dbo.tmpEngineVerList


End

-- eposmb - Truncate table of recent changes
Truncate Table dbo.smbTmpComplianceDefn


-- need to create ProductFamilyDesc table, until then update the product family descriptions manually

if @DATComplianceDefnMayChange > 0 or @ENGComplianceDefnMayChange > 0
Begin

	update ReportInputParameters
	set Prompt = 'McAfee (DAT)'
	where 
	ReportID = 'COMPLIANCEISSUES'
	and ParmName = 'TVD_DATs' 
	
	update ReportInputParameters
	set Prompt = 'McAfee (ENG)'
	where 
	ReportID = 'COMPLIANCEISSUES'
	and ParmName = 'TVD_Engines' 
	
	update ReportInputParameters
	set Prompt = substring(ParmName, 8, len(ParmName)-12) + ' (DAT)'
	where 
	ReportID = 'COMPLIANCEISSUES'
	and ParmName like ('TVD_NC_%DATs') 
	and ParmName <> 'TVD_NC_DATs'
	
	update ReportInputParameters
	set Prompt = substring(ParmName, 8, len(ParmName)-15) + ' (ENG)'
	where 
	ReportID = 'COMPLIANCEISSUES'
	and ParmName like ('TVD_NC_%Engines') 
	and ParmName <> 'TVD_NC_Engines'
	
	update ReportInputParameters
	set Prompt = 'Symantec (DAT)'
	where 
	ReportID = 'COMPLIANCEISSUES'
	and ParmName = 'TVD_NC_DATs' 
	
	update ReportInputParameters
	set Prompt = 'Symantec (ENG)'
	where 
	ReportID = 'COMPLIANCEISSUES'
	and ParmName = 'TVD_NC_Engines' 

End

-- test

--select * 
--from ReportInputParameters
--where 
--    ReportInputParameters.ReportID =  'COMPLIANCEISSUES'

END

--return @ret

END
GO
---------------------------------




--------------------------------------
-- test populate procedures

if exists (select * from sysobjects where id = object_id(N'[SMBSP_PopulateSMBCompliance]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [SMBSP_PopulateSMBCompliance]
GO

CREATE PROCEDURE dbo.SMBSP_PopulateSMBCompliance AS
Begin

Truncate Table smbCompliance
delete ReportINputParameters where reportid in ('ComplianceIssues','OldComplianceIssues')

insert smbCompliance
(
 [AutoID],
 [ComputerName],
 [OSType],
 [OSVersion],
 [Type],
 [LastUpdate],
 [AgentVersion],
 [AVinstalls],
 [ProductCode],
 [ProductFamily],
 [ProductName],
 [ProductVersion], 
 [EngineVer],
 [DATVer],
 [ExtraDATNames],
 [Servicepack],
 [Hotfix],
 [FirstRecord],
 prodverchange, agentchange, datchange, engchange
)
Select
 LeafNode.AutoID,
-- case
--	when ComputerProperties.ComputerName is null then LeafNode.Nodename
--	else ComputerProperties.ComputerName
--	end ,
 Leafnode.NodeName,
 ComputerProperties.OSType,
 ComputerProperties.OSVersion,
 LeafNode.Type,
 LeafNode.LastUpdate,
 LeafNode.AgentVersion,
 LeafNode.AVinstalls,
 ProductProperties.ProductCode,
 AVIView_Software.ProductFamily,
 AVIView_Software.SoftwareName,
 ProductProperties.ProductVersion, 
 ProductProperties.EngineVer,
 ProductProperties.DATVer,
 ProductProperties.ExtraDATNames,
 ProductProperties.Servicepack,
 ProductProperties.Hotfix,
 case AVIView_Software.ProductFamily
	when 'TVD' then 1
	when 'TVD_NC_AntiSpyware' then 1
	else 0
	end as FirstRecord,
  1, 1, 1, 1 
From 
	(
	LeafNode 
	Left Outer Join ComputerProperties on (LeafNode.AutoID = ComputerProperties.ParentID)
	)
	Left outer Join 
	( ProductProperties 
		Join AVIView_Software on (ProductProperties.ProductCode = AVIView_Software.ProductCode
			      			AND ( aviview_Software.ProductFamily in ( 'TVD','TVD_NC','SECURE' )
							or aviview_Software.ProductFamily like 'TVD_NC%' ) )
	) on (LeafNode.AutoID = ProductProperties.ParentID)

	-- update agent version: dont rely on leafnode.agentversion
	update smbCompliance
	set agentversion = productproperties.productversion
	from productproperties
	where smbCompliance.autoid = productproperties.parentid
		and productproperties.productcode like 'epoagent%'

	
	-- roll changes here so that complaince defn is created
	Insert smbTmpComplianceDefn
	 ( SoftwareName, ProductVersion, 
		ProductCode, ProductFamily, EngineVer, DATVer,
		ProdVerChange, AgentChange, DATChange, ENGChange, RepositoryOrProperty) 
		Select
			ProductName, ProductVersion, 
			ProductCode, ProductFamily, EngineVer, DATVer,
			1, 1, 1, 1, 0
		From smbcompliance
		Group BY ProductName, ProductVersion, 
			ProductCode, ProductFamily, EngineVer, DATVer
	-- add agent
	Insert smbTmpComplianceDefn
	 ( SoftwareName, ProductVersion, 
		ProductCode, ProductFamily, EngineVer, DATVer,
		ProdVerChange, AgentChange, DATChange, ENGChange, RepositoryOrProperty) 
		Select
			SoftwareName, max(ProductVersion), 
			productProperties.ProductCode, 'EPO', '', '',
			0, 1, 0, 0, 0
		From productProperties, aviview_software
			where productProperties.productcode = aviview_software.productcode
				and productfamily = 'EPO'
			Group by SoftwareName, productProperties.ProductCode

	----------------------------------
	-- Rollup Compliance summary data
	
	-- Rollup Computer/product smbCompliance table into Computer summary table for accurate computer counts
	Select LeafNode.AutoID
	        , LeafNode.ParentID
		, case	
--			when sum(smbCompliance.UptoDateNotLate) > 0 then 1
			when (sum(smbCompliance.OutofDateNotLate) = 0 and sum(smbCompliance.Late) = 0) then 1
			else 0
			end as UptoDateNotLate
		, case
			when sum(smbCompliance.OutofDateNotLate) > 0 then 1
			else 0 
			end as OutofDateNotLate 
		, case
			when sum(smbCompliance.Late) > 0 then 1
			else 0
			end as Late
		, case
			when sum(smbCompliance.PendingChange) > 0 then 1
			else 0
			end as Pending
		, 1 as Total	
	Into #tmpComputerCompliance	
	From smbCompliance, LeafNode
	Where		
		smbCompliance.AutoID = LeafNode.AutoID
		and LeafNode.Type != 24
	Group by
		LeafNode.AutoID, LeafNode.ParentID
	
	Truncate table smbComplianceRollup

	Insert smbComplianceRollup
		Select BranchNode.AutoID, Branchnode.NodeName,
			sum(#tmpComputerCompliance.UptoDateNotLate), 
			sum(#tmpComputerCompliance.OutofDateNotLate), 
			sum(#tmpComputerCompliance.Late)
,			sum(#tmpComputerCompliance.Pending),
			count(*)		
		From #tmpComputerCompliance, BranchNode
		Where		
			BranchNode.AutoID = #tmpComputerCompliance.ParentID
--			and smbCompliance.AutoID = LeafNode.AutoID
		Group by
			BranchNode.AutoID, Branchnode.NodeName

	-- set checkpoint table to recheck compliance for all computers
	update smbCheckPoint
		set ComplianceDefnMayChange = 1, LastComplianceCheck = '1/1/2000',
			ProdVerComplianceDefnMayChange=1,
			DATComplianceDefnMayChange=1,
			ENGComplianceDefnMayChange=1

End
GO

-------------------

if exists (select * from sysobjects where id = object_id(N'[SMBSP_ProcessCurrentProductChanges]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [SMBSP_ProcessCurrentProductChanges]
GO

CREATE PROCEDURE SMBSP_ProcessCurrentProductChanges AS
Begin

	-- Make sure all McAfee software tables entries are marked as TVD
	-- Do this strange exception only for GroupShield 6000
	Declare @PFCnt int
	Set @PFCnt = 0
	Select @PFCnt = count(*) from Software
		Where 
--			( ProductCode like 'VIRUSCAN%' or ProductCode like 'GROUPSHD%' )
			ProductCode = 'GROUPSHD6000' 
			and ( ProductFamily = '' or ProductFamily is null ) 
	If @PFCnt > 0
		Update Software
		Set ProductFamily = 'TVD', SoftwareName = 'McAfee GroupShield'
		Where 
--			( ProductCode like 'VIRUSCAN%' or ProductCode like 'GROUPSHD%' )
			ProductCode = 'GROUPSHD6000' 
			and ( ProductFamily = '' or ProductFamily is null ) 

	
	-----------------------------------------------------------------------------
	-- Take snapshot of changes to have a fixed set to work with (codereview)
	-- any changes that come in while we are processing will be processed on the next run
	--truncate table smbCurrentProductChangesSnapshot
	-- using delete instead of truncate here because truncate may ignore the table lock when
	--  this routine is run concurrently causing data to be lost.
-- debug
--insert smbCurrentProductChangesLog  (AutoID,ProductFamily,ProductCode,SoftwareName,ProductVersion,EngineVer,DATVer,ProdVerChange,AgentChange,DATChange,ENGChange,InsertUpdate) 
--   select AutoID,'smbCurrentProductChanges:PF:'+ProductFamily,ProductCode,SoftwareName,ProductVersion,EngineVer,DATVer,ProdVerChange,AgentChange,DATChange,ENGChange,InsertUpdate from smbCurrentProductChanges

	delete smbCurrentProductChangesSnapshot
	insert smbCurrentProductChangesSnapshot select * from smbCurrentProductChanges
	delete smbCurrentProductChanges from smbCurrentProductChangesSnapshot
		where smbCurrentProductChanges.productcode = smbCurrentProductChangesSnapshot.productcode
			and smbCurrentProductChanges.productversion = smbCurrentProductChangesSnapshot.productversion
			and smbCurrentProductChanges.datver = smbCurrentProductChangesSnapshot.datver
			and smbCurrentProductChanges.enginever = smbCurrentProductChangesSnapshot.enginever

	declare @cntSnapshot int
	Set @cntSnapshot=0
	select @cntSnapshot=count(*) from smbCurrentProductChangesSnapshot

	-- v1.1 bugfix:20050131 : ignore entries having no product, dat and engine version
--	delete smbCurrentProductChangesSnapshot
--		where 
--			( ProductVersion = '' or ProductVersion is null )
--			and ( DATVer = '' or DATVer is null )
--			and ( EngineVer = '' or EngineVer is null )

	-- update software values in smbCurrentProductChangesSnapshot
	update smbCurrentProductChangesSnapshot
		set ProductFamily=aviview_software.ProductFamily, softwarename=aviview_software.softwarename
		from aviview_software
		where  smbCurrentProductChangesSnapshot.productcode= aviview_software.productcode
		        AND ( aviview_software.ProductFamily in ( 'TVD','TVD_NC','SECURE','EPO' )  
				or aviview_software.ProductFamily like 'TVD_NC%' ) 


	
	-- PRP 1.1 bugfix: If LN trigger insert fails (deadlock?), then smbCompliance entry with
	-- FirstRecord=1 will not be present and basic product information changes will not be recorded
	-- Check if record is missing, if so add it

	-- cleanup any empty records
	Delete smbCompliance
		from smbCurrentProductChangesSnapshot
		where (smbCompliance.productcode = '' or smbCompliance.productcode is null)
			and smbCompliance.FirstRecord = 0 
			and smbCurrentProductChangesSnapshot.autoid = smbCompliance.autoid

	-- add firstrecord=1 if missing
	Insert smbCompliance
	 ( AutoID, ComputerName, Type, ChangedSinceLastCheckpoint, ComplianceMayChange, FirstRecord,
		OutOfDate, ProdVerChange, AgentChange, DATChange, ENGChange,
		AgentVersion, ProductVersion, EngineVer, DatVer) 
	Select
	leafnode.AutoID, leafnode.NodeName, 1, 1, 1, 1, 1, 1, 1, 1, 1, '', '', '', ''  
	From smbCurrentProductChangesSnapshot, leafnode
	Where 
		smbCurrentProductChangesSnapshot.autoid = leafnode.autoid
		and smbCurrentProductChangesSnapshot.autoid not in
		(select smbCompliance.autoid from smbCompliance where FirstRecord=1)
	

---------------------------------------
-- LoggingCode test case: Keep log of trigger addition activity
--insert smbCurrentProductChangesLog  (AutoID,ProductFamily,ProductCode,SoftwareName,ProductVersion,EngineVer,DATVer,ProdVerChange,AgentChange,DATChange,ENGChange,InsertUpdate) 
--   select * from smbCurrentProductChangesSnapshot
--insert smbCurrentProductChangesLog  (AutoID,ProductFamily,ProductCode,SoftwareName,ProductVersion,EngineVer,DATVer,ProdVerChange,AgentChange,DATChange,ENGChange,InsertUpdate) 
--   select 0, '','Process Called',convert(char(30),getdate(),120),'','','', 0,0,0,0,999



	-- rollup changes for comparison to current compliance definition 
--	Truncate table smbTmpComplianceDefn
--	Do not truncate the table here since software table insert triggers may update it
	Insert smbTmpComplianceDefn
	 ( SoftwareName, ProductVersion, 
		ProductCode, ProductFamily, EngineVer, DATVer,
		ProdVerChange, AgentChange, DATChange, ENGChange, RepositoryOrProperty) 
		Select
			SoftwareName, ProductVersion, 
			ProductCode, ProductFamily, EngineVer, DATVer,
			ProdVerChange, AgentChange, DATChange, ENGChange, 0
		From smbCurrentProductChangesSnapshot
		Where 
			( smbCurrentProductChangesSnapshot.ProductVersion > '' 
			or smbCurrentProductChangesSnapshot.EngineVer > '' 
			or smbCurrentProductChangesSnapshot.DATVer > '' )
		Group BY SoftwareName, ProductVersion, 
			ProductCode, ProductFamily, EngineVer, DATVer, 
			ProdVerChange, AgentChange, DATChange, ENGChange
--		where inserted.productcode = aviview_software.productcode
--	        AND ( aviview_software.ProductFamily in ( 'TVD','TVD_NC','EPO','SECURE' )
--			or aviview_software.ProductFamily like 'TVD_NC%' ) 	

--test
--select 'smbTmpComplianceDefn',* from smbTmpComplianceDefn
 
	Declare @AgentChange int
	Set @AgentChange = 0
	select @AgentChange=count(*) from smbTmpComplianceDefn 
		where ProductFamily = 'EPO' and ProductVersion > ''

	Declare @ProductsInserted int
	Set @ProductsInserted = 0
	select @ProductsInserted=count(*) from smbCurrentProductChangesSnapshot where InsertUpdate = 1
				and ProductFamily != 'EPO'
	Declare @ProductsInsertedNotVS int
	Set @ProductsInsertedNotVS = 0


	-- agentstate values:
	--	0x80	Branch\leaf delete pending	 only PP delete trigger clears flags 0xc0
	--	0x40	uninstall pending		 only PP delete trigger clears flags 0xc0
	--	0x02	deploy pending			 cleared as soon as deploy occurs
	--	0x01	update pending			 cleared as soon as deploy occurs
	-- PendingChange and Pending flags cleared as soon as any update occurs

	-- an update or new agent has been added
	if @AgentChange > 0
	Begin
		UPDATE smbCompliance Set AgentVersion = smbCurrentProductChangesSnapshot.productversion	
				,AgentProductCode = smbCurrentProductChangesSnapshot.productcode
				,AgentProductName = smbCurrentProductChangesSnapshot.softwarename
				,ComplianceMayChange =1
				,PendingChange = AgentState & 0xfc
				, AgentChange = 1
				,AgentState = AgentState & 0xfc  
		  from smbCurrentProductChangesSnapshot
			where
			smbCompliance.autoid = smbCurrentProductChangesSnapshot.autoid
			and smbCurrentProductChangesSnapshot.productfamily = 'EPO'
			and smbCurrentProductChangesSnapshot.productcode like 'epoagent%'
			and smbCompliance.FirstRecord = 1
			-- paranoia code: update it only is value is numeric (not blank)
			-- record is cleared only by PP delete trigger
			and smbCurrentProductChangesSnapshot.productversion > '1'


		UPDATE LeafNode Set AgentVersion = smbCurrentProductChangesSnapshot.productversion
				,AgentState = AgentState & 0xfc		-- turn off deploy pending flag
		  from smbCurrentProductChangesSnapshot, aviview_software
			where
			leafnode.autoid = smbCurrentProductChangesSnapshot.autoid
			and smbCurrentProductChangesSnapshot.productfamily = 'EPO'
			and smbCurrentProductChangesSnapshot.productcode like 'epoagent%'
			and smbCurrentProductChangesSnapshot.productversion > ''

	End




	-- look for new VirusScan inserts first
	if @ProductsInserted > 0
	Begin
		-- First TVD product installed - insert record having no product version
		UPDATE smbCompliance 
			Set ProductVersion = 
					case 
					when smbCurrentProductChangesSnapshot.productversion > ''
						then smbCurrentProductChangesSnapshot.productversion
					else smbCompliance.ProductVersion
					end
				,ProductCode= smbCurrentProductChangesSnapshot.productcode
				,ProductFamily= smbCurrentProductChangesSnapshot.productfamily
				,ProductName= smbCurrentProductChangesSnapshot.softwarename
				,EngineVer= 
					case 
					when smbCurrentProductChangesSnapshot.enginever > ''
						then smbCurrentProductChangesSnapshot.enginever
					else smbCompliance.EngineVer
					end
				,DATVer= 
					case 
					when smbCurrentProductChangesSnapshot.datver > ''
						then smbCurrentProductChangesSnapshot.datver
					else smbCompliance.DATVer
					end
				,ComplianceMayChange = 1
				,avinstalls=1
				,PendingChange = AgentState & 0xfc
				,ProdVerChange=1
				,DATChange=1
				,ENGChange=1
				,AgentState = AgentState & 0xfc
		  from smbCurrentProductChangesSnapshot
			where
			smbCompliance.autoid = smbCurrentProductChangesSnapshot.autoid
		        AND ( smbCurrentProductChangesSnapshot.ProductFamily in ( 'TVD', 'TVD_NC_AntiSpyware' ) ) -- TVD, TV_NC_Antispyware only
			and ( smbCurrentProductChangesSnapshot.ProductCode like 'VIRUSCAN%'   -- virusscan only
				or smbCurrentProductChangesSnapshot.ProductCode like 'ANTISPYW%'   -- anti-spyware only
				or smbCurrentProductChangesSnapshot.ProductCode like 'NSHLDNW_%'  )  -- Netshield Netware (codereview)

--				or smbCurrentProductChangesSnapshot.ProductFamily like 'TVD_NC%' ) 
			and FirstRecord = 1 
--			and (smbCompliance.ProductVersion = '' or smbCompliance.ProductVersion is null)
			and smbCurrentProductChangesSnapshot.InsertUpdate = 1
--			Must not do this cause initial VS insert has blank data
--			and
--			( smbCurrentProductChangesSnapshot.ProductVersion > '' 
--			or smbCurrentProductChangesSnapshot.EngineVer > '' 
--			or smbCurrentProductChangesSnapshot.DATVer > '' )

		-- check if other types of products are inserted
		select @ProductsInsertedNotVS=count(*) from smbCurrentProductChangesSnapshot 
			where InsertUpdate = 1
				and smbCurrentProductChangesSnapshot.ProductFamily != 'EPO'
				and ( smbCurrentProductChangesSnapshot.ProductCode not like 'VIRUSCAN%'
					and smbCurrentProductChangesSnapshot.ProductCode not like 'ANTISPYW%' 
					and smbCurrentProductChangesSnapshot.ProductCode not like 'NSHLDNW_%'  )  -- Netshield Netware

	End

--	Must do update here, catch update after blank VS inserts, and any other updates
--	if @PVChange > 0


	UPDATE smbCompliance 
		Set 
			ProductVersion = 
					case 
					when smbCurrentProductChangesSnapshot.productversion > ''
						then smbCurrentProductChangesSnapshot.productversion
					else smbCompliance.ProductVersion
					end
--			,ProductCode= smbCurrentProductChangesSnapshot.productcode
--			,ProductFamily= smbCurrentProductChangesSnapshot.productfamily
			,ProductName= smbCurrentProductChangesSnapshot.softwarename
			,EngineVer= 
				case 
					when smbCurrentProductChangesSnapshot.enginever > ''
						then smbCurrentProductChangesSnapshot.enginever
					else smbCompliance.EngineVer
				end
			,DATVer= 
				case 
					when smbCurrentProductChangesSnapshot.datver > ''
						then smbCurrentProductChangesSnapshot.datver
					else smbCompliance.DATVer
				end
--			,EngineVer= smbCurrentProductChangesSnapshot.enginever
--			,DATVer= smbCurrentProductChangesSnapshot.datver
--			,ExtraDATNames= smbCurrentProductChangesSnapshot.extradatnames
--			,ServicePack= smbCurrentProductChangesSnapshot.servicepack
--			,Hotfix= smbCurrentProductChangesSnapshot.hotfix
			,ComplianceMayChange =1
			,PendingChange = AgentState & 0xfc
			,ProdVerChange=smbCurrentProductChangesSnapshot.ProdVerChange
--			,AgentChange=0
			,DATChange=smbCurrentProductChangesSnapshot.DATChange
			,ENGChange=smbCurrentProductChangesSnapshot.ENGChange
			,AgentState = AgentState & 0xfc
		from smbCurrentProductChangesSnapshot
		where
			smbCompliance.autoid = smbCurrentProductChangesSnapshot.autoid
			and smbCurrentProductChangesSnapshot.productcode = smbCompliance.productcode
		        AND ( smbCurrentProductChangesSnapshot.ProductFamily in ( 'TVD','TVD_NC', 'SECURE' )  
				or smbCurrentProductChangesSnapshot.ProductFamily like 'TVD_NC%' ) 
--			and smbCurrentProductChangesSnapshot.ProductVersion > ''
			and smbCurrentProductChangesSnapshot.InsertUpdate = 0
			and
			( smbCurrentProductChangesSnapshot.ProductVersion > '' 
			or smbCurrentProductChangesSnapshot.EngineVer > '' 
			or smbCurrentProductChangesSnapshot.DATVer > '' )

---------------------------------------
-- LoggingCode test case: Keep log of trigger addition activity
--insert smbCurrentProductChangesLog  (AutoID,ProductFamily,ProductCode,SoftwareName,ProductVersion,EngineVer,DATVer,ProdVerChange,AgentChange,DATChange,ENGChange,InsertUpdate) 
--	select '', 'update smbCompliance rows=',@@ROWCOUNT,'','','','', 0,0,0,0,2
--insert smbCurrentProductChangesLog  (AutoID,ProductFamily,ProductCode,SoftwareName,ProductVersion,EngineVer,DATVer,ProdVerChange,AgentChange,DATChange,ENGChange,InsertUpdate) 
--	select smbCurrentProductChangesSnapshot.* from smbCurrentProductChangesSnapshot, smbCompliance
--		where
--			smbCompliance.autoid = smbCurrentProductChangesSnapshot.autoid
--			and smbCurrentProductChangesSnapshot.productcode = smbCompliance.productcode
--		        AND ( smbCurrentProductChangesSnapshot.ProductFamily in ( 'TVD','TVD_NC', 'SECURE' )  
--				or smbCurrentProductChangesSnapshot.ProductFamily like 'TVD_NC%' ) 
--			and smbCurrentProductChangesSnapshot.InsertUpdate = 0
--			and
--			( smbCurrentProductChangesSnapshot.ProductVersion > '' 
--			or smbCurrentProductChangesSnapshot.EngineVer > '' 
--			or smbCurrentProductChangesSnapshot.DATVer > '' )
--insert smbCurrentProductChangesLog  (AutoID,ProductFamily,ProductCode,SoftwareName,ProductVersion,EngineVer,DATVer,ProdVerChange,AgentChange,DATChange,ENGChange,InsertUpdate) 
--	select '', 'update smbCompliance rows=',@@ROWCOUNT,'','','','', 0,0,0,0,2




	-- look for new insert of any other product
	if @ProductsInsertedNotVS > 0
	Begin

		-- Delete any product which is already present for this computer (dont want to insert dup records)
		Delete smbCurrentProductChangesSnapshot
			From smbCompliance
			Where 
				smbCompliance.autoid = smbCurrentProductChangesSnapshot.autoid
				and smbCompliance.ProductCode = smbCurrentProductChangesSnapshot.ProductCode
--				and FirstRecord = 1 
--				update already done so delete anything having a matching PC
--				and smbCurrentProductChangesSnapshot.InsertUpdate = 1

		-- add remaining newly inserted products
		-- make sure it matches with a computer in the leafnode table 
		Insert smbCompliance
		 ( AutoID, 
			ComputerName, 
			Type, ChangedSinceLastCheckpoint, ComplianceMayChange,
--			AgentVersion, 
			ProductName, ProductVersion, 
			ReasonOutOfDate, ReasonProductVer, ReasonAgent, ReasonDatVer, ReasonEngineVer,
			ProductCode, ProductFamily, EngineVer, DATVer, ProdVerChange, DATChange, ENGChange,
			FirstRecord) --ExtraDATNames, ServicePack, Hotfix ) 
			Select
				smbCurrentProductChangesSnapshot.autoid, 'noop',
--				leafnode.nodename, 
				0, 1, 1,  
--				leafnode.agentversion, 
				SoftwareName, 
				ProductVersion, 
				'', '', '', '', '',
				ProductCode, ProductFamily, EngineVer, DATVer, -- ExtraDATNames, ServicePack, Hotfix
				1, 1, 1, 0
			From smbCurrentProductChangesSnapshot, leafnode
			where 
			leafnode.autoid = smbCurrentProductChangesSnapshot.autoid
		        AND 
			( smbCurrentProductChangesSnapshot.ProductCode in (select ProductCode from software where (RepoFlag & 0x02) > 0) 
				and (smbCurrentProductChangesSnapshot.ProductFamily in ( 'TVD','TVD_NC','SECURE' )
				or smbCurrentProductChangesSnapshot.ProductFamily like 'TVD_NC%' ) )
			and smbCurrentProductChangesSnapshot.InsertUpdate = 1
			-- make sure only one row is inserted.
			Group by
				smbCurrentProductChangesSnapshot.autoid, SoftwareName, ProductVersion,
				ProductCode, ProductFamily, EngineVer, DATVer


		-- must do update again, in case a blank data insert is followed by full data updates
		if @@rowcount > 0
			UPDATE smbCompliance 
			Set 
				ProductVersion = 
						case 
						when smbCurrentProductChangesSnapshot.productversion > ''
							then smbCurrentProductChangesSnapshot.productversion
						else smbCompliance.ProductVersion
						end
	--			,ProductCode= smbCurrentProductChangesSnapshot.productcode
	--			,ProductFamily= smbCurrentProductChangesSnapshot.productfamily
				,ProductName= smbCurrentProductChangesSnapshot.softwarename
				,EngineVer= 
					case 
						when smbCurrentProductChangesSnapshot.enginever > ''
							then smbCurrentProductChangesSnapshot.enginever
						else smbCompliance.EngineVer
					end
				,DATVer= 
					case 
						when smbCurrentProductChangesSnapshot.datver > ''
							then smbCurrentProductChangesSnapshot.datver
						else smbCompliance.DATVer
					end
	--			,EngineVer= smbCurrentProductChangesSnapshot.enginever
	--			,DATVer= smbCurrentProductChangesSnapshot.datver
	--			,ExtraDATNames= smbCurrentProductChangesSnapshot.extradatnames
	--			,ServicePack= smbCurrentProductChangesSnapshot.servicepack
	--			,Hotfix= smbCurrentProductChangesSnapshot.hotfix
				,ComplianceMayChange =1
				,PendingChange = AgentState & 0xfc
				,ProdVerChange=smbCurrentProductChangesSnapshot.ProdVerChange
	--			,AgentChange=0
				,DATChange=smbCurrentProductChangesSnapshot.DATChange
				,ENGChange=smbCurrentProductChangesSnapshot.ENGChange
				,AgentState = AgentState & 0xfc
			from smbCurrentProductChangesSnapshot
			where
				smbCompliance.autoid = smbCurrentProductChangesSnapshot.autoid
				and smbCurrentProductChangesSnapshot.productcode = smbCompliance.productcode
			        AND ( smbCurrentProductChangesSnapshot.ProductFamily in ( 'TVD','TVD_NC', 'SECURE' )  
					or smbCurrentProductChangesSnapshot.ProductFamily like 'TVD_NC%' ) 
	--			and smbCurrentProductChangesSnapshot.ProductVersion > ''
				and smbCurrentProductChangesSnapshot.InsertUpdate = 0
				and
				( smbCurrentProductChangesSnapshot.ProductVersion > '' 
				or smbCurrentProductChangesSnapshot.EngineVer > '' 
				or smbCurrentProductChangesSnapshot.DATVer > '' )

	End


-- Post PRP1.1 fix: 236917 Make sure all ProdProp changes reflected in smbCompliance
--	Trigger seems to sometimes fail to update the smbCurrentProductChanges table

if @cntSnapshot > 0
begin

update smbCompliance
Set smbCompliance.ProductVersion = productproperties.ProductVersion,
smbCompliance.datver = productproperties.datver,
smbCompliance.enginever = productproperties.enginever,
ProdVerChange=1, DATChange=1, ENGChange=1
from productproperties
where
smbcompliance.autoid = productproperties.parentid
and smbcompliance.productcode = productproperties.productcode
and productproperties.productcode not like 'epoagent%'
and 
(
smbcompliance.productversion != productproperties.productversion
or smbcompliance.datver != productproperties.datver
or smbcompliance.enginever != productproperties.enginever
)
 
update smbCompliance
Set smbCompliance.AgentVersion = productproperties.ProductVersion,
AgentChange=1
from productproperties
where
smbcompliance.autoid = productproperties.parentid
and smbcompliance.firstrecord=1
and productproperties.productcode like 'epoagent%'
and 
(
smbcompliance.agentversion != productproperties.productversion
)

end
 

Truncate table smbCurrentProductChangesSnapshot


End
GO

---------------------------------
-- SMBSP_ShowDatEngine

if exists (select * from sysobjects where id = object_id(N'[dbo].[SMBSP_ShowDatEngine]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[SMBSP_ShowDatEngine]
GO

CREATE PROCEDURE dbo.SMBSP_ShowDatEngine 
AS
Begin

	Select
		ProductFamily
		,SoftwareName as RepositoryType
		,ProductVersion

	From Software
	Where
		ProductFamily = 'UPD_TVD'
		and ProductCode in ('VSCANDAT1000', 'VSCANENG1000')
		and RepositoryType = 'Updates'


End
Go


IF EXISTS (SELECT name FROM sysobjects
      WHERE name = 'TR_EPO_DELPRODSETTINGS' AND type = 'TR')
drop trigger TR_EPO_DELPRODSETTINGS
go

CREATE TRIGGER TR_EPO_DELPRODSETTINGS ON dbo.ProductProperties 
for delete
as
BEGIN
delete ProductSettings where ParentID IN (select AutoID from deleted)

	-- smb1.1 agentstate values:
	--	0x80	Leaf/Branch delete pending (new for 1.1)
	--	0x40	uninstall pending (new for 1.1)
	--	0x02	deploy pending	
	--	0x01	update pending


-- smb1.1 reset Agentstate and set type=24 if agentstate - branch or computer delete pending

-- set type=24 only if uninstall pending set
UPDATE LeafNode 
	Set Type=24	
   WHERE 
	LeafNode.AutoID in  
    (Select ParentID 
     from deleted, aviview_software 
     where deleted.ProductCode = aviview_Software.ProductCode
      AND ( aviview_Software.ProductFamily in ( 'TVD','TVD_NC','SECURE' ) 
			or aviview_Software.ProductFamily like 'TVD_NC%' ) 
	)     
   AND LeafNode.AgentState & 0x80 > 0 


UPDATE LeafNode 
	Set AgentState = AgentState & 0x3f  -- clear all flags	
   WHERE 
	LeafNode.AutoID in  
    (Select ParentID 
     from deleted, aviview_software 
     where deleted.ProductCode = aviview_Software.ProductCode
      AND ( aviview_Software.ProductFamily in ( 'TVD','TVD_NC','SECURE' ) 
			or aviview_Software.ProductFamily like 'TVD_NC%' ) 
	)     
   AND LeafNode.AgentState & 0xc0 > 0 

--insert DebugLog (Datetime1, Int1, String1, String2, String3, String4) 
--	select getdate(), deleted.parentid, 'PP Delete', 'leafnode.type,AgentState', leafnode.type, leafnode.agentstate
--	from deleted, leafnode
--	where deleted.parentid = leafnode.autoid

UPDATE LeafNode 
	Set AVInstalls = AVInstalls - 1	
   WHERE LeafNode.AutoID in  
    (Select ParentID 
     from deleted, aviview_software 
     where deleted.ProductCode = aviview_Software.ProductCode
      AND ( aviview_Software.ProductFamily in ( 'TVD','TVD_NC' ) 
			or aviview_Software.ProductFamily like 'TVD_NC%' ) 
	)     
   AND LeafNode.AVInstalls > 0 


declare @delpv nvarchar(50)

select @delpv = productversion from deleted

UPDATE LeafNode Set AgentVersion = ''
   WHERE LeafNode.AgentVersion = @delpv
	and LeafNode.AutoID in  
    (Select ParentID 
     from deleted, aviview_software 
     where deleted.ProductCode = aviview_Software.ProductCode
      AND aviview_Software.ProductFamily in ( 'EPO' )
      and deleted.ProductCode like 'ePOAgent%'  )     

---------------------------------------
-- loggingcode test case: Keep log of trigger activity
--insert smbCurrentProductChangesLog 
--	select parentid as autoid, 'Delete',ProductCode,'',ProductVersion,EngineVer,DATVer, 0,0,0,0,2
--	From deleted


-- smb changes
UPDATE smbCompliance Set AgentVersion = '', ComplianceMayChange =1
  from deleted, aviview_software
	where
	smbCompliance.autoid = deleted.parentid
	and deleted.productcode = aviview_software.productcode
	and smbCompliance.AgentVersion = deleted.ProductVersion
	and aviview_software.productfamily = 'EPO'
	and aviview_software.productcode like 'epoagent%'

-- For smb assume only one tvd product installed
-- For epo more types of products involved, must allow delete (but dont delete the last entry or computer disappears)
-- Do delete or clear
--Declare @Count nvarchar(64)

--select @Count=Count(*) 
--	from smbCompliance, deleted
--	where
--	smbCompliance.autoid = deleted.parentid
--	and smbCompliance.productcode > ''

--IF @Count = 1
--Begin
-- never delete the last entry or the computer goes away
UPDATE smbCompliance 
	Set ProductVersion = ''
		,ProductCode= ''
		,ProductFamily= ''
		,ProductName= ''
		,EngineVer= ''
		,DATVer= ''
		,ExtraDATNames= ''
		,ServicePack= ''
		,Hotfix= ''
		,ComplianceMayChange =1
		,UncompliantProductVer=1
		,UpToDate = 0
		,OutOfDate = 1
		,PendingChange = PendingChange & 0x3f 
		,AgentState = AgentState & 0x3f
  from deleted, aviview_software
	where
	smbCompliance.autoid = deleted.parentid
	and deleted.productcode = smbCompliance.productcode
	and deleted.productcode = aviview_software.productcode
	and smbCompliance.ProductVersion = deleted.ProductVersion
        AND ( aviview_software.ProductFamily in ( 'TVD', 'TVD_NC_AntiSpyware' ))  -- tvd and tvd_nc_antispyware only
--		or aviview_software.ProductFamily like 'TVD_NC%' ) 
	and FirstRecord = 1

-- make sure the delete is dont to remove possibility of duplicate records
--If @@rowcount = 0
	Delete smbCompliance
 	from deleted, aviview_software
	where
		smbCompliance.autoid = deleted.parentid
		and deleted.productcode = smbCompliance.productcode
		and FirstRecord = 0


	-- redo product version compliance check
	Update smbCheckpoint Set ComplianceDefnMayChange =1
		, ProdVerComplianceDefnMayChange=1
		, ComplianceRedoRollup =1
   
END
GO


-- merged sql fixes from ePO 3.5 patches up to patch 5 level

-- epo3.5 patch4 bz234570
-- patch4 code review: dont hardcode global rootid=1
--	Fix groupshield report metadata where product and report productcodes are the same
--	Reset groupshield reports productcode to GROUPSHD6000RPT
begin
-- step 1 create separate GROUPSHD6000RPT reporting productcode and move over reporting policies

update software set productcode = 'GROUPSHD6000RPT'
where
productcode = 'GROUPSHD6000' and productfamily = 'epo_reports'

if (@@rowcount > 0)
begin
-- patch4 code review: dont hardcode global rootid=1
declare @grid int
set @grid=0  -- make sure it has a default
select @grid=autoid from branchnode where type=7 and parentid=0
if @grid=0   set @grid=1		-- make sure it has

if not exists(select * from policy where productcode = 'GROUPSHD6000RPT' and parenttype = 7)
insert policy (Parentid, parenttype, productcode)
values(@grid, 7, 'GROUPSHD6000RPT')

declare @aid int
select @aid=autoid from policy where productcode = 'GROUPSHD6000RPT'

if not exists (select * from policysettings where parentid = @aid)
insert policysettings
(parentid, sectionname, settingname, value)
select 
@aid, sectionname, settingname, value
from policysettings, policy
where
policysettings.parentid = policy.autoid
and policy.productcode= 'GROUPSHD6000'
and policy.ParentType = 7


-- step 2 delete all reporting policysetting entries from GROUPSHD6000

delete policysettings
from policy
where
policysettings.parentid = policy.autoid
and policy.productcode = 'GROUPSHD6000'
and settingname in ('action1','action2','action3','action4','action5','action6','action7')

delete policysettings
from policy
where
policysettings.parentid = policy.autoid
and policy.productcode = 'GROUPSHD6000'
and settingname in ('version','version1','version2','version3','version4','version5','version6','version7')

delete policysettings
from policy
where
policysettings.parentid = policy.autoid
and policy.productcode = 'GROUPSHD6000'
and settingname in ('filename1','filename2','filename3','filename4','filename5','filename6','filename7')

delete policysettings
from policy
where
policysettings.parentid = policy.autoid
and policy.productcode = 'GROUPSHD6000'
and settingname in ('numfiles','language')

--update software
--set productfamily = 'TVD',
--installguid = '{00000000-0000-0000-0000-000000000000}',
--softwarename = 'VirusScan Enterprise',
--platformssupported = 'WNTW:4:0:4|WNTS|W2KW|W2KS|WXPHE|WXPW|WXPS',
--ostype='Windows'
--where
--productcode = 'viruscan7100'
--and productfamily = ''


-- set timestamps for GROUPSHD6000

update policy set TheTimeStamp = @@dbts, DeleteTimestamp = @@dbts
where productcode = 'GROUPSHD6000'

update leafnode
set policytimestamp = @@dbts, TheTimestamp = @@dbts
from policy
where leafnode.autoid = policy.parentid
and productcode = 'GROUPSHD6000'
	and parenttype =1 

update branchnode
set policytimestamp = @@dbts, TheTimestamp = @@dbts
from policy
where branchnode.autoid = policy.parentid
and productcode = 'GROUPSHD6000'
	and parenttype in (3, 6, 5)

end

end
go


-------------------------------
-- epo3.5 patch5 bz244131: alter memeory fields to store more than 2**32
-- Alter columns to make into bigint (values > 4G)

ALTER TABLE [dbo].[ComputerProperties] DROP
	CONSTRAINT [DF_ComputerProperties_TotalPhysicalMemory] ,
	CONSTRAINT [DF_ComputerProperties_FreeMemory]
GO


-- using numeric instead of bigint for sql 7 compatibility
ALTER TABLE [dbo].[ComputerProperties] 
ALTER COLUMN
TotalPhysicalMemory nvarchar(64) null
go 

ALTER TABLE [dbo].[ComputerProperties] 
ALTER COLUMN
FreeMemory nvarchar(64) null
go

ALTER TABLE [dbo].[ComputerProperties] ADD
	CONSTRAINT [DF_ComputerProperties_TotalPhysicalMemory] DEFAULT ('0') FOR [TotalPhysicalMemory],
	CONSTRAINT [DF_ComputerProperties_FreeMemory] DEFAULT ('0') FOR [FreeMemory]
GO


-- merged from PRP 1.5 for DAT aaaa.bbbb format support

-----------------------------------------------------------------------------------
-- Dat, Eng ver conversions 
-----------------------------------------------------------------------------------
-- SMBFN_CONVERT_DAT_VER: Function to convert DAT version 
-- This is used for some tables, others use SMBFN_CONVERT_DAT_VER2
-- xxxx.xxxx strings are unchanged
-- 4.0.xxx fmt converted to xxxx fmt
IF EXISTS (SELECT * FROM sysobjects WHERE name = 'SMBFN_CONVERT_DAT_VER')
DROP function SMBFN_CONVERT_DAT_VER 
GO 

create function SMBFN_CONVERT_DAT_VER
(
	@strIn nvarchar(100)
)
returns nvarchar(100)
as
begin
	declare @strOut nvarchar(100)
	declare @at1 int
	declare @at2 int
	declare @len int
	declare @first int
	declare @safety int

	set @len = len(@strIn)

	-- default is just the same as the original
	set @strOut = @strIn

	-- First check if this is the 5000 fmt xxxx.xxxx
	set @at1 = charindex('.',@strIn)	
	if (@at1>0)
	begin
		set @at1 = charindex('.',@strIn,@at1+1)	
		-- Exactly 1 dot and 9 chars
		if ((@at1<=0) AND (@len=9))
		begin
			return @strOut
		end
	end
	

	-- Since it is not xxxx.xxxx fmt, we want xxxx fmt
	-- So, just use the lats part after the last dot
	set @safety=0
	set @at1=0
	set @first=1
	set @at2=@at1

	while (((@first=1) OR (@at1>0)) AND (@safety<=10))
	begin
		set @at2 = @at1+1
		set @at1 = charindex('.',@strIn, @at2)
		set @first = 0
		set @safety = @safety+1
	end

	if (@at2>1)	
	begin
		set @strOut = substring(@strIn, @at2, @len-@at2+1)
	end

	return @strOut
end
GO



-- SMBFN_CONVERT_ENG_VER: Function to convert ENGINE version 
-- This is used for some tables, others use EPOFN_CONVERT_ENG_VER2
-- xxxx.xxxx strings are unchanged
-- x.x.xx fmt converted to xxxx fmt (any non xxxx.xxxx gets dots removed)

IF EXISTS (SELECT * FROM sysobjects WHERE name = 'SMBFN_CONVERT_ENG_VER')
DROP function SMBFN_CONVERT_ENG_VER 
GO 

create function SMBFN_CONVERT_ENG_VER
(
	@strIn nvarchar(100)
)
returns nvarchar(100)
as
begin
	declare @strOut nvarchar(100)
	declare @at1 int
	declare @at2 int
	declare @len int
	declare @first int
	declare @safety int

	set @len = len(@strIn)

	-- default is just the same as the original
	set @strOut = @strIn

	-- First check if this is the 5000 fmt xxxx.xxxx
	set @at1 = charindex('.',@strIn)	
	if (@at1>0)
	begin
		set @at1 = charindex('.',@strIn,@at1+1)	
		-- Exactly 1 dot and 9 chars
		if ((@at1<=0) AND (@len=9))
		begin
			return @strOut
		end
	end
	

	-- Since it is not xxxx.xxxx fmt, we want xxxx fmt by removing all dots
	set @strOut = replace(@strIn, '.', '')

	return @strOut
end
GO

-- SMBFN_CONVERT_DAT_VER2: Function to convert DAT version forcing aaaa.bbbb format
-- This is used for some tables, others use SMBFN_CONVERT_DAT_VER
-- aaaa.bbbb strings are unchanged
-- a.b.cccc -> cccc.0000 (i.e. DAT)
-- aaaa -> aaaa.0000
-- a.b.cc -> abcc.0000 (i.e. Engine)
IF EXISTS (SELECT * FROM sysobjects WHERE name = 'SMBFN_CONVERT_DAT_VER2')
DROP function SMBFN_CONVERT_DAT_VER2 
GO 

create function SMBFN_CONVERT_DAT_VER2
(
	@strIn nvarchar(100)
)
returns nvarchar(100)
as
begin
	declare @strOut nvarchar(100)
	declare @at1 int
	declare @at2 int
	declare @len int
	declare @first int
	declare @safety int
	declare @strLastPart nvarchar(100)
	declare @strTemp nvarchar(100)

	set @len = len(@strIn)

	-- default is just the same as the original
	set @strOut = @strIn

	-- If the value is empty, just return it as is
	if (@len=0)
		return @strOut

	-- Check if this is the 5000 fmt aaaa.bbbb.  If so, just return it unchanged.
	set @at1 = charindex('.',@strIn)	
	if (@at1>0)
	begin
		set @at1 = charindex('.',@strIn,@at1+1)	

		-- Exactly 1 dot and 9 chars
		if ((@at1<=0) AND (@len=9))
		begin
			return @strOut
		end

		-- Check if this has 2 dots and 10 digits.  If so, strip the dots and stick the dot in the middle
		if ((@at1>0) AND (@len=10))
		begin
			set @at1 = charindex('.',@strIn,@at1+1)			
			if (@at1<=0)
			begin				
				set @strTemp = replace(@strIn, '.', '')
				set @strOut = substring(@strTemp, 1, 4) + '.'
				set @strLastPart = substring(@strTemp, 5, 4)
				set @strOut = @strOut + @strLastPart
				return @strOut
			end
		end
	end
	

	-- Since it is not aaaa.bbbb fmt, we want to convert it to aaaa.bbbb fmt
	
	-- If the format is aaaa, convert to aaaa.0000
	set @at1 = charindex('.',@strIn, 0)
	if ((@at1<=0) and (len(@strIn)=4))
	begin
		set @strOut = @strIn + '.0000'
		return @strOut
	end


	-- If the current format is a.b.cccc convert to cccc.0000
	-- If the current format is a.b.cc convert to abcc.0000
	-- So, just use the last part after the last dot
	set @safety=0
	set @at1=0
	set @first=1
	set @at2=@at1
	set @strLastPart=''

	while (((@first=1) OR (@at1>0)) AND (@safety<=10))
	begin
		set @at2 = @at1+1
		set @at1 = charindex('.',@strIn, @at2)
		set @first = 0
		set @safety = @safety+1
	end

	if (@at2>1)	
	begin
		set @strLastPart = substring(@strIn, @at2, @len-@at2+1)
	end

	if (len(@strLastPart)>3)
	begin
		set @strOut = @strLastPart + '.0000'
	end
	else if (len(@strLastPart)>0)
	begin
		set @strOut = replace(@strIn, '.', '') + '.0000'
	end

	-- if it is an unexpected format, just return the original string input as the output.
	
	return @strOut
end
GO



-- SMBFN_CONVERT_ENG_VER: Function to convert ENGINE version, forcing aaaa.bbbb format
-- This is used for some tables, others use SMBFN_CONVERT_ENG_VER
IF EXISTS (SELECT * FROM sysobjects WHERE name = 'SMBFN_CONVERT_ENG_VER2')
DROP function SMBFN_CONVERT_ENG_VER2 
GO 

create function SMBFN_CONVERT_ENG_VER2
(
	@strIn nvarchar(100)
)
returns nvarchar(100)
as
begin
	declare @strOut nvarchar(100)
	-- My DAT conversion fcn is general enough to handle both DATs and Engines.  I like to keep this
	-- a spearate stored proc, so if changes are needed, specific to DAT or engine, they can be made 
	-- with just a stored proc change
	set @strOut = dbo.SMBFN_CONVERT_DAT_VER2(@strIn)

	return @strOut
end
GO



-- SMBSP_CONVERT_DAT_ENG_VERS: Update DAT, ENG versions in each table that it is needed in
IF EXISTS (SELECT * FROM sysobjects WHERE name = 'SMBSP_CONVERT_DAT_ENG_VERS')
DROP procedure SMBSP_CONVERT_DAT_ENG_VERS 
GO 

-- Update DAT, ENG versions in each table that it is needed in
create procedure SMBSP_CONVERT_DAT_ENG_VERS
as
begin
	-- Update Software Table 	
	if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Software]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
	begin
		update Software set ProductVersion = dbo.SMBFN_CONVERT_DAT_VER2(Software.ProductVersion) where ProductCode='VSCANDAT1000'
		update Software set ProductVersion = dbo.SMBFN_CONVERT_ENG_VER2(Software.ProductVersion) where ProductCode='VSCANENG1000'
	end

	-- Update smbSecurityThreats
	if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[smbSecurityThreats]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
	begin
		update smbSecurityThreats set min_dat=dbo.SMBFN_CONVERT_DAT_VER(smbSecurityThreats.min_dat)
		update smbSecurityThreats set min_engine=dbo.SMBFN_CONVERT_ENG_VER(smbSecurityThreats.min_engine)
	end

	-- Update smbLatestUpdates
	if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[smbLatestUpdates]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
	begin
		update smbLatestUpdates set version=dbo.SMBFN_CONVERT_DAT_VER2(smbLatestUpdates.version) where type='DAT'
		update smbLatestUpdates set version=dbo.SMBFN_CONVERT_ENG_VER2(smbLatestUpdates.version) where type='ENGINE'
	end

	-- Update ProductProperties
	if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ProductProperties]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
	begin
		update ProductProperties set DATVer = dbo.SMBFN_CONVERT_DAT_VER(ProductProperties.DATVer) 
		update ProductProperties set EngineVer = dbo.SMBFN_CONVERT_ENG_VER(ProductProperties.EngineVer) 
	end


end
GO

-- Fire off the proc to convert all the dat,eng ver in the database to the new format
-- We drop and recreate the prodprop trigger to improve performance

exec SMBSP_CONVERT_DAT_ENG_VERS
go


-----------------------------------------------------------------------------------
-- end of Dat, Eng ver conversions 
-----------------------------------------------------------------------------------


-- Merged from PRP 1.5 for DAT aaaa.bbbb format support
if exists (select * from sysobjects where id = object_id(N'[dbo].[SMBSP_UpdateCompliance]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[SMBSP_UpdateCompliance]
GO

-- BZ 299759: explicitly create and drop temp tables

CREATE PROCEDURE dbo.SMBSP_UpdateCompliance AS
Begin

--Test
--select * from smbCheckpoint
--select * from smbCompliance
--select * from smbComplianceRollup

    -- PostRCFix: Assure that only one call can execute this procedure at a time
    -- Open transaction, then lock table for the duration
    Begin Transaction

	-- PostRCFix: exclusive table Lock on smbCurrentProductChangesSnapshot for duration of the transaction
	--	A simulataneous call to this routine will freeze here until the first call completes
	-- 	clear work table 
	delete from smbCurrentProductChangesSnapshot with (TABLOCKX)

	--dc Do initial data population if needed (SMBSP_PopulateSMBCompliance)
	Declare @Init int
	Select @Init=count(*) from smbCompliance

--	if @Init = 0
--		Execute SMBSP_PopulateSMBCompliance
--	else
		Execute SMBSP_ProcessCurrentProductChanges

	-------------------------------------------
	--dc Fetch last checkpoint (smbCheckPoint.LastUpdate, LastComplianceCheck, ComplianceDefnMayChange)
	-- Has compliance def'n possibly changed
	Declare @UpdateEventsAutoID int
	Declare @ComplianceRedoRollup int
	Declare @LastUpdate varchar(16)
	Declare @LastComplianceCheck DateTime
	Declare @ComplianceDefnMayChange int 	Declare @ComplianceDefnMayChange1 int
	Declare @ProdVerChange int		Declare @ProdVerChange1 int
	Declare @AgentChange int		Declare @AgentChange1 int
	Declare @DATChange int			Declare @DATChange1 int
	Declare @ENGChange int			Declare @ENGChange1 int
	Declare @LastLateDefninDays int

	Select
		@UpdateEventsAutoID = UpdateEventsAutoID
		,@LastUpdate = LastUpdate	
		,@LastComplianceCheck = LastComplianceCheck
		,@ComplianceRedoRollup =ComplianceRedoRollup 
	 	,@ComplianceDefnMayChange=ComplianceDefnMayChange -- delete trigs may set these
		,@ProdVerChange=ProdVerComplianceDefnMayChange
		,@DATChange=DATComplianceDefnMayChange
		,@ENGChange=ENGComplianceDefnMayChange
		,@LastLateDefninDays=LastLateDefninDays
		from smbCheckpoint

	---------------------------
	-- PRP1.1 bug fix (209648)  Time out PendingState after one day
	Declare @NewDay int
	set @NewDay = DateDiff(day, @LastComplianceCheck, GetDate());

	if @NewDay > 0
	begin
		Update smbCompliance
			Set  AgentState=0, PendingChange=0,
				ComplianceMayChange=1, ProdVerChange=1, AgentChange=1,
				DATChange=1, ENGChange=1				
		Where   
			PendingChange > 0
			and DateDiff(hour, PendingStart, GetDate()) > 6			
	end


	-- ins & upd trigs set these
	Select
	 	@ComplianceDefnMayChange1=count(*)
		,@ProdVerChange1=sum(ProdVerChange)
		,@AgentChange1=sum(AgentChange)
		,@DATChange1=sum(DATChange)
		,@ENGChange1=sum(ENGChange)
		from smbTmpComplianceDefn

	if @ComplianceDefnMayChange > 0 or @ComplianceDefnMayChange1 > 0
		Set @ComplianceDefnMayChange = 1
	-- if scanner or agent version changes, check both
	if @ProdVerChange > 0 or @ProdVerChange1 > 0 or @AgentChange1 > 0
		Set @ProdVerChange = 1
	-- if either dat or engine changes, check both
	if @ENGChange > 0 or @ENGChange1  > 0 or @DATChange > 0 or @DATChange1 > 0
	Begin
		Set @ENGChange = 1 
		Set @DATChange = 1
	End

-- select @ComplianceDefnMayChange, @ProdVerChange, @ENGChange, @DATChange

	-- If its been a while since compliance checked
	Declare @NotRunLately int
	set @NotRunLately = DateDiff(week, @LastComplianceCheck, GetDate());

	Declare @ComplianceDefnChanged int
	Set @ComplianceDefnChanged = 0 	-- default

--test
--set @ComplianceDefnMayHaveChanged = 1
--select 'before',* from smbCompliance 

	-- smb1.1 Check if ReportUserComplianceSettings has changed,
	--	if so, recalculate compliance definition
	Declare @UserComplianceDefnLastChange DateTime
	select @UserComplianceDefnLastChange=max(LastChange) from ReportUserComplianceLastChange

	if ( @UserComplianceDefnLastChange >= @LastComplianceCheck)
	begin
		Set @ComplianceDefnChanged = 1 	
		Set @ComplianceDefnMayChange = 1 	

		-- update all to latest version in case user sets a compliance rule back to latest version
		update ReportInputParameters
		set ReportInputParameters.ParmValue = Productproperties.ProductVersion,
		ReportInputParameters.ParmValuePrompt = Productproperties.ProductVersion
		from Productproperties, AVIVIew_Software
		where 
		Productproperties.productcode = AVIVIew_Software.productcode
		and ReportInputParameters.ParmName = AVIVIew_Software.SoftwareName
		and ReportInputParameters.DBFldName = AVIVIew_Software.ProductFamily
		and ReportInputParameters.ParmValue < Productproperties.ProductVersion
		and ReportInputParameters.ReportID = 'COMPLIANCEISSUES'
	end


	--dc If ComplianceDefnMayHaveChanged
	if( @ComplianceDefnMayChange > 0 or @NotRunLately > 0 or @Init = 0)
	Begin	

--test
--select @ComplianceDefnMayHaveChanged as ComplianceDefnMayHaveChanged
--test
--select ReportID,ParmName,ParmValue from ReportInputParameters where reportid in ('COMPLIANCEISSUES','OLDCOMPLIANCEISSUES') and ParmValue > ''
		
		--dc Fetch current Compliance Def'n using same routine as epo 3.0 (Compliance = latest installed version) 
		Execute dbo.SMBSP_FetchComplianceDefinition '|FULLLANG0409|REPORTCOMPLIANCEISSUES|RPTGRPCUSTGROUP|'

		-- Note Compliance Defn Checked (Comment out later for performance)
		update smbCheckPoint Set LastComplianceDefnCheck = GetDate(),
				ComplianceDefnChecks = ComplianceDefnChecks+1

		-- smb1.1 Set any User Compliance Definition settings as overrides
		Update ReportInputParameters
		Set ParmValue = ReportUserComplianceSettings.ProductVersion,
			ParmValuePrompt = ReportUserComplianceSettings.ProductVersion
		From ReportUserComplianceSettings
		Where 
		ReportInputParameters.ParmName = ReportUserComplianceSettings.SoftwareName
		and ReportInputParameters.DBFldName = ReportUserComplianceSettings.ProductFamily
		and ReportInputParameters.ReportID = 'COMPLIANCEISSUES'

		--dc Has compliance def'n actually changed since last run
--		Select @ComplianceMayHaveChanged
--		Declare @ComplianceDefnChanged int
		Declare @NotFirstRun int
		Select @NotFirstRun = count(*)
			From ReportInputParameters 
			Where 
				ReportID = 'OLDCOMPLIANCEISSUES'

		Select @ComplianceDefnChanged = count(*)
			From ReportInputParameters a, ReportInputParameters b
			Where 
				a.ReportID = 'COMPLIANCEISSUES'
				and b.ReportID = 'OLDCOMPLIANCEISSUES'
				and a.ParmName = b.ParmName
				and a.ParmValue <> b.ParmValue

		-- for firstrun assume compliance defn has changed		
		if @NotFirstRun = 0
			Set @ComplianceDefnChanged = 1 	-- default, assume changed if no OLDCOMPLIANCEISSUES

		-- Note Compliance defn change
		if @ComplianceDefnChanged > 0
		begin
			update smbCheckPoint Set LastComplianceDefnChange = GetDate(),
				ComplianceDefnChanges = ComplianceDefnChanges+1
			Set @ProdVerChange = 1
			Set @ENGChange = 1 
			Set @DATChange = 1
		end

--select * from ReportInputParameters where reportid in ('COMPLIANCEISSUES','OLDCOMPLIANCEISSUES')
--select @ComplianceDefnChanged as CompliDefnChanged

		-- Save current compliance defn for next run
		Delete ReportInputParameters Where ReportID = 'OLDCOMPLIANCEISSUES'
		Insert ReportInputParameters
			(ParmName, ParmValue, CustPageName, ReportID, RptGroupID)
			Select ParmName, ParmValue, CustPageName, 'OLDCOMPLIANCEISSUES', 'XXX'
				From ReportInputParameters Where ReportID = 'COMPLIANCEISSUES'


		-- finish checking compliance defn, clear tmp table
		Delete from smbTmpComplianceDefn

--test
--select @ComplianceDefnMayHaveChanged as ComplianceDefnMayHaveChanged
--test
--select ReportID,ParmName,ParmValue from ReportInputParameters where reportid in ('COMPLIANCEISSUES','OLDCOMPLIANCEISSUES') and ParmValue > ''

	End



--test
--set @ComplianceDefnChanged = 1
--test
--select @ComplianceDefnChanged as ComplianceDefnChanged

	-- Check for leafnode deletes: type=24
	-- Can this be made faster??
--	Update smbCompliance Set type=24
--			From LeafNode
--			Where LeafNode.AutoID = smbCompliance.AutoID
--				and LeafNode.type = 24



	----------------------------------------------------------------
	-- Determine what computers have checked in since last run

	--dc If computer connected since last run its no longer late and needs to be rechecked for compliance
	-- Also store its OSType in case that has changed
	-- trigger enhancement (trigchange)

	-- check for connection since last run
	Declare @NewConnections int
	Select @NewConnections=count(*) from smbCurrentLastUpdates
	if @NewConnections > 0
	Begin
		Update smbCompliance Set ChangedSinceLastCheckpoint =1, Late=0,
					OutofDateNotLate=OutofDate, UptoDateNotLate=UptoDate
	--				smbCompliance.OSType = ComputerProperties.OSType,			
	--				smbCompliance.OSVersion = ComputerProperties.OSVersion	
			From LeafNode, smbCurrentLastUpdates
			Where LeafNode.AutoID = smbCurrentLastUpdates.AutoID
				and smbCompliance.AutoID = smbCurrentLastUpdates.AutoID
				and smbCompliance.Late > 0
		Delete from smbCurrentLastUpdates
	End

	-- check for OS change
	Declare @OsChanges int
	Select @OsChanges=count(*) from smbCurrentOSChanges
	if @OsChanges > 0
	Begin
		Update smbCompliance Set ChangedSinceLastCheckpoint =1,
					smbCompliance.OSType = smbCurrentOSChanges.OSType,			
					smbCompliance.OSVersion = smbCurrentOSChanges.OSVersion	
			From smbCompliance, smbCurrentOSChanges--, ComputerProperties
			Where smbCurrentOSChanges.AutoID = smbCompliance.AutoID 
--				and LeafNode.AutoID = ComputerProperties.ParentID 
		Delete from smbCurrentOSChanges
	End

	


--	Update smbCompliance Set ChangedSinceLastCheckpoint =1, Late=0,
--			smbCompliance.LastUpdate = LeafNode.LastUpdate,
--			smbCompliance.Type = LeafNode.Type,
----			smbCompliance.AVinstalls=LeafNode.AVinstalls,
--			smbCompliance.AgentVersion=LeafNode.AgentVersion,  -- try this
----			smbCompliance.AgentState=LeafNode.AgentState,  -- try this
--				OutofDateNotLate=OutofDate, UptoDateNotLate=UptoDate,
--				smbCompliance.OSType = ComputerProperties.OSType,			
--				smbCompliance.OSVersion = ComputerProperties.OSVersion	
--		From LeafNode, ComputerProperties
--		Where LeafNode.AutoID = smbCompliance.AutoID
--			and LeafNode.AutoID = ComputerProperties.ParentID
--			and 
--			 LeafNode.LastUpdate >=  @LastUpdate

	-- Check any computer those status is undetermined
	Update smbCompliance Set ChangedSinceLastCheckpoint=1, ComplianceMayChange=1,
			ProdVerChange=1, AgentChange=1, DATChange=1, ENGChange=1
		where Late=0 and OutofDate=0 and UptoDate=0 and PendingChange = 0

--test
--select * from smbCompliance where ChangedSinceLastCheckpoint =1



	-----------------------------------------------------------------
	-- Determine if any computers may have changed compliance status

	Declare @ComputerComplianceChangeMaybe int
	Select @ComputerComplianceChangeMaybe = count(*) 
		From smbCompliance
		Where ChangedSinceLastCheckpoint > 0
			or ComplianceMayChange > 0


--test
--select @ComputerComplianceChangeMaybe as ComputerComplianceChangeMaybe

	----------------------------------------------------------
	-- Start Compliance Change detection
	if( @ComputerComplianceChangeMaybe > 0 or @ComplianceDefnChanged > 0)
	Begin

	-----------------------------------------------
	-- Start checking for compliance changes

--	Not needed ProdProps update trigger will marking these as having changed compliance status
--	Update smbCompliance Set ChangedSinceLastCheckpoint =1
--		From UpdateEvents
--		Where UpdateEvents.NodeID = smbCompliance.AutoID
--			and UpdateEvents.AutoID >=  @UpdateEventsAutoID


	---------------------------------------------------------
	-- reset pending flag when compliance may change is set (reset for install error)
	update smbCompliance 
		set PendingChange = 0, OutOfDateNotLate=OutOfDate, UpToDateNotLate=UpToDate
		where 
			ComplianceMayChange =1 and PendingChange > 0 and late = 0

	--------------------------------------------------------------
	-- Set defaults

	-- If Compliance Def'n changed, Recheck Compliance on all computers
	if ( @ComplianceDefnChanged > 0 )
		Update smbCompliance 
			Set ChangedSinceLastCheckpoint =1, ComplianceMayChange =1,
				ProdVerChange=1, AgentChange=1, DATChange=1, ENGChange=1


	-- Check compliance for computers that have changed: Set defaults = UptoDate
--	Update smbCompliance Set UptoDate=1, OutofDate=0, UptoDateNotLate=0, OutofDateNotLate=0, ReasonOutofDate='',
--		UncompliantProductVer = 0, UncompliantDATVer = 0, UncompliantEngineVer = 0, UncompliantAgent = 0
--		Where ChangedSinceLastCheckpoint =1 or ComplianceMayChange=1

	--------------------------------------------------------
	-- Compare compliance values to compliance definition
--select 'check prodver'

	-- ProductVersions
	if @ProdVerChange > 0 
	Begin
		Update smbCompliance Set UncompliantProductVer = 0, UncompliantAgent = 0,
				ReasonProductVer = '@', ReasonAgent = '@'
			Where (ChangedSinceLastCheckpoint =1 or ComplianceMayChange=1)
				and (ProdVerChange > 0 or AgentChange > 0)

		Update smbCompliance Set OutofDate=1, UptoDate=0, --ReasonOutofDate= ReasonOutofDate+'ProductVersion|',
				UncompliantProductVer=1, ReasonProductVer = 'ProductVersion|'
			From ReportInputParameters
			Where 
				(smbCompliance.ChangedSinceLastCheckpoint=1
					or smbCompliance.ComplianceMayChange=1)
				AND (
				(
					smbCompliance.ProductName = ''
					or smbCompliance.ProductName is null
				)
--				OR smbCompliance.AVInstalls = 0
				OR (ReportInputParameters.ReportID = 'COMPLIANCEISSUES'
					and ReportInputParameters.ParmName = smbCompliance.ProductName
					and ReportInputParameters.ParmValue > smbCompliance.ProductVersion
					and ReportInputParameters.CustPageName = 'ProductVersions'
					and (ProdVerChange > 0 or AgentChange > 0)
				  )
				)
	
		-- look for OS exceptions
		Update smbCompliance Set OutofDate=0, UptoDate=1, --ReasonOutofDate= '',
				UncompliantProductVer=0, ReasonProductVer = '@'
			From smbComplianceOSExceptions
			Where 
				(smbCompliance.ChangedSinceLastCheckpoint=1
					or smbCompliance.ComplianceMayChange=1)
				AND (
					smbCompliance.ProductName = smbComplianceOSExceptions.SoftwareName
					and smbCompliance.OSType = smbComplianceOSExceptions.OSType
					and smbComplianceOSExceptions.ProductVersion <= smbCompliance.ProductVersion 
					and (ProdVerChange > 0 or AgentChange > 0)
					)

		-- Allow product versions without build numbers to be compliant
		Update smbCompliance Set OutofDate=0, UptoDate=1, --ReasonOutofDate= '',
				UncompliantProductVer=0, ReasonProductVer = '@'
			From ReportInputParameters
			Where 
				(smbCompliance.ChangedSinceLastCheckpoint=1
					or smbCompliance.ComplianceMayChange=1)
				AND (
				 (ReportInputParameters.ReportID = 'COMPLIANCEISSUES'
					and ReportInputParameters.ParmName = smbCompliance.ProductName
					and ReportInputParameters.ParmValueAlternative = smbCompliance.ProductVersion
					and ReportInputParameters.CustPageName = 'ProductVersions'
					and (ProdVerChange > 0 or AgentChange > 0)
				  )
				)
	
		-- Record any Late Computers: dont below now
	--	Update smbCompliance Set ReasonOutofDate= ReasonOutofDate+'LATE|'
	--		Where Late = 1 and ( ReasonOutofDate = '' or ReasonOutofDate = 'ProductVersion|' )
	
		-- ePO Agent
		Update smbCompliance Set OutofDate=1, UptoDate=0, --ReasonOutofDate= ReasonOutofDate+'AgentVersion|',
				UncompliantAgent=1, ReasonAgent = 'AgentVersion|'
			From ReportInputParameters
			Where 
				(smbCompliance.ChangedSinceLastCheckpoint=1
					or smbCompliance.ComplianceMayChange=1)
				AND (
				(
					smbCompliance.FirstRecord = 1
					and (	
					smbCompliance.AgentVersion = ''
					or smbCompliance.AgentVersion is null )
				)
				OR (ReportInputParameters.ReportID = 'COMPLIANCEISSUES'
--					and ReportInputParameters.ParmName in ('ePO Agent', 'ProtectionPilot Agent')
					and ReportInputParameters.ParmName = smbCompliance.AgentProductName
					and ReportInputParameters.ParmValue > smbCompliance.AgentVersion
					and ReportInputParameters.CustPageName = 'ProductVersions'
					and smbCompliance.FirstRecord = 1
					and (ProdVerChange > 0 or AgentChange > 0)
					)
				)

		-- must have PV to be compliant
		Update smbCompliance Set UpToDate=0, OutofDate=1, UncompliantProductVer=1, ReasonProductVer='ProductVersion|'
			Where (ProductVersion = '' or ProductVersion is null) and FirstRecord=1
			and (smbCompliance.ChangedSinceLastCheckpoint=1
					or smbCompliance.ComplianceMayChange=1)

	End

	-- Engine
	if @ENGChange > 0
	Begin
		Update smbCompliance Set UncompliantEngineVer = 0, ReasonEngineVer = '@'
			Where (ChangedSinceLastCheckpoint =1 or ComplianceMayChange=1)
			and smbCompliance.ENGChange = 1


			-- BZ 299759: explicitly create and drop temp table

			IF EXISTS (select * from sysobjects where name = 'tmpEngVers' and xtype = 'U')
	  		DROP TABLE dbo.tmpEngVers
			
			CREATE TABLE [dbo].[tmpEngVers] (
			rip_autoid int, 
			smbautoid int, 
			pv nvarchar(128), 
			lv nvarchar(128), 
			pc nvarchar(128)
			)

		INSERT INTO tmpEngVers
			SELECT ReportInputParameters.autoid, smbCompliance.autoid, ReportInputParameters.ParmValue, EngineVer, smbCompliance.ProductCode
			FROM ReportInputParameters, smbCompliance
			where ReportInputParameters.ReportID = 'COMPLIANCEISSUES'
			and ReportInputParameters.ParmName = smbCompliance.ProductFamily+'_Engines'
			and ReportInputParameters.CustPageName = 'EngineDATs';
		UPDATE tmpEngVers	SET pv = SUBSTRING(pv, 1,4), lv = SUBSTRING(lv, 1,4)
		WHERE LEN(lv) != LEN(pv);

		Update smbCompliance Set OutofDate=1, UptoDate=0, --ReasonOutofDate= ReasonOutofDate+'Engine|',
				UncompliantEngineVer=1, ReasonEngineVer = 'Engine|'
	
			From tmpEngVers AS A
			Where 
				smbCompliance.autoid = A.smbautoid
				and smbCompliance.ProductCode = A.pc
				and pv > lv
				and (smbCompliance.ChangedSinceLastCheckpoint=1
					or smbCompliance.ComplianceMayChange=1)
				and smbCompliance.ENGChange = 1
			
			DROP TABLE dbo.tmpEngVers
	End

	-- DATs
	if @DATChange > 0
	Begin
		Update smbCompliance Set UncompliantDATVer = 0, ReasonDATVer = '@'
			Where (ChangedSinceLastCheckpoint =1 or ComplianceMayChange=1)
				and smbCompliance.DATChange = 1

			-- BZ 299759: explicitly create and drop temp table

			IF EXISTS (select * from sysobjects where name = 'tmpDatVers' and xtype = 'U')
	  		DROP TABLE dbo.tmpDatVers
			
			CREATE TABLE [dbo].[tmpDatVers] (
			rip_autoid int, 
			smbautoid int, 
			pv nvarchar(128), 
			lv nvarchar(128), 
			pc nvarchar(128))

		INSERT INTO tmpDatVers
			SELECT ReportInputParameters.autoid, smbCompliance.autoid, ReportInputParameters.ParmValue, DATVer, smbCompliance.ProductCode
			FROM ReportInputParameters, smbCompliance
			where ReportInputParameters.ReportID = 'COMPLIANCEISSUES'
			and ReportInputParameters.ParmName = smbCompliance.ProductFamily+'_DATs'
			and ReportInputParameters.CustPageName = 'EngineDATs';
		UPDATE tmpDatVers	SET pv = SUBSTRING(pv, 1,4), lv = SUBSTRING(lv, 1,4)
		WHERE LEN(lv) != LEN(pv);

		Update smbCompliance Set OutofDate=1, UptoDate=0, --ReasonOutofDate= ReasonOutofDate+'DAT|',
				UncompliantDATVer=1, ReasonDATVer = 'DAT|'
			From tmpDatVers AS A
			Where 
				smbCompliance.autoid = A.smbautoid
				and smbCompliance.ProductCode = A.pc
				and pv > lv
				and (smbCompliance.ChangedSinceLastCheckpoint=1
					or smbCompliance.ComplianceMayChange=1)
				and smbCompliance.DATChange = 1

			DROP TABLE dbo.tmpDatVers
	End


	-- Set ReasonOutOfDateFlag: try to remove this if possible (duplicate storage)
	Update smbCompliance 
		Set ReasonOutofDate= 
			Replace(ReasonProductVer+ReasonDatVer+ReasonEngineVer+ReasonAgent,'@','')
	from smbCompliance
	where
		(smbCompliance.ChangedSinceLastCheckpoint=1
				or smbCompliance.ComplianceMayChange=1)
--	Update smbCompliance 
--		Set ReasonOutofDate= Replace(ReasonOutofDate,'@','')
--	from smbCompliance
--	where
--		(smbCompliance.ChangedSinceLastCheckpoint=1
--				or smbCompliance.ComplianceMayChange=1)

	-- Set as Compliant
	-- reset compliance check flags
	Update smbCompliance Set UpToDate=1, OutofDate=0, ReasonOutofDate=''
		Where 
			UncompliantDATVer=0
			and UncompliantEngineVer=0
			and UncompliantAgent=0
			and UncompliantProductVer=0
		and (smbCompliance.ChangedSinceLastCheckpoint=1
				or smbCompliance.ComplianceMayChange=1)


	-- Set UpToDateNotLate Flag
	Update smbCompliance Set OutofDateNotLate=1, UptoDateNotLate=0  
		Where OutofDate =1 and Late = 0 and PendingChange=0
	-- Set OutOfDateNotLate Flag
	Update smbCompliance Set UptoDateNotLate=1, OutofDateNotLate=0 
		Where UptoDate =1 and Late = 0 and PendingChange=0
	-- Set Late flag
	Update smbCompliance Set ReasonOutofDate= ReasonOutofDate+'Late|', UptoDateNotLate=0, OutofDateNotLate=0 
		where Late =1 and (ComplianceMayChange=1 or ChangedSinceLastCheckpoint=1)


	-- reset compliance check flags
	Update smbCompliance
		Set ComplianceMayChange=0, ChangedSinceLastCheckpoint=0
		Where ComplianceMayChange=1 or ChangedSinceLastCheckpoint=1


	
	End



	----------------------------------------------------------
	-- Check who is late: Should check for lateness just once an hour
	-- Read ServerPolicy: 'ComplianceRules', 'LateDefninDays'
	Declare @CheckforLates int
	set @CheckforLates = DateDiff(hour, @LastComplianceCheck, GetDate());

	-- If LateDefn Changes then recalculate all late setings
	Declare @NumDays int
	Select 	@NumDays=LateDefninDays from ServerInfo
	if @LastLateDefninDays !=  @NumDays
		Set @CheckforLates =1

	-- if not set the set it to a default value
	if @NumDays = 0 or @NumDays is null
	begin
		Update dbo.ServerInfo  Set LateDefninDays = 7
		Set @NumDays = 7
	end
	
		


--test
--set @CheckforLates =1
--test
--select @CheckforLates as CheckForLates
 
	if( @CheckforLates > 0 )
	Begin
--		Declare @NumDays int
--		Select @NumDays=convert(int,Value) From ServerPolicy Where SectionName = 'ComplianceRules' and SettingName = 'LateDefninDays'
--		Select @NumDays=LateDefninDays From ServerInfo

		-- set a default value
		if @NumDays is null or @NumDays = 0
			Set @NumDays = 7

		Declare @LateCheckPoint datetime
		set @LateCheckPoint = DateAdd(hour, -(@NumDays*24), GetDate());

		Declare @YYYYMMDD char(30)	
		set @YYYYMMDD = Replace( Replace( Replace( convert(char(30), @LateCheckPoint,120), '-', ''), ':', ''), ' ', '')

		--(trigchange)
		Update smbCompliance Set Late=1, ReasonOutofDate= ReasonOutofDate+'Late|',
				OutofDateNotLate=0, UptoDateNotLate=0, PendingChange = 0
--				, ChangedSinceLastCheckpoint=1
--			From ReportInputParameters
			From LeafNode
			Where 
				smbCompliance.autoid = LeafNode.autoid
				and LeafNode.LastUpdate < @YYYYMMDD
				and LeafNode.LastUpdate != '' and LeafNode.LastUpdate is not null
				and smbCompliance.Late = 0
	End


	
	-----------------------------------------
	-- Check if need to do rollup
	if( @ComputerComplianceChangeMaybe > 0 or @ComplianceRedoRollup > 0 or @CheckforLates > 0
		or @ComplianceDefnChanged > 0)
	Begin

		-- Set Pending/Late flag: Late has higer priority over pending, uptodate and outofdate
		Update smbCompliance Set OutofDateNotLate=0, UptoDateNotLate=0
			where PendingChange > 0
		Update smbCompliance Set OutofDateNotLate=0, UptoDateNotLate=0, PendingChange = 0
			where Late =1
	
		----------------------------------
		-- Rollup Compliance summary data
		-- Rollup Computer/product smbCompliance table into Computer summary table for accurate computer counts
		Delete from smbComplianceComputer

		Insert smbComplianceComputer
		Select 
			LeafNode.AutoID
		        , LeafNode.ParentID
			, case	
--				when sum(smbCompliance.UptoDateNotLate) > 0 then 1
				when (sum(smbCompliance.OutofDateNotLate) = 0 
					and sum(smbCompliance.Late) = 0
					and sum(smbCompliance.PendingChange) = 0 ) then 1
				else 0
				end as UptoDateNotLate
			, case
				when sum(smbCompliance.OutofDateNotLate) > 0 then 1
				else 0 
				end as OutofDateNotLate 
			, case
				when sum(smbCompliance.Late) > 0 then 1
				else 0
				end as Late
			, case
				when sum(smbCompliance.PendingChange) > 0 then 1
				else 0
				end as Pending
			, 1 as Total	
--		Into smbComplianceComputer	
		From smbCompliance, LeafNode
		Where		
			smbCompliance.AutoID = LeafNode.AutoID
			and LeafNode.Type != 24
		Group by
			LeafNode.AutoID, LeafNode.ParentID
	
	
		Delete from smbComplianceRollup
	
		Insert smbComplianceRollup
			Select BranchNode.AutoID, Branchnode.NodeName,
				sum(smbComplianceComputer.UptoDateNotLate), 
				sum(smbComplianceComputer.OutofDateNotLate), 
				sum(smbComplianceComputer.Late),
				sum(smbComplianceComputer.Pending),
				count(*)		
			From smbComplianceComputer, BranchNode
			Where		
				BranchNode.AutoID = smbComplianceComputer.ParentID
--				and smbCompliance.AutoID = LeafNode.AutoID
			Group by
				BranchNode.AutoID, Branchnode.NodeName


	End
	-- End Compliance change detection
	----------------------------------------------------------



	------------------------------------------------------
	-- Update compliancecheckpoint info for next run
	Update smbCheckPoint
		Set 	LastComplianceCheck = GetDate(),
-- no longer need to store this (trigchange)
--			UpdateEventsAutoID = (select max(autoid) from ProductEvents),
--			LastUpdate = (Select max(lastupdate) from leafnode),
			ComplianceDefnMayChange = 0,
			ProdVerComplianceDefnMayChange = 0,
			DATComplianceDefnMayChange = 0,
			ENGComplianceDefnMayChange = 0,
			ComplianceRedoRollup = 0,
			LastLateDefninDays=@NumDays

	Update smbCompliance Set ChangedSinceLastCheckpoint =0, ComplianceMayChange =0,
				ProdVerChange=0, AgentChange=0, DATChange=0, ENGChange=0

    -- PostRCFix: Unfreeze all exclusively locked tables to simultaneous call can proceed
    Commit Transaction

--Test
--select * from smbCheckpoint
--select * from smbCompliance
--select * from smbComplianceRollup	

End
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[SMBSP_IsUptoDate]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[SMBSP_IsUptoDate]
GO

CREATE PROCEDURE dbo.SMBSP_IsUptoDate 
AS
Begin

DECLARE @CurrentDAT nvarchar (100) 
DECLARE @CurrentEngine nvarchar (100) 
DECLARE @LatestDAT nvarchar (100) 
DECLARE @LatestEngine nvarchar (100) 

SET @CurrentDAT = (SELECT top 1 ProductVersion FROM Software WHERE ProductCode = 'VSCANDAT1000')
SET @CurrentEngine = (SELECT top 1 ProductVersion FROM Software WHERE ProductCode = 'VSCANENG1000')
SET @LatestDAT = (SELECT top 1 version FROM smbLatestUpdates WHERE type = 'DAT')
SET @LatestEngine = (SELECT top 1 version FROM smbLatestUpdates WHERE type = 'ENGINE')

IF (LEN(@CurrentDAT) != LEN(@LatestDAT))
BEGIN
	SET @LatestDAT = SUBSTRING(@LatestDAT, 1, 4)
	SET @CurrentDAT = SUBSTRING(@CurrentDAT, 1, 4)
END

IF (LEN(@CurrentEngine) != LEN(@LatestEngine))
BEGIN
	SET @LatestEngine = SUBSTRING(@LatestEngine, 1, 4)
	SET @CurrentEngine = SUBSTRING(@CurrentEngine, 1, 4)
END

SELECT ProductVersion, SoftwareName 
FROM Software 
WHERE ProductFamily = 'UPD_TVD' and ((@CurrentDAT < @LatestDAT) or (@CurrentEngine < @LatestEngine))

END
Go

-- recalculate compliance
delete smbCompliance
delete smbComplianceRollup
exec SMBSP_PopulateSMBCompliance
exec SMBSP_UpdateCompliance
GO

-- this has to be execute twice
delete smbCompliance
delete smbComplianceRollup
exec SMBSP_PopulateSMBCompliance
exec SMBSP_UpdateCompliance
GO

