#!/bin/bash
# Copyright (C) 2004 Networks Associates Technology Inc. All rights reserved.

unset LC_ALL LANGUAGE LANG TEXTDOMAIN TEXTDOMAINDIR
[[ -n ${WS_LANGUAGE+set} ]] && LANG=$WS_LANGUAGE
[[ -n ${WS_TEXTDOMAIN+set} ]] && TEXTDOMAIN=$WS_TEXTDOMAIN
[[ -n ${WS_TEXTDOMAINDIR+set} ]] && TEXTDOMAINDIR=$WS_TEXTDOMAINDIR

ReportProgress ()
{
    # arg1 should be _TR_, arg2 is message id (not used)
    # arg3 is format string (localised) for remaining args
    [[ $# -gt 2 ]] || return 0	# skip if <3 args
    [[ -w /proc/self/fd/3 ]] || return 0	# skip if no &3
    shift 2
    local f="$1"; shift
    printf "$f\n" "$@" >&3 || exec 3>&-
}

StoreForm()
{
    [[ $1 == _TR_ && $2 == MSG_[a-z]* ]] || return 1
    eval "$2=\"$3\""
}

ReportMessage()
{
    # arg1 is message id of format string (localised) for remaining args
    [[ $# -gt 0 ]] || return 0	# skip if <1 args
    [[ -w /proc/$$/fd/3 ]] || return 0	# skip if no &3
    local f="${!1}"; shift
    [[ -n $f ]] && { printf "$f\n" "$@" >&3 || exec 3>&- ; }
}

StoreForm _TR_ "MSG_install_hotfix" $"Installing hotfix %s"
StoreForm _TR_ "MSG_hotfix_failed" $"Failed to install hotfix %s"
StoreForm _TR_ "MSG_hotfix_success" $"Successfully installed hotfix %s"
StoreForm _TR_ "MSG_ui_restart" $"UI service will restart in %d seconds"
StoreForm _TR_ "MSG_reboot" $"Appliance will reboot in %d seconds"
StoreForm _TR_ "MSG_install_package" $"Installing package %s"
StoreForm _TR_ "MSG_install_file" $"Installing file %s"
StoreForm _TR_ "MSG_install_failed" $"Failed to install %s"
StoreForm _TR_ "MSG_prerequisite" $"Missing prerequisite %s"
StoreForm _TR_ "MSG_wrongbox" $"Wrong appliance type for hotfix %s"
