/*Variables for functions*/
var images;
var allNews;
var masonryObjects;
/*Randomizer for wordcloud/tagcloud*/
function random_sort(thing)
{
      return (0.5 - Math.random() );
}

$("document").ready(function(){
	
	/*Search box focus and blur settings*/
	var el = $('#search_text');
    el.focus(function(e) {
		el.css("color","#000");
		el.css("textTransform","none");
        if (e.target.value == e.target.defaultValue)
			e.target.value = '';
    });
    el.blur(function(e) {
        if (e.target.value == '')
			el.css("color","#afafaf");
			el.css("textTransform","uppercase");
			e.target.value = e.target.defaultValue;
    });
	
	/*Check if the page is the frontpage*/
	if($(".frontpage").hasClass("mainsitefront")){
		//getNews();
		getWeather();
		getSlides();
		//newsSlider();
		fpImagesClick();
	}
	/*Check if the page is the solutions-frontpage*/
	if($(".frontpage").hasClass("solutions")){
		getMasonryObjects();
		masonryClickNHover();
	}
	/*Check if the page is the products-frontpage*/
	if($(".frontpage").hasClass("products")){
		/* TagCanvas */
		if(!$('#tagCanvas').tagcanvas({
			interval: 20,
			textHeight: 30,
			textColour: '#202426',
			outlineColour: '#7491ad',
			outlineThickness: 5,
			reverse: true,
			depth: 0.42,
			initial: [0.03,-0.03],
			frontSelect: true,
			weight: true,
			shape: 'hcylinder',
			//lock: 'x',
			stretchX: 0.90,
			stretchY: 0.70,
			freezeActive: true,
			maxSpeed: 0.04,
			minSpeed: 0.01,
			pulsateTo: 0.2,
			pulsateTime: 0.75,
			shadow: '#c0c0c0',
			wheelZoom: false,
			zoom: 1.1,
			minBrightness: 0.05,
			shadowBlur: 1
		},'tags')) {
			// something went wrong, hide the canvas container
			$('#tagCloudContainer').hide();
		}
	}
	
	/* If Customer Care main page or Info Center main page*/
	if($(".frontpage").hasClass("customercare")) {
		handleImageSelections();
	}
	if($(".frontpage").hasClass("infocenter")) {
		handleImageSelections();
	}
	if($(".frontpage").hasClass("gridpage")) {
		handleImageSelections();
	}

	/*Effects and events for main menu*/
	menuHovers();
	
});

/*
GET NEWS&WEATHER FOR FRONTPAGE

Currently uses ajax to read JSON files that have newsitems in them, can be changed to read xml files or printing them just out on the frontpage and usin visibility to trigger them.
The weather uses a php file that calls the Yahoo-weather api and gets a JSON-response which it then relays to this script 
*/
function getWeather(){
	var woeid = "";
	if($("#temperature h2 #temp_val") && $("#temperature h2 #temp_val").attr("woeid"))
		woeid = "?woeid="+$("#temperature h2 #temp_val").attr("woeid");
	if($("#temperature h2 #temp_val") && $("#temperature h2 #temp_val").attr("unit") && $("#temperature h2 #temp_val").attr("unit")=="f"){
		if(woeid == "")
			woeid = "?unit=f";
		else
			woeid += "&unit=f";
	}
	$.getJSON('/opencms/opencms/system/modules/com.clicksandlinks.opencms.sites.stonesoft/files/weather.json'+woeid, function(data) {
		  $("#temperature h2 #temp_val").prepend(data.query.results.channel.item.condition.temp);
		  $("#temperature h2 #temp_val").animate({marginTop:0},240,"linear",function(){ });
	 });
}
function getNews(){
	
	var root_uri = location.href;
	root_uri = root_uri.substring(root_uri.indexOf(document.domain)+document.domain.length, root_uri.length);
	if(root_uri.indexOf("/opencms/opencms/")==0)
		root_uri = root_uri.substring("/opencms/opencms/".length-1, root_uri.length);
	if(root_uri.indexOf("/opencms/export/")==0)
		root_uri = root_uri.substring("/opencms/export/".length-1, root_uri.length);
	if(root_uri.indexOf("/",2)>0 && root_uri.indexOf("/",2)<root_uri.length)
		root_uri = root_uri.substring(0, root_uri.indexOf("/",2)+1);
	$.ajax({
		url: '/opencms/opencms/system/modules/com.clicksandlinks.opencms.sites.stonesoft/files/news.json?root_uri='+root_uri,
	    dataType: 'text',
	    success: function(result){
	    	result = result.replace(/(\r\n|\n|\r)/gm,"");
	    	storeNews(JSON.parse(result));
	    }, 
	    error: function(xhr) {
	        //alert (xhr.statusText);
	    }
	});
}
function storeNews(ns){
	allNews=ns;
	f=parseInt($("#dates .date ").length)-1;
	i=0;
	$("#news a").attr("href",allNews.news[f].newsItem.href);
	$("#news p").append(allNews.news[i].newsItem.blurb);
	$("#dates .date a").each(function(){
		$(this).empty();
		$(this).append(allNews.news[i].newsItem.date);
		i++;
	});
}
/*The sliding balls for the newsslider*/
function newsSlider(){
	$(".date a").click(function(){
		$(".date").removeClass("active");
		var nr=parseInt($(this).attr("href").substr(1,1))-1;
		$(this).parent(".date").addClass("active");
		$("#news p").fadeOut(240,"linear",function(){
			$(this).empty();
			$("#news a").attr("href",allNews.news[nr].newsItem.href);
			$("#news p").append(allNews.news[nr].newsItem.blurb);
			$("#news p").fadeIn(240,"linear",function(){});
		});
		$("#news a").fadeOut(240,"linear",function(){$("#news a").fadeIn(240,"linear",function(){ });});
		$("#time_slider").animate({marginLeft:(((nr)*67)+((nr)*59)+10)},240,"linear",function(){ });
	});
}


/*
MASONRY FUNCTIONS

Get objects that have the masonry effect from a json file and print them on he page, can probably be changed to do dynamically in the CMS animate them when clicked.
*/
function getMasonryObjects(){
	$.getJSON('/opencms/opencms/system/modules/com.clicksandlinks.opencms.sites.stonesoft/files/masonry_objects.json', function(data) {
	  printMasonryObjects(data);
	});
}
function printMasonryObjects(obs){
	masonryObjects=obs;
	
	for(i=0;i<obs.masonryItems.length;i++){
		bg_color=obs.masonryItems[i].item.background;
		title=obs.masonryItems[i].item.title;
		text=obs.masonryItems[i].item.text;
		link_url=obs.masonryItems[i].item.linkUrl
		link_text=obs.masonryItems[i].item.linkTxt
		$("#isotope_container").append("<div style='background:"+bg_color+";' num='"+i+"' class='i_item closed'><h3>"+title+"</h3><p>"+text+"</p><a href='"+link_url+"'>"+link_text+"<div class='arrow-right'></div></a><div class='arrow-right-white'></div></div>");
	}
	$('#isotope_container').isotope({
    // options
    itemSelector : '.i_item',
    layoutMode : 'masonry',
    animationOptions: {
		duration: 400,
		easing: 'linear',
		queue: false
    },
	resizable: false,
	masonry: {
		columnWidth: 75
	}
	});
	relayOut();
	masonryClickNHover();
}
function relayOut(){
	$('#isotope_container').isotope("reLayout");
}
function masonryClickNHover(){
	$("#isotope_container .i_item").hover(function(){
		num=$(this).attr('num');
		if(!$(this).hasClass("open")){
		$(this).css({'background-image' : 'url(http://'+window.location.host+"/system/galleries/pics/www.stonesoft.com/solutions/"+masonryObjects.masonryItems[num].item.hover+')','background-repeat': 'no-repeat'});
		}
	},function(){
		num=$(this).attr('num');
		if(!$(this).hasClass("open")){
		$(this).css("backgroundImage","none");
		}
	});
	$("#isotope_container .i_item").click(function(){
	
		$("#isotope_container .i_item").each(function(){ 
			if($(this).hasClass("open")){
				$(this).css("backgroundImage","none");
				$(this).animate({width:180,height:95},200);
			}
			$(this).removeClass("open");
			$(this).addClass("closed");
			});
	$(this).removeClass("closed");
	$(this).animate({width:405,height: 365},{duration:400,step:function(){num=$(this).attr('num'); $(this).addClass("open");$(this).css({'background-image' : 'url(http://'+window.location.host+"/system/galleries/pics/www.stonesoft.com/solutions/"+masonryObjects.masonryItems[num].item.bg+')','background-repeat': 'no-repeat'});$('#isotope_container').isotope("reLayout");}});
	
});
}

/*
MENUS AND THEIR ANIMATIONS
*/
function menuHovers(){

	$("#site_nav_toggle_open").click(function(){$("#toggle_nav").animate({top:-1},200);});
	$("#site_nav_toggle_close").click(function(){$("#toggle_nav").animate({top:-320},200);});

	$("#home_link").hover(function(){
		$("#main_navigation>li").removeClass("active");
		$("#main_navigation>li .arrow-up").remove();
		$("#home_link .arrow_up").remove();
		$("#home_link").append("<div class='arrow-up'></div>");
		$("#home_link").addClass("active");
	},function(){
		if(!$("#home_link").hasClass("active-page")){
		$("#home_link .arrow-up").remove();
		$("#home_link").removeClass("active");
		$(".active-page").append("<div class='arrow-up'></div>");
	}
	});
	
	var _timer_header_toggle;

	if($(".frontpage").hasClass("mainsitefront") || (!$(".currentlink")[0] && !$(".is-second-level-page")[0])){
		$("#main_navigation").hover(function(){		
			$("#home_link").removeClass("active");
			$("#home_link .arrow-up").remove();	
			clearTimeout(_timer_header_toggle);
			$("#fp_sidebar").stop().animate({top:206}, 200, "linear");
			
			$("header").stop().animate({height:164}, 200, "linear", function(){
				$("header").css({"overflow":"visible"});
			});
			$(".sub_nav_wrap").css("z-index","0");
			$(".sub_navigation").css("z-index","0");
		},
		function(){			
			_timer_header_toggle = setTimeout(function(){
				$("#fp_sidebar").stop().delay(75).animate({top:165}, 200, "linear");
				$("header").stop().delay(75).animate({height:123}, 200, "linear", function(){
					$("header").css({"overflow":"hidden"});
					$("#main_navigation>li").removeClass("active");
					$("#home_link").append("<div class='arrow-up'></div>");
					$("#home_link").addClass("active");					
				});
				$(".sub_nav_wrap").css("z-index","-1000");
				$(".sub_navigation").css("z-index","-1000");
			}, 800);
					
		});
	}
	else{
		$("header").css("overflow","visible");
		$("header").css("height","164px");
	}
	$("#main_navigation>li").hover(function(){
		$("#main_navigation>li").removeClass("active");
		$("#main_navigation>li").removeClass("last-visible");
		$("#main_navigation>li .arrow-up").remove();
		$(this).append("<div class='arrow-up'></div>");
		$(this).addClass("active");	
	},function(){
		$(this).addClass("last-visible");
		$(this).removeClass("active");
		$(this).children(".arrow-up").remove();
		$(".active-page").append("<div class='arrow-up'></div>");
	});
	$(".sub_nav_wrap").hover(function(){	
		$(this).siblings("a").css("color","#e63e97");
	},function(){
		$(this).siblings("a").css("color","");
	});
}
/*
FRONTPAGE LARGE IMAGE FADE
Gets images locations from a JSON file
*/
function getSlides(){
	var currentPage = location.href;
	currentPage = currentPage.substring(currentPage.indexOf(document.domain)+document.domain.length, currentPage.length);
	if(currentPage.indexOf("/opencms/opencms/")==0)
		currentPage = currentPage.substring("/opencms/opencms/".length-1, currentPage.length);
	if(currentPage.indexOf("/opencms/export/")==0)
		currentPage = currentPage.substring("/opencms/export/".length-1, currentPage.length);
	if(currentPage.indexOf("index.html")==-1)
		currentPage = currentPage + "index.html";
	$.ajax({
	    url: '/opencms/opencms/system/modules/com.clicksandlinks.opencms.sites.stonesoft/files/front_images.json?page_uri='+currentPage,
	    dataType: 'text',
	    success: function(result){
	    	storeImages(JSON.parse(result));
	    }, 
	    error: function(xhr) {
	        //alert (xhr.statusText);
	    }
	});
}
function storeImages(imgs){
	images=imgs;
	setFirstImage();
}
/*Sets first image from json file, there is a fallback in css*/
function setFirstImage(){
	$("#fp_images .image_text").css("backgroundImage","url('"+images.imagesFront[0].img.text_img+"')");
	$("#fp_images  #big_image").css("backgroundImage","url('"+images.imagesFront[0].img.img_url+"')");
	$("#fp_images .read_more_link a").attr("href",images.imagesFront[0].img.href);
	$("#fp_images .bigimagelink").attr("href",images.imagesFront[0].img.href);
}
/*FRONTPAGE IMAGE CHANGE
When link element is clicked changes image in image carousel and textimage and href value for read more link
*/
function fpImagesClick(){
	
	$("#fp_images .links_and_progressbar a").click(function(e){
		e.preventDefault();	
		
		$("#fp_images .read_more_link").stop();
		$(".image_text").stop();
		$("#fp_images #big_image").stop();
		
		var nr=parseInt($(this).attr("href").substr(1,1));
		image=nr-1;
		
		$("#fp_images #big_image_bg_fade").css("backgroundImage","url('"+images.imagesFront[image].img.img_url+"')");
		
		$("#fp_images .links_and_progressbar a").each(function(){
				$(this).removeClass("active");
			});
		$(this).addClass("active");
		
		$("#fp_images .read_more_link a").attr("href",images.imagesFront[image].img.href);
		$("#fp_images .bigimagelink").attr("href",images.imagesFront[image].img.href);
	
		
		$("#fp_images .read_more_link a").attr("href",images.imagesFront[image].img.href);
		$("#fp_images .bigimagelink").attr("href",images.imagesFront[image].img.href);
		
		$("#fp_images .read_more_link").animate({opacity:0},400,"linear",function(){
				$("#fp_images .read_more_link a").attr("href",images.imagesFront[image].img.href);
				$("#fp_images .bigimagelink").attr("href",images.imagesFront[image].img.href);
				$("#fp_images .read_more_link").animate({opacity:1},400,"linear");
		});
		
		$(".image_text").animate({opacity:0},400,"linear",function(){
				$("#fp_images .image_text").css("backgroundImage","url('"+images.imagesFront[image].img.text_img+"')"); 
				$("#fp_images .image_text").animate({opacity:1},400,"linear");
		});
		
		$("#fp_images #big_image").animate({opacity:0},650,"linear",function(){
			$("#fp_images #big_image").css("backgroundImage","url('"+images.imagesFront[image].img.img_url+"')");
			$("#fp_images #big_image").css("opacity","1")
		});
	});
}

/*
APPLIANCES SEARCH.
*/
function appliancesFilterResults(site_root){
	var enterprise_size=$('#enterprise_size').val(); 
	var type=$('#type').val(); 
	var technology=$('#technology').val(); 
	$.getJSON('/opencms/opencms/system/modules/com.clicksandlinks.opencms.sites.stonesoft/files/appliance_search.json?site_root='+site_root+'&enterprise_size='+enterprise_size+'&type='+type+'&technology='+technology, function(data) {
		$('#AL_form_sub').css({visibility: "visible"});
		$('#AL_form_results').css({visibility: "visible"});
		$('#result_count').html(data.length);
		$('#AL_form_results').html("");
		for(i=0;i<data.length;i++){
			var content="<div class=\"resultBox\"><div class=\"RBimg\">";
			content += "<a href=\""+data[i].link+"\"><img alt=\""+data[i].image_title+"\" title=\""+data[i].image_title+"\" src=\""+data[i].image_location+"\"/></a>";
			content += "</div>";
			content += "<p class=\"title\"><a href=\""+data[i].link+"\">"+data[i].title+"</a></p>";
			content += "</div>";
			$('#AL_form_results').append(content);
		}
	 });
}

function appliancesClearFilters(site_root){
	$('#enterprise_size').val(0);
	$('#type').val(0);
	$('#technology').val(0);
	appliancesFilterResults(site_root);
}

function appliancesPresetFilters(site_root,enterprise_size,type,technology){
	$('#enterprise_size').val(enterprise_size);
	$('#type').val(type);
	$('#technology').val(technology);
	appliancesFilterResults(site_root);
}

/*
CASESTUDY SEARCH.
*/
function casestudyFilterResultsOnlyOne(site_root,select_item){
	if(select_item!=1)
		$('#industry').val(0);
	if(select_item!=2)
		$('#country').val(0);
	if(select_item!=3)
		$('#challenge').val(0);
	if(select_item!=4)
		$('#product').val(0);
	if(select_item!=5)
		$('#technology').val(0);
	if(select_item!=6)
		$('#solutions').val(0);
	
	casestudyFilterResults(site_root);
}

function casestudyFilterResults(site_root){
	var industry=$('#industry').val();
	var country=$('#country').val();
	var challenge=$('#challenge').val();
	var product=$('#product').val();
	var technology=$('#technology').val();
	var solutions=$('#solutions').val();
	var content="<div class=\"resultBox\">";
	$.getJSON('/opencms/opencms/system/modules/com.clicksandlinks.opencms.sites.stonesoft/files/casestudy_search.json?site_root='+site_root+'&industry='+industry+'&country='+country+'&challenge='+challenge+'&product='+product+'&technology='+technology+'&solutions='+solutions, function(data) {
		$('#CSS_form_sub').css({visibility: "visible"});
		$('#CSS_form_results').css({visibility: "visible"});
		$('#result_count').html(data.length);
		$('#CSS_form_results').html("");
		for(i=0;i<data.length;i++){
			if (i>0) {
				content += "<hr/>";
			}
			content += "<div class=\"leftbox\">";
			content += "<p class=\"title\"><a href=\""+data[i].link+"\">"+data[i].title+"</a></p>";
			content += "<p class=\"descwords\">"+data[i].intro+"</p>";
			content += "<div style=\"align:right;\"><a href=\""+data[i].link+"\">"+data[i].caption_read_more+"<div class=\"arrow-right\"></div></a></div>";
	//		content += "<p class=\"pdflink\"><a href=\""+data[i].link+"\">"+data[i].caption_read_more+"</a></p>";
			content += "</div>";
			content += "<div class=\"rightbox\">";
			content += "<img alt=\""+data[i].image_title+"\" title=\""+data[i].image_title+"\" src=\""+data[i].image_location+"\">";
			content += "</div>";
			content += "<div class=\"divider\"></div>";
			content += "<p class=\"categories\">"+data[i].caption_categories;
			if(data[i].industry_value)
				content += " <a href=\"#\" onclick=\"casestudySelectCategory('"+site_root+"', 1, "+data[i].industry_value+")\">"+data[i].industry_caption+"</a>";
			if(data[i].country_value)
				content += " <a href=\"#\" onclick=\"casestudySelectCategory('"+site_root+"', 2, "+data[i].country_value+")\">"+data[i].country_caption+"</a>";
			var j=0;
			while(data[i]["challenge_value"+j]){
				content += " <a href=\"#\" onclick=\"casestudySelectCategory('"+site_root+"', 3, "+data[i]["challenge_value"+j]+")\">"+data[i]["challenge_caption"+j]+"</a>";
				j++;
			}
			j=0;
			while(data[i]["product_value"+j]){
				content += " <a href=\"#\" onclick=\"casestudySelectCategory('"+site_root+"', 4, "+data[i]["product_value"+j]+")\">"+data[i]["product_caption"+j]+"</a>";
				j++;
			}
			j=0;
			while(data[i]["technology_value"+j]){
				content += " <a href=\"#\" onclick=\"casestudySelectCategory('"+site_root+"', 5, "+data[i]["technology_value"+j]+")\">"+data[i]["technology_caption"+j]+"</a>";
				j++;
			}
			j=0;
			while(data[i]["solution_value"+j]){
				content += " <a href=\"#\" onclick=\"casestudySelectCategory('"+site_root+"', 6, "+data[i]["solution_value"+j]+")\">"+data[i]["solution_caption"+j]+"</a>";
				j++;
			}
			content += "</p>";
		}
		content += "</div>";
		$('#CSS_form_results').append(content);
	 });
}

function casestudyPresetFilters(site_root,industry,country,challenge,product,technology,solutions){
	$('#industry').val(industry);
	$('#country').val(country);
	$('#challenge').val(challenge);
	$('#product').val(product);
	$('#technology').val(technology);
	$('#solutions').val(solutions);
	casestudyFilterResults(site_root);
}

function casestudyClearFilters(site_root){
	$('#industry').val(0);
	$('#country').val(0);
	$('#challenge').val(0);
	$('#product').val(0);
	$('#technology').val(0);
	$('#solutions').val(0);
	casestudyFilterResults(site_root);
}

function casestudySelectCategory(site_root, category, item){
	$('#industry').val(0);
	$('#country').val(0);
	$('#challenge').val(0);
	$('#product').val(0);
	$('#technology').val(0);
	$('#solutions').val(0);
	if(category == 1)
		$('#industry').val(item);
	else if(category == 2)
		$('#country').val(item);
	else if(category == 3)
		$('#challenge').val(item);
	else if(category == 4)
		$('#product').val(item);
	else if(category == 5)
		$('#technology').val(item);
	else if(category == 6)
		$('#solutions').val(item);
	casestudyFilterResults(site_root);
}

/*
SEARCH BOX
*/

function processSearchQuery(){
	$('#search_box_query').val($('#search_text').val());
}

/*
VIDEO POPUP
*/

function openVideo(video_url){
	$.colorbox({href:video_url,
				iframe:true,
				open:true,
				returnFocus:true,
				opacity: 0.65,
				fixed:true,
				innerWidth:700, 
				innerHeight:394});
}

/*
COLORBOX POPUP
*/

function openPopup(target_url, width, height){
	var boxWidth = 700;
	if(width)
		boxWidth = width;
	var boxHeight = 394;
	if(height)
		boxHeight = height;
	$.colorbox({href:target_url,
				iframe:true,
				open:true,
				returnFocus:true,
				opacity: 0.65,
				fixed:true,
				innerWidth:boxWidth, 
				innerHeight:boxHeight});
}

/*
WHITEPAPER DOWNLOAD POPUP
*/

var C_WHITEPAPER_DOWNLOAD_COOKIE_NAME = "SS_WHITEPAPER_DOWNLOAD";
var C_WHITEPAPER_DOWNLOAD_COOKIE_REDIRECT_URL = "SS_WHITEPAPER_DOWNLOAD_REDIRECT_URL";
var C_WHITEPAPER_DOWNLOAD_COOKIE_USER_IDENTIFIER = "SS_WHITEPAPER_DOWNLOAD_USER_ID";
var C_WHITEPAPER_DOWNLOAD_COOKIE_EXPIRY_DAYS = 365;
function downloadWhitePaper(target_url,form_url, width, height){
	
	if(!getCookie(C_WHITEPAPER_DOWNLOAD_COOKIE_NAME)){
		setCookie(C_WHITEPAPER_DOWNLOAD_COOKIE_REDIRECT_URL,target_url,1);
		window.location = form_url;
		/*
		var boxWidth = 700;
		if(width)
			boxWidth = width;
		var boxHeight = 394;
		if(height)
			boxHeight = height;
		$.colorbox({href:form_url,
					iframe:true,
					open:true,
					returnFocus:true,
					opacity: 0.65,
					fixed:true,
					innerWidth:boxWidth, 
					innerHeight:boxHeight});
		*/
	}else{
		window.open(
					target_url,
				  '_blank'
				);
	}
		//window.location = target_url;
}

function downloadWhitePaperSetUserIndenticator(identification_field_name){
	var value =  $('[name='+identification_field_name+']').val();
	if(value)
		setCookie(C_WHITEPAPER_DOWNLOAD_COOKIE_USER_IDENTIFIER,value,1);
}

function downloadWhitePaperSetCookie(){
	var identifier = getCookie(C_WHITEPAPER_DOWNLOAD_COOKIE_USER_IDENTIFIER);
	if(identifier!= "undefined"){
		setCookie(C_WHITEPAPER_DOWNLOAD_COOKIE_NAME,identifier,C_WHITEPAPER_DOWNLOAD_COOKIE_EXPIRY_DAYS);
		window.open(
				getCookie(C_WHITEPAPER_DOWNLOAD_COOKIE_REDIRECT_URL),
			  '_blank'
			);
		/*
		parent.$.fn.colorbox.close();
		parent.window.location = getCookie(C_WHITEPAPER_DOWNLOAD_COOKIE_REDIRECT_URL);
		*/
	}
}

function setCookie(c_name,value,exdays){
	var exdate=new Date();
	exdate.setDate(exdate.getDate() + exdays);
	var c_value=escape(value) + ((exdays==null) ? "" : "; expires="+exdate.toUTCString())+"; path=/";
	document.cookie=c_name + "=" + c_value;
}

function getCookie(c_name){
	var i,x,y,ARRcookies=document.cookie.split(";");
	for (i=0;i<ARRcookies.length;i++){
	  x=ARRcookies[i].substr(0,ARRcookies[i].indexOf("="));
	  y=ARRcookies[i].substr(ARRcookies[i].indexOf("=")+1);
	  x=x.replace(/^\s+|\s+$/g,"");
	  if (x==c_name)
	    return unescape(y);
	}
}

/* 
IMAGE SELECTION ELEMENT 
*/

function handleImageSelections() {
		$(".hoverable .cell_content .links").find("a").hover(
			function () { // mouseover
				$(this).parents('.cell_content').find('h2 a').css("color","#ffffff");
			}, 
			function () { // mouseout
				$(this).parents('.cell_content').find('h2 a').css("color","#7491ad");
			}
		);
		$(".hoverable").hover(
			function () { // mouseover
				$(this).find('h2').find('a').css("color","#7491ad");
			}, 
			function () { // mouseout
				$(this).find('h2').find('a').css("color","#ffffff");
			}
		);
}
